package q02b.grupos.operacionesinternas;



import java.util.ArrayList;

import java.util.HashMap;



import q02b.exe.comun.valueobjects.Q02bCodigoValor;

import q02b.exe.operacioninterna.Q02bOperacionInterna;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;

import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;



public class Q02bOITratarListasConsultaGrupo extends Q02bOperacionInterna {

	

	private static Q70Traza tr = Q70Traza.getSingleton();

	protected static final String COMPONENTE = "OPERACION_INTERNA";

	

	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto,Q70OperacionInternaConfigBean configuracion,

			Q70OperacionInternaErrors errores)

			throws Exception {

		

		try{

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":preProcessMappingEntrada: entrando");

			}

			contexto.set("listaRolesSeleccionados",new String[0]);

			contexto.set("listaRolesAsignados",new Q02bCodigoValor[0]);

			contexto.set("listaRoles",new Q02bCodigoValor[0]);

			

			contexto.set("listaUsuariosSeleccionados",new String[0]);

			contexto.set("listaUsuariosAsignados",new Q02bCodigoValor[0]);

			contexto.set("listaUsuarios",new Q02bCodigoValor[0]);

			

		}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":preProcessMappingEntrada: " + sw.getBuffer ().toString());

	        throw ex;

		}finally {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":preProcessMappingEntrada: saliendo.");

			}

		}

	}

	

	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errores)

		throws Exception {

		try{

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":postProcessMappingSalida: entrando");

			}

			Q02bCodigoValor[] listaRolesAsignados = new Q02bCodigoValor[0];

			Q02bCodigoValor[] listaRoles = new Q02bCodigoValor[0];

			

			Q02bCodigoValor[] listaUsuariosAsignados = new Q02bCodigoValor[0];

			Q02bCodigoValor[] listaUsuarios = new Q02bCodigoValor[0];

			

			HashMap mapaGrupo = (HashMap)contexto.get("grupo");

			

			ArrayList listaRolesSeleccionados = (ArrayList)mapaGrupo.get("listaRolesSeleccionados");

			ArrayList listaRolesNoSeleccionados = (ArrayList)mapaGrupo.get("listaRoles");

			

			ArrayList listaUsuariosSeleccionados = (ArrayList)mapaGrupo.get("listaUsuariosSeleccionados");

			ArrayList listaUsuariosNoSeleccionados = (ArrayList)mapaGrupo.get("listaUsuarios");

			

			if (null!=listaRolesSeleccionados && listaRolesSeleccionados.size()>0){

				listaRolesAsignados = (Q02bCodigoValor[])listaRolesSeleccionados.toArray(new Q02bCodigoValor[listaRolesSeleccionados.size()]);

			}

			if (null!=listaRolesNoSeleccionados && listaRolesNoSeleccionados.size()>0){

				listaRoles = (Q02bCodigoValor[])listaRolesNoSeleccionados.toArray(new Q02bCodigoValor[listaRolesNoSeleccionados.size()]);

			}

			

			if (null!=listaUsuariosSeleccionados && listaUsuariosSeleccionados.size()>0){

				listaUsuariosAsignados = (Q02bCodigoValor[])listaUsuariosSeleccionados.toArray(new Q02bCodigoValor[listaUsuariosSeleccionados.size()]);

			}

			if (null!=listaUsuariosNoSeleccionados && listaUsuariosNoSeleccionados.size()>0){

				listaUsuarios = (Q02bCodigoValor[])listaUsuariosNoSeleccionados.toArray(new Q02bCodigoValor[listaUsuariosNoSeleccionados.size()]);

			}

			

			contexto.set("listaRolesAsignados",listaRolesAsignados);

			contexto.set("listaRoles",listaRoles);

			

			contexto.set("listaUsuariosAsignados",listaUsuariosAsignados);

			contexto.set("listaUsuarios",listaUsuarios);

	

		}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":postProcessMappingSalida: " + sw.getBuffer ().toString());

	        throw ex;

		}finally {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":postProcessMappingSalida: saliendo.");

			}

		}

	}

}