package q02bUsuariosSesionEJB;



import java.rmi.RemoteException;

import java.util.ArrayList;

import java.util.HashMap;



import javax.ejb.CreateException;

import javax.ejb.EJBException;

import javax.ejb.SessionBean;



import q02b.exe.comun.Q02bAplicException;

import q02b.exe.comun.Q02bAutenticador;

import q02b.exe.grupos.beans.Q02bGruposBean;

import q02b.exe.grupos.valueobjects.Q02bGrupos;

import q02b.exe.usuarios.beans.Q02bUsuariosBean;

import q02b.exe.usuarios.valueobjects.Q02bUsuario;

import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

 

/**

 * XDoclet-based session bean.  The class must be declared

 * public according to the EJB specification.

 *

 * To generate the EJB related files to this EJB:

 *		- Add Standard EJB module to XDoclet project properties

 *		- Customize XDoclet configuration for your appserver

 *		- Run XDoclet

 *

 * Below are the xdoclet-related tags needed for this EJB.

 * 

 * @ejb.bean name="Q02bCuestionariosSMAnuSesion"

 *           display-name="Name for Q02bCuestionariosSMAnuSesion"

 *           description="Description for Q02bCuestionariosSMAnuSesion"

 *           jndi-name="ejb/Q02bCuestionariosSMAnuSesion"

 *           type="Stateless"

 *           view-type="remote"

 */

  



public class Q02bUsuariosSesionBean implements SessionBean {



	

	private static final long serialVersionUID = 4131248384461301469L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "EJB_SESION_DATOS";

	protected Q02bUsuariosBean beanUsuarios= null;

	

	/** The session context */

	private javax.ejb.SessionContext mySessionCtx;



	 

	

	public Q02bUsuariosSesionBean() {

		super();

		// TODO Auto-generated constructor stub

	}

	/**

	 * Set the associated session context. The container calls this method 

	 * after the instance creation.

	 * 

	 * The enterprise bean instance should store the reference to the context 

	 * object in an instance variable.

	 * 

	 * This method is called with no transaction context. 

	 * 

	 * @throws EJBException Thrown if method fails due to system-level error.

	 */

	/**

	 * getSessionContext

	 */

	public javax.ejb.SessionContext getSessionContext() {

		return mySessionCtx;

	}

	/**

	 * setSessionContext

	 */

	public void setSessionContext(javax.ejb.SessionContext ctx) {

		mySessionCtx = ctx;

	}



	public void ejbRemove() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbActivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbPassivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	/**

	 * An ejbCreate method as required by the EJB specification.

	 * 

	 * The container calls the instance?s <code>ejbCreate</code> method whose

	 * signature matches the signature of the <code>create</code> method invoked

	 * by the client. The input parameters sent from the client are passed to

	 * the <code>ejbCreate</code> method. Each session bean class must have at

	 * least one <code>ejbCreate</code> method. The number and signatures

	 * of a session bean?s <code>create</code> methods are specific to each 

	 * session bean class.

	 * 

	 * @throws CreateException Thrown if method fails due to system-level error.

	 * 

	 * @ejb.create-method

	 * 

	 */

	public void ejbCreate() throws CreateException {

		// TODO Add ejbCreate method implementation

	}  

	// -------------------------------------------------------------------------------------------------

	// ------------------------------------- USUARIOS  -------------------------------------------------

	// -------------------------------------------------------------------------------------------------

	

	/**

	 * Obtener la lista de usuarios

	 * @param autenticador - Q02bAutenticador Autenticador

	 * @return Devuelve la lista de usuarios

	 * @throws Exception

	 */

	public ArrayList obtenerUsuarios(HashMap mapaFiltroUsuarios, Q02bAutenticador autenticador) throws Exception 

	{		

		ArrayList listaUsuarios= new ArrayList(); 

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuarios: entrando.");

	   		}		

			beanUsuarios= new Q02bUsuariosBean();

			beanUsuarios.setAutenticador(autenticador);

			listaUsuarios = beanUsuarios.getUsuarios(mapaFiltroUsuarios);

			//listaUsuarios = beanUsuarios.getUsuarios();

			return listaUsuarios;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuarios: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuarios: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuarios: saliendo.");

	   		}

	 	}

	}//fin obtenerUsuarios

	

	

	public HashMap obtenerUsuarioModificacion(String idUsuario, Q02bAutenticador autenticador) throws Exception {

		//Definicin de variables que no se van a modificar

		final String TRACE_METODO 	= ":obtenerUsuarioModificacion:";

		//Definicin de objetos

		HashMap hashUsuario =null;

		Q02bUsuario usuarioVO = null;

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando " + idUsuario);

	   		}

			//Se instancia el bean de negocio

			beanUsuarios= new Q02bUsuariosBean();

			usuarioVO = new Q02bUsuario();

			//Se pasa el autenticador

			beanUsuarios.setAutenticador(autenticador);

			//Se obtiene la lista con los grupos

			usuarioVO = beanUsuarios.obtenerUsuarioModificacion(idUsuario);

			//Se obtiene el objeto a partir del hashmap

			hashUsuario = (HashMap)Q02bVoUtils.getHashMap(usuarioVO);

			//Se devuelve la lista

			return hashUsuario;

		}catch(Exception ex){	 	

			java.io.StringWriter 	sw = new java.io.StringWriter();

			java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " saliendo.");

	   		}

	 	}

	}//fin obtenerGrupoModificacion

	

	/**

	 * Inserta un usuario en la bbdd

	 * @param mapaUsuario - HashMap con los datos del usuario

	 * @param autenticador - Q02bAutenticador Autenticador

	 * @return Devuelve el nmero interno del usuario inertado

	 * @throws Exception

	 */

	public String insertarUsuario(HashMap mapaUsuario, Q02bAutenticador autenticador) throws Exception 

	{		

		String idUsuario=null; 

		Q02bUsuario usuarioVO=null;

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarUsuario: entrando.");

	   		}		

			usuarioVO = (Q02bUsuario) Q02bVoUtils.getValueObject(mapaUsuario,"q02b.exe.usuarios.valueobjects.Q02bUsuario");

			

			beanUsuarios= new Q02bUsuariosBean();

			beanUsuarios.setAutenticador(autenticador);

			

			idUsuario = beanUsuarios.insertarUsuario(usuarioVO);

			return idUsuario;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarUsuario: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarUsuario: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarUsuario: saliendo.");

	   		}

	 	}

	}//fin insertarUsuario

	

	/**

	 * Mtodo que llama a un Bean para obtener los datos de un grupo para su consulta.

	 * @param niGrupo nmero interno del grupo en la bbdd.

	 * @param autenticador Objeto con el id. y perfil de usuario e idioma. 

	 * @return HashMap con los datos del grupo.

	 * @throws Exception

	 */

	public HashMap obtenerUsuarioConsulta(String idUsuario, Q02bAutenticador autenticador) throws Exception {

		//Definicin de variables que no se van a modificar

		final String TRACE_METODO 	= ":obtenerUsuarioConsulta:";

		//Definicin de objetos

		Q02bUsuario usuario = new Q02bUsuario();

		HashMap usuarioHashMap = new HashMap(); 

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando " + idUsuario);

	   		}

			//Se instancia el bean de negocio

			beanUsuarios = new Q02bUsuariosBean();

			//Se pasa el autenticador

			beanUsuarios.setAutenticador(autenticador);

			//Se obtiene la lista con los grupos

			usuario = beanUsuarios.obtenerUsuarioConsulta(idUsuario);

			//Se obtiene el objeto a partir del hashmap

			usuarioHashMap = (HashMap)Q02bVoUtils.getHashMap(usuario);

			//Se devuelve la lista

			return usuarioHashMap;

		}catch(Exception ex){	 	

			java.io.StringWriter 	sw = new java.io.StringWriter();

			java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " saliendo.");

	   		}

	 	}

	}// fin obtenerGrupoConsulta

	

	/**

	 * Modifica un usuario de la bbdd

	 * @param mapaUsuario - HashMap con los datos del usuario

	 * @param autenticador - Q02bAutenticador Autenticador

	 * @throws Exception

	 */

	public void modificarUsuario(HashMap mapaUsuario, Q02bAutenticador autenticador) throws Exception 

	{		

		Q02bUsuario usuarioVO=null;

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarUsuario: entrando.");

	   		}		

			usuarioVO = (Q02bUsuario) Q02bVoUtils.getValueObject(mapaUsuario,"q02b.exe.usuarios.valueobjects.Q02bUsuario");

			

			beanUsuarios= new Q02bUsuariosBean();

			beanUsuarios.setAutenticador(autenticador);

			

			beanUsuarios.modificarUsuario(usuarioVO);

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarUsuario: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarUsuario: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarUsuario: saliendo.");

	   		}

	 	}

	}//fin modificarUsuario

	



	/**

	 * Borra un usuario de la bbdd

	 * @param idUsuario - String nmero interno del usuario

	 * @param autenticador - Q02bAutenticador Autenticador

	 * @throws Exception

	 */

	public void borrarUsuario(String idUsuario, Q02bAutenticador autenticador) throws Exception 

	{		

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarUsuario: entrando.");

	   		}		

			

			beanUsuarios= new Q02bUsuariosBean();

			beanUsuarios.setAutenticador(autenticador);

			

			beanUsuarios.borrarUsuario(idUsuario);

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarUsuario: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarUsuario: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarUsuario: saliendo.");

	   		}

	 	}

	}//fin borrarUsuario

	

	// --------------------------------------------------------------------------

	// ---------- FIN USUARIOS -----------

	// ---------------------------------------------------------------------------



} // fin clase

