package q02bRolesSesionEJB;



import java.rmi.RemoteException;

import java.util.ArrayList;

import java.util.HashMap;



import javax.ejb.CreateException;

import javax.ejb.EJBException;

import javax.ejb.SessionBean;



import q02b.exe.comun.Q02bAplicException;

import q02b.exe.comun.Q02bAutenticador;

import q02b.exe.roles.beans.Q02bRolesBean;

import q02b.exe.roles.valueobjects.Q02bRoles;

import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

 

/**

 * XDoclet-based session bean.  The class must be declared

 * public according to the EJB specification.

 *

 * To generate the EJB related files to this EJB:

 *		- Add Standard EJB module to XDoclet project properties

 *		- Customize XDoclet configuration for your appserver

 *		- Run XDoclet

 *

 * Below are the xdoclet-related tags needed for this EJB.

 * 

 * @ejb.bean name="Q02bRolesSesion"

 *           display-name="Name for Q02bRolesSesion"

 *           description="Description for Q02bRolesSesion"

 *           jndi-name="ejb/Q02bRolesSesion"

 *           type="Stateless"

 *           view-type="remote"

 */

  



public class Q02bRolesSesionBean implements SessionBean {



	

	private static final long serialVersionUID = 4131248384461301469L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "EJB_SESION_DATOS";

	protected Q02bRolesBean beanRoles= null;

	

	/** The session context */

	private javax.ejb.SessionContext mySessionCtx;



	 

	

	public Q02bRolesSesionBean() {

		super();

		// TODO Auto-generated constructor stub

	}

	/**

	 * Set the associated session context. The container calls this method 

	 * after the instance creation.

	 * 

	 * The enterprise bean instance should store the reference to the context 

	 * object in an instance variable.

	 * 

	 * This method is called with no transaction context. 

	 * 

	 * @throws EJBException Thrown if method fails due to system-level error.

	 */

	/**

	 * getSessionContext

	 */

	public javax.ejb.SessionContext getSessionContext() {

		return mySessionCtx;

	}

	/**

	 * setSessionContext

	 */

	public void setSessionContext(javax.ejb.SessionContext ctx) {

		mySessionCtx = ctx;

	}



	public void ejbRemove() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbActivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbPassivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	/**

	 * An ejbCreate method as required by the EJB specification.

	 * 

	 * The container calls the instance?s <code>ejbCreate</code> method whose

	 * signature matches the signature of the <code>create</code> method invoked

	 * by the client. The input parameters sent from the client are passed to

	 * the <code>ejbCreate</code> method. Each session bean class must have at

	 * least one <code>ejbCreate</code> method. The number and signatures

	 * of a session bean?s <code>create</code> methods are specific to each 

	 * session bean class.

	 * 

	 * @throws CreateException Thrown if method fails due to system-level error.

	 * 

	 * @ejb.create-method

	 * 

	 */

	public void ejbCreate() throws CreateException {

		// TODO Add ejbCreate method implementation

	}  

	// ------------------------------------------

	// ---------- PROCESOS  ----------

	// ------------------------------------------



	/**

	 * Obtener la lista de roles

	 * @return Devuelve la lista de roles

	 * @throws Exception

	 */

	public ArrayList obtenerRoles(java.util.HashMap mapaFiltroRol, Q02bAutenticador autenticador) throws Exception 

	{		

		//Definicin de variables			 		

		Q02bRoles rol = new Q02bRoles();

		ArrayList listaRoles = new ArrayList(); 

		try

		{

			if (tr.isTraceActive())

			{

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRoles: entrando.");

	   			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaFiltroRoles : " + mapaFiltroRol);

	   		}			

			beanRoles = new Q02bRolesBean();

			beanRoles.setAutenticador(autenticador);

			rol = (Q02bRoles) Q02bVoUtils.getValueObject(mapaFiltroRol,"q02b.exe.roles.valueobjects.Q02bRoles");

			listaRoles = beanRoles.obtenerRoles(rol);

			return listaRoles;

			

		}catch(Exception ex)

		{	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerRoles: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally {    	

	        if (tr.isTraceActive()) {

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRoles: saliendo.");

	   		}

	 	}

	}//fin obtenerRoles

	

	/**

     * Mtodo que dado un rol lo inserta en la BBDD 

     * insertara en la BBDD los datos de dicho rol

     * @param mapaRol

     */ 

	public void insertarRoles(HashMap mapaRol, Q02bAutenticador autenticador) throws Exception 

	{

		Q02bRoles rol = null;

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarRoles: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaRol : " + mapaRol.toString());

			}

			

			//se pasa el hashmap de entrada a un objeto de tipo Q02bRoles	

			rol = (Q02bRoles) Q02bVoUtils.getValueObject(mapaRol,"q02b.exe.roles.valueobjects.Q02bRoles");

			

			//se instancia el bean de negocio

			beanRoles= new Q02bRolesBean();

	  		//se pasa el autenticador

			beanRoles.setAutenticador(autenticador);

	  		

	  		//se llama al mtodo del bean necesario

	  		beanRoles.insertarRoles(rol);		

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarRoles: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarRoles: saliendo");

			}			

		}

	} // fin insertarRoles

	

	/**

     * Mtodo que dado el nmero interno del rol

     * recuperara de la BBDD los datos de dicho rol

     * @param idRol

     * @return rol

     */ 

	public HashMap obtenerRolModificacion(String idRol, Q02bAutenticador autenticador) throws Exception 

	{		

		//Definicin de variables

		HashMap rol =  new HashMap(); 

		Q02bRoles rolVO = new Q02bRoles();

		try{

			if (tr.isTraceActive()) {

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRol ejb-> ** idRol=:" + idRol);	   			

	   		}			

			beanRoles= new Q02bRolesBean();

			

			//se pasa el autenticador

	  		beanRoles.setAutenticador(autenticador);

	  		

	  		//se llama al mtodo del bean necesario			

	  		rolVO = beanRoles.obtenerRolModificacion(idRol);

	  		

	  		//se pasa el resultado a un hashMap

	  		rol = (HashMap)Q02bVoUtils.getHashMap(rolVO);

			

			return rol;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRol: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerRol: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRol: saliendo.");

	   		}

	 	}

	}//fin obtenerRol

	

	/**

     * Mtodo que dado el nmero interno del rol

     * recuperara de la BBDD los datos de dicho rol

     * @param idRol

     * @return rol

     */ 

	public HashMap obtenerRolConsulta(String idRol, Q02bAutenticador autenticador) throws Exception 

	{		

		//Definicin de variables

		HashMap rol =  new HashMap(); 

		Q02bRoles rolVO = new Q02bRoles();

		try{

			if (tr.isTraceActive()) {

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRol ejb-> ** idRol=:" + idRol);	   			

	   		}			

			beanRoles= new Q02bRolesBean();

			

			//se pasa el autenticador

	  		beanRoles.setAutenticador(autenticador);

	  		

	  		//se llama al mtodo del bean necesario			

	  		rolVO = beanRoles.obtenerRolConsulta(idRol);

	  		

	  		//se pasa el resultado a un hashMap

	  		rol = (HashMap)Q02bVoUtils.getHashMap(rolVO);

			

			return rol;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRol: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerRol: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRol: saliendo.");

	   		}

	 	}

	}//fin obtenerRol

	

	/**

	 * Borrar de bbdd un rol

	 * @param idRol - Nmero interno del rol a borrar

	 */

	public void borrarRoles(String idRol, Q02bAutenticador autenticador) throws Exception

	{

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarRoles: entrando con ayuntamiento: " + idRol);

			}

			beanRoles= new Q02bRolesBean();

			//se pasa el autenticador

	  		beanRoles.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario

			beanRoles.borrarRoles(idRol);			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarRoles: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarRoles: saliendo");

			 }	

		 }			  

	} // fin borrarRoles

	

	/**

	 * Modificar en bbdd un rol con los datos pasados como parmetro en la HashMap

	 */

	public void modificarRoles(HashMap mapaRol, Q02bAutenticador autenticador) throws Exception

	{

		Q02bRoles rol = null;	  	

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarRoles: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaRol : " + mapaRol.toString());

			}			

			//se pasa el hashmap de entrada a un objeto de tipo Q02bRoles

			rol = (Q02bRoles) Q02bVoUtils.getValueObject(mapaRol,"q02b.exe.roles.valueobjects.Q02bRoles");

			

			beanRoles= new Q02bRolesBean();

			//se pasa el autenticador

	  		beanRoles.setAutenticador(autenticador);

			//se llama al metodo del bean para modificar el Roles

			beanRoles.modificarRoles(rol);			

		}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarRoles: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarRoles: saliendo");

			 }

		 }		

	} // fin modificarRoles

      

	// ---------------------------------------------

	// ---------- FIN ROLES -----------

	// ---------------------------------------------



} // fin clase

