package q02bResultadosSesionEJB;



import java.rmi.RemoteException;

import java.util.ArrayList;

import java.util.HashMap;



import javax.ejb.CreateException;

import javax.ejb.EJBException;

import javax.ejb.SessionBean;



import q02b.exe.comun.Q02bAplicException;

import q02b.exe.comun.Q02bAutenticador;



import q02b.exe.resultados.beans.Q02bResultadosBean;

import q02b.exe.resultados.valueobjects.Q02bResultados;

import q02b.exe.utils.Q02bFormatData;

import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

import org.w3c.dom.Document;

 

/**

 * XDoclet-based session bean.  The class must be declared

 * public according to the EJB specification.

 *

 * To generate the EJB related files to this EJB:

 *		- Add Standard EJB module to XDoclet project properties

 *		- Customize XDoclet configuration for your appserver

 *		- Run XDoclet

 *

 * Below are the xdoclet-related tags needed for this EJB.

 * 

 * @ejb.bean name="Q02bCuestionariosSMAnuSesion"

 *           display-name="Name for Q02bCuestionariosSMAnuSesion"

 *           description="Description for Q02bCuestionariosSMAnuSesion"

 *           jndi-name="ejb/Q02bCuestionariosSMAnuSesion"

 *           type="Stateless"

 *           view-type="remote"

 */

  



public class Q02bResultadosSesionBean implements SessionBean {



	

	private static final long serialVersionUID = 4131248384461301469L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "EJB_SESION_DATOS";

	

	//Se indica el bean de negocio que se va a utilizar

    protected Q02bResultadosBean bean = null;

	

	private static final String Aitziber = "Aitziber";

	

	/** The session context */

	private javax.ejb.SessionContext mySessionCtx;



	

	

	public Q02bResultadosSesionBean() {

		super();

		// TODO Auto-generated constructor stub

	}

	/**

	 * Set the associated session context. The container calls this method 

	 * after the instance creation.

	 * 

	 * The enterprise bean instance should store the reference to the context 

	 * object in an instance variable.

	 * 

	 * This method is called with no transaction context. 

	 * 

	 * @throws EJBException Thrown if method fails due to system-level error.

	 */

	/**

	 * getSessionContext

	 */

	public javax.ejb.SessionContext getSessionContext() {

		return mySessionCtx;

	}

	/**

	 * setSessionContext

	 */

	public void setSessionContext(javax.ejb.SessionContext ctx) {

		mySessionCtx = ctx;

	}



	public void ejbRemove() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbActivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbPassivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	/**

	 * An ejbCreate method as required by the EJB specification.

	 * 

	 * The container calls the instance?s <code>ejbCreate</code> method whose

	 * signature matches the signature of the <code>create</code> method invoked

	 * by the client. The input parameters sent from the client are passed to

	 * the <code>ejbCreate</code> method. Each session bean class must have at

	 * least one <code>ejbCreate</code> method. The number and signatures

	 * of a session bean?s <code>create</code> methods are specific to each 

	 * session bean class.

	 * 

	 * @throws CreateException Thrown if method fails due to system-level error.

	 * 

	 * @ejb.create-method

	 * 

	 */

	public void ejbCreate() throws CreateException {

		// TODO Add ejbCreate method implementation

	}  

	// -------------------------------------------------------------------------------------------------

	// ---------- CUESTIONARIOS VAPM  ----------

	// -------------------------------------------------------------------------------------------------



	

	 // -------------------- INI - OBTENER LISTA -------------------

    /**

     * Metodo del EJB para obtener un ArrayList de objetos

     * en funcion de los parametros del filtro

     * @param filtro - Q02bResultadosFiltro

     * @return  - ArrayList de objetos - Q02bResultadosLista

     * @throws Exception

     * @see Q02bResultadosFiltro

     * @see Q02bResultadosBean

     * @generated

     */

    public ArrayList obtenerListaResultados(HashMap filtroMapa, Q02bAutenticador autenticador) throws Exception {

        //Definici?n de constantes

        final String TRACE_METODO = "Q02bResultadosSesionBean:obtenerListaResultados";

        final String RUTA_CLASE = "q02b.exe.resultados.valueobjects.Q02bResultados";

        Q02bResultados filtroVO = new Q02bResultados();

        ArrayList lista = new ArrayList();



        if (tr.isTraceActive()) {

            tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +

                ": entrando");

            tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,

                TRACE_METODO + ": filtroMapa: " + filtroMapa.toString());

        }



        try {

            //Se instancia el bean de negocio

            bean = new Q02bResultadosBean();

            //Se pasa el autenticador

            bean.setAutenticador(autenticador);

            //Se obtiene el objeto a partir del hashmap

            filtroVO = (Q02bResultados) Q02bVoUtils.getValueObject(filtroMapa,RUTA_CLASE);

            //Se obtiene la lista con los resultados

            lista = bean.obtenerListaResultados(filtroVO);



            //Se devuelve la lista

            return lista;

        } catch (Exception ex) {

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

                TRACE_METODO + sw.getBuffer().toString());

            throw ex;

        } finally {

            if (tr.isTraceActive()) {

                tr.trace(COMPONENTE, Q70TraceLevel.INFO,

                    RUTA_CLASE + " saliendo.");

            }

        }

    }



    // -------------------- FIN - OBTENER LISTA -------------------

    

    /**

     * Mtodo que dado un resultado lo inserta en la BBDD 

     * insertara la BBDD los datos de dicho resultado

     * @param mapaResultados

     */ 

	public void insertarResultados(HashMap mapaResultados, Q02bAutenticador autenticador) throws Exception 

	{

		Q02bResultados resultado = null;

		try {

			

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarResultados: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaResultados : " + mapaResultados.toString());

			}

			//se pasa el hashmap de entrada a un objeto de tipo Q02bResultados	

			resultado = (Q02bResultados) Q02bVoUtils.getValueObject(mapaResultados,"q02b.exe.resultados.valueobjects.Q02bResultados");

			

			//se instancia el bean de negocio

	  		bean= new Q02bResultadosBean();

	  		//se pasa el autenticador

	  		bean.setAutenticador(autenticador);

	  		

	  		//se llama al mtodo del bean necesario

	  		bean.insertarResultados(resultado);		

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarResultados: " + sw.getBuffer ().toString());

			}

            

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarResultados: saliendo");

			}			

		}

	} // fin insertarResultados

	

	/**

     * Mtodo que dado el nmero interno del resultado 

     * recuperara de la BBDD los datos de dicho cuestionario

     * @param idResul

     * @return resultado

     */ 

	public HashMap obtenerResultado(String idResul, Q02bAutenticador autenticador) throws Exception 

	{		

		//Definicin de variables

		HashMap resultado =  new HashMap(); 

		Q02bResultados resultadoVO = new Q02bResultados();

		try{

			if (tr.isTraceActive())

			{

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerResultado ejb-> ** idResul=:" + idResul);	   			

	   		}			

			bean = new Q02bResultadosBean();

			

			//se pasa el autenticador

	  		bean.setAutenticador(autenticador);

	  		

	  		//se llama al mtodo del bean necesario			

	  		resultadoVO = bean.obtenerResultado(idResul);

	  		

	  		//se pasa el resultado a un hashMap

	  		resultado = (HashMap)Q02bVoUtils.getHashMap(resultadoVO);

			return resultado;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerResultado: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerResultado: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerResultado: saliendo.");

	   		}

	 	}

	}//fin obtenerOficinaMunicipal

	

	/**

	 * Modificar en bbdd un resultado con los datos pasados como parmetro en la HashMap

	 */

	public void modificarResultados(HashMap mapaResultado, Q02bAutenticador autenticador) throws Exception

	{

		Q02bResultados resultado = null;	  	

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarResultados: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaResultado : " + mapaResultado.toString());

			}			

			//se pasa el hashmap de entrada a un objeto de tipo Q02bResultados

			resultado = (Q02bResultados) Q02bVoUtils.getValueObject(mapaResultado,"q02b.exe.resultados.valueobjects.Q02bResultados");

			

			bean= new Q02bResultadosBean();

			//se pasa el autenticador

	  		bean.setAutenticador(autenticador);

			//se llama al metodo del bean para modificar el contacto

			bean.modificarResultados(resultado);			

		}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarResultados: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarResultados: saliendo");

			 }

		 }		

	} // fin modificarResultados



	/**

	 * Borrar de bbdd un resultado

	 * @param idResul - Nmero interno del resultado a borrar

	 */

	public void borrarResultado(String idResul, Q02bAutenticador autenticador) throws Exception

	{

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarResultado: entrando con resultado: " + idResul);

			}

			bean= new Q02bResultadosBean();

			//se pasa el autenticador

			bean.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario

			bean.borrarResultado(idResul);			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarResultado: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarResultado: saliendo");

			 }	

		 }			  

	} // fin borrarResultado

	

	

} // fin clase

