package q02bPlazosSesionEJB;



import java.rmi.RemoteException;

import java.util.ArrayList;

import java.util.HashMap;



import javax.ejb.CreateException;

import javax.ejb.EJBException;

import javax.ejb.SessionBean;



import q02b.exe.comun.Q02bAplicException;

import q02b.exe.comun.Q02bAutenticador;

import q02b.exe.plazos.beans.Q02bPlazosBean;

import q02b.exe.plazos.valueobjects.Q02bPlazos;

import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

 

/**

 * XDoclet-based session bean.  The class must be declared

 * public according to the EJB specification.

 *

 * To generate the EJB related files to this EJB:

 *		- Add Standard EJB module to XDoclet project properties

 *		- Customize XDoclet configuration for your appserver

 *		- Run XDoclet

 *

 * Below are the xdoclet-related tags needed for this EJB.

 * 

 * @ejb.bean name="Q02bPlazosSesion"

 *           display-name="Name for Q02bPlazosSesion"

 *           description="Description for Q02bPlazosSesion"

 *           jndi-name="ejb/Q02bPlazosSesion"

 *           type="Stateless"

 *           view-type="remote"

 */

  



public class Q02bPlazosSesionBean implements SessionBean {



	

	private static final long serialVersionUID = 4131248384461301469L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "EJB_SESION_DATOS";

	protected Q02bPlazosBean beanPlazos= null;

	

	/** The session context */

	private javax.ejb.SessionContext mySessionCtx;



	 

	

	public Q02bPlazosSesionBean() {

		super();

		// TODO Auto-generated constructor stub

	}

	/**

	 * Set the associated session context. The container calls this method 

	 * after the instance creation.

	 * 

	 * The enterprise bean instance should store the reference to the context 

	 * object in an instance variable.

	 * 

	 * This method is called with no transaction context. 

	 * 

	 * @throws EJBException Thrown if method fails due to system-level error.

	 */

	/**

	 * getSessionContext

	 */

	public javax.ejb.SessionContext getSessionContext() {

		return mySessionCtx;

	}

	/**

	 * setSessionContext

	 */

	public void setSessionContext(javax.ejb.SessionContext ctx) {

		mySessionCtx = ctx;

	}



	public void ejbRemove() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbActivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbPassivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	/**

	 * An ejbCreate method as required by the EJB specification.

	 * 

	 * The container calls the instance?s <code>ejbCreate</code> method whose

	 * signature matches the signature of the <code>create</code> method invoked

	 * by the client. The input parameters sent from the client are passed to

	 * the <code>ejbCreate</code> method. Each session bean class must have at

	 * least one <code>ejbCreate</code> method. The number and signatures

	 * of a session bean?s <code>create</code> methods are specific to each 

	 * session bean class.

	 * 

	 * @throws CreateException Thrown if method fails due to system-level error.

	 * 

	 * @ejb.create-method

	 * 

	 */

	public void ejbCreate() throws CreateException {

		// TODO Add ejbCreate method implementation

	}  

	// -------------------------------------------------------------------------------------------------

	// ---------- PLAZOS  ----------

	// -------------------------------------------------------------------------------------------------



	/**

	 * Obtener la lista de plazos

	 * @return Devuelve la lista de plazos

	 * @throws Exception

	 */

	public ArrayList obtenerPlazos(java.util.HashMap mapaFiltroPlazos, Q02bAutenticador autenticador) throws Exception 

	{	

		//Definicin de variables			 		

		Q02bPlazos filtroPlazos = new Q02bPlazos();

		ArrayList listaPlazos= new ArrayList(); 

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazos: entrando.");

	   		}		

			beanPlazos= new Q02bPlazosBean();

			beanPlazos.setAutenticador(autenticador);

			filtroPlazos = (Q02bPlazos) Q02bVoUtils.getValueObject(mapaFiltroPlazos,"q02b.exe.plazos.valueobjects.Q02bPlazos");

			listaPlazos = beanPlazos.getPlazos(filtroPlazos);

			return listaPlazos;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazos: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerPlazos: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazos: saliendo.");

	   		}

	 	}

	}//fin obtenerPlazos

	

	/**

     * Mtodo que dado el nmero interno del plazo 

     * recuperara de la BBDD los datos de dicho cuestionario

     * @param niPlazo

     * @return plazo

     */ 

	public HashMap obtenerPlazo(String niPlazo, Q02bAutenticador autenticador) throws Exception 

	{		

		//Definicin de variables

		HashMap plazo =  new HashMap(); 

		Q02bPlazos plazoVO = new Q02bPlazos();

		try{

			if (tr.isTraceActive())

			{

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazo ejb-> ** niPlazo=:" + niPlazo);	   			

	   		}			

			beanPlazos= new Q02bPlazosBean();

			

			//se pasa el autenticador

	  		beanPlazos.setAutenticador(autenticador);

	  		

	  		//se llama al mtodo del bean necesario			

	  		plazoVO = beanPlazos.obtenerPlazo(niPlazo);

	  		

	  		//se pasa el resultado a un hashMap

	  		plazo = (HashMap)Q02bVoUtils.getHashMap(plazoVO);

			return plazo;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazo: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerPlazo: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazo: saliendo.");

	   		}

	 	}

	}//fin obtenerPlazo

	

	/**

     * Mtodo que dado un plazo lo inserta en la BBDD 

     * insertara la BBDD los datos de dicho plazo

     * @param mapaPlazos

     */ 

	public void insertarPlazos(HashMap mapaPlazos, Q02bAutenticador autenticador) throws Exception 

	{

		Q02bPlazos plazo = null;

		try {

			

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarPlazos: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaPlazos : " + mapaPlazos.toString());

			}

			//se pasa el hashmap de entrada a un objeto de tipo Q02bCuestionarioVTMAnu	

			plazo = (Q02bPlazos) Q02bVoUtils.getValueObject(mapaPlazos,"q02b.exe.plazos.valueobjects.Q02bPlazos");

			

			//se instancia el bean de negocio

	  		beanPlazos= new Q02bPlazosBean();

	  		//se pasa el autenticador

	  		beanPlazos.setAutenticador(autenticador);

	  		

	  		//se llama al mtodo del bean necesario

	  		beanPlazos.insertarPlazos(plazo);		

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarPlazos: " + sw.getBuffer ().toString());

			}

            

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarPlazos: saliendo");

			}			

		}

	} // fin insertarPlazos

	

	/**

	 * Borrar de bbdd un plazo

	 * @param niPlazo - Nmero interno del plazo a borrar

	 */

	public void borrarPlazos(String niPlazo, Q02bAutenticador autenticador) throws Exception

	{

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarPlazos: entrando con plazo: " + niPlazo);

			}

			beanPlazos= new Q02bPlazosBean();

			//se pasa el autenticador

	  		beanPlazos.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario

			beanPlazos.borrarPlazos(niPlazo);			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarPlazos: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarPlazos: saliendo");

			 }	

		 }			  

	} // fin borrarPlazos

	

	/**

	 * Modificar en bbdd un plazo con los datos pasados como parmetro en la HashMap

	 */

	public void modificarPlazos(HashMap mapaPlazos, Q02bAutenticador autenticador) throws Exception

	{

		Q02bPlazos plazo = null;	  	

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarPlazos: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaPlazos : " + mapaPlazos.toString());

			}			

			//se pasa el hashmap de entrada a un objeto de tipo Q02bPlazos

			plazo = (Q02bPlazos) Q02bVoUtils.getValueObject(mapaPlazos,"q02b.exe.plazos.valueobjects.Q02bPlazos");

			

			beanPlazos= new Q02bPlazosBean();

			//se pasa el autenticador

	  		beanPlazos.setAutenticador(autenticador);

			//se llama al metodo del bean para modificar el contacto

			beanPlazos.modificarPlazos(plazo);			

		}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarPlazos: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarPlazos: saliendo");

			 }

		 }		

	} // fin modificarPlazos

	

	// --------------------------------------------------------------------------

	// ---------- FIN PLAZOS -----------

	// ---------------------------------------------------------------------------



} // fin clase

