package q02bModulosSesionEJB;



import java.rmi.RemoteException;

import java.util.ArrayList;

import java.util.HashMap;



import javax.ejb.CreateException;

import javax.ejb.EJBException;

import javax.ejb.SessionBean;



import q02b.exe.comun.Q02bAplicException;

import q02b.exe.comun.Q02bAutenticador;

import q02b.exe.modulos.beans.Q02bModulosBean;

import q02b.exe.modulos.valueobjects.Q02bModulos;

import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

 

/**

 * XDoclet-based session bean.  The class must be declared

 * public according to the EJB specification.

 *

 * To generate the EJB related files to this EJB:

 *		- Add Standard EJB module to XDoclet project properties

 *		- Customize XDoclet configuration for your appserver

 *		- Run XDoclet

 *

 * Below are the xdoclet-related tags needed for this EJB.

 * 

 * @ejb.bean name="Q02bPlazosSesion"

 *           display-name="Name for Q02bPlazosSesion"

 *           description="Description for Q02bPlazosSesion"

 *           jndi-name="ejb/Q02bPlazosSesion"

 *           type="Stateless"

 *           view-type="remote"

 */

  



public class Q02bModulosSesionBean implements SessionBean {



	

	private static final long serialVersionUID = 4131248384461301469L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "EJB_SESION_DATOS";

	protected Q02bModulosBean beanModulos= null;

	

	/** The session context */

	private javax.ejb.SessionContext mySessionCtx;



	 

	

	public Q02bModulosSesionBean() {

		super();

		// TODO Auto-generated constructor stub

	}

	/**

	 * Set the associated session context. The container calls this method 

	 * after the instance creation.

	 * 

	 * The enterprise bean instance should store the reference to the context 

	 * object in an instance variable.

	 * 

	 * This method is called with no transaction context. 

	 * 

	 * @throws EJBException Thrown if method fails due to system-level error.

	 */

	/**

	 * getSessionContext

	 */

	public javax.ejb.SessionContext getSessionContext() {

		return mySessionCtx;

	}

	/**

	 * setSessionContext

	 */

	public void setSessionContext(javax.ejb.SessionContext ctx) {

		mySessionCtx = ctx;

	}



	public void ejbRemove() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbActivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbPassivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	/**

	 * An ejbCreate method as required by the EJB specification.

	 * 

	 * The container calls the instance?s <code>ejbCreate</code> method whose

	 * signature matches the signature of the <code>create</code> method invoked

	 * by the client. The input parameters sent from the client are passed to

	 * the <code>ejbCreate</code> method. Each session bean class must have at

	 * least one <code>ejbCreate</code> method. The number and signatures

	 * of a session bean?s <code>create</code> methods are specific to each 

	 * session bean class.

	 * 

	 * @throws CreateException Thrown if method fails due to system-level error.

	 * 

	 * @ejb.create-method

	 * 

	 */

	public void ejbCreate() throws CreateException {

		// TODO Add ejbCreate method implementation

	}  

	// -------------------------------------------------------------------------------------------------

	// ---------- PLAZOS  ----------

	// -------------------------------------------------------------------------------------------------



	/**

	 * Obtener la lista de modulos

	 * @return Devuelve la lista de modulos

	 * @throws Exception

	 */

	public ArrayList obtenerModulos(java.util.HashMap mapaFiltroModulos, Q02bAutenticador autenticador) throws Exception 

	{	

		//Definicin de variables			 		

		Q02bModulos filtroModulos = new Q02bModulos();

		ArrayList listaModulos= new ArrayList(); 

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerModulos: entrando.");

	   		}		

			beanModulos= new Q02bModulosBean();

			beanModulos.setAutenticador(autenticador);

			filtroModulos = (Q02bModulos) Q02bVoUtils.getValueObject(mapaFiltroModulos,"q02b.exe.modulos.valueobjects.Q02bModulos");

			listaModulos = beanModulos.obtenerModulos(filtroModulos);

			return listaModulos;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerModulos: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerModulos: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerModulos: saliendo.");

	   		}

	 	}

	}//fin obtenerModulos

	

	/**

     * Mtodo que dado el nmero interno del mdulo

     * recuperara de la BBDD los datos de dicho mdulo

     * @param idModulo

     * @return mapaModulo

     */ 

	public HashMap obtenerModulo(String idModulo, Q02bAutenticador autenticador) throws Exception 

	{		

		//Definicin de variables

		HashMap mapaModulo =  new HashMap(); 

		Q02bModulos moduloVO = new Q02bModulos();

		try{

			if (tr.isTraceActive())

			{

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerModulo ejb-> ** idModulo=:" + idModulo);	   			

	   		}			

			beanModulos= new Q02bModulosBean();

			

			//se pasa el autenticador

	  		beanModulos.setAutenticador(autenticador);

	  		

	  		//se llama al mtodo del bean necesario			

	  		moduloVO = beanModulos.obtenerModulo(idModulo);

	  		

	  		//se pasa el resultado a un hashMap

	  		mapaModulo = (HashMap)Q02bVoUtils.getHashMap(moduloVO);

			return mapaModulo;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerModulo: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerModulo: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerModulo: saliendo.");

	   		}

	 	}

	}//fin obtenerModulo

	

	/**

     * Mtodo que dado un mdulo lo inserta en la BBDD 

     * insertara la BBDD los datos de dicho mdulo

     * @param mapaModulos

     */ 

	public void insertarModulos(HashMap mapaModulos, Q02bAutenticador autenticador) throws Exception 

	{

		Q02bModulos modulo = null;

		try {

			

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarModulos: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaPlazos : " + mapaModulos.toString());

			}

			//se pasa el hashmap de entrada a un objeto de tipo Q02bModulos	

			modulo = (Q02bModulos) Q02bVoUtils.getValueObject(mapaModulos,"q02b.exe.modulos.valueobjects.Q02bModulos");

			

			//se instancia el bean de negocio

	  		beanModulos= new Q02bModulosBean();

	  		//se pasa el autenticador

	  		beanModulos.setAutenticador(autenticador);

	  		

	  		//se llama al mtodo del bean necesario

	  		beanModulos.insertarModulos(modulo);		

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarModulos: " + sw.getBuffer ().toString());

			}

            

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarModulos: saliendo");

			}			

		}

	} // fin insertarModulos

	

	/**

	 * Borrar de bbdd un mdulo

	 * @param idModulo - Nmero interno del mdulo a borrar

	 */

	public void borrarModulos(String idModulo, Q02bAutenticador autenticador) throws Exception

	{

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarModulos: entrando con plazo: " + idModulo);

			}

			beanModulos= new Q02bModulosBean();

			//se pasa el autenticador

	  		beanModulos.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario

			beanModulos.borrarModulos(idModulo);			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarModulos: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarModulos: saliendo");

			 }	

		 }			  

	} // fin borrarModulos

	

	

	/**

	 * Activar de bbdd un mdulo

	 * @param idModulo - Nmero interno del mdulo a activar

	 */

	public void activarModulos(String idModulo, Q02bAutenticador autenticador) throws  Exception

	{

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":activarModulos: entrando con plazo: " + idModulo);

			}

			beanModulos= new Q02bModulosBean();

			//se pasa el autenticador

	  		beanModulos.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario

			beanModulos.activarModulos(idModulo);			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":activarModulos: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":activarModulos: saliendo");

			 }	

		 }	

		

	}// fin ActivarMdulo

	

	/**

	 * DesactivarModulos de bbdd un mdulo

	 * @param idModulo - Nmero interno del mdulo a desactivar

	 */

	public void desactivarModulos(String idModulo, Q02bAutenticador autenticador) throws  Exception

	{

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":desactivarModulos: entrando con plazo: " + idModulo);

			}

			beanModulos= new Q02bModulosBean();

			//se pasa el autenticador

	  		beanModulos.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario

			beanModulos.desactivarModulos(idModulo);			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":desactivarModulos: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":desactivarModulos: saliendo");

			 }	

		 }	

		

	}

	

	/**

	 * Modificar en bbdd un mdulo con los datos pasados como parmetro en la HashMap

	 */

	public void modificarModulos(HashMap mapaModulos, Q02bAutenticador autenticador) throws Exception

	{

		Q02bModulos modulo = null;	  	

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarModulos: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaModulos : " + mapaModulos.toString());

			}			

			//se pasa el hashmap de entrada a un objeto de tipo Q02bModulos

			modulo = (Q02bModulos) Q02bVoUtils.getValueObject(mapaModulos,"q02b.exe.modulos.valueobjects.Q02bModulos");

			

			beanModulos= new Q02bModulosBean();

			//se pasa el autenticador

	  		beanModulos.setAutenticador(autenticador);

			//se llama al metodo del bean para modificar el contacto

			beanModulos.modificarModulos(modulo);			

		}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarModulos: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarModulos: saliendo");

			 }

		 }		

	} // fin modificarModulos

	

	// --------------------------------------------------------------------------

	// ---------- FIN PLAZOS -----------

	// ---------------------------------------------------------------------------



} // fin clase

