package q02bGruposSesionEJB;



import java.rmi.RemoteException;

import java.util.ArrayList;

import java.util.HashMap;



import javax.ejb.CreateException;

import javax.ejb.EJBException;

import javax.ejb.SessionBean;



import q02b.exe.comun.Q02bAplicException;

import q02b.exe.comun.Q02bAutenticador;

import q02b.exe.grupos.beans.Q02bGruposBean;

import q02b.exe.grupos.valueobjects.Q02bGrupos;

import q02b.exe.procesos.beans.Q02bProcesosBean;

import q02b.exe.procesos.valueobjects.Q02bProcesos;

import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

 

/**

 * XDoclet-based session bean.  The class must be declared

 * public according to the EJB specification.

 *

 * To generate the EJB related files to this EJB:

 *		- Add Standard EJB module to XDoclet project properties

 *		- Customize XDoclet configuration for your appserver

 *		- Run XDoclet

 *

 * Below are the xdoclet-related tags needed for this EJB.

 * 

 * @ejb.bean name="Q02bPlazosSesion"

 *           display-name="Name for Q02bPlazosSesion"

 *           description="Description for Q02bPlazosSesion"

 *           jndi-name="ejb/Q02bPlazosSesion"

 *           type="Stateless"

 *           view-type="remote"

 */

  



public class Q02bGruposSesionBean implements SessionBean {



	

	private static final long serialVersionUID = 4131248384461301469L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "EJB_SESION_DATOS";

	protected Q02bGruposBean beanGrupos= null;

	

	/** The session context */

	private javax.ejb.SessionContext mySessionCtx;



	 

	

	public Q02bGruposSesionBean() {

		super();

		// TODO Auto-generated constructor stub

	}

	/**

	 * Set the associated session context. The container calls this method 

	 * after the instance creation.

	 * 

	 * The enterprise bean instance should store the reference to the context 

	 * object in an instance variable.

	 * 

	 * This method is called with no transaction context. 

	 * 

	 * @throws EJBException Thrown if method fails due to system-level error.

	 */

	/**

	 * getSessionContext

	 */

	public javax.ejb.SessionContext getSessionContext() {

		return mySessionCtx;

	}

	/**

	 * setSessionContext

	 */

	public void setSessionContext(javax.ejb.SessionContext ctx) {

		mySessionCtx = ctx;

	}



	public void ejbRemove() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbActivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbPassivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	/**

	 * An ejbCreate method as required by the EJB specification.

	 * 

	 * The container calls the instance?s <code>ejbCreate</code> method whose

	 * signature matches the signature of the <code>create</code> method invoked

	 * by the client. The input parameters sent from the client are passed to

	 * the <code>ejbCreate</code> method. Each session bean class must have at

	 * least one <code>ejbCreate</code> method. The number and signatures

	 * of a session bean?s <code>create</code> methods are specific to each 

	 * session bean class.

	 * 

	 * @throws CreateException Thrown if method fails due to system-level error.

	 * 

	 * @ejb.create-method

	 * 

	 */

	public void ejbCreate() throws CreateException {

		// TODO Add ejbCreate method implementation

	}  

	// -------------------------------------------------------------------------------------------------

	// ---------- PLAZOS  ----------

	// -------------------------------------------------------------------------------------------------



	/**

	 * Obtener la lista de grupos

	 * @return Devuelve la lista de grupos

	 * @throws Exception

	 */

	public ArrayList obtenerGrupos(java.util.HashMap mapaFiltroGrupos, Q02bAutenticador autenticador) throws Exception 

	{	

		//Definicin de variables			 		

		Q02bGrupos filtroGrupos = new Q02bGrupos();

		ArrayList listaGrupos= new ArrayList(); 

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupos: entrando.");

	   		}		

			beanGrupos= new Q02bGruposBean();

			beanGrupos.setAutenticador(autenticador);

			filtroGrupos = (Q02bGrupos) Q02bVoUtils.getValueObject(mapaFiltroGrupos,"q02b.exe.grupos.valueobjects.Q02bGrupos");

			listaGrupos = beanGrupos.obtenerGrupos(filtroGrupos);

			return listaGrupos;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupos: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGrupos: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupos: saliendo.");

	   		}

	 	}

	}//fin obtenerGrupos

	

	/**

     * Mtodo que dado el nmero interno del grupo

     * recuperara de la BBDD los datos de dicho grupo

     * @param niGrupo

     * @return grupo

     */ 

/*	public HashMap obtenerGrupo(String niGrupo, Q02bAutenticador autenticador) throws Exception 

	{		

		//Definicin de variables

		HashMap mapaGrupo =  new HashMap(); 

		Q02bGrupos grupoVO = new Q02bGrupos();

		try{

			if (tr.isTraceActive())

			{

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupo ejb-> ** niGrupo=:" + niGrupo);	   			

	   		}			

			beanGrupos= new Q02bGruposBean();

			

			//se pasa el autenticador

	  		beanGrupos.setAutenticador(autenticador);

	  		

	  		//se llama al mtodo del bean necesario			

	  		grupoVO = beanGrupos.obtenerGrupo(niGrupo);

	  		

	  		//se pasa el resultado a un hashMap

	  		mapaGrupo = (HashMap)Q02bVoUtils.getHashMap(grupoVO);

			return mapaGrupo;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupo: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGrupo: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupo: saliendo.");

	   		}

	 	}

	}//fin obtenerGrupo*/

	

	public HashMap obtenerGrupoModificacion(String niGrupo, Q02bAutenticador autenticador) throws Exception {

		//Definicin de variables que no se van a modificar

		final String TRACE_METODO 	= ":obtenerGrupoModificacion:";

		//Definicin de objetos

		Q02bGrupos	grupo	= new Q02bGrupos();

		HashMap grupoHashMap		= new HashMap(); 

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando " + niGrupo);

	   		}

			//Se instancia el bean de negocio

			beanGrupos = new Q02bGruposBean();

			//Se pasa el autenticador

			beanGrupos.setAutenticador(autenticador);

			//Se obtiene la lista con los grupos

			grupo = beanGrupos.obtenerGrupoModificacion(niGrupo);

			//Se obtiene el objeto a partir del hashmap

			grupoHashMap = (HashMap)Q02bVoUtils.getHashMap(grupo);

			//Se devuelve la lista

			return grupoHashMap;

		}catch(Exception ex){	 	

			java.io.StringWriter 	sw = new java.io.StringWriter();

			java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " saliendo.");

	   		}

	 	}

	}//fin obtenerGrupoModificacion

	

	/**

     * Mtodo que dado un grupo lo inserta en la BBDD 

     * insertara la BBDD los datos de dicho grupo

     * @param grupo

     */ 

	public void insertarGrupos(HashMap mapaGrupos, Q02bAutenticador autenticador) throws Exception 

	{

		Q02bGrupos grupo = null;

		try {

			

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGrupos: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap grupo : " + mapaGrupos.toString());

			}

			//se pasa el hashmap de entrada a un objeto de tipo Q02bGrupos	

			grupo = (Q02bGrupos) Q02bVoUtils.getValueObject(mapaGrupos,"q02b.exe.grupos.valueobjects.Q02bGrupos");

			

			//se instancia el bean de negocio

	  		beanGrupos= new Q02bGruposBean();

	  		//se pasa el autenticador

	  		beanGrupos.setAutenticador(autenticador);

	  		

	  		//se llama al mtodo del bean necesario

	  		beanGrupos.insertarGrupos(grupo);		

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarGrupos: " + sw.getBuffer ().toString());

			}

            

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGrupos: saliendo");

			}			

		}

	} // fin insertarModulos

	

	/**

	 * Borrar de bbdd un grupo

	 * @param niGrupo - Nmero interno del grupo a borrar

	 */

	public void borrarGrupos(String niGrupo, Q02bAutenticador autenticador) throws Exception

	{

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarGrupos: entrando con niGrupo: " + niGrupo);

			}

			beanGrupos= new Q02bGruposBean();

			//se pasa el autenticador

	  		beanGrupos.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario

			beanGrupos.borrarGrupos(niGrupo);			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarGrupos: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarGrupos: saliendo");

			 }	

		 }			  

	} // fin borrarGrupos

	

	/**

	 * Modificar en bbdd un grupo con los datos pasados como parmetro en la HashMap

	 */

	public void modificarGrupos(HashMap mapaGrupos, Q02bAutenticador autenticador) throws Exception

	{

		Q02bGrupos grupo = null;	  	

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarGrupos: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaGrupos : " + mapaGrupos.toString());

			}			

			//se pasa el hashmap de entrada a un objeto de tipo Q02bModulos

			grupo = (Q02bGrupos) Q02bVoUtils.getValueObject(mapaGrupos,"q02b.exe.grupos.valueobjects.Q02bGrupos");

			

			beanGrupos= new Q02bGruposBean();

			//se pasa el autenticador

	  		beanGrupos.setAutenticador(autenticador);

			//se llama al metodo del bean para modificar el contacto

			beanGrupos.modificarGrupos(grupo);			

		}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarGrupos: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarGrupos: saliendo");

			 }

		 }		

	} // fin modificarGrupos

	

	/**

	 * Mtodo que llama a un Bean para obtener los datos de un grupo para su consulta.

	 * @param niGrupo nmero interno del grupo en la bbdd.

	 * @param autenticador Objeto con el id. y perfil de usuario e idioma. 

	 * @return HashMap con los datos del grupo.

	 * @throws Exception

	 */

	public HashMap obtenerGrupoConsulta(String niGrupo, Q02bAutenticador autenticador) throws Exception {

		//Definicin de variables que no se van a modificar

		final String TRACE_METODO 	= ":obtenerGrupoConsulta:";

		//Definicin de objetos

		Q02bGrupos grupo = new Q02bGrupos();

		HashMap grupoHashMap = new HashMap(); 

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando " + niGrupo);

	   		}

			//Se instancia el bean de negocio

			beanGrupos = new Q02bGruposBean();

			//Se pasa el autenticador

			beanGrupos.setAutenticador(autenticador);

			//Se obtiene la lista con los grupos

			grupo = beanGrupos.obtenerGrupoConsulta(niGrupo);

			//Se obtiene el objeto a partir del hashmap

			grupoHashMap = (HashMap)Q02bVoUtils.getHashMap(grupo);

			//Se devuelve la lista

			return grupoHashMap;

		}catch(Exception ex){	 	

			java.io.StringWriter 	sw = new java.io.StringWriter();

			java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " saliendo.");

	   		}

	 	}

	}// fin obtenerGrupoConsulta

	

	// --------------------------------------------------------------------------

	// ---------- FIN GRUPOS -----------

	// ---------------------------------------------------------------------------



} // fin clase

