package q02bCuestionariosVTMAnuSesionEJB;



import java.rmi.RemoteException;

import java.util.ArrayList;

import java.util.HashMap;



import javax.ejb.CreateException;

import javax.ejb.EJBException;

import javax.ejb.SessionBean;



import q02b.exe.comun.Q02bAplicException;

import q02b.exe.comun.Q02bAutenticador;

import q02b.exe.cuestionariosSMAnu.valueobjects.Q02bCuestionarioSMFiltro;

import q02b.exe.cuestionariosVTMAnu.beans.Q02bCuestionariosVTMAnuBean;

import q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMAnu;

import q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMAnuFiltro;

import q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMFiltro;

import q02b.exe.utils.Q02bFormatData;

import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

import org.w3c.dom.Document;

 

/**

 * XDoclet-based session bean.  The class must be declared

 * public according to the EJB specification.

 *

 * To generate the EJB related files to this EJB:

 *		- Add Standard EJB module to XDoclet project properties

 *		- Customize XDoclet configuration for your appserver

 *		- Run XDoclet

 *

 * Below are the xdoclet-related tags needed for this EJB.

 * 

 * @ejb.bean name="Q02bCuestionariosVTMAnuSesion"

 *           display-name="Name for Q02bCuestionariosVTMAnuSesion"

 *           description="Description for Q02bCuestionariosVTMAnuSesion"

 *           jndi-name="ejb/Q02bCuestionariosVTMAnuSesion"

 *           type="Stateless"

 *           view-type="remote"

 */

  



public class Q02bCuestionariosVTMAnuSesionBean implements SessionBean {



	

	private static final long serialVersionUID = 4131248384461301469L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "EJB_SESION_DATOS";

	protected Q02bCuestionariosVTMAnuBean beanCuestionarioVTMAnu= null;

	

	/** The session context */

	private javax.ejb.SessionContext mySessionCtx;



	 

	

	public Q02bCuestionariosVTMAnuSesionBean() {

		super();

		// TODO Auto-generated constructor stub

	}

	/**

	 * Set the associated session context. The container calls this method 

	 * after the instance creation.

	 * 

	 * The enterprise bean instance should store the reference to the context 

	 * object in an instance variable.

	 * 

	 * This method is called with no transaction context. 

	 * 

	 * @throws EJBException Thrown if method fails due to system-level error.

	 */

	/**

	 * getSessionContext

	 */

	public javax.ejb.SessionContext getSessionContext() {

		return mySessionCtx;

	}

	/**

	 * setSessionContext

	 */

	public void setSessionContext(javax.ejb.SessionContext ctx) {

		mySessionCtx = ctx;

	}



	public void ejbRemove() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbActivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbPassivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	/**

	 * An ejbCreate method as required by the EJB specification.

	 * 

	 * The container calls the instance?s <code>ejbCreate</code> method whose

	 * signature matches the signature of the <code>create</code> method invoked

	 * by the client. The input parameters sent from the client are passed to

	 * the <code>ejbCreate</code> method. Each session bean class must have at

	 * least one <code>ejbCreate</code> method. The number and signatures

	 * of a session bean?s <code>create</code> methods are specific to each 

	 * session bean class.

	 * 

	 * @throws CreateException Thrown if method fails due to system-level error.

	 * 

	 * @ejb.create-method

	 * 

	 */

	public void ejbCreate() throws CreateException {

		// TODO Add ejbCreate method implementation

	}  

	// -------------------------------------------------------------------------------------------------

	// ---------- CUESTIONARIOS VIVIENDA TASADA MUNICIPAL  ----------

	// -------------------------------------------------------------------------------------------------



	/**

	 * Insertar en bbdd un  nuevo cuestionario con los datos pasados como parmetro en la HashMap

	 */

	public String insertarCuestionarioVTMAnu(HashMap mapaCuestionarioVTMAnu, HashMap mapaFiltroPortadaCuestionarioVTM) throws Exception 

	{

		String niCuestionarioVTMAnu = "";

		Q02bCuestionarioVTMAnu cuestionarioVTMAnu = null;

		Q02bCuestionarioVTMAnuFiltro cuestionarioVTMFiltroPortada = null;

		String niGrupoCuesVTMAnu = null;

		try {

			

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioVTMAnu: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaCuestionarioVTMAnu : " + mapaCuestionarioVTMAnu.toString());

			}

			//se pasa el hashmap de entrada a un objeto de tipo Q02bCuestionarioVTMAnu	

			

			cuestionarioVTMAnu = (Q02bCuestionarioVTMAnu) Q02bVoUtils.getValueObject(mapaCuestionarioVTMAnu,"q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMAnu");

			

			//se instancia el bean de negocio

	  		beanCuestionarioVTMAnu= new Q02bCuestionariosVTMAnuBean();

	  		//se pasa el autenticador

	  		//beanCuestionarioVTMAnu.setAutenticador(autenticador);

	  		

	  		//En caso de que vengamos de la portada, el campo niGrupoVTMAnu del mapa no va a tener ningn valor

	  		//Puede que est en el contexto (en caso de que estemos haciendo altas para los mismo parmetros de portada)

	  		//o  no, en cuyo caso lo tendremos que obtener

	  		if(Q02bFormatData.esNullSinCero(cuestionarioVTMAnu.getNiGrupoCuesVTMAnu()).equals("")){ 

	  			cuestionarioVTMFiltroPortada = (Q02bCuestionarioVTMAnuFiltro) Q02bVoUtils.getValueObject(mapaFiltroPortadaCuestionarioVTM,"q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMAnuFiltro");

	  			niGrupoCuesVTMAnu = beanCuestionarioVTMAnu.altaModifGrupoCuestionariosVTMAnu(cuestionarioVTMFiltroPortada);

	  			cuestionarioVTMAnu.setNiGrupoCuesVTMAnu(niGrupoCuesVTMAnu);

	  		}

	  		else niGrupoCuesVTMAnu = cuestionarioVTMAnu.getNiGrupoCuesVTMAnu();

	  		

	  		//Miramos si hay que modificar el campo indicativo de si se han concedido licencias

	  		//Si el campo tiene valor 1, habr que modificar el campo de la BD con el valor que tenga el campo realizaActuacion

	  		//Si el campo tiene valor 0, habr que borrar los cuestionarios rellenados anteriormente y modificar el campo de la BD con el valor que tenga el campo realizaActuacion 

	  		if(cuestionarioVTMFiltroPortada!= null && Q02bFormatData.esNullSinCero(cuestionarioVTMFiltroPortada.getModificarConcedidoLicen()).equals("1")){

	  			beanCuestionarioVTMAnu.modificarGrupoCuestionariosVTM(niGrupoCuesVTMAnu,cuestionarioVTMFiltroPortada.getRealizaActuacion(),cuestionarioVTMFiltroPortada.getMes(), cuestionarioVTMFiltroPortada.getObsVTM());

	  		}

	  		

	  		//se llama al mtodo del bean necesario

	  		niCuestionarioVTMAnu= beanCuestionarioVTMAnu.insertarCuestionarioVTMAnu(cuestionarioVTMAnu);

			return niCuestionarioVTMAnu;			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioVTMAnu: " + sw.getBuffer ().toString());

			}

            

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioVTMAnu: saliendo");

			}			

		}

	} // fin insertarCuestionarioVTMAnu

	/**

	 * Borrar de bbdd un cuestionario

	 * 

	 * @param niCuestionarioVTMAnu - Nmero interno del cuestionario a borrar

	 *

	 */

	public void borrarCuestionarioVTMAnu(String niCuestionarioVTMAnu,String niGrupoCuestionarioVTMAnu) throws Exception

	{

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVTMAnu: entrando con cuestionario: " + niCuestionarioVTMAnu);

			}

			beanCuestionarioVTMAnu= new Q02bCuestionariosVTMAnuBean();

			//se pasa el autenticador

	  		//beanCuestionarioVTMAnu.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario

			beanCuestionarioVTMAnu.borrarCuestionarioVTMAnu(niCuestionarioVTMAnu,niGrupoCuestionarioVTMAnu);			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioVTMAnu: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVTMAnu: saliendo");

			 }	

		 }			 

		 

	} // fin borrarCuestionarioVTMAnu

	/**

	 * Modificar en bbdd un cuestionario con los datos pasados como parmetro en la HashMap

	 */

	public void modificarCuestionarioVTMAnu(HashMap mapaCuestionarioVTMAnu) throws Exception

	{

		Q02bCuestionarioVTMAnu cuestionarioVTMAnu = null;	  	

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVTMAnu: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaCuestionarioVTMAnu : " + mapaCuestionarioVTMAnu.toString());

			}			

			//se pasa el hashmap de entrada a un objeto de tipo Q02bCuestionarioVTMAnu

			cuestionarioVTMAnu = (Q02bCuestionarioVTMAnu) Q02bVoUtils.getValueObject(mapaCuestionarioVTMAnu,"q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMAnu");

			

			beanCuestionarioVTMAnu= new Q02bCuestionariosVTMAnuBean();

			//se pasa el autenticador

	  		//beanCuestionarioVTMAnu.setAutenticador(autenticador);

			//se llama al metodo del bean para modificar el contacto

			beanCuestionarioVTMAnu.modificarCuestionarioVTMAnu(cuestionarioVTMAnu);			

		}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVTMAnu: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVTMAnu: saliendo");

			 }

		 }		

	} // fin modificarCuestionarioVTMAnu



	

	/**

	/**

     * Mtodo que dado el nmero interno del cuestionario recuperara de la BBDD

     * los datos de dicho cuestionario

     * @param niCuestionarioVTMAnu

     * @return cuestionarioVTMAnu

     */

	 

	public HashMap obtenerCuestionarioVTMAnu(String niCuestionarioVTMAnu,String niGrupoCuestionarioVTMAnu ) throws Exception 

	{		

		//Definicin de variables

		HashMap cuestionarioVTMAnu =  new HashMap(); 

		Q02bCuestionarioVTMAnu cuestionarioVTMAnuVO = new Q02bCuestionarioVTMAnu();

		try{

			if (tr.isTraceActive())

			{

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVTMAnu ejb-> ** niCuestionarioVTMAnu=:" + niCuestionarioVTMAnu + "  , niGrupoCuestionarioVTMAnu = " + niGrupoCuestionarioVTMAnu+ " ** entrando.");	   			

	   		}			

			beanCuestionarioVTMAnu= new Q02bCuestionariosVTMAnuBean();

			//se pasa el autenticador

	  		//beanCuestionarioVTMAnu.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario			

	  		cuestionarioVTMAnuVO = beanCuestionarioVTMAnu.obtenerCuestionarioVTMAnu(niCuestionarioVTMAnu,niGrupoCuestionarioVTMAnu);

	  		//se pasa el resultado a un hashMap

	  		cuestionarioVTMAnu = (HashMap)Q02bVoUtils.getHashMap(cuestionarioVTMAnuVO);

			return cuestionarioVTMAnu;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVTMAnu: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVTMAnu: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVTMAnu: saliendo.");

	   		}

	 	}

	}//fin obtenerCuestionarioVTMAnu

	

	/**

	 * Obtener la lista de cuestionarios

	 * 

	 * 

	 * @return Devuelve la lista de cuestionarios



	 * 

	 * @throws Exception

	 */

	public ArrayList obtenerCuestionariosVTM(HashMap mapaFiltroPortadaCuestionarioVTM) throws Exception 

	{		

		//Definicin de variables			 

		//final String RUTA_CLASE= "q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMAnuFiltro";

		ArrayList listaCuestionariosVTM= new ArrayList(); 

		Q02bCuestionarioVTMFiltro cuestionariosVTMFiltro = null;

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosVTM: entrando.");

	   			//tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaFiltroEntidad : " + mapaFiltroEntidad.toString());

	   		}			

			beanCuestionarioVTMAnu= new Q02bCuestionariosVTMAnuBean();

			cuestionariosVTMFiltro = (Q02bCuestionarioVTMFiltro)Q02bVoUtils.getValueObject(mapaFiltroPortadaCuestionarioVTM,"q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMFiltro");

			

			//se llama al mtodo del bean necesario

			listaCuestionariosVTM = beanCuestionarioVTMAnu.getCuestionariosVTM(cuestionariosVTMFiltro);

			return listaCuestionariosVTM;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosVTM: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionariosVTM: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosVTMAnu: saliendo.");

	   		}

	 	}

	}//fin obtenerEntidades

	

	/**

	 * Insertar/Modifica en bbdd un  nuevo grupo de cuestionarios con los datos pasados como parmetro en la HashMap de filtro

	 */

	public String altaModifGrupoCuestionariosVTMAnu(HashMap mapaCuestionarioVTMAnuFiltro) throws Exception 

	{

		Q02bCuestionarioVTMAnuFiltro cuestionarioVTMAnuFiltro = null;

		String niGrupoCuesVTMAnu=null;	  		

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: entrando");

			}

			//se pasa el hashmap de entrada a un objeto de tipo Q02bCuestionarioVTMAnu	  		

			cuestionarioVTMAnuFiltro = (Q02bCuestionarioVTMAnuFiltro) Q02bVoUtils.getValueObject(mapaCuestionarioVTMAnuFiltro,"q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMAnuFiltro");

			//se instancia el bean de negocio

	  		beanCuestionarioVTMAnu= new Q02bCuestionariosVTMAnuBean();

	  		//se pasa el autenticador

	  		//beanCuestionarioVTMAnu.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario

	  		

	  		niGrupoCuesVTMAnu=beanCuestionarioVTMAnu.altaModifGrupoCuestionariosVTMAnu(cuestionarioVTMAnuFiltro);

	  		

	  		if(cuestionarioVTMAnuFiltro!= null && Q02bFormatData.esNullSinCero(cuestionarioVTMAnuFiltro.getModificarConcedidoLicen()).equals("1")){

	  			beanCuestionarioVTMAnu.modificarGrupoCuestionariosVTM(niGrupoCuesVTMAnu,cuestionarioVTMAnuFiltro.getRealizaActuacion(),cuestionarioVTMAnuFiltro.getMes(), cuestionarioVTMAnuFiltro.getObsVTM());

	  		}

	  		

	  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: niGrupoCuestionarioVTMAnu="+ niGrupoCuesVTMAnu);

			return niGrupoCuesVTMAnu;			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: " + sw.getBuffer ().toString());

			}

            

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: saliendo");

			}			

		}

	} // fin altaModifGrupoCuestionariosVTMAnu

	

	

	/**

	     * Metodo que se encarga de devolver un XML con los datos principales de los cuestionarios a firmar que no estn ya firmados.

	     * @param ArrayList ArrayList arrCuestionariosVTMAnuFirma

	     * @throws Exception

	     */

	    public Document obtenerXmlFirmaCuestionariosVTMAnu(ArrayList arrCuestionariosVTMAnuFirma ) throws Exception{

	        final String TRACE_METODO = "Q02bCuestionariosVTMAnuSesionBean:obtenerXmlFirmaCuestionariosVTMAnu";

	        

	        //Variable que se va a devolver

	        Document document = null;

	        

	        if (tr.isTraceActive())

	        {

	            	tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +": entrando");

	        }

	        

	        try{

		            //Se instancia el bean de negocio

		            beanCuestionarioVTMAnu= new Q02bCuestionariosVTMAnuBean();

		            //Se obtiene la lista con los resultados

		            

		            tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +": ArrayList ="+ (arrCuestionariosVTMAnuFirma==null?"Es nulo":Integer.toString(arrCuestionariosVTMAnuFirma.size())));

		            document=beanCuestionarioVTMAnu.obtenerXmlFirmaCuestionariosVTMAnu(arrCuestionariosVTMAnuFirma);

		            //Se devuelve el objeto

		            return document;

	        }catch (Exception ex) 

	        {

		            java.io.StringWriter sw = new java.io.StringWriter();

		            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

		            ex.printStackTrace(pw);

		            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

		            TRACE_METODO + sw.getBuffer().toString());

	            throw ex;

	        } finally {

	            if (tr.isTraceActive()) {

	                tr.trace(COMPONENTE, Q70TraceLevel.INFO,

	                		TRACE_METODO + " saliendo.");

	            }

	        }

	    }

	    

	    public void guardarFirmaGrupoCuestionariosVTMAnu(String niGrupoCuesVTMAnu,String xmlFirmaGrupoCuestionariosVTMAnu ) throws Exception

	    {  	

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: entrando");

			}			

			

			beanCuestionarioVTMAnu= new Q02bCuestionariosVTMAnuBean();

			//se pasa el autenticador

	  		//beanCuestionarioVTMAnu.setAutenticador(autenticador);

			//se llama al metodo del bean para modificar el contacto

			beanCuestionarioVTMAnu.guardarFirmaGrupoCuestionariosVTMAnu(niGrupoCuesVTMAnu,xmlFirmaGrupoCuestionariosVTMAnu);

		}

		catch(Exception ex)

		{

            			java.io.StringWriter sw = new java.io.StringWriter();

            			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            			ex.printStackTrace(pw);

            			if (tr.isTraceActive())

            			{

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: " + sw.getBuffer ().toString());

			}

            			throw ex;

		 }finally

		 {

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: saliendo");

			 }

		 }		

	} // fin guardarFirmaGrupoCuestionariosVTMAnu



	

	    

	    public void borrarTodosCuestionarioVTMAnu(String niGrupoCuestionarioVTMAnu) throws Exception

		{

			try {

				if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: entrando con cuestionario: " + niGrupoCuestionarioVTMAnu);

				}

				beanCuestionarioVTMAnu= new Q02bCuestionariosVTMAnuBean();

				//se pasa el autenticador

		  		//beanCuestionarioVTMAnu.setAutenticador(autenticador);

		  		//se llama al mtodo del bean necesario

				beanCuestionarioVTMAnu.borrarTodosCuestionarioVTMAnu(niGrupoCuestionarioVTMAnu);			

		     }catch(Exception ex){

	            java.io.StringWriter sw = new java.io.StringWriter();

	            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	            ex.printStackTrace(pw);

	            if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: " + sw.getBuffer ().toString());

				}

	            throw ex;

			 }finally{

				 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: saliendo");

				 }	

			 }			 

			 

		} // fin borrarTodosCuestionarioVTMAnu

	// --------------------------------------------------------------------------

	// ---------- FIN CUESTIONARIOS VIVIENDA TASADA MUNICIPAL -----------

	// ---------------------------------------------------------------------------



} // fin clase

