package q02bContactosSesionEJB;



import java.rmi.RemoteException;

import java.util.ArrayList;

import java.util.HashMap;



import javax.ejb.CreateException;

import javax.ejb.EJBException;

import javax.ejb.SessionBean;



import q02b.exe.comun.Q02bAplicException;

import q02b.exe.comun.Q02bAutenticador;

import q02b.exe.contactos.beans.Q02bContactosBean;

import q02b.exe.contactos.valueobjects.Q02bContactos;

import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

 

/**

 * XDoclet-based session bean.  The class must be declared

 * public according to the EJB specification.

 *

 * To generate the EJB related files to this EJB:

 *		- Add Standard EJB module to XDoclet project properties

 *		- Customize XDoclet configuration for your appserver

 *		- Run XDoclet

 *

 * Below are the xdoclet-related tags needed for this EJB.

 * 

 * @ejb.bean name="Q02bAyuntamientoSesion"

 *           display-name="Name for Q02bAyuntamientoSesion"

 *           description="Description for Q02bAyuntamientoSesion"

 *           jndi-name="ejb/Q02bPlazosSesion"

 *           type="Stateless"

 *           view-type="remote"

 */

  



public class Q02bContactosSesionBean implements SessionBean {



	

	private static final long serialVersionUID = 4131248384461301469L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "EJB_SESION_DATOS";

	protected Q02bContactosBean beanContactos= null;

	

	/** The session context */

	private javax.ejb.SessionContext mySessionCtx;



	 

	

	public Q02bContactosSesionBean() {

		super();

		// TODO Auto-generated constructor stub

	}

	/**

	 * Set the associated session context. The container calls this method 

	 * after the instance creation.

	 * 

	 * The enterprise bean instance should store the reference to the context 

	 * object in an instance variable.

	 * 

	 * This method is called with no transaction context. 

	 * 

	 * @throws EJBException Thrown if method fails due to system-level error.

	 */

	/**

	 * getSessionContext

	 */

	public javax.ejb.SessionContext getSessionContext() {

		return mySessionCtx;

	}

	/**

	 * setSessionContext

	 */

	public void setSessionContext(javax.ejb.SessionContext ctx) {

		mySessionCtx = ctx;

	}



	public void ejbRemove() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbActivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbPassivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	/**

	 * An ejbCreate method as required by the EJB specification.

	 * 

	 * The container calls the instance?s <code>ejbCreate</code> method whose

	 * signature matches the signature of the <code>create</code> method invoked

	 * by the client. The input parameters sent from the client are passed to

	 * the <code>ejbCreate</code> method. Each session bean class must have at

	 * least one <code>ejbCreate</code> method. The number and signatures

	 * of a session bean?s <code>create</code> methods are specific to each 

	 * session bean class.

	 * 

	 * @throws CreateException Thrown if method fails due to system-level error.

	 * 

	 * @ejb.create-method

	 * 

	 */

	public void ejbCreate() throws CreateException {

		// TODO Add ejbCreate method implementation

	}  

	// ------------------------------------------

	// ---------- CONTACTOS  ----------

	// ------------------------------------------



	/**

	 * Obtener la lista de Contactos

	 * @return Devuelve la lista de Contactos

	 * @throws Exception

	 */

	public ArrayList obtenerContactos(java.util.HashMap mapaFiltroContacto, Q02bAutenticador autenticador) throws Exception 

	{		

		//Definicin de variables			 		

		Q02bContactos contacto = new Q02bContactos();

		ArrayList listaContactos = new ArrayList(); 

		try

		{

			if (tr.isTraceActive())

			{

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerContactos: entrando.");

	   			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaFiltroContacto : " + mapaFiltroContacto);

	   		}			

			beanContactos = new Q02bContactosBean();

			beanContactos.setAutenticador(autenticador);

			contacto = (Q02bContactos) Q02bVoUtils.getValueObject(mapaFiltroContacto,"q02b.exe.contactos.valueobjects.Q02bContactos");

			listaContactos = beanContactos.obtenerContactos(contacto);

			return listaContactos;

			

		}catch(Exception ex)

		{	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerContactos: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally

	 	{    	

	        if (tr.isTraceActive())

	        {

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerContactos: saliendo.");

	   		}

	 	}

	}//fin obtenerContactos

	

	/**

     * Mtodo que dado un contacto lo inserta en la BBDD 

     * insertara en la BBDD los datos de dicho contacto

     * @param mapaAyuntamiento

     */ 

	public void insertarContactos(HashMap mapaContacto, Q02bAutenticador autenticador) throws Exception 

	{

		Q02bContactos contacto = null;

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarContactos: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaContacto: " + mapaContacto.toString());

			}

			

			//se pasa el hashmap de entrada a un objeto de tipo Q02bAyuntamiento	

			contacto = (Q02bContactos) Q02bVoUtils.getValueObject(mapaContacto,"q02b.exe.contactos.valueobjects.Q02bContactos");

			

			//se instancia el bean de negocio

			beanContactos= new Q02bContactosBean();

	  		//se pasa el autenticador

			beanContactos.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario

	  		beanContactos.insertarContactos(contacto);		

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarContactos: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarContactos: saliendo");

			}			

		}

	} // fin insertarContactos

	

	/**

     * Mtodo que dado el nmero interno del contacto

     * recuperara de la BBDD los datos de dicho contacto

     * @param idContacto

     * @return contacto

     */ 

	public HashMap obtenerContacto(String idContacto, Q02bAutenticador autenticador) throws Exception 

	{		

		//Definicin de variables

		HashMap contacto =  new HashMap(); 

		Q02bContactos contactoVO = new Q02bContactos();

		try{

			if (tr.isTraceActive()) {

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerContacto ejb-> ** idContacto=:" + idContacto);	   			

	   		}			

			beanContactos = new Q02bContactosBean();

			

			//se pasa el autenticador

	  		beanContactos.setAutenticador(autenticador);

	  		

	  		//se llama al mtodo del bean necesario			

	  		contactoVO = beanContactos.obtenerContacto(idContacto);

	  		

	  		//se pasa el resultado a un hashMap

	  		contacto = (HashMap)Q02bVoUtils.getHashMap(contactoVO);

			return contacto;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerContacto: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerContacto: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerContacto: saliendo.");

	   		}

	 	}

	}//fin obtenerContacto

	

	/**

	 * Borrar de bbdd un contacto

	 * @param idContacto - Nmero interno del contacto a borrar

	 */

	public void borrarContactos(String idContacto, Q02bAutenticador autenticador) throws Exception

	{

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarContactos: entrando con contacto: " + idContacto);

			}

			beanContactos= new Q02bContactosBean();

			//se pasa el autenticador

	  		beanContactos.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario

			beanContactos.borrarContactos(idContacto);			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarContactos: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarContactos: saliendo");

			 }	

		 }			  

	} // fin borrarContactos

	

	/**

	 * Modificar en bbdd un contacto con los datos pasados como parmetro en la HashMap

	 */

	public void modificarContactos(HashMap mapaContacto, Q02bAutenticador autenticador) throws Exception

	{

		Q02bContactos contacto = null;	  	

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarContactos: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaContacto: " + mapaContacto.toString());

			}			

			//se pasa el hashmap de entrada a un objeto de tipo Q02bAyuntamiento

			contacto = (Q02bContactos) Q02bVoUtils.getValueObject(mapaContacto,"q02b.exe.contactos.valueobjects.Q02bContactos");

			

			beanContactos= new Q02bContactosBean();

			//se pasa el autenticador

	  		beanContactos.setAutenticador(autenticador);

			//se llama al metodo del bean para modificar el Ayuntamiento

			beanContactos.modificarContactos(contacto);			

		}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarContactos: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarContactos: saliendo");

			 }

		 }		

	} // fin modificarContactos

      

	// ---------------------------------------------

	// ---------- FIN CONTACTOS -----------

	// ---------------------------------------------



} // fin clase

