package q02bComunSesionEJB;



import java.rmi.RemoteException;

import java.util.ArrayList;

import java.util.HashMap;



import javax.ejb.CreateException;

import javax.ejb.EJBException;

import javax.ejb.SessionBean;

 

import q02b.exe.comun.Q02bAutenticador;

import q02b.exe.comun.beans.Q02bBuscadorGeneralBean;

import q02b.exe.comun.beans.Q02bContactoBean;

import q02b.exe.comun.beans.Q02bMailToBean;

import q02b.exe.comun.valueobjects.Q02bBuscadorGeneralFiltro;

import q02b.exe.comun.valueobjects.Q02bBuscadorGeneralSelect;

import q02b.exe.comun.valueobjects.Q02bContacto;

import q02b.exe.comun.valueobjects.Q02bMailTo;

import q02b.exe.utils.Q02bFormatData;

import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

 

/**

 * XDoclet-based session bean.  The class must be declared

 * public according to the EJB specification.

 *

 * To generate the EJB related files to this EJB:

 *		- Add Standard EJB module to XDoclet project properties

 *		- Customize XDoclet configuration for your appserver

 *		- Run XDoclet

 *

 * Below are the xdoclet-related tags needed for this EJB.

 * 

 * @ejb.bean name="Q02bCuestionariosAyunMenSesion"

 *           display-name="Name for Q02bCuestionariosAyunMenSesion"

 *           description="Description for Q02bCuestionariosAyunMenSesion"

 *           jndi-name="ejb/Q02bCuestionariosAyunMenSesion"

 *           type="Stateless"

 *           view-type="remote"

 */

  



public class Q02bComunSesionBean implements SessionBean {



	

	private static final long serialVersionUID = 4131248384461301469L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "EJB_SESION_COMUN";

	//protected Q02bComunBean beanComun= null;

	protected Q02bBuscadorGeneralBean 	buscadorGeneralBean 	= null;

	/** The session context */

	private javax.ejb.SessionContext mySessionCtx;



	 

	

	public Q02bComunSesionBean() {

		super();

		// TODO Auto-generated constructor stub

	}

	/**

	 * Set the associated session context. The container calls this method 

	 * after the instance creation.

	 * 

	 * The enterprise bean instance should store the reference to the context 

	 * object in an instance variable.

	 * 

	 * This method is called with no transaction context. 

	 * 

	 * @throws EJBException Thrown if method fails due to system-level error.

	 */

	public javax.ejb.SessionContext getSessionContext() {

		return mySessionCtx;

	}

	/**

	 * setSessionContext

	 */

	public void setSessionContext(javax.ejb.SessionContext ctx) {

		mySessionCtx = ctx;

	}



	public void ejbRemove() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbActivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbPassivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	/**

	 * An ejbCreate method as required by the EJB specification.

	 * 

	 * The container calls the instance?s <code>ejbCreate</code> method whose

	 * signature matches the signature of the <code>create</code> method invoked

	 * by the client. The input parameters sent from the client are passed to

	 * the <code>ejbCreate</code> method. Each session bean class must have at

	 * least one <code>ejbCreate</code> method. The number and signatures

	 * of a session bean?s <code>create</code> methods are specific to each 

	 * session bean class.

	 * 

	 * @throws CreateException Thrown if method fails due to system-level error.

	 * 

	 * @ejb.create-method

	 * 

	 */

	public void ejbCreate() throws CreateException {

		// TODO Add ejbCreate method implementation

	}   

	

	/**

	 * Enviar Correo Electronico al responsable de la aplicacion

	 * 

	 * 

	 *  

	 * @throws Exception

	 */

	 public void enviarEmailContacto (java.util.HashMap mailMapa) throws Exception {

        // Definicin de variables que no se van a modificar

		final String TRACE_METODO 	= ":enviarEmailContacto:";

		

		final String RUTA_CLASE_EMAIL_TO 		= "q02b.exe.comun.valueobjects.Q02bMailTo";



		try{

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + "entrando.");

	   		}

			

	        Q02bMailToBean bean = new Q02bMailToBean();

	  		//se pasa el autenticador

	  		//bean.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario

	  		Q02bMailTo mail = new Q02bMailTo();

	  		mail = (Q02bMailTo) Q02bVoUtils.getValueObject(mailMapa,RUTA_CLASE_EMAIL_TO);

	  		mail.setDestinatario("");

	  		bean.enviarEmailContacto(mail); 

	        

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerContactos: " + sw.getBuffer ().toString());

			throw ex;		

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + "saliendo.");

	   		}

	 	}

	}// fin enviarEmailContacto

	 

	 public void contactar (java.util.HashMap datosContacto) throws Exception {

	        // Definicin de variables que no se van a modificar

			final String TRACE_METODO 	= ":contactar:";

			

			final String RUTA_CLASE_CONTACTO = "q02b.exe.comun.valueobjects.Q02bContacto";



			try{

		        if (tr.isTraceActive()){

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + "entrando.");

		   		}

				

		        Q02bContactoBean bean = new Q02bContactoBean();

		  		//se pasa el autenticador

		  		//bean.setAutenticador(autenticador);

		  		//se llama al mtodo del bean necesario

		  		Q02bContacto mail = new Q02bContacto();

		  		mail = (Q02bContacto) Q02bVoUtils.getValueObject(datosContacto,RUTA_CLASE_CONTACTO);

		  		mail.setDestinatario("");

		  		bean.contactar(mail); 

		        

			}catch(Exception ex){	 	

				java.io.StringWriter sw = new java.io.StringWriter();

				java.io.PrintWriter pw = new java.io.PrintWriter(sw);

				ex.printStackTrace(pw);

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":contactar: " + sw.getBuffer ().toString());

				throw ex;		

		 	}finally{    	

		        if (tr.isTraceActive()){

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + "saliendo.");

		   		}

		 	}

		}// fin contactar

    

	 /**

		 * obtiene la lista de elementos del combo del buscador general

		 * 

		 * @param mapaFiltro

		 * @param mapaDatosSelect

		 * @param autenticador

		 * 

		 * @return Devuelve la lista de datos del combo para el buscador general

		 * 

		 * @throws Exception

		 */

		public ArrayList obtenerComboBuscadorGeneral(HashMap mapaDatosSelect, Q02bAutenticador autenticador) throws Exception {

			//Definicin de variables que no se van a modificar

			final String TRACE_METODO 			= ":obtenerDatosBuscadorGeneral:";

			final String RUTA_CLASE_SELECT		= "q02b.exe.comun.valueobjects.Q02bBuscadorGeneralSelect";

			//Definicin de objetos

			Q02bBuscadorGeneralSelect 	buscadorGeneralSelect = new Q02bBuscadorGeneralSelect();

			ArrayList 					lista 				  = new ArrayList();

			try{

				if (tr.isTraceActive()){

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando.");

		   			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaDatosSelect : " + mapaDatosSelect.toString());

				}		

				//Se instancia el bean de negocio

				buscadorGeneralBean = new Q02bBuscadorGeneralBean();

				//Se pasa el autenticador

				buscadorGeneralBean.setAutenticador(autenticador);

//				Se obtiene el objeto a partir del hashmap que contiene los datos de la select

				buscadorGeneralSelect = (Q02bBuscadorGeneralSelect)Q02bVoUtils.getValueObject(mapaDatosSelect,RUTA_CLASE_SELECT);

//				Se comprueba si existe el combo

				if(!Q02bFormatData.esVacio(buscadorGeneralSelect.getTableCombo()) && !Q02bFormatData.esVacio(buscadorGeneralSelect.getComboLabelColumn()) && !Q02bFormatData.esVacio(buscadorGeneralSelect.getComboValueColumn())){

					//Se obtiene la lista con los campos de los combos

					lista = buscadorGeneralBean.obtenerDatosBuscadorGeneralCombo(buscadorGeneralSelect);		

				}

				//Se devuelve la lista

				return lista;

			}catch(Exception ex){	 	

				java.io.StringWriter 	sw = new java.io.StringWriter();

				java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

				ex.printStackTrace(pw);

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

				throw ex;                     

		 	}finally{    	

		        if (tr.isTraceActive()){

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " saliendo.");

		   		}

		 	}

		}//fin obtenerComboBuscadorGeneral

		

		

		/**

		 * Obtener la lista de datos del buscador general que cumplan 

		 * los datos del filtro pasado como parmetro. Del mismo modo

		 * se envan los datos para conocer la tabla y los campos.

		 * 

		 * @param mapaFiltro

		 * @param mapaDatosSelect

		 * @param autenticador

		 * 

		 * @return Devuelve la lista de datos para el buscador general

		 * 

		 * @throws Exception

		 */

		public ArrayList obtenerDatosBuscadorGeneral(HashMap mapaFiltro, HashMap mapaDatosSelect, Q02bAutenticador autenticador) throws Exception {

			//Definicin de variables que no se van a modificar

			final String TRACE_METODO 			= ":obtenerDatosBuscadorGeneral:";

			final String RUTA_CLASE_FILTRO		= "q02b.exe.comun.valueobjects.Q02bBuscadorGeneralFiltro";

			final String RUTA_CLASE_SELECT		= "q02b.exe.comun.valueobjects.Q02bBuscadorGeneralSelect";

			//Definicin de objetos

			Q02bBuscadorGeneralFiltro 	buscadorGeneralFiltro = new Q02bBuscadorGeneralFiltro();

			Q02bBuscadorGeneralSelect 	buscadorGeneralSelect = new Q02bBuscadorGeneralSelect();

			ArrayList 					lista 				  = new ArrayList();

			ArrayList 					listaBuscador 		  = new ArrayList();

			try{

				if (tr.isTraceActive()){

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando.");

		   			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaFiltro 		: " + mapaFiltro.toString());

		   			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaDatosSelect : " + mapaDatosSelect.toString());

				}		

				//Se instancia el bean de negocio

				buscadorGeneralBean = new Q02bBuscadorGeneralBean();

				//Se pasa el autenticador

				buscadorGeneralBean.setAutenticador(autenticador);

				//Si entramos la primera vez no contiene datos

				if(!mapaFiltro.isEmpty()){

					//Se obtiene el objeto a partir del hashmap del filtro

					buscadorGeneralFiltro = (Q02bBuscadorGeneralFiltro)Q02bVoUtils.getValueObject(mapaFiltro,RUTA_CLASE_FILTRO);

				}

				//Se obtiene el objeto a partir del hashmap que contiene los datos de la select

				buscadorGeneralSelect = (Q02bBuscadorGeneralSelect)Q02bVoUtils.getValueObject(mapaDatosSelect,RUTA_CLASE_SELECT);

				//Se obtiene la lista con los resultados

				listaBuscador = buscadorGeneralBean.obtenerDatosBuscadorGeneral(buscadorGeneralFiltro,buscadorGeneralSelect);

				//Se aade a la lista genrica

				lista.add(listaBuscador);

				//Se devuelve la lista

				return lista;

			}catch(Exception ex){	 	

				java.io.StringWriter 	sw = new java.io.StringWriter();

				java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

				ex.printStackTrace(pw);

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

				throw ex;                     

		 	}finally{    	

		        if (tr.isTraceActive()){

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " saliendo.");

		   		}

		 	}

		}//fin obtenerDatosBuscadorGeneral

} // fin clase

