package q02bAyuntamientoSesionEJB;



import java.rmi.RemoteException;

import java.util.ArrayList;

import java.util.HashMap;



import javax.ejb.CreateException;

import javax.ejb.EJBException;

import javax.ejb.SessionBean;



import q02b.exe.ayuntamiento.beans.Q02bAyuntamientoBean;

import q02b.exe.ayuntamiento.valueobjects.Q02bAyuntamiento;

import q02b.exe.comun.Q02bAplicException;

import q02b.exe.comun.Q02bAutenticador;

import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

 

/**

 * XDoclet-based session bean.  The class must be declared

 * public according to the EJB specification.

 *

 * To generate the EJB related files to this EJB:

 *		- Add Standard EJB module to XDoclet project properties

 *		- Customize XDoclet configuration for your appserver

 *		- Run XDoclet

 *

 * Below are the xdoclet-related tags needed for this EJB.

 * 

 * @ejb.bean name="Q02bAyuntamientoSesion"

 *           display-name="Name for Q02bAyuntamientoSesion"

 *           description="Description for Q02bAyuntamientoSesion"

 *           jndi-name="ejb/Q02bAyuntamientoSesion"

 *           type="Stateless"

 *           view-type="remote"

 */

  



public class Q02bAyuntamientoSesionBean implements SessionBean {



	

	private static final long serialVersionUID = 4131248384461301469L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "EJB_SESION_DATOS";

	protected Q02bAyuntamientoBean beanAyuntamiento= null;

	

	/** The session context */

	private javax.ejb.SessionContext mySessionCtx;



	 

	

	public Q02bAyuntamientoSesionBean() {

		super();

		// TODO Auto-generated constructor stub

	}

	/**

	 * Set the associated session context. The container calls this method 

	 * after the instance creation.

	 * 

	 * The enterprise bean instance should store the reference to the context 

	 * object in an instance variable.

	 * 

	 * This method is called with no transaction context. 

	 * 

	 * @throws EJBException Thrown if method fails due to system-level error.

	 */

	/**

	 * getSessionContext

	 */

	public javax.ejb.SessionContext getSessionContext() {

		return mySessionCtx;

	}

	/**

	 * setSessionContext

	 */

	public void setSessionContext(javax.ejb.SessionContext ctx) {

		mySessionCtx = ctx;

	}



	public void ejbRemove() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbActivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbPassivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	/**

	 * An ejbCreate method as required by the EJB specification.

	 * 

	 * The container calls the instance?s <code>ejbCreate</code> method whose

	 * signature matches the signature of the <code>create</code> method invoked

	 * by the client. The input parameters sent from the client are passed to

	 * the <code>ejbCreate</code> method. Each session bean class must have at

	 * least one <code>ejbCreate</code> method. The number and signatures

	 * of a session bean?s <code>create</code> methods are specific to each 

	 * session bean class.

	 * 

	 * @throws CreateException Thrown if method fails due to system-level error.

	 * 

	 * @ejb.create-method

	 * 

	 */

	public void ejbCreate() throws CreateException {

		// TODO Add ejbCreate method implementation

	}  

	// ------------------------------------------

	// ---------- AYUNTAMIENTOS  ----------

	// ------------------------------------------



	/**

	 * Obtener la lista de ayuntamientos

	 * @return Devuelve la lista de ayuntamientos

	 * @throws Exception

	 */

	public ArrayList obtenerAyuntamientos(java.util.HashMap mapaFiltroAyuntamiento, Q02bAutenticador autenticador) throws Exception 

	{		

		//Definicin de variables			 		

		Q02bAyuntamiento ayuntamiento = new Q02bAyuntamiento();

		ArrayList listaAyuntamientos = new ArrayList(); 

		try

		{

			if (tr.isTraceActive())

			{

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAyuntamientos: entrando.");

	   			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaFiltroAyuntamientos : " + mapaFiltroAyuntamiento);

	   		}			

			beanAyuntamiento = new Q02bAyuntamientoBean();

			beanAyuntamiento.setAutenticador(autenticador);

			ayuntamiento = (Q02bAyuntamiento) Q02bVoUtils.getValueObject(mapaFiltroAyuntamiento,"q02b.exe.ayuntamiento.valueobjects.Q02bAyuntamiento");

			listaAyuntamientos = beanAyuntamiento.obtenerAyuntamientos(ayuntamiento);

			return listaAyuntamientos;

			

		}catch(Exception ex)

		{	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAyuntamientos: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally {    	

	        if (tr.isTraceActive()) {

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAyuntamientos: saliendo.");

	   		}

	 	}

	}//fin obtenerAyuntamientos

	

	/**

     * Mtodo que dado un ayuntamiento lo inserta en la BBDD 

     * insertara en la BBDD los datos de dicho ayuntamiento

     * @param mapaAyuntamiento

     */ 

	public void insertarAyuntamiento(HashMap mapaAyuntamiento, Q02bAutenticador autenticador) throws Exception 

	{

		Q02bAyuntamiento ayuntamiento = null;

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarAyuntamiento: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaAyuntamiento : " + mapaAyuntamiento.toString());

			}

			

			//se pasa el hashmap de entrada a un objeto de tipo Q02bAyuntamiento	

			ayuntamiento = (Q02bAyuntamiento) Q02bVoUtils.getValueObject(mapaAyuntamiento,"q02b.exe.ayuntamiento.valueobjects.Q02bAyuntamiento");

			

			//se instancia el bean de negocio

			beanAyuntamiento= new Q02bAyuntamientoBean();

	  		//se pasa el autenticador

			beanAyuntamiento.setAutenticador(autenticador);

	  		

	  		//se llama al mtodo del bean necesario

	  		beanAyuntamiento.insertarAyuntamiento(ayuntamiento);		

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarAyuntamiento: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarAyuntamiento: saliendo");

			}			

		}

	} // fin insertarAyuntamiento

	

	/**

     * Mtodo que dado el nmero interno del ayuntamiento

     * recuperara de la BBDD los datos de dicho ayuntamiento

     * @param idAyuntamiento

     * @return ayuntamiento

     */ 

	public HashMap obtenerAyuntamiento(String idAyuntamiento, Q02bAutenticador autenticador) throws Exception 

	{		

		//Definicin de variables

		HashMap ayuntamiento =  new HashMap(); 

		Q02bAyuntamiento ayuntamientoVO = new Q02bAyuntamiento();

		try{

			if (tr.isTraceActive()) {

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAyuntamiento ejb-> ** idAyuntamiento=:" + idAyuntamiento);	   			

	   		}			

			beanAyuntamiento= new Q02bAyuntamientoBean();

			

			//se pasa el autenticador

	  		beanAyuntamiento.setAutenticador(autenticador);

	  		

	  		//se llama al mtodo del bean necesario			

	  		ayuntamientoVO = beanAyuntamiento.obtenerAyuntamiento(idAyuntamiento);

	  		

	  		//se pasa el resultado a un hashMap

	  		ayuntamiento = (HashMap)Q02bVoUtils.getHashMap(ayuntamientoVO);

			return ayuntamiento;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAyuntamiento: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAyuntamiento: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAyuntamiento: saliendo.");

	   		}

	 	}

	}//fin obtenerAyuntamiento

	

	/**

	 * Borrar de bbdd un ayuntamiento

	 * @param idAyuntamiento - Nmero interno del ayuntamiento a borrar

	 */

	public void borrarAyuntamiento(String idAyuntamiento, Q02bAutenticador autenticador) throws Exception

	{

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarAyuntamiento: entrando con ayuntamiento: " + idAyuntamiento);

			}

			beanAyuntamiento= new Q02bAyuntamientoBean();

			//se pasa el autenticador

	  		beanAyuntamiento.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario

			beanAyuntamiento.borrarAyuntamiento(idAyuntamiento);			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarAyuntamiento: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarAyuntamiento: saliendo");

			 }	

		 }			  

	} // fin borrarAyuntamiento

	

	/**

	 * Modificar en bbdd un ayuntamiento con los datos pasados como parmetro en la HashMap

	 */

	public void modificarAyuntamiento(HashMap mapaAyuntamiento, Q02bAutenticador autenticador) throws Exception

	{

		Q02bAyuntamiento ayuntamiento = null;	  	

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarAyuntamiento: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaAyuntamiento : " + mapaAyuntamiento.toString());

			}			

			//se pasa el hashmap de entrada a un objeto de tipo Q02bAyuntamiento

			ayuntamiento = (Q02bAyuntamiento) Q02bVoUtils.getValueObject(mapaAyuntamiento,"q02b.exe.ayuntamiento.valueobjects.Q02bAyuntamiento");

			

			beanAyuntamiento= new Q02bAyuntamientoBean();

			//se pasa el autenticador

	  		beanAyuntamiento.setAutenticador(autenticador);

			//se llama al metodo del bean para modificar el Ayuntamiento

			beanAyuntamiento.modificarAyuntamiento(ayuntamiento);			

		}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarAyuntamiento: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarAyuntamiento: saliendo");

			 }

		 }		

	} // fin modificarAyuntamiento

      

	// ---------------------------------------------

	// ---------- FIN AYUNTAMIENTOS -----------

	// ---------------------------------------------



} // fin clase

