package q02bAgentesSesionEJB;



import java.rmi.RemoteException;

import java.util.ArrayList;

import java.util.HashMap;



import javax.ejb.CreateException;

import javax.ejb.EJBException;

import javax.ejb.SessionBean;



import q02b.exe.comun.Q02bAplicException;

import q02b.exe.comun.Q02bAutenticador;

import q02b.exe.agentes.beans.Q02bAgenteOfiBean;

import q02b.exe.agentes.beans.Q02bAgentesBean;

import q02b.exe.agentes.valueobjects.Q02bAgenteOfi;

import q02b.exe.agentes.valueobjects.Q02bAgentes;

import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

 

/**

 * XDoclet-based session bean.  The class must be declared

 * public according to the EJB specification.

 *

 * To generate the EJB related files to this EJB:

 *		- Add Standard EJB module to XDoclet project properties

 *		- Customize XDoclet configuration for your appserver

 *		- Run XDoclet

 *

 * Below are the xdoclet-related tags needed for this EJB.

 * 

 * @ejb.bean name="Q02bAgentesSesion"

 *           display-name="Name for Q02bAgentesSesion"

 *           description="Description for Q02bAgentesSesion"

 *           jndi-name="ejb/Q02bAgentesSesion"

 *           type="Stateless"

 *           view-type="remote"

 */

  



public class Q02bAgentesSesionBean implements SessionBean {



	

	private static final long serialVersionUID = 4131248384461301469L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "EJB_SESION_DATOS";

	protected Q02bAgentesBean beanAgentes= null;

	protected Q02bAgenteOfiBean beanAgenteOfi= null;

	

	/** The session context */

	private javax.ejb.SessionContext mySessionCtx;



	 

	

	public Q02bAgentesSesionBean() {

		super();

		// TODO Auto-generated constructor stub

	}

	/**

	 * Set the associated session context. The container calls this method 

	 * after the instance creation.

	 * 

	 * The enterprise bean instance should store the reference to the context 

	 * object in an instance variable.

	 * 

	 * This method is called with no transaction context. 

	 * 

	 * @throws EJBException Thrown if method fails due to system-level error.

	 */

	/**

	 * getSessionContext

	 */

	public javax.ejb.SessionContext getSessionContext() {

		return mySessionCtx;

	}

	/**

	 * setSessionContext

	 */

	public void setSessionContext(javax.ejb.SessionContext ctx) {

		mySessionCtx = ctx;

	}



	public void ejbRemove() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbActivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	public void ejbPassivate() throws EJBException, RemoteException {

		// TODO Auto-generated method stub



	}



	/**

	 * An ejbCreate method as required by the EJB specification.

	 * 

	 * The container calls the instance?s <code>ejbCreate</code> method whose

	 * signature matches the signature of the <code>create</code> method invoked

	 * by the client. The input parameters sent from the client are passed to

	 * the <code>ejbCreate</code> method. Each session bean class must have at

	 * least one <code>ejbCreate</code> method. The number and signatures

	 * of a session bean?s <code>create</code> methods are specific to each 

	 * session bean class.

	 * 

	 * @throws CreateException Thrown if method fails due to system-level error.

	 * 

	 * @ejb.create-method

	 * 

	 */

	public void ejbCreate() throws CreateException {

		// TODO Add ejbCreate method implementation

	}  

	// -------------------------------------------------------------------------------------------------

	// ---------- AGENTES  ----------

	// -------------------------------------------------------------------------------------------------



	/**

	 * Obtener la lista de agentes

	 * @return Devuelve la lista de agentes

	 * @throws Exception

	 */

	//public ArrayList obtenerAgentes(Q02bAutenticador autenticador) throws Exception

	public ArrayList obtenerAgentes(HashMap mapaFiltroAgentes, Q02bAutenticador autenticador) throws Exception

	

	{		

		ArrayList listaAgentes= new ArrayList(); 

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obteneragentes: entrando.");

	   		}		

			beanAgentes= new Q02bAgentesBean();

			beanAgentes.setAutenticador(autenticador);

			listaAgentes = beanAgentes.getAgentes(mapaFiltroAgentes);

			return listaAgentes;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAgentes: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obteneragentes: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAgentes: saliendo.");

	   		}

	 	}

	}//fin obteneragentes

	

	/**

     * Mtodo que dado el nmero interno del agente 

     * recuperara de la BBDD los datos de dicho cuestionario

     * @param idAgente

     * @return agente

     */	

	public HashMap obtenerAgente(String idAgente, Q02bAutenticador autenticador) throws Exception 

	{		

		//Definicin de variables

		HashMap agente =  new HashMap(); 

		Q02bAgentes agenteVO = new Q02bAgentes();

		try{

			if (tr.isTraceActive())

			{

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAgente ejb-> ** idAgente=:" + idAgente);	   			

	   		}			

			beanAgentes= new Q02bAgentesBean();

			

			//se pasa el autenticador

			beanAgentes.setAutenticador(autenticador);	  		

	  		//se llama al mtodo del bean necesario			

			agenteVO = beanAgentes.obtenerAgente(idAgente);

	  		

	  		//se pasa el resultado a un hashMap

	  		agente = (HashMap)Q02bVoUtils.getHashMap(agenteVO);

			return agente;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAgente: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAgente: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAgente: saliendo.");

	   		}

	 	}

	}

	

	/**

     * Mtodo que dado un agente lo inserta en la BBDD 

     * insertara la BBDD los datos de dicho agente

     * @param mapaAgentes

     */

	 

	public String insertarAgentes(HashMap mapaAgentes, Q02bAutenticador autenticador) throws Exception

	{

		Q02bAgentes agente = null;

		String idAgente=null;

		try {

			

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarAgentes: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaagentes : " + mapaAgentes.toString());

			}

			//se pasa el hashmap de entrada a un objeto de tipo Q02bCuestionarioVTMAnu	

			agente = (Q02bAgentes) Q02bVoUtils.getValueObject(mapaAgentes,"q02b.exe.agentes.valueobjects.Q02bAgentes");

			

			//se instancia el bean de negocio

	  		beanAgentes= new Q02bAgentesBean();

	  		//se pasa el autenticador

	  		beanAgentes.setAutenticador(autenticador);

	  		

	  		//se llama al mtodo del bean necesario

	  		idAgente=beanAgentes.insertarAgentes(agente);

	  		return(idAgente);

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarAgentes: " + sw.getBuffer ().toString());

			}

            

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarAgentes: saliendo");

			}			

		}

	} // fin insertarAgentes

	

	/**

	 * Borrar de bbdd un agente

	 * @param niAgente - Nmero interno del agente a borrar

	 */	

	public void borrarAgentes(String idAgente, Q02bAutenticador autenticador) throws Exception

	{

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarAgentes: entrando con agente: " + idAgente);

			}

			beanAgentes= new Q02bAgentesBean();

			//se pasa el autenticador

	  		beanAgentes.setAutenticador(autenticador);

	  		//se llama al mtodo del bean necesario

			beanAgentes.borrarAgentes(idAgente);			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarAgentes: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarAgentes: saliendo");

			 }	

		 }			  

	} // fin borraragentes

	

	/**

	 * Modificar en bbdd un agente con los datos pasados como parmetro en la HashMap

	 */

	

	public void modificarAgentes(HashMap mapaAgentes, Q02bAutenticador autenticador) throws Exception

	{

		Q02bAgentes agente = null;	  	

		try {

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarAgentes: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaAgentes : " + mapaAgentes.toString());

			}			

			//se pasa el hashmap de entrada a un objeto de tipo Q02bAgentes

			agente = (Q02bAgentes) Q02bVoUtils.getValueObject(mapaAgentes,"q02b.exe.agentes.valueobjects.Q02bAgentes");

			

			beanAgentes= new Q02bAgentesBean();

			//se pasa el autenticador

	  		beanAgentes.setAutenticador(autenticador);

			//se llama al metodo del bean para modificar el contacto

			beanAgentes.modificarAgentes(agente);			

		}catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarAgentes: " + sw.getBuffer ().toString());

			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarAgentes: saliendo");

			 }

		 }		

	} // fin modificarAgentes

	

//	 -------------------- INI - INSERTAR -------------------

    /**

     * Metodo del EJB que realiza la inserci?n del objeto Q02bAgenteOfi

     * @param mapaEntrada

     * @param autenticador

     *

     * @return Devuelve un 1 para indicar que se ha realizado la insercin

     * @throws Exception

     *    

     * @generated

     */

    public String insertarAgenteOfi(HashMap mapaEntrada, Q02bAutenticador autenticador

      //  S99bAutenticador autenticador) throws Exception {

    ) throws Exception {

        //Definicion de variables que no se van a modificar

        final String TRACE_METODO = "Q02bAgenteOfiBean:insertarAgenteOfi";

       



        try {

            if (tr.isTraceActive()) {

                tr.trace(COMPONENTE, Q70TraceLevel.INFO,

                    TRACE_METODO + ": entrando");

                tr.trace(COMPONENTE, Q70TraceLevel.DEBUG,

                    TRACE_METODO + ": HashMap: " + mapaEntrada.toString());

            }



            //se pasa el hashmap de entrada a un objeto de tipo Q02bAgenteOfi	  		

            Q02bAgenteOfi voInsert = (Q02bAgenteOfi) Q02bVoUtils.getValueObject(mapaEntrada,

            		"q02b.exe.agentes.valueobjects.Q02bAgenteOfi");

           

            

            //Se instancia el bean de negocio

            beanAgenteOfi= new Q02bAgenteOfiBean();

            //Se pasa el autenticador

            beanAgenteOfi.setAutenticador(autenticador);

           

            //Se llama al m?todo del bean de negocio que realiza la inserci?n

            beanAgenteOfi.insertarAgenteOfi(voInsert);

            

            return "1";

        } catch (Exception ex) {

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

                TRACE_METODO + sw.getBuffer().toString());

            throw ex;

        } finally {

            if (tr.isTraceActive()) {

                tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + " saliendo.");

            }

        }

    }

	

    

    /**

	 * Obtener la lista de oficinas de un agente

	 * @return Devuelve la lista de oficinas de un agente

	 * @throws Exception

	 */	

	public ArrayList obtenerListaAgenteOfi(String niAgente, Q02bAutenticador autenticador) throws Exception

	

	{		

		ArrayList listaAgenteOfi= new ArrayList(); 

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerListaAgenteOfi: entrando.");

	   		}		

			 beanAgenteOfi= new Q02bAgenteOfiBean();

			 

			beanAgenteOfi.setAutenticador(autenticador);

			listaAgenteOfi = beanAgenteOfi.obtenerListaAgenteOfi(niAgente);

			return listaAgenteOfi;

		} catch(Q02bAplicException ex1){	 		  

	          java.io.StringWriter sw = new java.io.StringWriter();

	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          ex1.printStackTrace(pw);

	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerListaAgenteOfi: " + sw.getBuffer ().toString());

	          throw ex1;       	

		}catch(Exception ex){	 	

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerListaAgenteOfi: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerListaAgenteOfi: saliendo.");

	   		}

	 	}

	}//fin obtenerListaAgenteOfi

	

	// --------------------------------------------------------------------------

	// ---------- FIN agentes -----------

	// ---------------------------------------------------------------------------



	 // -------------------- INI - BORRAR -------------------------

    /**     

     *

     * @param columnaPKAgenteOfi

     * @param autenticador

     *

     * @throws Exception

     * @see Q02bAgenteOfiBean

     * @see 

     * @generated

     */

   // public void borrarVarActEprtr(String columnaPKAgenteOfi,

   //     S99bAutenticador autenticador) throws Exception {

	public void borrarAgenteOfi(String columnaPKAgenteOfi,

	     Q02bAutenticador autenticador) throws Exception {

	 

        //Definicion de variables que no se van a modificar

        final String TRACE_METODO = "Q02bAgentesSesionBean:borrarAgenteOfi";



        try {

            if (tr.isTraceActive()) {

                tr.trace(COMPONENTE, Q70TraceLevel.INFO,

                    TRACE_METODO + ": entrando");

            }



            // se instancia el objeto que contendra la clave primaria

            Q02bAgenteOfi voPK = new Q02bAgenteOfi();



            //Se separa la PK compuesta por el delimitador

            String[] colPekas = columnaPKAgenteOfi.split(",");



            //Informamos la clave primaria  Q022JT00_ID_AGEN

            voPK.setIdAgente(colPekas[0]);

            //Informamos la clave primaria Q022HT00_ID_OFI

            voPK.setIdOfi(colPekas[1]);

            //Se instancia el bean de negocio

            beanAgenteOfi = new Q02bAgenteOfiBean();

            //Se pasa el autenticador

            beanAgenteOfi.setAutenticador(autenticador);

            //Se llama al metodo del bean de negocio que realiza el borrado

            beanAgenteOfi.borrarAgenteOfi(voPK);

        } catch (Exception ex) {

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

                TRACE_METODO + sw.getBuffer().toString());

            throw ex;

        } finally {

            if (tr.isTraceActive()) {

                tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + " saliendo.");

            }

        }

    }



    // -------------------- FIN - BORRAR ------------------------

} // fin clase

