package q02b.exe.utils;



import java.util.ListResourceBundle;

/**

 * Message Bundle for custom error messages used by the framework

 * extension functionality for the Pet Store demo.

 */

public class Q02bMimeTypes extends ListResourceBundle {

  private static final Object[][] sMimeTypesStrings = new String[][] {

    /*

     * MIME TYPES

     */

	 {"dwg","application/acad"},

    {"arj","application/arj"},

    {"asd","application/astound"},

    {"asn","application/astound"},

	{"ccad","application/clariscad"},

	{"drw","application/drafting"},

	{"dxf","application/dxf"},

	{"unv","application/i-deas"},

	{"iges","application/iges"},

	{"igs","application/iges"},

	{"","application/"},

	{"jar","application/java-archive"},

	{"hqx","application/mac-binhex40"},

	{"mdb","application/msaccess"},

	{"xla","application/msexcel"},

	{"xls","application/msexcel"},

	{"xlt","application/msexcel"},

	{"xlw","application/msexcel"},

	{"pot","application/mspowerpoint"},

	{"pps","application/mspowerpoint"},

	{"mpp","application/msproject"},	

	{"doc","application/msword"},

	{"word","application/msword"},

	{"w6w","application/msword"},

	{"wri","application/mswrite"},	

	{"bin","application/octet-stream"},

	{"oda","application/oda"},

	{"pdf","application/pdf"},

	{"ai","application/postscript"},

	{"eps","application/postscript"},

	{"ps","application/postscript"},

	{"part","application/pro_eng"},

	{"prt","application/pro_eng"},	

	{"rtf","application/rtf"},

	{"set","application/set"},

	{"stl","application/sla"},

	{"sol","application/solids"},

	{"st","application/STEP"},

	{"step","application/STEP"},

	{"stp","application/STEP"},

	{"vda","application/vda"},

	{"bcpio","application/x-bcpio"},

	{"cpio","application/x-cpio"},

	{"csh","application/x-csh"},

	{"dcr","application/x-director"},

	{"dir","application/x-director"},

	{"dxr","application/x-director"},

	{"dvi","application/x-dvi"},

	{"dwf","application/x-dwf"},

	{"gtar","application/x-gtar"},

	{"gz","application/x-gzip"},

	{"gzip","application/x-gzip"},

	{"hdf","application/x-hdf"},

	{"js","application/x-javascript"},

	{"latex","application/x-latex"},

	{"bin","application/x-macbinary"},

	{"mid","application/x-midi"},

	{"mif","application/x-mif"},

	{"cdf","application/x-netcdf"},

	{"nc","application/x-netcdf"},

	{"sh","application/x-sh"},

	{"shar","application/x-shar"},

	{"swf","application/x-shockwave-flash"},

	{"sit","application/x-stuffit"},

	{"sv4cpio","application/x-sv4cpio"},

	{"sv4crc","application/x-sv4crc"},

	{"tar","application/x-tar"},

	{"tcl","application/x-tcl"},

	{"tex","application/x-tex"},

	{"texi","application/x-texinfo"},

	{"texinfo","application/x-texinfo"},

	{"roff","application/x-troff"},

	{"t","application/x-troff"},

	{"tr","application/x-troff"},

	{"man","application/x-troff-man"},

	{"me","application/x-troff-me"},

	{"ms","application/x-troff-ms"},

	{"ustar","application/x-ustar"},

	{"src","application/x-wais-source"},

	{"hlp","application/x-winhelp"},

	{"zip","application/zip"},

	{"au","audio/basic"},

	{"snd","audio/basic"},

	{"mid","audio/midi"},

	{"midi","audio/midi"},

	{"aif","audio/x-aiff"},

	{"aifc","audio/x-aiff"},

	{"aiff","audio/x-aiff"},

	{"mp3","audio/x-mpeg"},

	{"ra","audio/x-pn-realaudio"},

	{"ram","audio/x-pn-realaudio"},

	{"rpm","audio/x-pn-realaudio-plugin"},

	{"voc","audio/x-voice"},

	{"wav","application/x-wav"},

	{"bmp","image/bmp"},

	{"gif","image/gif"},

	{"ief","image/ief"},

	{"jpe","image/jpeg"},

	{"jpeg","image/jpeg"},

	{"jpg","image/jpeg"},

	{"pict","image/pict"},

	{"png","image/png"},

	{"tif","image/tiff"},

	{"tiff","image/tiff"},

	{"ras","image/x-cmu-raster"},

	{"pnm","image/x-portable-anymap"},

	{"pbm","image/x-portable-bitmap"},

	{"pgm","image/x-portable-graymap"},

	{"ppm","image/x-portable-pixmap"},

	{"rgb","image/x-rgb"},

	{"xbm","image/x-xbitmap"},

	{"xpm","image/x-xpixmap"},

	{"xwd","image/x-xwindowdump"},

	{"gzip","multipart/x-gzip"},

	{"zip","multipart/x-zip"},

	{"htm","text/html"},

	{"html","text/html"},

	{"C","text/plain"},

	{"cc","text/plain"},

	{"h","text/plain"},

	{"rtx","text/richtext"},

	{"tsv","text/tab-separated-values"},

	{"etx","text/x-setext"},

	{"sgm","text/x-sgml"},

	{"sgml","text/x-sgml"},

	{"mpe","video/mpeg"},

	{"mpeg","video/mpeg"},

	{"mpg","video/mpeg"},

	{"avi","video/msvideo"},

	{"mov","video/quicktime"},

	{"mogtv","video/quicktime"},

	{"vdo","video/vdo"},

	{"viv","video/vivo"},

	{"vivo","video/vivo"},

	{"movie","video/x-sgi-movie"},

	{"ice","x-conference/x-cooltalk"},

	{"svr","x-world/x-svr"},

	{"wrl","x-world/x-vrml"},

	{"vrt","x-world/x-vrt"},

	{"txt","text/plain"},

	{"xml","text/xml"}

  };//application/octet-stream



  /**

   * Return String Identifiers and corresponding Messages in a two-dimensional array.

   */

  protected Object[][] getContents() {

    return sMimeTypesStrings;

  }

  

  /**

   * Return String Identifiers and corresponding Messages in a two-dimensional array.

   */

  public static String getMessage(String clave) {	

	  String msg = "";

	  for(int i = 0; i < sMimeTypesStrings.length; i++ ) {

		  String[] a = (String[])sMimeTypesStrings[i];

	      String key =  a[0];

	      if (key!= null && key.equals(clave)){

	    	  msg = a[1];

	    	  break;

	      }

	  }

	  if (msg.equals("")){

		  msg="text/plain";
      }
	  return msg;

  }

}