package q02b.exe.utils;



import java.io.IOException;

import java.io.InputStream;

import java.util.Properties;



public class Q02bConstantes {

	

	private static final String CONFIG_NAME = "/html/datos/q02bConstantes.properties"; //$NON-NLS-1$

	public static final String REGISTRO_ACTIVO = "0";

	public static final String REGISTRO_INACTIVO = "1";

	public static final String REGISTRO_TODOS = "2";

	public static final String SEPARADOR_PK = "#";

	// para pasar la pk por url

	public static final String SEPARADOR_URL = "_";

	public static final String SEPARADOR_LISTA = ",";

	public static final char ESTADO_HABILITADO = 'H';

	public static final char ESTADO_DESHABILITADO = 'D';

	public static final char ESTADO_PROTEGIDO = 'P';

	public static final char ESTADO_INVISIBLE = 'I';



	// Como lo de REGISTRO ACTIVO E INACTIVO lleva a errores

	// Estas dos constantes deben usarse UNICAMENTE para establecer los valores

	// de los campos de auditoria de IND_INACTIVO

	// para anular --> REGISTRO_ANULADO

	// para reestablecer/insertar --> REGISTRO_OK

	public static final String REGISTRO_OK="0";

	public static final String REGISTRO_ANULADO="1";



	// para cargar cualquier indicador generico que no sea el anterior

	// indicadores de obligatorio, o sea cualquie campo IND_XXXXX

	// que no sea en anterior.

	// puesto a "1" indica que el check estar marcado

	public static final String MARCA_ACTIVO="1";

	public static final String MARCA_INACTIVO="0";

	

	//Especifican el tipo de dato para la secuencia de un nmero correlativo

	public static final String CORRELATIVO_NUMERICO 	= "N";

	public static final String CORRELATIVO_VARCHAR  	= "C";

	public static final String CORRELATIVO_DATE 		= "D";

	public static final String CORRELATIVO_PATRON_DATE 	= "dd/MM/yyyy";

	

	//Especifican el tipo de restriccn para los buscadores de entidad y centro

	public static final String TIPO_RESTRICCION_ORIGEN = "ORIGEN";

	public static final String TIPO_RESTRICCION_DESTINO = "DESTINO";

	public static final String TIPO_RESTRICCION_GESTOR_INFORMACION_AMBIENTAL = "TODOS_GIA";

	public static final String TIPO_RESTRICCION_GESTOR = "TODOS_GESTORES";

	public static final String TIPO_RESTRICCION_VERIFICADOR = "TODOS_VERIFICADORES";

	public static final String TIPO_RESTRICCION_TRANSPORTISTA = "TODOS_TRANSPORTISTAS";

	

	//Indicadores de Actividad Principal y secundaria

	public static final String ACTIVIDAD_PRINCIPAL="1";

	public static final String ACTIVIDAD_SECUNDARIA="0";

	

	//Especifican el tipo de dato para la secuencia de un nmero correlativo

	public static final String PL_NUMERICO 	= "N";

	public static final String PL_VARCHAR  	= "C";

	public static final String PL_DATE 		= "D";

	

    //Formatos de fecha

	public static final String FORMATO_FECHA_FORMAT_DATA 	= "1";

	public static final String FORMATO_FECHA 	  			= "dd/MM/yyyy";

	public static final String FORMATO_FECHA_HORA 			= "dd/MM/yyyy HH:mm:ss";

	

	//Contacto

	public static final String CODIGO_PORTADA_CONTACTO		= "contacto"; 

	public static final String PORTADA_EMAIL_CONTACTO		= "leire.uriarte@ieuskadi.com"; 

	

	 /**

     * Aqu se almacenan las propiedades

     */

    private static final Properties props = new Properties();

    

    /**

     * Intentamos cargar el fichero de configuracin de un fichero llamado config.properties que est ubicado en el raz

     * del jar en el que se encuentre esta clase.

     */

    static{

        try{

            reload();

        }catch(Throwable ex){

            //System.err.println("WARNING::Error inicializando la clase Q02bConstantes: "+ex.getLocalizedMessage());

            ex.printStackTrace(System.err);

        }

    }

    

 

    

    /**

     * REcarga el fichero de configuracin

     * @throws IOException Si se produce algn error

     */

    public static final void reload() throws IOException{

            InputStream is = null;

            Properties newProps = new Properties();

            try{

                is = Q02bConstantes.class.getResourceAsStream(CONFIG_NAME);

                newProps.load( is );

                props.clear();

                props.putAll(newProps);

                

            }finally{

                try{

                    is.close();

                }catch(Throwable ex){}

            }

        

    }

    

    /**

     * Devuelve el valor de la propiedad key

     * @param key Nombre de la propiedad a buscar

     * @return Valor de la propiedad key

     */

    public static final String getString(String key){

            return props.getProperty(key);

       

    }

    

}

