

package q02b.exe.utils;



import java.sql.ResultSet;

import java.sql.Connection;

import java.sql.PreparedStatement;

import q02b.exe.arquitectura.dataobjects.Q02bDAOException;

import q02b.exe.utils.Q02bConstantes;

import es.ejie.frmk.conectores.conectorJDBC.Q70ConectorJDBC;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

import es.ejie.frmk.listeners.base.Q70ListenerUtils;







/**

 * Clase que obtiene el cdigo de un elemento a partir de su nmero interno

 * 

 * @author leire.uriarte

 * @author Javier.cruz

 *

 */

public class Q02bCODLocator{

	 protected static final String COMPONENTE = "CODLOCATOR";

	 private static Q70Traza tr = Q70Traza.getSingleton();

	 protected static String Q02_JNDI_DATASOURCE = Q70ListenerUtils.getApplicationProperty("Q02bCODLocator",null,"Q02_JNDI_DATASOURCE");

    /**

     *  Constructor vaco

     */

    public Q02bCODLocator() {

        super();

    }



    

    /**

     * Mtodo que dado el ni de una tabla de tablas devolver el cdigo

     * @param ni

     * @return

     * @throws Q02bDAOException

     */

    public static String getCOD(String ni) throws Q02bDAOException {

    	

    	//recuperamos la vista del TT sobre la que realizaremos las consultas

    	String tabla = Q02bConstantes.getString("TT_TABLA");

    	//se definen las columnas que corresponde con el ni y el codigo

    	String colSelect = Q02bConstantes.getString("TT_COLUM_COD");

    	String colWhere = Q02bConstantes.getString("TT_COLUM_NI");

    	

    	//se define el cdigo de retorno

    	String codRetorno = null;

    	try

    	{

    		if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Q02bCODLocator :getCOD: entrando.");

	   		}

    		codRetorno = getCODGenerico(tabla,colWhere, colSelect, ni);

    		return codRetorno;    	

    	}catch (Exception ex) {    		

    		java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Q02bCODLocator::getCOD Error. " + sw.getBuffer ().toString());

                }			    		

    		throw new Q02bDAOException(ex);

    	}

    	finally

    	{

    		if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Q02bCODLocator:getCOD: saliendo.");

	   		}

    	}

    	

    }

    

    /**

     * Mtodo que dado el ni de una tabla de tablas devolver el cdigo

     * @param ni

     * @return

     * @throws Q02bDAOException

     */

    public static String getCODWithConnection(String ni, Connection connection) throws Q02bDAOException {

    	

    	//recuperamos la vista del TT sobre la que realizaremos las consultas

    	String tabla = Q02bConstantes.getString("TT_TABLA");

    	//se definen las columnas que corresponde con el ni y el codigo

    	String colSelect = Q02bConstantes.getString("TT_COLUM_COD");

    	String colWhere = Q02bConstantes.getString("TT_COLUM_NI");

    	

    	//se define el cdigo de retorno

    	String codRetorno = null;

    	try

    	{

    		if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Q02bCODLocator :getCODWithConnection: entrando.");

	   		}

    		codRetorno = getCODGenericoWithConnection(tabla,colWhere, colSelect, ni, connection);

    		return codRetorno;    	

    	}catch (Exception ex) {    		

    		java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Q02bCODLocator::getCODWithConnection Error. " + sw.getBuffer ().toString());

                }			    		

    		throw new Q02bDAOException(ex);

    	}

    	finally

    	{

    		if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, "Q02bCODLocator:getCODWithConnection: saliendo.");

	   		}

    	}

    	

    }

    

    

    /**

     * Mtodo que recuperara el cdigo de tabla de tablas pasados los parametros adecuados.

     * @param tabla

     * @param colWhere

     * @param colSelect

     * @param ni

     * @return

     * @throws Q02bDAOException

     */

    public static String getCODGenerico(String tabla, String colWhere,String colSelect,String ni) throws Q02bDAOException {    	

    	

    	//objetos necesarios para la consulta

		StringBuffer selectStatement = null;

	    PreparedStatement prepStmt = null;

	    ResultSet rs = null;

	    Connection connection = null;

	    String cod = null;

	    

	    try {	

	    	if(tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q02bCODLocator::getCODGenerico beginning.");

	    	}

	    	//connection = Q02bDatabaseConnectionLocator.getConnection();

	    	connection = Q70ConectorJDBC.getSingleton().getConnection(Q02_JNDI_DATASOURCE);

	    	selectStatement = new StringBuffer( "SELECT ").append(colSelect);

	    	selectStatement.append(" FROM ").append(tabla);

			selectStatement.append(" WHERE ").append(colWhere).append(" = ? ");

			if(tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q02bCODLocator::getCODGenerico." + selectStatement.toString());

	    	}

	    	prepStmt = connection.prepareStatement(selectStatement.toString());

	    	//se carga el parametro del cdigo del que se busca el ni correspondiente

	    	try{

	    		prepStmt.setLong(1,Long.parseLong(ni));

	    	}catch(Exception e){

	    		//si el codigo esta entre comillas se eliminaran estas comillas	    		

	    		if (ni.startsWith("'")&& ni.endsWith("'"))

	    		{

	    			//se eliminan las comillas

	    			ni = ni.substring(1,(ni.length()-1));

	    		}

	    		prepStmt.setString(1,ni);	

	    	}

	    	rs = prepStmt.executeQuery();

	    	

	    	if (rs.next()){

            	cod = rs.getString(colSelect);

            }

	    	if(tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q02bCODLocator::getCODGenerico ending.");

	    	}			

			if(cod!=null && !cod.equals("") && !cod.equals("")) {

	            return cod;

			}else{

				if(tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, ":Q02bCODLocator:getCODGenerico error :: " + tabla + " :: " + colWhere + " :: " + colSelect + " :: " + ni);

		    	}							

	            return ni;

			}



	    }catch (Exception ex) {    	

	    	if(tr.isTraceActive()){

	    		java.io.StringWriter sw = new java.io.StringWriter();

	            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	            ex.printStackTrace(pw);

	            if (tr.isTraceActive()){

	                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Q02bCODLocator::getCODGenerico Error. " + sw.getBuffer ().toString());

	                }			

	    	}		

			throw new Q02bDAOException(ex);

	    } finally {        

	    	try{//se liberan todos los recursos

	    		if (rs!=null){rs.close();}

	    		if (prepStmt!=null){prepStmt.close();}

	    		if (connection!=null){connection.close();}    		

	    	}catch (Exception ex) {   

	    		java.io.StringWriter sw = new java.io.StringWriter();

	            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	            ex.printStackTrace(pw);

	            if (tr.isTraceActive()){

	            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Q02bCODLocator::getCODGenerico Error cerrando. " + sw.getBuffer ().toString());

	            }

	            throw new Q02bDAOException(ex);

	        } 

	    	if(tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q02bCODLocator::getCODGenerico saliendo.");

	    	}

	    }

    }

    

    /**

     * Mtodo que recuperara el cdigo de tabla de tablas pasados los parametros adecuados.

     * @param tabla

     * @param colWhere

     * @param colSelect

     * @param ni

     * @return

     * @throws Q02bDAOException

     */

    public static String getCODGenericoWithConnection(String tabla, String colWhere,String colSelect,String ni, Connection connection) throws Q02bDAOException {    	

    	

    	//objetos necesarios para la consulta

		StringBuffer selectStatement = null;

	    PreparedStatement prepStmt = null;

	    ResultSet rs = null;

	    String cod = null;

	    

	    try {	

	    	if(tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q02bCODLocator::getCODGenerico beginning.");

	    	}

	    	selectStatement = new StringBuffer( "SELECT ").append(colSelect);

	    	selectStatement.append(" FROM ").append(tabla);

			selectStatement.append(" WHERE ").append(colWhere).append(" = ? ");

			if(tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q02bCODLocator::getCODGenericoWithConnection." + selectStatement.toString());

	    	}

	    	prepStmt = connection.prepareStatement(selectStatement.toString());

	    	//se carga el parametro del cdigo del que se busca el ni correspondiente

	    	try{

	    		prepStmt.setLong(1,Long.parseLong(ni));

	    	}catch(Exception e){

	    		//si el codigo esta entre comillas se eliminaran estas comillas	    		

	    		if (ni.startsWith("'")&& ni.endsWith("'"))

	    		{

	    			//se eliminan las comillas

	    			ni = ni.substring(1,(ni.length()-1));

	    		}

	    		prepStmt.setString(1,ni);	

	    	}

	    	rs = prepStmt.executeQuery();

	    	

	    	if (rs.next()){

            	cod = rs.getString(colSelect);

            }

	    	if(tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q02bCODLocator::getCODGenericoWithConnection ending.");

	    	}			

			if(cod!=null && !cod.equals("") && !cod.equals("")) {

	            return cod;

			}else{

				if(tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, ":Q02bCODLocator:getCODGenericoWithConnection error :: " + tabla + " :: " + colWhere + " :: " + colSelect + " :: " + ni);

		    	}							

	            return ni;

			}



	    }catch (Exception ex) {    	

	    	if(tr.isTraceActive()){

	    		java.io.StringWriter sw = new java.io.StringWriter();

	            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	            ex.printStackTrace(pw);

	            if (tr.isTraceActive()){

	                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Q02bCODLocator::getCODGenericoWithConnection Error. " + sw.getBuffer ().toString());

	                }			

	    	}		

			throw new Q02bDAOException(ex);

	    } finally {        

	    	try{//se liberan todos los recursos

	    		if (rs!=null){rs.close();}

	    		if (prepStmt!=null){prepStmt.close();}   		

	    	}catch (Exception ex) {   

	    		java.io.StringWriter sw = new java.io.StringWriter();

	            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	            ex.printStackTrace(pw);

	            if (tr.isTraceActive()){

	            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Q02bCODLocator::getCODGenericoWithConnection Error cerrando. " + sw.getBuffer ().toString());

	            }

	            throw new Q02bDAOException(ex);

	        } 

	    	if(tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Q02bCODLocator::getCODGenericoWithConnection saliendo.");

	    	}

	    }

    }

}