package q02b.exe.usuarios.beans;



import java.util.ArrayList;
import java.util.HashMap;

import q02b.exe.arquitectura.beans.Q02bBaseBean;
import q02b.exe.usuarios.dataobjects.Q02bUsuariosDataBaseDAO;
import q02b.exe.usuarios.valueobjects.Q02bFiltroUsuarios;
import q02b.exe.usuarios.valueobjects.Q02bUsuario;
import q02b.exe.utils.Q02bConstantes;
import q02b.exe.utils.Q02bVoUtils;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;



public class Q02bUsuariosBean extends Q02bBaseBean{

	

	private static final long serialVersionUID = 5474311672836163390L;

	protected Q02bUsuariosDataBaseDAO daoUsuarios = null;



	

	 /** Constructor vacio */

    public Q02bUsuariosBean() {

        super();

    }

    

    

    /**

     * Funcin que recupera los usuarios

     * 

     * @return listausuarios  -  Listado de usuarios obtenidos

     * @throws Exception

     */

	public ArrayList getUsuarios(HashMap mapaFiltroUsuarios) throws Exception 

	{

		Q02bFiltroUsuarios filtroUsuariosVO = null;

		

		//String noRegRecuperados = "NoHayUsuarios";

		ArrayList listaUsuarios = new ArrayList();

		int numUsuarios = 0;

		boolean error = false;

		//boolean obtenerListado=false;

		

		try{

			 if (tr.isTraceActive()){

		   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getUsuarios: entrando.");

		   	}  	  

			

			//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoUsuarios = new Q02bUsuariosDataBaseDAO(this.getConn());

			daoUsuarios.setIdioma(this.getAutenticador().getIdioma());

			

			//Pasamos del hashMap recibido al valueObject

			filtroUsuariosVO = (Q02bFiltroUsuarios) Q02bVoUtils.getValueObject(mapaFiltroUsuarios,"q02b.exe.usuarios.valueobjects.Q02bFiltroUsuarios");

			

			//se llamamara al dao para obtener el nmero de cuestionarios

			numUsuarios = daoUsuarios.getCountUsuarios(filtroUsuariosVO);

			if(numUsuarios>0){

				listaUsuarios = daoUsuarios.getUsuarios(filtroUsuariosVO);

	     	}

	        return listaUsuarios;              

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getUsuarios: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoUsuarios.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getUsuarios: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getUsuarios: saliendo.");

	   		}

 	  	}

 	  } //fin getCuestionariosSM 

	

	public Q02bUsuario obtenerUsuarioModificacion(String idUsuario) throws Exception{

    	boolean error = false;

    	Q02bUsuario usuario = new Q02bUsuario();

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuarioModificacion: entrando");

      		}

			abrirConexion();			

			this.daoUsuarios = new Q02bUsuariosDataBaseDAO(this.getConn());

            //Pasamos los perfiles del usuario e idioma

			this.daoUsuarios.setUser(this.autenticador.getUser());

			this.daoUsuarios.setIdioma(this.autenticador.getIdioma());

			

			usuario = daoUsuarios.getUsuario(idUsuario);

			

			//Obtenemos los usuarios seleccionados para el grupo

			usuario.setListaGruposSeleccionados(this.obtenerGruposSeleccionados(idUsuario));

			

			//Obtenemos los usuarios no seleccionados

			usuario.setListaGrupos(this.obtenerGruposNoSeleccionados(idUsuario));

			

			

//			Obtenemos los municipios seleccionados para el usuario

			usuario.setListaMunicipiosSeleccionados(this.obtenerMunicipiosSeleccionados(idUsuario));

						

//			Obtenemos los municipios no seleccionados

			usuario.setListaMunicipios(this.obtenerMunicipiosNoSeleccionados(idUsuario));

						

			return usuario;

    	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuarioModificacion: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

    		try{

    			this.daoUsuarios.freeResourcesNotConnection();

    		}catch(Exception ex){

    		   if (tr.isTraceActive()){

    			   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuarioModificacion: error liberando recursos");

    		   }  

    		}  		 

    	 	//se cierra la conexin  

    	 	cerrarConexion(error);	       	

    		if (tr.isTraceActive()){

    			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuarioModificacion saliendo.");

    		}

    	 }

    }

	

	/**

     * Mtodo que llama a un DAO para obtener un objeto Q02bUsuario con los datos para la consulta.

     * @param idUsuario nmero interno del usuario en bbdd.

     * @return Objeto Q02bUsuario con los datos del usuario

     * @throws Exception

     */

    public Q02bUsuario obtenerUsuarioConsulta (String idUsuario) throws Exception {		 	 

		//Definicin de variables que no se van a modificar

		final String 	TRACE_METODO 	= ":obtenerGrupo:";

		//Definicin de dems variables

		Q02bUsuario usuario = new Q02bUsuario();

		boolean	error = false;

		

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando.");

	   		}  

			//Se abre la conexin

			abrirConexion();

			//Se instancia el dao pasandole la conexin			

			daoUsuarios = new Q02bUsuariosDataBaseDAO(this.getConn());

			//Se pasan los parmetros de usuario e idioma

			daoUsuarios.setUser(this.autenticador.getUser());

			daoUsuarios.setIdioma(this.autenticador.getIdioma());

						

			usuario = daoUsuarios.getUsuario(idUsuario);		

            

            // Obtenemos los grupos seleccionados para el usuario

			usuario.setListaGruposSeleccionados(this.obtenerGruposSeleccionados(idUsuario));

			

			//Obtener los municipios seleccionados para el usuario

			usuario.setListaMunicipiosSeleccionados(this.obtenerMunicipiosSeleccionados(idUsuario));

			

			return usuario;              

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter 	sw = new java.io.StringWriter();

          java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoUsuarios.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + " error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO  + " saliendo.");

	   		}

 	  	}

 	  }

	

	/**

     * Mtodo que llama a un DAO para obtener la lista de grupos seleccionados para un usuario

     * @param idUusario nmero interno del usuario en bbdd.

     * @return ArrayList con la lista de grupos asignados a un usuario

     * @throws Exception

     */

    private ArrayList obtenerGruposSeleccionados(String idUsuario) throws Exception{

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGruposSeleccionados: entrando");

      		}

    		this.daoUsuarios = new Q02bUsuariosDataBaseDAO(this.getConn());

    		this.daoUsuarios.setUser(this.autenticador.getUser());

    		this.daoUsuarios.setIdioma(this.autenticador.getIdioma());

			

			return daoUsuarios.obtenerGruposSeleccionados(idUsuario);

    	}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGruposSeleccionados: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

 		    try{

 		    	this.daoUsuarios.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGruposSeleccionados: error liberando recursos");

	   	   	   }  

 		    }  		         	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGruposSeleccionados: saliendo.");

	   		}

    	}

    }  

    

    /**

     * Mtodo que llama a un DAO para obtener la lista de grupos no seleccionados para un usuario.

     * @param idUsuario

     * @return ArrayList con la lista de grupos no asignados a un usuario.

     * @throws Exception

     */

    private ArrayList obtenerGruposNoSeleccionados(String idUsuario) throws Exception{

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGruposNoSeleccionados: entrando");

      		}

    		this.daoUsuarios = new Q02bUsuariosDataBaseDAO(this.getConn());

    		this.daoUsuarios.setUser(this.autenticador.getUser());

    		this.daoUsuarios.setIdioma(this.autenticador.getIdioma());

			

			return this.daoUsuarios.obtenerGruposNoSeleccionados(idUsuario);

    	}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGruposNoSeleccionados: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

 		    try{

 		    	this.daoUsuarios.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGruposNoSeleccionados: error liberando recursos");

	   	   	   }  

 		    }  		         	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGruposNoSeleccionados: saliendo.");

	   		}

    	}

    }

	

	/**

     * Funcin que inserta un usuario en la bbdd

     * @param usuarioVO - Q02bUsuario valueobject usuario con los datos del usuario

     * @return idUsuario - String  Nmero interno del usuario insertado

     * @throws Exception

     */

	public String insertarUsuario(Q02bUsuario usuarioVO) throws Exception 

	{

		String idUsuario= null;		

		boolean error = false;

		

		

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarUsuario: entrando.");

			}  	  

			//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoUsuarios = new Q02bUsuariosDataBaseDAO(this.getConn());

			daoUsuarios.setIdioma(this.getAutenticador().getIdioma());

			//se llamamara al dao para insertar el usuario

			idUsuario = daoUsuarios.insertarUsuario(usuarioVO);

			

			//se llama al metodo para insertar los usuarios y los grupos

			daoUsuarios.insertarGruposUsuario(idUsuario, usuarioVO.getListaGruposSeleccionados());

			

			//si entre los municipios a metido TODOS			

			String todos  =Q02bConstantes.getString("municipios.todos");

			boolean incluyeTodos=false;

			ArrayList listaMunicipios=usuarioVO.getListaMunicipiosSeleccionados();

			for(int i=0; i<listaMunicipios.size() ; i++){

				if (listaMunicipios.get(i).equals( todos)){

					incluyeTodos=true;				
                }
			}

						

//			se llama al metodo para insertar los municipios a los que tien acceso el usuario

			// si tiene municipios seleccionados y no incluye TODOS en provincia o no tiene entre los municipios seleccionados todos

			if ( usuarioVO.getListaMunicipiosSeleccionados().size()>0 && !usuarioVO.getCodProvincia().equals(todos) && !incluyeTodos ){

			        daoUsuarios.insertarMunicipiosUsuario(usuarioVO.getCodProvincia(),idUsuario, listaMunicipios);
            }
			

	        return idUsuario;              

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarUsuario: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoUsuarios.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarUsuario: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarUsuario: saliendo.");

	   		}

 	  	}

 	  } //fin insertarUsuario 



	/**

     * Funcin que modifica un usuario de la bbdd

     * 

     * @param usuarioVO - Q02bUsuario valueobject usuario con los datos del usuario

     * @throws Exception

     */

	public void modificarUsuario(Q02bUsuario usuarioVO) throws Exception 

	{

		boolean error = false;

		

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarUsuario: entrando.");

			}  	  

			//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoUsuarios = new Q02bUsuariosDataBaseDAO(this.getConn());

			daoUsuarios.setIdioma(this.getAutenticador().getIdioma());

			//se llamamara al dao para modificar el usuario

			daoUsuarios.modificarUsuario(usuarioVO);

	        

			//modificamos los grupos asignados al usuario

			this.modificarGruposUsuario(usuarioVO.getIdUsuario(),usuarioVO.getListaGruposSeleccionados());

			

			

//			si entre los municipios a metido TODOS			

			/*String todos  =Q02bConstantes.getString("municipios.todos");

			boolean incluyeTodos=false;

			ArrayList listaMunicipios=usuarioVO.getListaMunicipiosSeleccionados();

			for(int i=0; i<listaMunicipios.size() ; i++){

				if (listaMunicipios.get(i).equals( todos))

					incluyeTodos=true;				

			}*/

						

//			se llama al metodo para insertar los municipios a los que tien acceso el usuario

			// si tiene municipios seleccionados y no incluye TODOS en provincia o no tiene entre los municipios seleccionados todos

			//if ( usuarioVO.getListaMunicipiosSeleccionados().size()>0 && !usuarioVO.getCodProvincia().equals(todos) && !incluyeTodos )

				//modificamos los municipios asignados al usuario

				this.modificarMunicipiosUsuario(usuarioVO.getCodProvincia(), usuarioVO.getIdUsuario(), usuarioVO.getListaMunicipiosSeleccionados());

			

			

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarUsuario: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoUsuarios.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarUsuario: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarUsuario: saliendo.");

	   		}

 	  	}

 	  } //fin modificarUsuario 

	

	/**

     * Mtodo que llama a un DAO para modificar los usuarios para un grupo determinado

     * @param niGrupo nmero interno del grupo en bbdd.

     * @param listaUsuarios ArrayList con los nmeros internos de cada usuario.

     * @throws Exception

     */

    private void modificarGruposUsuario(String idUsuario, ArrayList listaGrupos) throws Exception {

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarUsuariosGrupo: entrando");

      		}

    		this.daoUsuarios = new Q02bUsuariosDataBaseDAO(this.getConn());

    		this.daoUsuarios.setUser(this.autenticador.getUser());

			this.daoUsuarios.setIdioma(this.autenticador.getIdioma());

			

			//Primero eliminamos los que tena asignados

			this.daoUsuarios.borrarGruposUsuario(idUsuario);			

			

			// Ahora insertamos los nuevos

			for (int i=0;i<listaGrupos.size();i++){

				this.daoUsuarios.insertarUsuarioGrupo((String)listaGrupos.get(i),idUsuario);

			}

    	}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarUsuariosGrupo: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

 		    try{

 		    	this.daoUsuarios.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarUsuariosGrupo: error liberando recursos");

	   	   	   }  

 		    }  		  	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarUsuariosGrupo: saliendo.");

	   		}

    	}

    }//fin modificarGruposUsuario

    

	/**

     * Funcin que modifica un usuario de la bbdd

     * @param idUsuario - String Nmero interno del usuario

     * @throws Exception

     */

	public void borrarUsuario(String idUsuario) throws Exception 

	{

		boolean error = false;

		

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarUsuario: entrando.");

			}  	  

			//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoUsuarios = new Q02bUsuariosDataBaseDAO(this.getConn());

			daoUsuarios.setIdioma(this.getAutenticador().getIdioma());

			//se llamara al dao para borrar el usuario

			daoUsuarios.borrarGruposUsuario(idUsuario);

			daoUsuarios.borrarMunicipiosUsuario(idUsuario);

			daoUsuarios.borrarUsuario(idUsuario);			

	                      

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarUsuario: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoUsuarios.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarUsuario: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarUsuario: saliendo.");

	   		}

 	  	}

 	  } //fin borrarUsuario 

	

	

	/**

     * Mtodo que llama a un DAO para modificar los usuarios para un grupo determinado

     * @param niGrupo nmero interno del grupo en bbdd.

     * @param listaUsuarios ArrayList con los nmeros internos de cada usuario.

     * @throws Exception

     */

    private void modificarMunicipiosUsuario(String codProvincia, String idUsuario, ArrayList listaMunicipios) throws Exception {

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarMunicipiosUsuario: entrando");

      		}

    		this.daoUsuarios = new Q02bUsuariosDataBaseDAO(this.getConn());

    		this.daoUsuarios.setUser(this.autenticador.getUser());

			this.daoUsuarios.setIdioma(this.autenticador.getIdioma());

			

			//Primero eliminamos los que tena asignados

			this.daoUsuarios.borrarMunicipiosUsuario(idUsuario);			

			

			// Ahora insertamos los nuevos

			/*for (int i=0;i<listaMunicipios.size();i++){

				//this.daoUsuarios.insertarUsuarioGrupo ((String)listaMunicipios.get(i),idUsuario);			

			}*/

			String todos  =Q02bConstantes.getString("municipios.todos");

			boolean incluyeTodos=false;			//

			for(int i=0; i<listaMunicipios.size() ; i++){

				if (listaMunicipios.get(i).equals( todos)){

					incluyeTodos=true;				
                }
			}

			if ( listaMunicipios.size()>0 && !codProvincia.equals(todos) && !incluyeTodos ){

				this.daoUsuarios.insertarMunicipiosUsuario(codProvincia,idUsuario, listaMunicipios);
            }
			

    	}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarMunicipiosUsuario: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

 		    try{

 		    	this.daoUsuarios.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarMunicipiosUsuario: error liberando recursos");

	   	   	   }  

 		    }  		  	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarMunicipiosUsuario: saliendo.");

	   		}

    	}

    }//fin modificarGruposUsuario	

	

	

    /**

     * Mtodo que llama a un DAO para obtener la lista de municipios seleccionados para un usuario

     * @param idUusario nmero interno del usuario en bbdd.

     * @return ArrayList con la lista de municipios asignados a un usuario

     * @throws Exception

     */

    private ArrayList obtenerMunicipiosSeleccionados(String idUsuario) throws Exception{

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerMunicipiosSeleccionados: entrando");

      		}

    		this.daoUsuarios = new Q02bUsuariosDataBaseDAO(this.getConn());

    		this.daoUsuarios.setUser(this.autenticador.getUser());

    		this.daoUsuarios.setIdioma(this.autenticador.getIdioma());

			

			return daoUsuarios.obtenerMunicipiosSeleccionados(idUsuario);

    	}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerMunicipiosSeleccionados: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

 		    try{

 		    	this.daoUsuarios.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerMunicipiosSeleccionados: error liberando recursos");

	   	   	   }  

 		    }  		         	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerMunicipiosSeleccionados: saliendo.");

	   		}

    	}

    }  

    

    /**

     * Mtodo que llama a un DAO para obtener la lista de municipios no seleccionados para un usuario.

     * @param idUsuario

     * @return ArrayList con la lista de grupos no asignados a un usuario.

     * @throws Exception

     */

    private ArrayList obtenerMunicipiosNoSeleccionados(String idUsuario) throws Exception{

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerMunicipiosNoSeleccionados: entrando");

      		}

    		this.daoUsuarios = new Q02bUsuariosDataBaseDAO(this.getConn());

    		this.daoUsuarios.setUser(this.autenticador.getUser());

    		this.daoUsuarios.setIdioma(this.autenticador.getIdioma());

			

			//return this.daoUsuarios.obtenerGruposNoSeleccionados(idUsuario);

    		return this.daoUsuarios.obtenerMunicipiosNoSeleccionados(idUsuario);

    	}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerMunicipiosNoSeleccionados: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

 		    try{

 		    	this.daoUsuarios.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerMunicipiosNoSeleccionados: error liberando recursos");

	   	   	   }  

 		    }  		         	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerMunicipiosNoSeleccionados: saliendo.");

	   		}

    	}

    }  

    

	

}

