/*
* Copyright 2009 by GRUPO IE, Inc.
* 
* Private and Confidential
* Code contained in this document is the property of GRUPO IE. 
* It is for the exclusive use of designated employees 
* and not for distribution without prior written
* authorization.
*/
/*
* Q02bQ022HV01.java
*
* Created on 06/04/09 04:21:34
*/
package q02b.exe.tablasBD.jdbc.oracle;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.sql.ResultSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Types;

import q02b.exe.arquitectura.dataobjects.Q02bDAOException;
import q02b.exe.ejecucionValidaciones.valueobjects.Q02bEjecucionValidaciones;
import javax.naming.NamingException;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.conectores.conectorJDBC.Q70ConectorJDBC;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/*
*
* @author automatic generated
* @version 1.0
*/
public class Q02bTablaBDQ0299S00 extends q02b.exe.tablasBD.Q02bTablaBDQ0299S00 {
    private static final long serialVersionUID =1L;
    /** Obtenemos una referencia del componente gestor de trazas de Geremua */
    private static Q70Traza tr = Q70Traza.getSingleton();
    /** Obtenemos el nombre del DataSource de nuestra aplicacin */
    private String Q02B_JNDI_DATASOURCE = Q70ListenerUtils.getApplicationProperty(this.getClass().getName(),null,"Q02B_JNDI_DATASOURCE");
    /** Nombre del componente */
    private String COMPONENTE = "TABLAS_BD";
    /** Creates new Q02bTablaBDQ0299T00 */
    /** Est declarado como private para que se utilice el constructor con argumentos */
    private Q02bTablaBDQ0299S00() {
        super();
        this.idConexion="oracle";
    }

    /** Creates new Q0299S00 */
    public Q02bTablaBDQ0299S00(Connection con) {
        this();
        connection=con;
    }
    /** Method getCountValidaciones() 
    * @return Value of the resultSet.
    */
    public ResultSet getCountValidaciones()throws SQLException,Q02bDAOException  {
        String name = (this.getClass()).getName();
        StringBuffer mensaje = new StringBuffer();
        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" Beginning en getCountValidaciones de Q02bTablaBDQ0299S00:");
            mensaje.append(" select count");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }
        Connection con=null;
        con=this.getConnection();
        StringBuffer query = new StringBuffer();
        ResultSet rs = null;
        
        String tabla = this.getTableFrom();
        
        tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,tabla);
        
        query.append("SELECT Count (");
        query.append(q02b.exe.tablasBD.Q02bTablaBDQ0299S00.NOMCOLUMN_Q0299T00_VALIDACION);
        query.append(") from ").append(tabla);
        PreparedStatement prepStmt1 = con.prepareStatement(query.toString());
        rs = prepStmt1.executeQuery();
        addResultSet(rs);
        if (tr.isTraceActive()) {
            mensaje = new StringBuffer();
            mensaje.append(name);
            mensaje.append(" Ending:");
            mensaje.append(" getCountValidaciones");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }
        return rs;
    }
    
    /** Method deleteTablaQ0299S00() 
     */
    public void deleteTablaQ0299S00()throws SQLException,Q02bDAOException  {
        String name = (this.getClass()).getName();
        StringBuffer mensaje = new StringBuffer();
        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" Beginning en deleteTablaQ0299S00 de Q02bTablaBDQ0299S00:");
            mensaje.append(" delete");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }
        Connection con=null;
        con=this.getConnection();
        StringBuffer query = new StringBuffer();
        String tabla = this.getTableFrom();
        
        tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,tabla);
        
        query.append("DELETE ");
        query.append(" from ").append(tabla);
        PreparedStatement prepStmt1 = con.prepareStatement(query.toString());
        prepStmt1.executeUpdate();
        
        prepStmt1.close();
        if (tr.isTraceActive()) {
            mensaje = new StringBuffer();
            mensaje.append(name);
            mensaje.append(" Ending:");
            mensaje.append(" deleteTablaQ0299S00");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }
    }
    
    public void procedureEjecucionValidaciones(Q02bEjecucionValidaciones filtroVO) throws Exception{
    	String name = (this.getClass()).getName();
        StringBuffer mensaje = new StringBuffer();
        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" Beginning en procedureEjecucionValidaciones de Q02bTablaBDQ0299S00:");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
        }
        Connection con=null;
        con=this.getConnection();
        CallableStatement cs=null;
        
        Integer tipo=null;
        Integer anyo=null;
        Integer mes=null;
        Integer mun=null;
        
        //Hacemos esto por problemas con los casting
        if(filtroVO.getTipoEncuesta()!=null && !"".equals(filtroVO.getTipoEncuesta())){
        	tipo = new Integer(filtroVO.getTipoEncuesta());
        }
        if(filtroVO.getAnyo()!=null && !"".equals(filtroVO.getAnyo())){
        	anyo = new Integer(filtroVO.getAnyo());
        }
        if(filtroVO.getMesSolicitud()!=null && !"".equals(filtroVO.getMesSolicitud())){
        	mes = new Integer(filtroVO.getMesSolicitud());
        }
        if(filtroVO.getIdMunicipio()!=null && !"".equals(filtroVO.getIdMunicipio())){
        	mun = new Integer(filtroVO.getIdMunicipio());
        }
        
        if (tr.isTraceActive()) {
            mensaje.append(name);
            mensaje.append(" En procedureEjecucionValidaciones de Q02bTablaBDQ0299S00:");
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,"tipo= "+tipo+
            		" :anyo= "+anyo);
            tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,"mes= "+mes+
            		" :mun= "+mun);
        }
        
        
    	try {
          	//PROCEDURE q02b_validaciones (tipo in number, ano in number, mes in number, mun in number)
    		cs = con.prepareCall("{call q02b_validaciones(?,?,?,?)}");
    		
    		if(tipo == null){
    			//[JBHG] Con la nueva version de BBDD, esta funcion da error al pasarsele null sin especificar el tipo.
				// cs.setObject(1, null);
    			cs.setNull(1, Types.INTEGER);
    		}
    		else{
    			cs.setInt(1,tipo.intValue());
    		}
    		if(anyo == null){
//    			cs.setObject(2, null);
    			cs.setNull(2, Types.INTEGER);
    		}
    		else{
    			cs.setInt(2,anyo.intValue());
    		}
    		if(mes == null){
//    			cs.setObject(3, null);
    			cs.setNull(3, Types.INTEGER);
    		}
    		else{
    			cs.setInt(3,mes.intValue());
    		}
    		if(mun == null){
//    			cs.setObject(4, null);
    			cs.setNull(4, Types.INTEGER);
    		}
    		else{
    			cs.setInt(4,mun.intValue());
    		}
    		
    		cs.execute();

            if (tr.isTraceActive()) {
        	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, mensaje.toString() +
        	        ": el procedureEjecucionValidaciones se ha hecho con xito!!!!");
        	}   
        } catch(Exception e){
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Error en procedureEjecucionValidaciones: " + e.getLocalizedMessage());
        } 
    
    }
    
    /** Method selectValidaciones() 
     * @return Value of the resultSet.
     */
     public ResultSet selectValidaciones()throws SQLException,Q02bDAOException  {
         String name = (this.getClass()).getName();
         StringBuffer mensaje = new StringBuffer();
         //long user = 0;
         if (tr.isTraceActive()) {
             mensaje.append(name);
             mensaje.append(" Beginning en selectValidaciones de Q02bTablaBDQ0299S00:");
             mensaje.append(" select");
             tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
         }
 
         Connection con=null;
         con=this.getConnection();
         StringBuffer query = new StringBuffer();
         ResultSet rs = null;
         
         String tabla = this.getTableFrom();
         
         tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,tabla);
         
         query.append("SELECT Q0299T00_VALIDACION, Q0299T00_TEXTO, Q0299T00_GRUPO, Q0299T00_CUES," +
         		"Q0299T00_ANO, Q0299T00_MES, Q0299T00_CODPROV, Q0299T00_NOMPROV, Q0299T00_CODMUN," +
         		"Q0299T00_NOMMUN, Q0299T00_LICENCIA, to_char(Q0299T00_FECENT, 'dd/MM/yyyy') fecha ");
         query.append(" from ").append(tabla);
         //ordenamos primero por grupo y luego por cuestionario
         query.append(" order by "+Q02bTablaBDQ0299S00.NOMCOLUMN_Q0299T00_GRUPO+ ", "+Q02bTablaBDQ0299S00.NOMCOLUMN_Q0299T00_CUES);
         PreparedStatement prepStmt1 = con.prepareStatement(query.toString());
         rs = prepStmt1.executeQuery();
         addResultSet(rs);
         if (tr.isTraceActive()) {
             mensaje = new StringBuffer();
             mensaje.append(name);
             mensaje.append(" Ending:");
             mensaje.append(" selectValidaciones ");
             tr.trace(COMPONENTE,Q70TraceLevel.DEBUG,mensaje.toString());
         }
         return rs;
     }
    /** Getter for property idConexion.
    * @return Value of property idConexion.
    */
    public String getIdConexion() {
           return idConexion;
    }

    /** Getter for property Conexion.
    * @return Value of property Conexion.
    */
    public Connection getConn() {
           return connection;
    }

    /** Method addColumnSelect(nombreColumna) 
    * @param nombreColumna New value of property columnasSelect.
    * Este mtodo aade una nueva columna a mostrar en el resultado de la select
    * Aadir las columnas usando las constantes de la tabla
    */
    public void addColumnSelect(String nombreColumna) {
        while (nombreColumna.endsWith(" ")) {
            nombreColumna = nombreColumna.substring(0, nombreColumna.length()-1);
          }
        while (nombreColumna.startsWith(" ")) {
            nombreColumna = nombreColumna.substring(1, nombreColumna.length());
          }
        if (nombreColumna.lastIndexOf(" ")!=-1){
            this.alias.add(nombreColumna.substring(nombreColumna.lastIndexOf(" ")+1).trim());
            this.columnasSelect.add(nombreColumna.substring(0,nombreColumna.lastIndexOf(" ")).trim());
        }else{
            this.columnasSelect.add(nombreColumna.trim());
        }
    }

    /** Method clearColumnsSelect() 
    * Este mtodo vacia el ArrayList con los nombres de las columnas sobre los q hacer la select
    */
    public void clearColumnsSelect() {
        this.columnasSelect.clear();
    }

    /** Method setColumnsSelect(listaColumnas) 
    * Este mtodo da valor al ArrayList con los nombres de las columnas sobre los q hacer la select
    */
    public void setColumnsSelect(String listaColumnas) {
        this.clearColumnsSelect();
        java.util.StringTokenizer token1 = new java.util.StringTokenizer(listaColumnas,",");
        String columna=token1.nextToken();
        while (columna.endsWith(" ")) {
            columna = columna.substring(0, columna.length()-1);
          }
        while (columna.startsWith(" ")) {
            columna = columna.substring(1, columna.length());
          }
        if (columna.lastIndexOf(" ")!=-1){
            this.alias.add(columna.substring(columna.lastIndexOf(" ")).trim());
            this.columnasSelect.add(columna.substring(0,columna.lastIndexOf(" ")).trim());
        }else{
            this.columnasSelect.add(columna);
        }
        while (token1.hasMoreTokens()){
          columna=token1.nextToken();
        while (columna.endsWith(" ")) {
            columna = columna.substring(0, columna.length()-1);
          }
        while (columna.startsWith(" ")) {
            columna = columna.substring(1, columna.length());
          }
          if (columna.lastIndexOf(" ")!=-1){
            this.alias.add(columna.substring(columna.lastIndexOf(" ")+1).trim());
            this.columnasSelect.add(columna.substring(0,columna.lastIndexOf(" ")).trim());
          }else{
            this.columnasSelect.add(columna.trim());
          }
    }
    }

    /** Method getColumnsSelect() 
    * Este mtodo devuelve un String con los nombres de las columnas sobres las q hacer la
    * select separadas por comas.
    */
    public String getColumnsSelect() {
        sbColumnasSelect = new StringBuffer();
        String columnasTotal = "Q022HT00_ID_OFI, Q022HT00_PROV, Q022HT00_MUNI, Q022HT00_DESC, Q022HT00_DESC_EUS, Q022HT00_TVIA, Q022HT00_CALLE, Q022HT00_BLOQ, Q022HT00_NUME, Q022HT00_BIS, Q022HT00_ESCA, Q022HT00_PISO, Q022HT00_MANO, Q022HT00_PUER, Q022HT00_CODP, Q022HT00_CDIR, Q022HT00_DEPA, Q022HT00_EMAILD, Q022HT00_TELF1D, Q022HT00_TELF2D, Q022HT00_FAXD, Q022HT00_WEB, NORA_T17_PROVINCIA_DS, NORA_T17_MUNICIPIO_DS, NORA_T17_LOCALIZACION";
        if (columnasSelect!=null){
        for(int i=0; i<columnasSelect.size();i++){
            sbColumnasSelect.append( (String)this.columnasSelect.get(i));
            sbColumnasSelect.append(",");
            }
            }
        if (sbColumnasSelect!=null && !sbColumnasSelect.toString().equals("")){
            sbColumnasSelect.setLength(sbColumnasSelect.length()-1);
            return sbColumnasSelect.toString();
            }
        else{
            return columnasTotal;
        }
    }

    /** Method getColumnsSelectTotal() 
    * Este mtodo devuelve un String con los nombres de las columnas sobres las q hacer la
    * select separadas por comas.
    */
    public String getColumnsSelectTotal() {
        sbColumnasSelect = new StringBuffer();
        String columnasTotal = "Q022HT00_ID_OFI \"Q022HT00_ID_OFI\", Q022HT00_PROV \"Q022HT00_PROV\", Q022HT00_MUNI \"Q022HT00_MUNI\", Q022HT00_DESC \"Q022HT00_DESC\", Q022HT00_DESC_EUS \"Q022HT00_DESC_EUS\", Q022HT00_TVIA \"Q022HT00_TVIA\", Q022HT00_CALLE \"Q022HT00_CALLE\", Q022HT00_BLOQ \"Q022HT00_BLOQ\", Q022HT00_NUME \"Q022HT00_NUME\", Q022HT00_BIS \"Q022HT00_BIS\", Q022HT00_ESCA \"Q022HT00_ESCA\", Q022HT00_PISO \"Q022HT00_PISO\", Q022HT00_MANO \"Q022HT00_MANO\", Q022HT00_PUER \"Q022HT00_PUER\", Q022HT00_CODP \"Q022HT00_CODP\", Q022HT00_CDIR \"Q022HT00_CDIR\", Q022HT00_DEPA \"Q022HT00_DEPA\", Q022HT00_EMAILD \"Q022HT00_EMAILD\", Q022HT00_TELF1D \"Q022HT00_TELF1D\", Q022HT00_TELF2D \"Q022HT00_TELF2D\", Q022HT00_FAXD \"Q022HT00_FAXD\", Q022HT00_WEB \"Q022HT00_WEB\", NORA_T17_PROVINCIA_DS \"NORA_T17_PROVINCIA_DS\", NORA_T17_MUNICIPIO_DS \"NORA_T17_MUNICIPIO_DS\", NORA_T17_LOCALIZACION \"NORA_T17_LOCALIZACION\"";
        if (columnasSelect!=null){
        for(int i=0; i<columnasSelect.size();i++){
            sbColumnasSelect.append( (String)this.columnasSelect.get(i));
            if (alias.size()>0 && i<alias.size()){
               sbColumnasSelect.append(" \"" + (String)this.alias.get(i)+ "\"");
            }else{
               sbColumnasSelect.append(" \"" + (String)this.columnasSelect.get(i)+ "\"");
            }
            sbColumnasSelect.append(",");
            }
            }
        if (sbColumnasSelect!=null && !sbColumnasSelect.toString().equals("")){
            sbColumnasSelect.setLength(sbColumnasSelect.length()-1);
            return sbColumnasSelect.toString();
            }
        else{
            return columnasTotal;
        }
    }

    /** Method getColumnsSelectComitas() 
    * Este mtodo devuelve un String con los nombres de las columnas sobres las q hacer la
    * select separadas por comas.
    */
    public String getColumnsSelectComitas() {
        sbColumnasSelect = new StringBuffer();
        String columnasTotal = " \"Q022HT00_ID_OFI\", \"Q022HT00_PROV\", \"Q022HT00_MUNI\", \"Q022HT00_DESC\", \"Q022HT00_DESC_EUS\", \"Q022HT00_TVIA\", \"Q022HT00_CALLE\", \"Q022HT00_BLOQ\", \"Q022HT00_NUME\", \"Q022HT00_BIS\", \"Q022HT00_ESCA\", \"Q022HT00_PISO\", \"Q022HT00_MANO\", \"Q022HT00_PUER\", \"Q022HT00_CODP\", \"Q022HT00_CDIR\", \"Q022HT00_DEPA\", \"Q022HT00_EMAILD\", \"Q022HT00_TELF1D\", \"Q022HT00_TELF2D\", \"Q022HT00_FAXD\", \"Q022HT00_WEB\", \"NORA_T17_PROVINCIA_DS\", \"NORA_T17_MUNICIPIO_DS\", \"NORA_T17_LOCALIZACION\"";
        if (alias.size()>0){
        for(int i=0; i<alias.size();i++){
            sbColumnasSelect.append(" \"" + (String)this.alias.get(i)+ "\"");
            sbColumnasSelect.append(",");
            }
            }
        else if (columnasSelect!=null){
        for(int i=0; i<columnasSelect.size();i++){
            sbColumnasSelect.append(" \"" + (String)this.columnasSelect.get(i)+ "\"");
            sbColumnasSelect.append(",");
            }
            }
        if (sbColumnasSelect!=null && !sbColumnasSelect.toString().equals("")){
            sbColumnasSelect.setLength(sbColumnasSelect.length()-1);
            return sbColumnasSelect.toString();
            }
        else{
            return columnasTotal;
        }
    }

    /** Method setTableFrom(listaTablas) 
    * @param listaTablas New value of property tableFrom.
    * Este mtodo aade la lista de tablas pasadas por parametro a la from .
    * Cada tabla de la lista debe ir separada por comas
    */
    public void setTableFrom(String listaTablas) {
        if (listaTablas!=null){
             this.tableFrom="Q0299S00" + "," + listaTablas;
        }else{
             this.tableFrom="Q0299S00";}
    }

    /** Method getTableFrom() 
    * Este mtodo devuelve un String con los nombres de las tablas sobres las q hacer la
    * from separadas por comas.
    */
    public String getTableFrom() {
        return this.tableFrom;
    }

    /** Method getRegModif() 
    * Este mtodo devuelve un int con el n de registros modifcados.
    */
    public int getRegModif() {
        return this.regModif;
    }

    /** Method setUncommittedRead() 
    * Este mtodo es vlido SOLO EN DB2. Permite 'lecturas sucias' si se establece a true
    */
    public void setUncommittedRead(boolean ur) {
        this.uncommittedRead=ur;
    }

    /** Method getUncommittedRead() 
    * Este mtodo es vlido SOLO EN DB2.Devuelve el valor de UncommittedRead
    */
    public boolean getUncommittedRead() {
        return this.uncommittedRead;
    }

    /** Method setForUpdate() 
    * Este mtodo permite aadir la clausula FOR UPDATE si se establece a true
    */
    public void setForUpdate(boolean fu) {
        this.forUpdate=fu;
    }

    /** Method getForUpdate() 
    * Este mtodo devuelve el valor de forUpdate
    */
    public boolean getForUpdate() {
        return this.forUpdate;
    }

    /** Method setMax(columnName) 
    * @param columnName New value of property max.
    * Este mtodo da valor a la var. max .
    */
    public void setMax(String columnName) {
        if (columnName!=null){
             this.max=columnName;}
    }

    /** Method getMax() 
    * Este mtodo devuelve un String con el nombre de la columna sobre la q hacer la
    * clausula max.
    */
    public String getMax() {
        return this.max;
    }

    /** Method setDistinct(columnName) 
    * @param columnName New value of property distinct.
    * Este mtodo da valor a la var. distinct .
    */
    public void setDistinct(String columnName) {
        if (columnName!=null){
             this.distinct=columnName;}
    }

    /** Method getDistinct() 
    * Este mtodo devuelve un String con el nombre de la columna sobre la q hacer la
    * clausula distinct.
    */
    public String getDistinct() {
        return this.distinct;
    }

    /** Method setGroupBy(listaColumnas) 
    * @param listaColumnas New value of property groupBy.
    * Este mtodo da el valor de la lista de columnas pasadas por parametro a la groupby .
    * Cada columna de la lista debe ir separada por comas
    */
    public void setGroupBy(String listaColumnas) {
             this.groupBy=listaColumnas;
    }

    /** Method getGroupBy() 
    * Este mtodo devuelve un String con los nombres de las columnas sobres las q hacer la
    * groupBy separadas por comas.
    */
    public String getGroupBy() {
        return this.groupBy;
    }

    /** Method setOrderBy(valor) 
    * @param listaColumnas New value of property orderBy.
    * Este mtodo da el valor de la lista de columnas pasadas por parametro a la orderBy .
    * Cada columna de la lista debe ir separada por comas
    */
    public void setOrderBy(String listaColumnas) {
             this.orderBy=listaColumnas;
    }

    /** Method getOrderBy() 
    * Este mtodo devuelve un String con los nombres de las columnas sobres las q hacer la
    * orderBy separadas por comas.
    */
    public String getOrderBy() {
        return this.orderBy;
    }

    /** Method setLimitRows(valor) 
    * @param listaColumnas New value of property limitRows.
    * Este mtodo da el valor pasado por parametro a la limitRows .
    */
    public void setLimitRows(boolean valor) {
             this.limitRows=valor;
    }

    /** Method getLimitRows() 
    * Este mtodo devuelve un boolean el valor de limitRows
    */
    public boolean getLimitRows() {
        return this.limitRows;
    }

    /** Method setAditionalWhere(valor) 
    * @param valor New value of property aditionalWhere.
    * Este mtodo da el valor pasado por parametro a la aditionalWhere .
    */
    public void setAditionalWhere(String valor) {
             this.aditionalWhere=valor;
    }

    /** Method getAditionalWhere() 
    * Este mtodo devuelve un String con el valor de la aditionalWhere.
    */
    public String getAditionalWhere() {
        return this.aditionalWhere;
    }

    /** Method setInitialWhere(valor) 
    * @param valor New value of property initialWhere.
    * Este mtodo da el valor pasado por parametro a la initialWhere .
    */
    public void setInitialWhere(String valor) {
             this.initialWhere=valor;
    }

    /** Method getInitialWhere() 
    * Este mtodo devuelve un String con el valor de la initialWhere.
    */
    public String getInitialWhere() {
        return this.initialWhere;
    }

    /** Method setFixedWhere(valor) 
    * @param valor New value of property fixedWhere.
    * Este mtodo da el valor pasado por parametro a la fixedWhere .
    */
    public void setFixedWhere(String valor) {
             this.fixedWhere=valor;
    }

    /** Method getFixedWhere() 
    * Este mtodo devuelve un String con el valor de la fixedWhere.
    */
    public String getFixedWhere() {
        return this.fixedWhere;
    }

    /** Method getConnection() 
    * Este mtodo devuelve un objeto connection.
    */
    public java.sql.Connection getConnection() {
        	try{
        		if (this.connection==null || this.connection.isClosed()){
           		this.connection = Q70ConectorJDBC.getSingleton().getConnection(Q02B_JNDI_DATASOURCE);
           	}
        	}catch (NamingException nex){
           		nex.printStackTrace();
         }catch (SQLException sqlex){
           		sqlex.printStackTrace();
         }
        return this.connection;
    }


}
