package q02b.exe.solicitudesNora.dataobjects;



import java.sql.Connection;

import java.sql.ResultSet;

import java.util.ArrayList;



import q02b.exe.arquitectura.dataobjects.Q02bDataBaseDAO;

import q02b.exe.solicitudesNora.valueobjects.Q02bFiltroSolicitudesNora;

import q02b.exe.solicitudesNora.valueobjects.Q02bSolicitudNora;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022DS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022ES00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022WS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022WS01V01;

import q02b.exe.utils.Q02bConstantes;

import q02b.exe.utils.Q02bFormatData;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;



public class Q02bSolicitudesNoraDataBaseDAO extends Q02bDataBaseDAO{



	private static final long serialVersionUID = -8520551641771839103L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "DAO_ACCESO_DATOS";

	

	public Q02bSolicitudesNoraDataBaseDAO() {

        super();                

    }



    

    public Q02bSolicitudesNoraDataBaseDAO(Connection conn) {

    	super(conn);     

    }

    

    

	    

	    /**

	     * Mtodo que devuelve el nmero de registros de la BBDD de la tabla de Solicitudes Nora (Q022WT00)

	     * @return devuelve nmero de registros de la BBDD de la tabla de Solicitudes Nora

	     * @throws Exception

	     */

	    public int getCountSolicitudesNora(Q02bFiltroSolicitudesNora filtroSolicitudesVO) throws Exception {    	    

	     	//se crean las objetos necesarios.

	     	int numReg = 0;

	     	ResultSet rs = null;       

	     	Q02bTablaBDQ022WS01V01 vistaQ022WV01 = null;	

	     	

	         try{

	         	if (tr.isTraceActive()){

	     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCountSolicitudesNora: entrando");

	     		}

	         	//se instancia la clase del tablas bd a llamar pasandole la conexion        	

	         	vistaQ022WV01 = new Q02bTablaBDQ022WS01V01(this.getConnection());

	         	//Rellenamos la where de la select

	         	this.rellenaFiltroSolicitudes(filtroSolicitudesVO, vistaQ022WV01);

	         	//se realiza la count

	         	rs = vistaQ022WV01.selectCount();       	

	         	vistaQ022WV01.addResultSet(rs);

	         	if (rs.next()){          		 

	         	 	 numReg =  rs.getInt(1);

	         	}

	         	return numReg;

	         }catch(Exception ex){

	             java.io.StringWriter sw = new java.io.StringWriter();

	             java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	             ex.printStackTrace(pw);

	             tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCountSolicitudesNora: " + sw.getBuffer ().toString());

	             throw ex;

	        }finally{

	     	   try{

	     		  vistaQ022WV01.freeResourcesNotConnection();	

	     	   }catch(Exception ex){

	 			   if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCountSolicitudesNora: error liberando recursos");

	 	   	   	   }  

	 		   }  		

	     	   if (tr.isTraceActive()){

	     		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCountSolicitudesNora: saliendo");                

	            }           

	        }      

	     }//fin getCountSolicitudesNora()

    

	    /**

	     * Mtodo que devuelve un arraylist de objetos solicitudNora resultado de la consulta a bbdd

	     * @return listaSolicitudes - ArrayList arraylist de objetos solicitudNora

	     * @throws Exception

	     */

       public ArrayList getSolicitudesNora(Q02bFiltroSolicitudesNora filtroSolicitudesVO) throws Exception {		

	 		//se instancian los objetos necesarios para realizar la consulta.			

	    	Q02bTablaBDQ022WS01V01 vistaQ022WSV01=null;

	 		ResultSet rs = null;

	 		ArrayList listaSolicitudes = new ArrayList();

	 		//Q02bSolicitudNora solicitudVO;

	 		

	 		try{

	 	    	if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getSolicitudesNora: entrando");

	 			}

	 	    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	

	 	    	vistaQ022WSV01 = new Q02bTablaBDQ022WS01V01(this.getConnection());

	 	    	

	 	    	//Rellenamos la where de la select

	         	this.rellenaFiltroSolicitudes(filtroSolicitudesVO, vistaQ022WSV01);

	        	//se realiza la select

	 	    	rs = vistaQ022WSV01.select();

	 	    	//aadimos el cursor para luego poder liberarlo (en el freeResources)

	 	    	vistaQ022WSV01.addResultSet(rs); 

	 	    	//se trata el resultado obtenido aadiendolo a la lista de salida

	 	    	listaSolicitudes = this.rellenaVOsSolicitudes(rs);

	 	    	

	 	    	return listaSolicitudes;    	

	 		}catch(Exception ex){ 	   

	     		java.io.StringWriter sw = new java.io.StringWriter();

	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	     		ex.printStackTrace(pw);

	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getSolicitudesNora: " + sw.getBuffer ().toString());

	     		throw ex;

	 		}finally{

	 		 	try{

	 		 		vistaQ022WSV01.freeResourcesNotConnection();	

	 			 }catch(Exception ex){

	 			    if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getSolicitudesNora: error liberando recursos.");

	 	   	   	    }  

	 			 }  		 			

	 			 if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getSolicitudesNora: saliendo.");                

	 	         }   

	 		}	

	 	}

       

       

       /**

	     * Mtodo que devuelve un objeto solicitud resultado de la consulta a bbdd

	     * @param  idSolicitud - String nmero interno de la solicitud

	     * @return solicitudVO - Q02bSolicitudNora Valueobject de solicitud con los datos de la solicitud obtenida

	     * @throws Exception

	     */

       	public Q02bSolicitudNora getSolicitudNora(String idSolicitud) throws Exception {		

	 		//se instancian los objetos necesarios para realizar la consulta.			

	    	Q02bTablaBDQ022WS01V01 vistaQ022WSV01=null;

	    	//Q02bTablaBDQ022ES00 tablaSM = null;

	    	//Q02bTablaBDQ022DS00 tablaVTM = null;

	 		ResultSet rs = null;

	 		//ResultSet rs2 = null;

	 		Q02bSolicitudNora solicitudVO=null;

	 		

	 		try{

	 	    	if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getSolicitud: entrando");

	 			}

	 	    	//se instancia la clase del tablas bd a llamar pasandole la conexion

	 	    	//se realiza la select

	 	    	vistaQ022WSV01 = new Q02bTablaBDQ022WS01V01(this.getConnection());

	 	    	vistaQ022WSV01.setQ022WT00_NI_WHERE(Integer.parseInt(idSolicitud));

	 	    	rs = vistaQ022WSV01.select();

	 	    	//aadimos el cursos para luego poder liberarlo ( en el freeResources)

	 	    	vistaQ022WSV01.addResultSet(rs); 

	 	    	//se trata el resultado obtenido 

	 	    	solicitudVO= new Q02bSolicitudNora();

	 	    	if(rs.next()){

	 	    		this.rellenarVOSolicitud(solicitudVO, rs);

	 	    	}

	 	    	return solicitudVO;    	

	 		}catch(Exception ex){ 	   

	     		java.io.StringWriter sw = new java.io.StringWriter();

	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	     		ex.printStackTrace(pw);

	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getSolicitud: " + sw.getBuffer ().toString());

	     		throw ex;

	 		}finally{

	 		 	try{

	 		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

	 		 		vistaQ022WSV01.freeResourcesNotConnection();	

	 			 }catch(Exception ex){

	 			    if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getSolicitud: error liberando recursos.");

	 	   	   	    }  

	 			 }  		 			

	 			 if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getSolicitud: saliendo.");                

	 	         }   

	 		}	

	 	}

       	

   	/**

      * Mtodo que rellena el tablasBD con los datos del filtro de objeto que contiene

      * los criterios de bsqueda introducidos por el usuario

      * 

      * @param filtroSolicitudesVO - Q02bFiltroSolicitudesNora Objeto con los criterios introducidos por el usuario

      * @param tablaBD

      * 

      * @throws Exception

      */

	    public void rellenaFiltroSolicitudes(Q02bFiltroSolicitudesNora filtroSolicitudesVO, Q02bTablaBDQ022WS01V01 vistaQ022WV01)throws Exception

	    {

	     //Definicin de variables que no se van a modificar

	     final String TRACE_METODO = ":rellenaFiltroSolicitudes:";

	     StringBuffer additionalWhere=null;

	    	try{

	    		if (tr.isTraceActive()){

			        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando");                

	    		} 

	    		if(filtroSolicitudesVO!=null){

		    		//Estado

	    			if(!Q02bFormatData.esNull(filtroSolicitudesVO.getCodEstado()).equals("")){

	    				vistaQ022WV01.setQ022WT00_ESTADO_WHERE(filtroSolicitudesVO.getCodEstado());

	    			}

	    			

	    			additionalWhere = new StringBuffer();

	    			//Direccion

		    		if(!Q02bFormatData.esNull(filtroSolicitudesVO.getDireccion()).equals("")){

		    			additionalWhere.append(" AND TRANSLATE(UPPER(Q022WT00_DIRECCIN),'','AEIOUAEIOU') like '%' || ");

		    			additionalWhere.append("TRANSLATE(UPPER('").append(filtroSolicitudesVO.getDireccion()).append("'),'','AEIOUAEIOU') || '%'");

		    		}

		    		//Ao, mes, provincia, municipio

		    		//Tenemos un campo en la BBD (DATOS_CUESTIONARIO) de la forma: ao;mes;codProvincia;codMunicipio;descProvincia;descMunicipio;codEntidad;localidad

		    		//Por ej: 2009;3;48;911;Bizkaia;Ajangiz

		    		if(!Q02bFormatData.esNull(filtroSolicitudesVO.getAnyo()).equals("")){

		    			additionalWhere.append(" AND SUBSTR(DATOS_CUESTIONARIO,0,4)='").append(filtroSolicitudesVO.getAnyo()).append("'");

		    		}

		    		if(!Q02bFormatData.esNull(filtroSolicitudesVO.getMes()).equals("")){

		    			additionalWhere.append(" AND SUBSTR(DATOS_CUESTIONARIO,6,2)='").append(filtroSolicitudesVO.getMes()).append("'");

		    		}

		    		if(!Q02bFormatData.esNull(filtroSolicitudesVO.getCodProv()).equals("")){

		    			additionalWhere.append(" AND SUBSTR(DATOS_CUESTIONARIO,9,2)='").append(filtroSolicitudesVO.getCodProv()).append("'");

		    		}

		    		if(!Q02bFormatData.esNull(filtroSolicitudesVO.getCodMuni()).equals("")){

		    			additionalWhere.append(" AND SUBSTR(DATOS_CUESTIONARIO,12,3)='").append(filtroSolicitudesVO.getCodMuni()).append("'");

		    		}

		    		

		    		if(additionalWhere!=null && !additionalWhere.toString().equals("")){

		    			vistaQ022WV01.setAditionalWhere(additionalWhere.toString());
                    }
		    	}

	    		vistaQ022WV01.setOrderBy(" Q022WT00_FECHA_GRABACION ASC");

	       	}	    	

	    	catch(Exception ex){    	 	   

		       java.io.StringWriter sw = new java.io.StringWriter();

		       java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

		       ex.printStackTrace(pw);

		       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() 		+ TRACE_METODO + sw.getBuffer ().toString());

		       throw ex;

		}finally

		{			 	

			if (tr.isTraceActive())

			{

			        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() 	+ TRACE_METODO + " saliendo");                

			 }    				

		}

	    }//fin rellenaFiltroUsuarios()

	   

	    /**

	     * Mtodo que devuelve un arraylist de objetos solicitud resultado de la consulta a bbdd

	     * @param rs - ResultSet Resultado de la consulta a bbdd

	     * @return listaSolicitudes - ArrayList arraylist de objetos solicitud

	     * @throws Exception

	     */

	    private ArrayList rellenaVOsSolicitudes (ResultSet rs) throws Exception{

	     	Q02bSolicitudNora solicitudVO;

	     	ArrayList listaSolicitudes = new ArrayList();

	     	try{

	     		if (tr.isTraceActive()){

	 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsSolicitudes: entrando");                

	 		    } 

	     		while (rs.next()){	 

	 	        	//se cargan en el objeto usuario los datos recuperados

	     			solicitudVO = new Q02bSolicitudNora();

	     			rellenarVOSolicitud(solicitudVO,rs);

	     			listaSolicitudes.add(solicitudVO);

	   			}  	  

	     		return listaSolicitudes;

	     	}catch(Exception ex){    	 	   

	  	       java.io.StringWriter sw = new java.io.StringWriter();

	  	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	  	       ex.printStackTrace(pw);

	  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaVOsSolicitudes: " + sw.getBuffer ().toString());

	  	       throw ex;

	  		}finally{			 	

	  			if (tr.isTraceActive()){

	  		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsSolicitudes: saliendo");                

	  		    }    				

	  		}

	     } 

    

	    /**

	     * Mtodo que informa un valueobject de solicitud con los datos de las solicitudes obtenidas de la tabla de usuarios

	     * @param solicitudVO - Q02bSolicitudNora valueobject de solicitud que se va a informar

	     * @param rs - ResultSet Resultado de la consulta a bbdd

	     * @throws Exception

	     */

        private void rellenarVOSolicitud (Q02bSolicitudNora solicitudVO, ResultSet rs) throws Exception

	    {

	     	try{

			   	tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":rellenarVOSolicitud: Hay Datos");            

			   	

			   	String columnaDescEstado=null;

			   	String columnaTipoCuestionario=null;

			   	if(idioma.equals(Q02bConstantes.getString("idioma.es"))){

			   		columnaDescEstado ="Q022YT00_DESC";

			   		columnaTipoCuestionario="Q022NT00_DESC_ES";

			   	}

			   	else{

			   		columnaDescEstado ="Q022YT00_DESC_EUS";

			   		columnaTipoCuestionario="Q022NT00_DESC_EU";

			   	}

			   		

			   	solicitudVO.setNiSolicitud(rs.getString(Q02bTablaBDQ022WS01V01.NOMCOLUMN_Q022WT00_NI));

			   	solicitudVO.setCodigo(rs.getString(Q02bTablaBDQ022WS01V01.NOMCOLUMN_Q022NT00_CODIGO));

		

			   	String datosCuestionario = rs.getString(Q02bTablaBDQ022WS01V01.NOMCOLUMN_DATOS_CUESTIONARIO);

			   	if(datosCuestionario!=null){

			   		String[] aDatos = datosCuestionario.split(";"); 

			   		solicitudVO.setAnyo(aDatos[0]);

			   		solicitudVO.setMes(aDatos[1]);

			   		solicitudVO.setCodProv(aDatos[2]);

			   		solicitudVO.setDescProv(aDatos[4]);

			   		solicitudVO.setCodMuni(aDatos[3]);

			   		solicitudVO.setDescMuni(aDatos[5]);

			   		solicitudVO.setCodEntidad(aDatos[6]);

			   		solicitudVO.setLocalidad(aDatos[7]);

			   	

			   	}

			   	solicitudVO.setDireccion(rs.getString(Q02bTablaBDQ022WS01V01.NOMCOLUMN_Q022WT00_DIRECCIN));

			   	if(rs.getString(Q02bTablaBDQ022WS01V01.NOMCOLUMN_Q022WT00_FECHA_GRABACION)!=null){

			   		solicitudVO.setFechaGrabacion(new java.text.SimpleDateFormat("dd/MM/yyyy").format(rs.getDate(Q02bTablaBDQ022WS01V01.NOMCOLUMN_Q022WT00_FECHA_GRABACION)));
                }
			   	solicitudVO.setCodEstado(rs.getString(Q02bTablaBDQ022WS01V01.NOMCOLUMN_Q022WT00_ESTADO));

			   	solicitudVO.setDescEstado(rs.getString(columnaDescEstado));

			   	solicitudVO.setTipoCuestionario(rs.getString(columnaTipoCuestionario));

			   	solicitudVO.setObservaciones(rs.getString(Q02bTablaBDQ022WS01V01.NOMCOLUMN_Q022WT00_OBSERVACIONES));

			   	solicitudVO.setNiCuestionario(rs.getString(Q02bTablaBDQ022WS01V01.NOMCOLUMN_Q022WT00_ID_CUES));

			   	solicitudVO.setNiGrupoCuestionario(rs.getString(Q02bTablaBDQ022WS01V01.NOMCOLUMN_Q022WT00_ID_GRUPO));

			   	solicitudVO.setLocalizacion(rs.getString(Q02bTablaBDQ022WS01V01.NOMCOLUMN_LOCALIZACION));

	     	}

			catch (Exception e) {

			    if (tr.isTraceActive()){

			   	   	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenarVOSolicitud: error "+ e.getMessage());

				}  

		    }  	

	    }

    

    	/**

	     * Mtodo que modifica en la bbd la solicitud seleccionado en pantalla

	     * @param solicitudVO - Q02bSolicitudNora valueobject de solicitud con los datos de la solicitud

	     * @throws Exception

	     */

        public void modificarSolicitudNora(Q02bSolicitudNora solicitudVO) throws Exception {		

	 		

	    	Q02bTablaBDQ022WS00 tablaQ022WT00=null;

	    	//int idSolicitud = 0;

	 		try{

	 			if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarSolicitudNora: entrando");

	 			}

	 	    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	

	 			tablaQ022WT00 = new Q02bTablaBDQ022WS00(this.getConnection());

	 	    

	 			tablaQ022WT00.setQ022WT00_ESTADO(solicitudVO.getCodEstado());

	 			tablaQ022WT00.setQ022WT00_OBSERVACIONES(solicitudVO.getObservaciones());

	 			tablaQ022WT00.setQ022WT00_NI_WHERE(Integer.parseInt(solicitudVO.getNiSolicitud()));

	 			tablaQ022WT00.update();

	 	    

	 	  }catch(Exception ex){ 	   

	     		java.io.StringWriter sw = new java.io.StringWriter();

	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	     		ex.printStackTrace(pw);

	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarSolicitudNora: " + sw.getBuffer ().toString());

	     		throw ex;

	 		}finally{

	 		 	try{

	 		 		tablaQ022WT00.freeResourcesNotConnection();	

	 			 }catch(Exception ex){

	 			    if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarSolicitudNora: error liberando recursos.");

	 	   	   	    }  

	 			 }  		 			

	 			 if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarSolicitudNora: saliendo.");                

	 	         }   

	 		}	

	 	}

        

        /**

	     * Mtodo que devuelve el nmero de solicitude de alta en Nora en estado Pendiente

	     * @return numSolicitudes - int nmero de solicitudes en estado pendiente

	     * @throws Exception

	     */

	    public int getNumSolicitudesPdtes() throws Exception {    	    

	     	//se crean las objetos necesarios.

	     	int numSolicitudes = 0;

	     	ResultSet rs = null;       

	     	Q02bTablaBDQ022WS00 tablaQ022WS00 = null;	

	     	

	         try{

	         	if (tr.isTraceActive()){

	     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumSolicitudesPdtes: entrando");

	     		}

	         	String estadoPdte = Q02bConstantes.getString("solNora.estado.pdte");

	         	//se instancia la clase del tablas bd a llamar pasandole la conexion        	

	         	tablaQ022WS00 = new Q02bTablaBDQ022WS00(this.getConnection());

	         	tablaQ022WS00.setQ022WT00_ESTADO_WHERE(estadoPdte);

	         	//se realiza la count

	         	rs = tablaQ022WS00.selectCount();       	

	         	tablaQ022WS00.addResultSet(rs);

	         	if (rs.next()){          		 

	         	 	 numSolicitudes =  rs.getInt(1);

	         	}

	         	return numSolicitudes;

	         }catch(Exception ex){

	             java.io.StringWriter sw = new java.io.StringWriter();

	             java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	             ex.printStackTrace(pw);

	             tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumSolicitudesPdtes: " + sw.getBuffer ().toString());

	             throw ex;

	        }finally{

	     	   try{

	     		  tablaQ022WS00.freeResourcesNotConnection();	

	     	   }catch(Exception ex){

	 			   if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumSolicitudesPdtes: error liberando recursos");

	 	   	   	   }  

	 		   }  		

	     	   if (tr.isTraceActive()){

	     		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumSolicitudesPdtes: saliendo");                

	            }           

	        }      

	     }//fin getNumSolicitudesPdtes()

        

}



