package q02b.exe.solicitudesNora.beans;



import java.util.ArrayList;

import java.util.HashMap;



import q02b.exe.arquitectura.beans.Q02bBaseBean;

import q02b.exe.solicitudesNora.dataobjects.Q02bSolicitudesNoraDataBaseDAO;

import q02b.exe.solicitudesNora.valueobjects.Q02bFiltroSolicitudesNora;

import q02b.exe.solicitudesNora.valueobjects.Q02bSolicitudNora;

import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;



public class Q02bSolicitudesNoraBean extends Q02bBaseBean{

	

	private static final long serialVersionUID = 5474311672836163390L;

	protected Q02bSolicitudesNoraDataBaseDAO daoSolicitudes = null;



	

	 /** Constructor vacio */

    public Q02bSolicitudesNoraBean() {

        super();

    }

    

    

    /**

     * Funcin que recupera las solicitudes de alta en NORA

     * 

     * @return listaSolicitudes  -  Listado de solicitudes obtenidos

     * @throws Exception

     */

	public ArrayList getSolicitudesNora(HashMap mapaFiltroSolicitudes) throws Exception 

	{

		Q02bFiltroSolicitudesNora filtroSolicitudesVO = null;

		

		//String noRegRecuperados = "NoHaySolicitudes";

		ArrayList listaUsuarios = new ArrayList();

		int numSolicitudes = 0;

		boolean error = false;

		//boolean obtenerListado=false;

		

		try{

			 if (tr.isTraceActive()){

		   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getSolicitudesNora: entrando.");

		   	}  	  

			

			//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoSolicitudes = new Q02bSolicitudesNoraDataBaseDAO(this.getConn());

			daoSolicitudes.setIdioma(this.getAutenticador().getIdioma());

			

			//Pasamos del hashMap recibido al valueObject

			filtroSolicitudesVO = (Q02bFiltroSolicitudesNora) Q02bVoUtils.getValueObject(mapaFiltroSolicitudes,"q02b.exe.solicitudesNora.valueobjects.Q02bFiltroSolicitudesNora");

			

			//se llamamara al dao para obtener el nmero de solicitudes

			numSolicitudes = daoSolicitudes.getCountSolicitudesNora(filtroSolicitudesVO);

			if(numSolicitudes>0){

				listaUsuarios = daoSolicitudes.getSolicitudesNora(filtroSolicitudesVO);

	     	}

	        return listaUsuarios;              

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getSolicitudesNora: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoSolicitudes.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getSolicitudesNora: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getSolicitudesNora: saliendo.");

	   		}

 	  	}

 	  } //fin getSolicitudesNora 

	

	/**

     * Mtodo que llama a un DAO para obtener un objeto Q02bSolicitudNora con los datos para la modificacion.

     * @param idSolicitud nmero interno de la solicitud en bbdd.

     * @return Objeto Q02bSolicitudNora con los datos de la solicitud de alta en NORA

     * @throws Exception

     */

	

	public Q02bSolicitudNora obtenerSolicitudNoraModificacion(String idSolicitud) throws Exception{

    	boolean error = false;

    	Q02bSolicitudNora solicitud = null;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerSolicitudNoraModificacion: entrando");

      		}

    		solicitud = new Q02bSolicitudNora();

    		

			abrirConexion();			

			daoSolicitudes = new Q02bSolicitudesNoraDataBaseDAO(this.getConn());

            //Pasamos los perfiles del usuario e idioma

			daoSolicitudes.setUser(this.autenticador.getUser());

			daoSolicitudes.setIdioma(this.autenticador.getIdioma());

			

			solicitud = daoSolicitudes.getSolicitudNora(idSolicitud);

			

			return solicitud;

    	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerSolicitudNoraModificacion: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

    		try{

    			daoSolicitudes.freeResourcesNotConnection();

    		}catch(Exception ex){

    		   if (tr.isTraceActive()){

    			   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerSolicitudNoraModificacion: error liberando recursos");

    		   }  

    		}  		 

    	 	//se cierra la conexin  

    	 	cerrarConexion(error);	       	

    		if (tr.isTraceActive()){

    			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerSolicitudNoraModificacion saliendo.");

    		}

    	 }

    }

	

	/**

     * Mtodo que llama a un DAO para obtener un objeto Q02bSolicitudNora con los datos para la consulta.

     * @param idSolicitud nmero interno de la solicitud en bbdd.

     * @return Objeto Q02bSolicitudNora con los datos de la solicitud de alta en NORA

     * @throws Exception

     */

    public Q02bSolicitudNora obtenerSolicitudNoraConsulta (String idSolicitud) throws Exception {		 	 

		//Definicin de variables que no se van a modificar

		final String 	TRACE_METODO 	= ":obtenerSolicitudNoraConsulta:";

		//Definicin de dems variables

		Q02bSolicitudNora solicitud = null; 

		boolean	error = false;

		

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando.");

	   		}  

			solicitud = new Q02bSolicitudNora();

			//Se abre la conexin

			abrirConexion();

			//Se instancia el dao pasandole la conexin			

			daoSolicitudes = new Q02bSolicitudesNoraDataBaseDAO(this.getConn());

			//Se pasan los parmetros de usuario e idioma

			daoSolicitudes.setUser(this.autenticador.getUser());

			daoSolicitudes.setIdioma(this.autenticador.getIdioma());

						

			solicitud = daoSolicitudes.getSolicitudNora(idSolicitud);		

          

			return solicitud;              

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter 	sw = new java.io.StringWriter();

          java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoSolicitudes.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + " error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO  + " saliendo.");

	   		}

 	  	}

 	  }

	

	

	/**

     * Funcin que modifica una solicitud de la bbdd

     * 

     * @param solicitudNoraVO - Q02bSolicitudNora valueobject solicitud con los datos de la solicitud de alta en NORA

     * @throws Exception

     */

	public void modificarSolicitudNora(Q02bSolicitudNora solicitudNoraVO) throws Exception 

	{

		boolean error = false;

		

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarSolicitudNora: entrando.");

			}  	  

			//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoSolicitudes = new Q02bSolicitudesNoraDataBaseDAO(this.getConn());

			daoSolicitudes.setIdioma(this.getAutenticador().getIdioma());

			//se llamamara al dao para modificar el usuario

			daoSolicitudes.modificarSolicitudNora(solicitudNoraVO);

	      

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarSolicitudNora: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoSolicitudes.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarSolicitudNora: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarSolicitudNora: saliendo.");

	   		}

 	  	}

 	  } //fin modificarSolicitudNora 

	

	

	/**

     * Funcin que recupera el nmero de solicitudes en estado Pendiente

     * 

     * @return numSolicitudes  -  int numero de solicitudes pendientes

     * @throws Exception

     */

	public int getNumSolicitudesPdtes() throws Exception 

	{

		int numSolicitudes = 0;

		boolean error = false;

		

		try{

			 if (tr.isTraceActive()){

		   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumSolicitudesPdtes: entrando.");

		   	}  	  

			

			//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoSolicitudes = new Q02bSolicitudesNoraDataBaseDAO(this.getConn());

			//se llamamara al dao para obtener el nmero de solicitudes

			numSolicitudes = daoSolicitudes.getNumSolicitudesPdtes();

	        return numSolicitudes;              

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumSolicitudesPdtes: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoSolicitudes.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumSolicitudesPdtes: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumSolicitudesPdtes: saliendo con " + numSolicitudes+ " solicitudes");

	   		}

 	  	}

 	  } //fin getNumSolicitudesPdtes 

	

}

