package q02b.exe.resultados.beans;



import java.util.ArrayList;

//import java.util.HashMap;



import q02b.exe.arquitectura.beans.Q02bBaseBean;



//import q02b.exe.oficinasMunicipales.dataobjects.Q02bOficinasMunicipalesDataBaseDAO;

//import q02b.exe.oficinasMunicipales.valueobjects.Q02bOficinasMunicipales;

//import q02b.exe.plazos.dataobjects.Q02bPlazosDataBaseDAO;

//import q02b.exe.plazos.valueobjects.Q02bPlazos;

import q02b.exe.resultados.dataobjects.Q02bResultadosDataBaseDAO;

import q02b.exe.resultados.valueobjects.Q02bResultados;

//import q02b.exe.utils.Q02bConstantes;

//import q02b.exe.utils.Q02bFormatData;

//import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

//import q02b.exe.arquitectura.utils.xml.Q02bXMLBuilder;

//import org.w3c.dom.Document;

//import org.w3c.dom.Element;

//import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;



   

public class Q02bResultadosBean extends Q02bBaseBean{

	private static final long serialVersionUID = 5474311672836163390L;

	protected Q02bResultadosDataBaseDAO daoResultados = null;

	final static String	RESULTADO = "resultado";

	

	 /** Constructor vacio */

    public Q02bResultadosBean() {

        super();

    }

        

//  -------------------- INI - OBTENER LISTA

    /**

     * M?todo que se invoca desde un EJB para obtener un ArrayList de objetos

     * en funci?n de los par?metros del filtro

     * @param filtro - Q02bResultados

     * @return  - ArrayList de objetos - Q02bResultadosLista

     * @throws Exception

     * @see Q02bResultados

     * @see Q02bResultadosLista

     * @generated

     */

    public ArrayList obtenerListaResultados(Q02bResultados filtro)

        throws Exception {

        //Definici?n de constantes

        final String TRACE_METODO = nombreClaseSinPackage +

            ":obtenerListaResultados";

        //final String NUM_MAX_REG = "q02b.dma.cnae2009.num_max_reg";

        //final String IDIOMA_EU = "IDIOMA_EU";



        //Definici?n de variables

        //int numReg = 0;

        //int numMax = 0;

        ArrayList lista = new ArrayList();

        boolean error = false;



        // Variables de negocio

        Q02bResultadosDataBaseDAO dao = null;



        if (tr.isTraceActive()) {

            tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +

                ": entrando");

        }



        try {

            //Se abre la conexi?n

            abrirConexion();

            //Se instancia el dao pasandole la conexi?n			

            dao = new Q02bResultadosDataBaseDAO(this.getConn());

            //Se pasan los par?metros de usuario e idioma

            dao.setUser(this.autenticador.getUser());

            dao.setIdioma(this.autenticador.getIdioma());

            

            lista = dao.obtenerListaResultados(filtro);        

   



            //Se devuelve la lista

            return lista;

        } catch (Exception ex) {

            error = true;



            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

                TRACE_METODO + ": " + sw.getBuffer().toString());

            throw ex;

        } finally {

            try {

                dao.freeResourcesNotConnection();

            } catch (Exception ex) {

                if (tr.isTraceActive()) {

                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

                        TRACE_METODO + ": error liberando recursos");

                }

            }



            //se cierra la conexi?n  

            cerrarConexion(error);



            if (tr.isTraceActive()) {

                tr.trace(COMPONENTE, Q70TraceLevel.INFO,

                    TRACE_METODO + ": saliendo");

            }

        }

    }



    // -------------------- FIN - OBTENER LISTA

    

    /**

     * Funcin que inserta los datos del resultado pasada como parmetro en la BBDD

     * @param resultado - Datos del resultado a insertar

     * @throws Exception

     */

      public void insertarResultados(Q02bResultados resultado) throws Exception {   	 

    	boolean error = false;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarResultados: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			

			//se instancia el dao pasandole la conexin			

			daoResultados = new Q02bResultadosDataBaseDAO(this.getConn());

			

			//se pasan los parmetros de usuario e idioma

			//daoPlazos.setUser(this.autenticador.getUser());

			//daoPlazos.setIdioma(this.autenticador.getIdioma());

			

			//se llama la metodo del DAO que realiza la insert

			daoResultados.insertarResultados(resultado);

    	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarResultados: " + sw.getBuffer ().toString());

	        throw ex;                     

 	  }finally{

 		    try{

 		    	daoResultados.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarResultados: error liberando recursos");

	   	   	   }  

 		    }  		 

 		  	//se cierra la conexin  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarResultados: saliendo.");

	   		}

 	  }

    }//fin insertarResultados

      

      /**

       * Mtodo que dado el nmero interno del resultado 

       * recupera de la BBDD los datos de dicho cuestionario.

       * @param idResul

       * @return resultado

       */

  	public Q02bResultados obtenerResultado(String idResul)throws Exception{  	 

  	    	boolean error = false;

  	    	Q02bResultados resultado = null;

  	  	  	try  	  {

  	  	  		if (tr.isTraceActive()){

  	  	  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerResultado, ** idResul bean=" + idResul + " *** entrando");                

  	  	  		}

  	  	  		

  	  	  		//se abre la conexin

  	  	  		abrirConexion();

  	  	  		

  	  	  		//se instancia el dao pasandole la conexin			

  	  	  		daoResultados = new Q02bResultadosDataBaseDAO(this.getConn());

  	  	  		

  	  	  		//Segmento tecnico 

  	  			//daoPlazos.setUser(this.getAutenticador().getUser());

  	  			//daoPlazos.setIdioma(this.getAutenticador().getIdioma());

  	  			

  	  	  		//se llama al mtodo del dao que recupera el plazo

  	  	  		resultado = daoResultados.obtenerResultado(idResul);

  	  	  		

  	  	  		//se devuelve el cuestionario recuperado

  	  	  		return resultado;

  	  	  }catch(Exception ex){

  	  		  	error= true;

  	  		  	java.io.StringWriter sw = new java.io.StringWriter();

  	          	java.io.PrintWriter pw = new java.io.PrintWriter(sw);

  	          	ex.printStackTrace(pw);

  	          	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerResultado: " + sw.getBuffer ().toString());

  	          	throw ex;                     

  	 	  }finally{

  	 		  	try{

  	 		  	daoResultados.freeResourcesNotConnection();

  	 		  	}catch(Exception ex){

  				   if (tr.isTraceActive()){

  					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerResultado: error liberando recursos");

  		   	   	   }  

  	 		  	}  		 

  	 		  	//se cierra la conexin  

  	 		  	cerrarConexion(error);	       	

  		        if (tr.isTraceActive()){

  		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerResultado: saliendo.");

  		   		}

  	 	  }

  	    }//fin obtenerResultado

  	

  	/**

     * Funcin que modifica los datos del cuestionario pasado como parmetro en la BBDD

     * @param resultado - Datos del cuestionario a modificar 

     * @throws Exception

     */

    public void modificarResultados(Q02bResultados resultado) throws Exception {

   	 if (tr.isTraceActive()){

  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarResultados: entrando");

  		}

   	 boolean error = false;

   	try{

   		//se abre la conexin

   		abrirConexion();

   		//se instancia el dao pasandole la conexin			

   		daoResultados = new Q02bResultadosDataBaseDAO(this.getConn());

		

   		//Segmento tecnico 

		//daoPlazos.setUser(this.getAutenticador().getUser());

   		//daoPlazos.setIdioma(this.getAutenticador().getIdioma()); 



   		//se llamaa la metodo del DAO que realiza la update

   		daoResultados.modificarResultados(resultado);

   		    	

   	}catch(Exception ex){

		 error= true;

         java.io.StringWriter sw = new java.io.StringWriter();

         java.io.PrintWriter pw = new java.io.PrintWriter(sw);

         ex.printStackTrace(pw);

         tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarResultados: " + sw.getBuffer ().toString());

         throw ex;                     

	  }finally{

		 try{

			 daoResultados.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarResultados: error liberando recursos");

	   	   	   }  

		   }  		 

		  	//se cierra la conexin  

		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarResultados: saliendo.");

	   		}

	  }

   }//modificarResultados

     

   

    /**

     * Funcin que borra el resultado pasado como parmetro de la BBDD 

     * @param idResul - nmero interno del resultado a borrar

     * @throws Exception

     */

  public void borrarResultado(String idResul) throws Exception { 

  		if (tr.isTraceActive()){

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarResultado: entrando");

  		}

  		boolean error = false;

  		try{

  			//se abre la conexin

  			abrirConexion();

 			

  			//se instancia el dao pasandole la conexin			

  			daoResultados = new Q02bResultadosDataBaseDAO(this.getConn());

			  			 



  			daoResultados.borrarResultado(idResul);   		 	  

  		}catch(Exception ex){

  			error= true;

  			java.io.StringWriter sw = new java.io.StringWriter();

  			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

  			ex.printStackTrace(pw);

  			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarResultado: " + sw.getBuffer ().toString());

  			throw ex;           

	  

  		}finally{

  			try{

  				daoResultados.freeResourcesNotConnection();

  			}catch(Exception ex){

  				if (tr.isTraceActive()){

  					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarResultado: error liberando recursos");

	   	   	   		}  

  			}  		 

 		  		//se cierra la conexin  

 		  		cerrarConexion(error);	       	

 		  		if (tr.isTraceActive()){

 		  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarResultado: saliendo.");

 		  		}

  		}

  }//fin borrarResultado

    

}



		





