package q02b.exe.reports.beans;



import java.io.ByteArrayOutputStream;



import q02b.exe.arquitectura.beans.Q02bBaseBean;

import q02b.exe.reports.dataobjects.Q02bInformesDataBaseDAO;

import q02b.exe.reports.valueobjects.Q02bColumnas;

import q02b.exe.reports.valueobjects.Q02bParametrizacion;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;





/** 

 * Q02bInformesBean es un Bean que gestiona el acceso 

 * al DAO de Informes.

 */

public class Q02bInformesBean extends Q02bBaseBean {

	

	private static final long serialVersionUID = -4018422300357977737L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	protected Q02bInformesDataBaseDAO dao = null;

	

	/**

	 * Constructor

	 */

	public Q02bInformesBean() {

		super();                

	}

	

	

	/**

	 * Metodo que se invoca para obtener los datos de parametrizacion relativos 

	 * a un Informe

	 * @param String - niParametrizacion

	 * @return ValueObject de Q02bParametrizacion

	 * @throws Exception

	 */

	public Q02bParametrizacion obtenerParametrizacion(String niParametrizacion) throws Exception {

		final String TRACE_METODO 	= "Q02bInformesBean:obtenerParametrizacion";

		Q02bParametrizacion param 	= null;

		boolean error 				= false;

		

		if (tr.isTraceActive()){

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": entrando");

		}

		try {

			//Se abre la conexion

			abrirConexion();

			//Se instancia el dao pasandole la conexion			

			dao = new Q02bInformesDataBaseDAO(this.getConn());

			//Se pasan los parametros de usuario e idioma

			dao.setUser(this.autenticador.getUser()); 

			dao.setIdioma(this.autenticador.getIdioma());

			//Se llama al dao para obtener los valores de parametrizacin del Informe 

			param = dao.obtenerParametrizacion(niParametrizacion);

			

			return param;

		} catch(Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, TRACE_METODO + ": " + sw.getBuffer ().toString());

			throw ex;

		} finally {

			try {

				dao.freeResourcesNotConnection();	

			} catch(Exception ex) {

				if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, TRACE_METODO + ": error liberando recursos");

				}  

			}  		

			//se cierra la conexin  

			cerrarConexion(error);	 

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": saliendo");                

			}   

		}

	}

	

		

	public Q02bColumnas obtenerColumnasTabla(String nombreTabla) throws Exception {

		final String TRACE_METODO 	= "Q02bInformesBean:obtenerColumnasTabla";

		boolean error 				= false;

		Q02bColumnas columnas  		= null;

		

		if (tr.isTraceActive()){

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": entrando");

		}

		try {

			//Se abre la conexion

			abrirConexion();

			//Se instancia el dao pasandole la conexion			

			dao = new Q02bInformesDataBaseDAO(this.getConn());

			//Se pasan los parametros de usuario e idioma

			dao.setUser(this.autenticador.getUser());

			dao.setIdioma(this.autenticador.getIdioma());

			//Se llama al dao para obtener los valores de parametrizacin del Informe 

			columnas = dao.obtenerColumnasTabla(nombreTabla);

			

			return columnas;

		} catch(Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, TRACE_METODO + ": " + sw.getBuffer ().toString());

			throw ex;

		} finally {

			try {

				dao.freeResourcesNotConnection();	

			} catch(Exception ex) {

				if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, TRACE_METODO + ": error liberando recursos");

				}  

			}  		

			//se cierra la conexin  

			cerrarConexion(error);	 

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": saliendo");                

			}   

		}

	}

	

	

	/**

	 * Metodo que se invoca para obtener los datos de un Informe

	 * @param Q02bParametrizacion - datos de parametrizacion del informe

	 * @return ByteArrayOutputStream

	 * @throws Exception

	 */

	public ByteArrayOutputStream obtenerDatosInforme(Q02bParametrizacion parametrizacion, Q02bColumnas columnas) throws Exception {

		final String TRACE_METODO 		= "Q02bInformesBean:obtenerDatosInforme";

		boolean error 					= false;

		ByteArrayOutputStream outStr	= null;

		

		if (tr.isTraceActive()){

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": entrando");

		}

		try {

			//Se abre la conexion

			abrirConexion();

			//Se instancia el dao pasandole la conexion			

			dao = new Q02bInformesDataBaseDAO(this.getConn());

			//Se pasan los parametros de usuario e idioma

			dao.setUser(this.autenticador.getUser());

			dao.setIdioma(this.autenticador.getIdioma());

			//Se llama al dao para obtener los valores de parametrizacin del Informe 

			outStr = dao.obtenerDatosInforme(parametrizacion, columnas);

			

			return outStr;

		} catch(Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, TRACE_METODO + ": " + sw.getBuffer ().toString());

			throw ex;

		} finally {

			try {

				dao.freeResourcesNotConnection();	

			} catch(Exception ex) {

				if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, TRACE_METODO + ": error liberando recursos");

				}  

			}  		

			//se cierra la conexin  

			cerrarConexion(error);	 

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": saliendo");                

			}   

		}

	}



	/**

	 * Metodo que se invoca para obtener los datos de un Informe de texto plano

	 * @param Q02bParametrizacion - datos de parametrizacion del informe

	 * @return ByteArrayOutputStream

	 * @throws Exception

	 */

	public String obtenerDatosTextoPlano(Q02bParametrizacion parametrizacion, Q02bColumnas columnas) throws Exception {

		final String TRACE_METODO 		= "Q02bInformesBean: obtenerDatosTextoPlano";

		boolean error 					= false;

		String str	= null;

		

		if (tr.isTraceActive()){

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": entrando");

		}

		try {

			//Se abre la conexion

			abrirConexion();

			//Se instancia el dao pasandole la conexion			

			dao = new Q02bInformesDataBaseDAO(this.getConn());

			//Se pasan los parametros de usuario e idioma

			dao.setUser(this.autenticador.getUser());

			dao.setIdioma(this.autenticador.getIdioma());

			//Se llama al dao para obtener los valores de parametrizacin del Informe 

			str = dao.obtenerDatosTextoPlano(parametrizacion, columnas);

			

			return str;

		} catch(Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, TRACE_METODO + ": " + sw.getBuffer ().toString());

			throw ex;

		} finally {

			try {

				dao.freeResourcesNotConnection();	

			} catch(Exception ex) {

				if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, TRACE_METODO + ": error liberando recursos");

				}  

			}  		

			//se cierra la conexin  

			cerrarConexion(error);	 

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": saliendo");                

			}   

		}

	}





	/**

	 * Metodo que se invoca para generar un informe generico

	 * @param String - niParametrizacion, datos de parametrizacion del informe

	 * @return ByteArrayOutputStream

	 * @throws Exception

	 */

	public ByteArrayOutputStream generarInformeGenerico(String niParametrizacion, String addWhere) throws Exception{

		final String TRACE_METODO 			= "Q02bInformesBean:generarInformeGenerico";

		Q02bParametrizacion parametrizacion = null;

		Q02bColumnas columnas 				= null;

		ByteArrayOutputStream outStr		= null;

		

		if (tr.isTraceActive()){

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": entrando");

		}

		try {

			//Metodos que componen los datos del informe

			parametrizacion = obtenerParametrizacion(niParametrizacion);

			//Aadimos la additional where

			parametrizacion.setAddWhere(addWhere);

			columnas = obtenerColumnasTabla(parametrizacion.getTabla());

			outStr = obtenerDatosInforme(parametrizacion, columnas);

									

			return outStr;

		} catch(Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, TRACE_METODO + ": " + sw.getBuffer ().toString());

			throw ex;

		}    					

	}

	

	

	/**

	 * Metodo que se invoca para generar un informe de texto plano

	 * @param String - niParametrizacion, datos de parametrizacion del informe

	 * @return String

	 * @throws Exception

	 */

	public String generarInformeTexto(String niParametrizacion, String addWhere) throws Exception{

		final String TRACE_METODO 			= "Q02bInformesBean: generarInformeTexto";

		Q02bParametrizacion parametrizacion = null;

		Q02bColumnas columnas 				= null;

		String str		= null;

		

		if (tr.isTraceActive()){

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": entrando");

		}

		try {

			//Metodos que componen los datos del informe

			parametrizacion = obtenerParametrizacion(niParametrizacion);

			//Aadimos la additional where

			parametrizacion.setAddWhere(addWhere);

			columnas = obtenerColumnasTabla(parametrizacion.getTabla());

			str = obtenerDatosTextoPlano(parametrizacion, columnas);

									

			return str;

		} catch(Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, TRACE_METODO + ": " + sw.getBuffer ().toString());

			throw ex;

		}    					

	}

	

}