package q02b.exe.procesos.beans;



import java.util.ArrayList;



import q02b.exe.arquitectura.beans.Q02bBaseBean;

import q02b.exe.procesos.dataobjects.Q02bProcesosDataBaseDAO;

import q02b.exe.procesos.valueobjects.Q02bProcesos;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;



public class Q02bProcesosBean extends Q02bBaseBean {

	private static final long serialVersionUID = 5474311672836163390L;



	protected Q02bProcesosDataBaseDAO daoProcesos = null;



	final static String LISTA_PROCESOS = "listaProcesos";



	/** Constructor vacio */

	public Q02bProcesosBean() {

		super();

	}



	/**

	 * Funcin que recupera los procesos

	 * @return listaProcesos - Listado de procesos obtenidos

	 * @throws Exception

	 */

	public ArrayList obtenerProcesos(Q02bProcesos proceso) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerProcesos: entrando.");

		}

		ArrayList listaProcesos = new ArrayList();

		boolean error = false;



		try {

			// se abre la conexin

			abrirConexion();

			// se instancia el dao pasandole la conexin

			daoProcesos = new Q02bProcesosDataBaseDAO(this.getConn());



			// Segmento tecnico

			daoProcesos.setUser(this.getAutenticador().getUser());

			daoProcesos.setIdioma(this.getAutenticador().getIdioma());



			listaProcesos = daoProcesos.getProcesos(proceso);

			return listaProcesos;

		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":obtenerProcesos: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				daoProcesos.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE,Q70TraceLevel.ERROR,this.getClass().getName()+ ":obtenerProcesos: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerProcesos: saliendo.");

			}

		}

	} // fin obtenerProcesos



	/**

	 * Funcin que inserta los datos del proceso pasado como parmetro en la BBDD

	 * @param proceso - Datos del proceso a insertar

	 * @throws Exception

	 */

	public void insertarProcesos(Q02bProcesos proceso) throws Exception {

		boolean error = false;

		int idProceso = 0;

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":insertarProcesos: entrando");

			}

			// se abre la conexin

			abrirConexion();



			// se instancia el dao pasandole la conexin

			daoProcesos = new Q02bProcesosDataBaseDAO(this.getConn());

			

			// se pasan los parmetros de usuario e idioma

			daoProcesos.setUser(this.autenticador.getUser());

			daoProcesos.setIdioma(this.autenticador.getIdioma());



			// se llama la metodo del DAO que realiza la insert

			idProceso = daoProcesos.insertarProcesos(proceso);

			

			//se llama al metodo para insertar los roles y los procesos

			daoProcesos.insertarRolesProceso(idProceso, proceso.getListaRolesSeleccionados());

			

		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":insertarProcesos: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				daoProcesos.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE,Q70TraceLevel.ERROR,this.getClass().getName()+ ":insertarProcesos: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":insertarProcesos: saliendo.");

			}

		}

	}// fin insertarProcesos



	public Q02bProcesos obtenerProcesoModificacion(String idProceso) throws Exception{

	    	boolean error = false;

	    	Q02bProcesos proceso = new Q02bProcesos();

	    	try{

	    		if (tr.isTraceActive()){

	      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerProcesoModificacion: entrando");

	      		}

				abrirConexion();			

				this.daoProcesos = new Q02bProcesosDataBaseDAO(this.getConn());

	            //Pasamos los perfiles del usuario e idioma

				daoProcesos.setUser(this.autenticador.getUser());

				daoProcesos.setIdioma(this.autenticador.getIdioma());

				

				proceso = daoProcesos.obtenerProceso(idProceso);

				

	            // Obtenemos los roles seleccionados para el proceso

				proceso.setListaRolesSeleccionados(this.obtenerRolesSeleccionados(idProceso));

				

				// Obtenemos los roles no seleccionados

				proceso.setListaRoles(this.obtenerRolesNoSeleccionados(idProceso));

				

				return proceso;

	    	}catch(Exception ex){

		 		error= true;

		        java.io.StringWriter sw = new java.io.StringWriter();

		        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

		        ex.printStackTrace(pw);

		        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerProcesoModificacion: " + sw.getBuffer ().toString());

		        throw ex;                     

	    	}finally{

	    		try{

	    			this.daoProcesos.freeResourcesNotConnection();

	    		}catch(Exception ex){

	    		   if (tr.isTraceActive()){

	    			   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerProcesoModificacion: error liberando recursos");

	    		   }  

	    		}  		 

	    	 	//se cierra la conexin  

	    	 	cerrarConexion(error);	       	

	    		if (tr.isTraceActive()){

	    			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerProcesoModificacion saliendo.");

	    		}

	    	 }

	    }

	 

	 /**

	     * Mtodo que llama a un DAO para obtener la lista de roles no seleccionados para un proceso.

	     * @param niProceso

	     * @return ArrayList con la lista de roles no asignados a un proceso.

	     * @throws Exception

	     */

	    private ArrayList obtenerRolesNoSeleccionados(String idProceso) throws Exception{

	    	try{

	    		if (tr.isTraceActive()){

	      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRolesNoSeleccionados: entrando");

	      		}

	    		daoProcesos = new Q02bProcesosDataBaseDAO(this.getConn());

	    		daoProcesos.setUser(this.autenticador.getUser());

	    		daoProcesos.setIdioma(this.autenticador.getIdioma());

				

				return this.daoProcesos.obtenerRolesNoSeleccionados(idProceso);

	    	}catch(Exception ex){

		        java.io.StringWriter sw = new java.io.StringWriter();

		        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

		        ex.printStackTrace(pw);

		        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerRolesNoSeleccionados: " + sw.getBuffer ().toString());

		        throw ex;                     

	    	}finally{

	 		    try{

	 		    	this.daoProcesos.freeResourcesNotConnection();

	 		    }catch(Exception ex){

				   if (tr.isTraceActive()){

					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerRolesNoSeleccionados: error liberando recursos");

		   	   	   }  

	 		    }  		         	

		        if (tr.isTraceActive()){

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRolesNoSeleccionados: saliendo.");

		   		}

	    	}

	    }

	    

    /**

     * Mtodo que llama a un DAO para obtener la lista de roles seleccionados para un proceso

     * @param niProceso nmero interno del proceso en bbdd.

     * @return ArrayList con la lista de roles asignados a un proceso

     * @throws Exception

     */

    private ArrayList obtenerRolesSeleccionados(String idProceso) throws Exception{

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRolesSeleccionados: entrando");

      		}

    		daoProcesos = new Q02bProcesosDataBaseDAO(this.getConn());

    		daoProcesos.setUser(this.autenticador.getUser());

    		daoProcesos.setIdioma(this.autenticador.getIdioma());

			

			return daoProcesos.obtenerRolesSeleccionados(idProceso);

    	}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerRolesSeleccionados: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

 		    try{

 		    	this.daoProcesos.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerRolesSeleccionados: error liberando recursos");

	   	   	   }  

 		    }  		         	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRolesSeleccionados: saliendo.");

	   		}

    	}

    }    

    

    /**

     * Mtodo que llama a un DAO para obtener un objeto Q02bProceso con los datos para la consulta.

     * @param idProceso nmero interno del proceso en bbdd.

     * @return Objeto Q02bProceso con los datos del proceso

     * @throws Exception

     */

    public Q02bProcesos obtenerProcesoConsulta (String idProceso) throws Exception {		 	 

		//Definicin de variables que no se van a modificar

		final String 	TRACE_METODO 	= ":obtenerProceso:";

		//Definicin de dems variables

		Q02bProcesos proceso = new Q02bProcesos();

		boolean	error = false;

		

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando.");

	   		}  

			//Se abre la conexin

			abrirConexion();

			//Se instancia el dao pasandole la conexin			

			daoProcesos = new Q02bProcesosDataBaseDAO(this.getConn());

			//Se pasan los parmetros de usuario e idioma

			daoProcesos.setUser(this.autenticador.getUser());

			daoProcesos.setIdioma(this.autenticador.getIdioma());

						

			proceso = daoProcesos.obtenerProceso(idProceso);		

            

            // Obtenemos los roles seleccionados para el proceso

			proceso.setListaRolesSeleccionados(this.obtenerRolesSeleccionados(idProceso));

			

			return proceso;              

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter 	sw = new java.io.StringWriter();

          java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoProcesos.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + " error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO  + " saliendo.");

	   		}

 	  	}

 	  }

    

	/**

	 * Funcin que borra el proceso pasado como parmetro de la BBDD

	 * @param idProceso - nmero interno del proceso a borrar

	 * @throws Exception

	 */

	public void borrarProcesos(String idProceso) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":borrarProcesos: entrando");

		}

		boolean error = false;

		try {

			// se abre la conexin

			abrirConexion();



			// se instancia el dao pasandole la conexin

			daoProcesos = new Q02bProcesosDataBaseDAO(this.getConn());



			// Segmento tecnico

			daoProcesos.setUser(this.getAutenticador().getUser());

			daoProcesos.setIdioma(this.getAutenticador().getIdioma());

			//primero, se borran los Roles asignados a ese proceso 

			daoProcesos.borrarRolesProceso(idProceso);

			//despues, se borra el proceso

			daoProcesos.borrarProcesos(idProceso);

		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":borrarProcesos: " + sw.getBuffer().toString());

			throw ex;



		} finally {

			try {

				daoProcesos.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":borrarProcesos: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":borrarProcesos: saliendo.");

			}

		}

	}// fin borrarProcesos



	/**

	 * Funcin que modifica los datos del proceso pasado como parmetro en la BBDD

	 * @param proceso - Datos del proceso a modificar

	 * @throws Exception

	 */

	public void modificarProcesos(Q02bProcesos proceso) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":modificarProcesos: entrando");

		}

		boolean error = false;

		try {

			// se abre la conexin

			abrirConexion();

			// se instancia el dao pasandole la conexin

			daoProcesos = new Q02bProcesosDataBaseDAO(this.getConn());



			// Segmento tecnico

			daoProcesos.setUser(this.getAutenticador().getUser());

			daoProcesos.setIdioma(this.getAutenticador().getIdioma());



			// se llamaa la metodo del DAO que realiza la update

			daoProcesos.modificarProcesos(proceso);

			

			// modificamos los roles asignados al proceso

			this.modificarRolesProceso(proceso.getIdProceso(),proceso.getListaRolesSeleccionados());



		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":modificarProcesos: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				daoProcesos.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":modificarProcesos: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":modificarProcesos: saliendo.");

			}

		}

	}// modificarProcesos

	

	/**

     * Mtodo que llama a un DAO para modificar los roles para un proceso determinado

     * @param niProceso nmero interno del proceso en bbdd.

     * @param listaRoles ArrayList con los nmeros internos de cada rol.

     * @throws Exception

     */

    private void modificarRolesProceso(String idProceso, ArrayList listaRoles) throws Exception {

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarRolesProceso: entrando");

      		}

    		this.daoProcesos = new Q02bProcesosDataBaseDAO(this.getConn());

    		this.daoProcesos.setUser(this.autenticador.getUser());

			this.daoProcesos.setIdioma(this.autenticador.getIdioma());

			

			//Primero eliminamos los que tena asignados

			this.daoProcesos.borrarRolesProceso(idProceso);			

			

			// Ahora insertamos los nuevos

			for (int i=0;i<listaRoles.size();i++){

				this.daoProcesos.insertarProcesoRol((String)listaRoles.get(i),idProceso);

			}

    	}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarRolesProceso: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

 		    try{

 		    	this.daoProcesos.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarRolesProceso: error liberando recursos");

	   	   	   }  

 		    }  		  	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarRolesProceso: saliendo.");

	   		}

    	}

    }//fin modificarRolesProceso



}