package q02b.exe.plazos.beans;



import java.util.ArrayList;



import q02b.exe.arquitectura.beans.Q02bBaseBean;

import q02b.exe.plazos.dataobjects.Q02bPlazosDataBaseDAO;

import q02b.exe.plazos.valueobjects.Q02bPlazos;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;



   

public class Q02bPlazosBean extends Q02bBaseBean{

	private static final long serialVersionUID = 5474311672836163390L;

	protected Q02bPlazosDataBaseDAO daoPlazos = null;

	final static String	LISTA_PLAZOS = "listaPlazos";

	

	/** Constructor vacio */

    public Q02bPlazosBean() {

        super();

    }



    /**

     * Funcin que recupera los plazos

     * @return listaPlazos  -  Listado de plazos obtenidos

     * @throws Exception

     */

	public ArrayList getPlazos(Q02bPlazos filtroPlazos) throws Exception 

	{

		 if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getPlazos: entrando.");

	   		}  	  

		ArrayList listaPlazos = new ArrayList();

		boolean error = false;

		

		try{

			//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoPlazos = new Q02bPlazosDataBaseDAO(this.getConn());

			

			//Segmento tecnico 

  			daoPlazos.setUser(this.getAutenticador().getUser());

  			daoPlazos.setIdioma(this.getAutenticador().getIdioma());

			

			listaPlazos = daoPlazos.getPlazos(filtroPlazos);

            return listaPlazos;              

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getPlazos: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoPlazos.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getPlazos: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getPlazos: saliendo.");

	   		}

 	  	}

 	  } //fin getPlazos 

	

	

	/**

     * Mtodo que dado el nmero interno del plazo 

     * recupera de la BBDD los datos de dicho cuestionario.

     * @param niPlazo

     * @return Plazo

     */

	public Q02bPlazos obtenerPlazo(String niPlazo)throws Exception{  	 

	    	boolean error = false;

	    	Q02bPlazos plazo = null;

	  	  	try  	  {

	  	  		if (tr.isTraceActive()){

	  	  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazo, ** niPlazo bean=" + niPlazo + " *** entrando");                

	  	  		}

	  	  		

	  	  		//se abre la conexin

	  	  		abrirConexion();

	  	  		

	  	  		//se instancia el dao pasandole la conexin			

	  	  		daoPlazos = new Q02bPlazosDataBaseDAO(this.getConn());

	  	  		

	  	  		//Segmento tecnico 

	  			daoPlazos.setUser(this.getAutenticador().getUser());

	  			daoPlazos.setIdioma(this.getAutenticador().getIdioma());

	  			

	  	  		//se llama al mtodo del dao que recupera el plazo

	  	  		plazo = daoPlazos.obtenerPlazo(niPlazo);

	  	  		

	  	  		//se devuelve el cuestionario recuperado

	  	  		return plazo;

	  	  }catch(Exception ex){

	  		  	error= true;

	  		  	java.io.StringWriter sw = new java.io.StringWriter();

	          	java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          	ex.printStackTrace(pw);

	          	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerPlazo: " + sw.getBuffer ().toString());

	          	throw ex;                     

	 	  }finally{

	 		  	try{

	 		  		daoPlazos.freeResourcesNotConnection();

	 		  	}catch(Exception ex){

				   if (tr.isTraceActive()){

					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerPlazo: error liberando recursos");

		   	   	   }  

	 		  	}  		 

	 		  	//se cierra la conexin  

	 		  	cerrarConexion(error);	       	

		        if (tr.isTraceActive()){

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazo: saliendo.");

		   		}

	 	  }

	    }//fin obtenerPlazo

	

	/**

     * Funcin que inserta los datos del plazo pasado como parmetro en la BBDD

     * @param plazo - Datos del plazo a insertar

     * @throws Exception

     */

      public void insertarPlazos(Q02bPlazos plazo) throws Exception {   	 

    	boolean error = false;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarPlazos: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			

			//se instancia el dao pasandole la conexin			

			daoPlazos = new Q02bPlazosDataBaseDAO(this.getConn());

			

			//se pasan los parmetros de usuario e idioma

			daoPlazos.setUser(this.autenticador.getUser());

			daoPlazos.setIdioma(this.autenticador.getIdioma());

			

			//si se ha selecciona C.A.E. se inserta un registro por cada provincia

			if (plazo.getProvincia().equals("C.A.E.")){

				plazo.setProvincia("01");

			daoPlazos.insertarPlazos(plazo);

				plazo.setProvincia("20");

				daoPlazos.insertarPlazos(plazo);

				plazo.setProvincia("48");

				daoPlazos.insertarPlazos(plazo);

			} else {

				daoPlazos.insertarPlazos(plazo);

			}

    	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarPlazos: " + sw.getBuffer ().toString());

	        throw ex;                     

 	  }finally{

 		    try{

 		    	daoPlazos.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarPlazos: error liberando recursos");

	   	   	   }  

 		    }  		 

 		  	//se cierra la conexin  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarPlazos: saliendo.");

	   		}

 	  }

    }//fin insertarPlazos

      

      /**

       * Funcin que borra el plazo pasado como parmetro de la BBDD 

       * @param niPlazo - nmero interno del plazo a borrar

       * @throws Exception

       */

    public void borrarPlazos(String niPlazo) throws Exception { 

    		if (tr.isTraceActive()){

  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarPlazos: entrando");

    		}

    		boolean error = false;

    		try{

    			//se abre la conexin

    			abrirConexion();

   			

    			//se instancia el dao pasandole la conexin			

    			daoPlazos = new Q02bPlazosDataBaseDAO(this.getConn());

  			

    			//Segmento tecnico 

    			daoPlazos.setUser(this.getAutenticador().getUser());

    			daoPlazos.setIdioma(this.getAutenticador().getIdioma()); 



				daoPlazos.borrarPlazos(niPlazo);   		 	  

    		}catch(Exception ex){

    			error= true;

    			java.io.StringWriter sw = new java.io.StringWriter();

    			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    			ex.printStackTrace(pw);

    			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarPlazos: " + sw.getBuffer ().toString());

    			throw ex;           

  	  

    		}finally{

    			try{

    				daoPlazos.freeResourcesNotConnection();

    			}catch(Exception ex){

    				if (tr.isTraceActive()){

    					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarPlazos: error liberando recursos");

  	   	   	   		}  

    			}  		 

   		  		//se cierra la conexin  

   		  		cerrarConexion(error);	       	

   		  		if (tr.isTraceActive()){

   		  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarPlazos: saliendo.");

   		  		}

    		}

    }//fin borrarPlazos

    

    /**

     * Funcin que modifica los datos del cuestionario pasado como parmetro en la BBDD

     * @param cuestionarioVTMAnu - Datos del cuestionario a modificar 

     * @throws Exception

     */

    public void modificarPlazos(Q02bPlazos plazo) throws Exception {

   	 if (tr.isTraceActive()){

  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarPlazos: entrando");

  		}

   	 boolean error = false;

   	try{

   		//se abre la conexin

   		abrirConexion();

   		//se instancia el dao pasandole la conexin			

   		daoPlazos = new Q02bPlazosDataBaseDAO(this.getConn());

		

   		//Segmento tecnico 

		daoPlazos.setUser(this.getAutenticador().getUser());

   		daoPlazos.setIdioma(this.getAutenticador().getIdioma()); 



   		//se llamaa la metodo del DAO que realiza la update

   		daoPlazos.modificarPlazos(plazo);

   		    	

   	}catch(Exception ex){

		 error= true;

         java.io.StringWriter sw = new java.io.StringWriter();

         java.io.PrintWriter pw = new java.io.PrintWriter(sw);

         ex.printStackTrace(pw);

         tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarPlazos: " + sw.getBuffer ().toString());

         throw ex;                     

	  }finally{

		 try{

			daoPlazos.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarPlazos: error liberando recursos");

	   	   	   }  

		   }  		 

		  	//se cierra la conexin  

		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarPlazos: saliendo.");

	   		}

	  }

   }//modificarPlazos

}