package q02b.exe.oficinasMunicipales.beans;



import java.util.ArrayList;

//import java.util.HashMap;



import q02b.exe.arquitectura.beans.Q02bBaseBean;



import q02b.exe.oficinasMunicipales.dataobjects.Q02bOficinasMunicipalesDataBaseDAO;

import q02b.exe.oficinasMunicipales.valueobjects.Q02bOficinasMunicipales;

//import q02b.exe.plazos.dataobjects.Q02bPlazosDataBaseDAO;

//import q02b.exe.plazos.valueobjects.Q02bPlazos;

//import q02b.exe.utils.Q02bConstantes;

//import q02b.exe.utils.Q02bFormatData;

//import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

//import q02b.exe.arquitectura.utils.xml.Q02bXMLBuilder;

//import org.w3c.dom.Document;

//import org.w3c.dom.Element;

//import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;



   

public class Q02bOficinasMunicipalesBean extends Q02bBaseBean{

	private static final long serialVersionUID = 5474311672836163390L;

	protected Q02bOficinasMunicipalesDataBaseDAO daoOficinasMunicipales = null;

	final static String	OFICINA_MUNICIPAL = "oficinaMunicipal";

	

	 /** Constructor vacio */

    public Q02bOficinasMunicipalesBean() {

        super();

    }

        

//  -------------------- INI - OBTENER LISTA

    /**

     * M?todo que se invoca desde un EJB para obtener un ArrayList de objetos

     * en funci?n de los par?metros del filtro

     * @param filtro - Q02bOficinasMunicipales

     * @return  - ArrayList de objetos - Q02bOficinasMunicipalesLista

     * @throws Exception

     * @see Q02bOficinasMunicipales

     * @see Q02bOficinasMunicipalesLista

     * @generated

     */

    public ArrayList obtenerListaOficinasMunicipales(Q02bOficinasMunicipales filtro)

        throws Exception {

        //Definici?n de constantes

        final String TRACE_METODO = nombreClaseSinPackage +

            ":obtenerListaOficinasMunicipales";

        //final String NUM_MAX_REG = "q02b.dma.cnae2009.num_max_reg";

        //final String IDIOMA_EU = "IDIOMA_EU";



        //Definici?n de variables

        //int numReg = 0;

        //int numMax = 0;

        ArrayList lista = new ArrayList();

        boolean error = false;



        // Variables de negocio

        Q02bOficinasMunicipalesDataBaseDAO dao = null;



        if (tr.isTraceActive()) {

            tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +

                ": entrando");

        }



        try {

            //Se abre la conexi?n

            abrirConexion();

            //Se instancia el dao pasandole la conexi?n			

            dao = new Q02bOficinasMunicipalesDataBaseDAO(this.getConn());

            //Se pasan los par?metros de usuario e idioma

            dao.setUser(this.autenticador.getUser());

            dao.setIdioma(this.autenticador.getIdioma());

            

            lista = dao.obtenerListaOficinasMunicipales(filtro);

            

        



            //En funci?n del idioma se modifica el filtro

           /* if (dao.getIdioma()

                       .equals(Q70ListenerUtils.getApplicationProperty(

                            IDIOMA_EU))) {              

            }*/



            //Se llamar? al dao para obtener el n?mero de puntos de toma que cumplen el filtro

           /* numReg = dao.obtenerNumOficinasMunicipales(filtro);



            if (numReg == 0) {

                //no existen registros para el criterio introducido

                //se lanza la exception con el mensaje de error

                throw new Q02bAplicException("error.oi.noOficinasMunicipales");

            } else {*/

                //se comprueba que el n? reg recuperados no es superior al limite impuesto

                //numMax = Integer.valueOf(S99bConstantes.getString(NUM_MAX_REG)).intValue();

            	

            



                // Si el n?mero de registros devueltos es menor que el m?ximo permitido

                // y se ha devuelto registros

              /*  if (numReg <= numMax) {

                    lista = dao.obtenerListaCNAE2009(filtro);

                } else {

                    //el n? de reg es superior al permitido. 

                    //se lanza la exception con el mensaje de error	            			            		

                    throw new S99bAplicException("error.oi.limite.registros");

                }

                

                }*/

            



            //Se devuelve la lista

            return lista;

        } catch (Exception ex) {

            error = true;



            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

                TRACE_METODO + ": " + sw.getBuffer().toString());

            throw ex;

        } finally {

            try {

                dao.freeResourcesNotConnection();

            } catch (Exception ex) {

                if (tr.isTraceActive()) {

                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

                        TRACE_METODO + ": error liberando recursos");

                }

            }



            //se cierra la conexi?n  

            cerrarConexion(error);



            if (tr.isTraceActive()) {

                tr.trace(COMPONENTE, Q70TraceLevel.INFO,

                    TRACE_METODO + ": saliendo");

            }

        }

    }



    // -------------------- FIN - OBTENER LISTA

    

    /**

     * Funcin que inserta los datos de la oficinaMunicipal pasada como parmetro en la BBDD

     * @param oficinaMunicipal - Datos de la oficinaMunicipal a insertar

     * @throws Exception

     */

      public void insertarOficinasMunicipales(Q02bOficinasMunicipales oficinaMunicipal) throws Exception {   	 

    	boolean error = false;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarOficinasMunicipales: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			

			//se instancia el dao pasandole la conexin			

			daoOficinasMunicipales = new Q02bOficinasMunicipalesDataBaseDAO(this.getConn());

			

			//se pasan los parmetros de usuario e idioma

			//daoPlazos.setUser(this.autenticador.getUser());

			//daoPlazos.setIdioma(this.autenticador.getIdioma());

			

			//se llama la metodo del DAO que realiza la insert

			daoOficinasMunicipales.insertarOficinasMunicipales(oficinaMunicipal);

    	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarOficinasMunicipales: " + sw.getBuffer ().toString());

	        throw ex;                     

 	  }finally{

 		    try{

 		    	daoOficinasMunicipales.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarOficinasMunicipales: error liberando recursos");

	   	   	   }  

 		    }  		 

 		  	//se cierra la conexin  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarOficinasMunicipales: saliendo.");

	   		}

 	  }

    }//fin insertarOficinasMunicipales

      

      /**

       * Mtodo que dado el nmero interno de la oficinaMunicipal 

       * recupera de la BBDD los datos de dicho cuestionario.

       * @param idOfi

       * @return oficinaMunicipal

       */

  	public Q02bOficinasMunicipales obtenerOficinaMunicipal(String idOfi)throws Exception{  	 

  	    	boolean error = false;

  	    	Q02bOficinasMunicipales oficinaMunicipal = null;

  	  	  	try  	  {

  	  	  		if (tr.isTraceActive()){

  	  	  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerOficinaMunicipal, ** idOfi bean=" + idOfi + " *** entrando");                

  	  	  		}

  	  	  		

  	  	  		//se abre la conexin

  	  	  		abrirConexion();

  	  	  		

  	  	  		//se instancia el dao pasandole la conexin			

  	  	  		daoOficinasMunicipales = new Q02bOficinasMunicipalesDataBaseDAO(this.getConn());

  	  	  		

  	  	  		//Segmento tecnico 

  	  			//daoPlazos.setUser(this.getAutenticador().getUser());

  	  			//daoPlazos.setIdioma(this.getAutenticador().getIdioma());

  	  			

  	  	  		//se llama al mtodo del dao que recupera el plazo

  	  	  		oficinaMunicipal = daoOficinasMunicipales.obtenerOficinaMunicipal(idOfi);

  	  	  		

  	  	  		//se devuelve el cuestionario recuperado

  	  	  		return oficinaMunicipal;

  	  	  }catch(Exception ex){

  	  		  	error= true;

  	  		  	java.io.StringWriter sw = new java.io.StringWriter();

  	          	java.io.PrintWriter pw = new java.io.PrintWriter(sw);

  	          	ex.printStackTrace(pw);

  	          	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerOficinaMunicipal: " + sw.getBuffer ().toString());

  	          	throw ex;                     

  	 	  }finally{

  	 		  	try{

  	 		  	daoOficinasMunicipales.freeResourcesNotConnection();

  	 		  	}catch(Exception ex){

  				   if (tr.isTraceActive()){

  					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerOficinaMunicipal: error liberando recursos");

  		   	   	   }  

  	 		  	}  		 

  	 		  	//se cierra la conexin  

  	 		  	cerrarConexion(error);	       	

  		        if (tr.isTraceActive()){

  		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerOficinaMunicipal: saliendo.");

  		   		}

  	 	  }

  	    }//fin obtenerOficinaMunicipal

  	

  	/**

     * Funcin que modifica los datos del cuestionario pasado como parmetro en la BBDD

     * @param oficinaMunicipal - Datos del cuestionario a modificar 

     * @throws Exception

     */

    public void modificarOficinasMunicipales(Q02bOficinasMunicipales oficinaMunicipal) throws Exception {

   	 if (tr.isTraceActive()){

  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarOficinasMunicipales: entrando");

  		}

   	 boolean error = false;

   	try{

   		//se abre la conexin

   		abrirConexion();

   		//se instancia el dao pasandole la conexin			

   		daoOficinasMunicipales = new Q02bOficinasMunicipalesDataBaseDAO(this.getConn());

		

   		//Segmento tecnico 

		//daoPlazos.setUser(this.getAutenticador().getUser());

   		//daoPlazos.setIdioma(this.getAutenticador().getIdioma()); 



   		//se llamaa la metodo del DAO que realiza la update

   		daoOficinasMunicipales.modificarOficinasMunicipales(oficinaMunicipal);

   		    	

   	}catch(Exception ex){

		 error= true;

         java.io.StringWriter sw = new java.io.StringWriter();

         java.io.PrintWriter pw = new java.io.PrintWriter(sw);

         ex.printStackTrace(pw);

         tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarOficinasMunicipales: " + sw.getBuffer ().toString());

         throw ex;                     

	  }finally{

		 try{

			 daoOficinasMunicipales.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarOficinasMunicipales: error liberando recursos");

	   	   	   }  

		   }  		 

		  	//se cierra la conexin  

		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarOficinasMunicipales: saliendo.");

	   		}

	  }

   }//modificarOficinasMunicipales

     

   

    /**

     * Funcin que borra la oficina municipal pasado como parmetro de la BBDD 

     * @param idOfi - nmero interno de la oficina a borrar

     * @throws Exception

     */

  public void borrarOficinaMunicipal(String idOfi) throws Exception { 

  		if (tr.isTraceActive()){

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarOficinaMunicipal: entrando");

  		}

  		boolean error = false;

  		try{

  			//se abre la conexin

  			abrirConexion();

 			

  			//se instancia el dao pasandole la conexin			

  			daoOficinasMunicipales = new Q02bOficinasMunicipalesDataBaseDAO(this.getConn());

			

  			//Segmento tecnico 

  			//daoPlazos.setUser(this.getAutenticador().getUser());

  			//daoPlazos.setIdioma(this.getAutenticador().getIdioma()); 



  			daoOficinasMunicipales.borrarOficinaMunicipal(idOfi);   		 	  

  		}catch(Exception ex){

  			error= true;

  			java.io.StringWriter sw = new java.io.StringWriter();

  			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

  			ex.printStackTrace(pw);

  			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarOficinaMunicipal: " + sw.getBuffer ().toString());

  			throw ex;           

	  

  		}finally{

  			try{

  				daoOficinasMunicipales.freeResourcesNotConnection();

  			}catch(Exception ex){

  				if (tr.isTraceActive()){

  					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarOficinaMunicipal: error liberando recursos");

	   	   	   		}  

  			}  		 

 		  		//se cierra la conexin  

 		  		cerrarConexion(error);	       	

 		  		if (tr.isTraceActive()){

 		  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarOficinaMunicipal: saliendo.");

 		  		}

  		}

  }//fin borrarOficinaMunicipal

    

}



		





