package q02b.exe.informantes.beans;



import java.util.ArrayList;

import java.util.HashMap;



import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import q02b.exe.arquitectura.beans.Q02bBaseBean;

import q02b.exe.informantes.valueobjects.Q02bFiltroInformantes;

import q02b.exe.informantes.valueobjects.Q02bInformante;

import q02b.exe.informantes.dataobjects.Q02bInformantesDataBaseDAO;

import q02b.exe.utils.Q02bVoUtils;



public class Q02bInformantesBean extends Q02bBaseBean{

	

	private static final long serialVersionUID = 5474311672836163390L;

	protected Q02bInformantesDataBaseDAO daoInformantes = null;



	

	 /** Constructor vacio */

    public Q02bInformantesBean() {

        super();

    }

    

    

    /**

     * Funcin que recupera los informantes

     * 

     * @return listaInformantes  -  Listado de informantes obtenidos

     * @throws Exception

     */

	public ArrayList getInformantes(HashMap mapaFiltroInformantes) throws Exception 

	{

		Q02bFiltroInformantes filtroInformantesVO = null;

		//String noRegRecuperados = "NoHayInformantes";

		ArrayList listaInformantes = new ArrayList();

		int numInformantes = 0;

		boolean error = false;

		//boolean obtenerListado=false;

		

		try{

			 if (tr.isTraceActive()){

		   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getInformantes: entrando.");

		   	}  	  

			

			//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoInformantes = new Q02bInformantesDataBaseDAO(this.getConn());

			daoInformantes.setIdioma(this.getAutenticador().getIdioma());

			

			//Pasamos del hashMap recibido al valueObject

			filtroInformantesVO = (Q02bFiltroInformantes) Q02bVoUtils.getValueObject(mapaFiltroInformantes,"q02b.exe.informantes.valueobjects.Q02bFiltroInformantes");

			

			//se llamamara al dao para obtener el nmero de informantes

			numInformantes = daoInformantes.getCountInformantes(filtroInformantesVO);

			if(numInformantes>0){

				listaInformantes = daoInformantes.getInformantes(filtroInformantesVO);

	     	}

	        return listaInformantes;              

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getInformantes: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoInformantes.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getInformantes: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getInformantes: saliendo.");

	   		}

 	  	}

 	  } //fin getInformantes 

	

	

	 /**

     * Funcin que recupera los datos del informante seleccionado en el listado

     * @param idInformante - String  Nmero interno del informante insertado

     * @return informante  -  Q02bInformante objeto informante con los datos del informante obtebido

     * @throws Exception

     */

	public Q02bInformante getInformante(String idInformante) throws Exception 

	{

		boolean error = false;

		Q02bInformante informante=null;

		try{

			 if (tr.isTraceActive()){

		   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getInformante: entrando.");

		   	}  	  

			

			//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoInformantes = new Q02bInformantesDataBaseDAO(this.getConn());

			daoInformantes.setIdioma(this.getAutenticador().getIdioma());

			//se llamamara al dao para obtener el informante

			informante = daoInformantes.getInformante(idInformante);

	     	

	        return informante;              

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getInformante: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoInformantes.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getInformante: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getInformante: saliendo.");

	   		}

 	  	}

 	  } //fin getInformante 

	

	

	/**

     * Funcin que inserta un informante en la bbdd

     * @param informanteVO - Q02bInformante valueobject informante con los datos del informante

     * @return idInformante - String  Nmero interno del informante insertado

     * @throws Exception

     */

	public String insertarInformante(Q02bInformante informanteVO) throws Exception 

	{

		String idInformante= null;		

		boolean error = false;

		

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarInformante: entrando.");

			}  	  

			//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoInformantes = new Q02bInformantesDataBaseDAO(this.getConn());

			daoInformantes.setIdioma(this.getAutenticador().getIdioma());

			//se llamamara al dao para insertar el usuario

			idInformante = daoInformantes.insertarInformante(informanteVO);

	        return idInformante;              

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarInformante: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoInformantes.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarInformante: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarInformante: saliendo.");

	   		}

 	  	}

 	  } //fin insertarInformante 



	/**

     * Funcin que modifica un informante de la bbdd

     * 

     * @param informanteVO - Q02bInformante valueobject informante con los datos del informante

     * @throws Exception

     */

	public void modificarInformante(Q02bInformante informanteVO) throws Exception 

	{

		boolean error = false;

		

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarInformante: entrando.");

			}  	  

			//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoInformantes = new Q02bInformantesDataBaseDAO(this.getConn());

			daoInformantes.setIdioma(this.getAutenticador().getIdioma());

			//se llamamara al dao para modificar el usuario

			daoInformantes.modificarInformante(informanteVO);

	                      

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarInformante: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoInformantes.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarInformante: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarInformante: saliendo.");

	   		}

 	  	}

 	  } //fin modificarInformante 

	

	

	/**

     * Funcin que borra un informante de la bbdd

     * @param idInformante - String Nmero interno del informante

     * @throws Exception

     */

	public void borrarInformante(String idInformante) throws Exception 

	{

		boolean error = false;

		

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarInformante: entrando.");

			}  	  

			//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoInformantes = new Q02bInformantesDataBaseDAO(this.getConn());

			daoInformantes.setIdioma(this.getAutenticador().getIdioma());

			//se llamamara al dao para borrar el usuario

			daoInformantes.borrarInformante(idInformante);

	                      

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarInformante: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoInformantes.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarInformante: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarInformante: saliendo.");

	   		}

 	  	}

 	  } //fin borrarInformante 

}

