package q02b.exe.grupos.dataobjects;



import java.sql.Connection;

import java.sql.PreparedStatement;

import java.sql.ResultSet;

import java.util.ArrayList;



import q02b.exe.arquitectura.dataobjects.Q02bDataBaseDAO;

import q02b.exe.comun.valueobjects.Q02bCodigoValor;

import q02b.exe.grupos.valueobjects.Q02bGrupos;



//import q02b.exe.procesos.dataobjects.Q02bProcesosDataBaseDAO;

//import q02b.exe.procesos.valueobjects.Q02bProcesos;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021GS01V01;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021HS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021HS01V01;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021JS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021KS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022FS01V01;

//import q02b.exe.utils.Q02bConstantes;

import q02b.exe.utils.Q02bFormatData;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;







public class Q02bGruposDataBaseDAO extends Q02bDataBaseDAO{

	private static final long serialVersionUID = -8520551641771839103L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "DAO_ACCESO_DATOS";



	public Q02bGruposDataBaseDAO() {

        super();                

    }



    

    public Q02bGruposDataBaseDAO(Connection conn) {

    	super(conn);     

    }



    public void rellenaFiltroGrupos(Q02bGrupos grupoFiltro, Q02bTablaBDQ021HS00 tablaGrupos) throws Exception {

		// Definición de variables que no se van a modificar

		final String TRACE_METODO = ":rellenaFiltroGrupos:";

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ TRACE_METODO + " entrando");

			}

			if (grupoFiltro != null) {

			// Inicializacion del filtro

	            StringBuffer addWhere = new StringBuffer();

				if (!Q02bFormatData.esVacio(grupoFiltro.getCodGrupo())) {

	                addWhere.append(" AND ( (TRANSLATE(UPPER(");

	                addWhere.append(Q02bTablaBDQ021HS00.NOMCOLUMN_Q021HT00_COD);

	                addWhere.append("),'','AEIOUAEIOU')) LIKE  '%");

	                addWhere.append(Q02bFormatData.convertirMaysculaSinAcento(grupoFiltro.getCodGrupo()));

	                addWhere.append("%' ) ");

	            }

				if (!Q02bFormatData.esVacio(grupoFiltro.getDescripcionGrupo())) {

	                addWhere.append(" AND ( (TRANSLATE(UPPER(");

	                addWhere.append(Q02bTablaBDQ021HS00.NOMCOLUMN_Q021HT00_DESC);

	                addWhere.append("),'','AEIOUAEIOU')) LIKE  '%");

	                addWhere.append(Q02bFormatData.convertirMaysculaSinAcento(grupoFiltro.getDescripcionGrupo()));

	                addWhere.append("%' ) ");

	            }

				

				  //Se a?ade el aditional where al tablasBD

	            tablaGrupos.setAditionalWhere(addWhere.toString());

			}

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ TRACE_METODO + sw.getBuffer().toString());

			throw ex;

		} finally {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ TRACE_METODO + " saliendo");

			}

		}

	}// fin rellenaFiltroGrupos

    

    private ArrayList rellenaVOsGruposTabla( ResultSet rs ) throws Exception{

     	Q02bGrupos grupos;

     	ArrayList listaGrupos = new ArrayList();

     	try{

     		if (tr.isTraceActive()){

 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsGrupos: entrando");                

 		    } 

     		while (rs.next()){	 

 	        	//se cargan en el objeto cuestionario los datos recuperados

     			grupos = new Q02bGrupos();

     			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":rellenarVOsGrupos: Hay Datos");            

     			grupos = this.rellenarVO(grupos, rs); 

     			listaGrupos.add(grupos);

   			}  	  

     		return listaGrupos;

     	}catch(Exception ex){    	 	   

  	       java.io.StringWriter sw = new java.io.StringWriter();

  	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);

  	       ex.printStackTrace(pw);

  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaVOsGrupos: " + sw.getBuffer ().toString());

  	       throw ex;

  		}finally{			 	

  			if (tr.isTraceActive()){

  		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsGrupos: saliendo");                

  		    }    				

  		}

     }//fin rellenarVOsGruposTabla(rs) 

    

    private Q02bGrupos rellenarVO(Q02bGrupos grupos, ResultSet rs) throws Exception{

   	  		try{

   	  			if (tr.isTraceActive()){

 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenarVO: entrando");                

   	  			} 

   	  		grupos.setNiGrupo(rs.getString(Q02bTablaBDQ021HS00.NOMCOLUMN_Q021HT00_NI));

   	  		grupos.setCodGrupo(rs.getString(Q02bTablaBDQ021HS00.NOMCOLUMN_Q021HT00_COD));

   	  		grupos.setDescripcionGrupo(rs.getString(Q02bTablaBDQ021HS00.NOMCOLUMN_Q021HT00_DESC));

			

	    	return grupos;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

	  	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	  	       ex.printStackTrace(pw);

	  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenarVO: " + sw.getBuffer ().toString());

	  	       throw ex;

   	  		}  	

    	

   	  	}

     

     private int dameSeqNiGrupo(Q02bTablaBDQ021HS00 tablaGrupos) throws Exception 

     {

    	int niGrupo=1;

     	ResultSet rs = null;

       	PreparedStatement prepStmt =null;	

     	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameSeqNiGrupo: entrando");

	    	}

    		StringBuffer query = new StringBuffer(" SELECT Q021HQ00.NEXTVAL FROM DUAL ");

         	prepStmt = this.getConnection().prepareStatement(query.toString());         	

         	rs = prepStmt.executeQuery();

         	tablaGrupos.addResultSet(rs);

         	tablaGrupos.addStatement(prepStmt);        	

         	if (rs.next()){

         		niGrupo = rs.getInt(1);

         		

         	}	         	

         	return niGrupo;

        }

	        catch(Exception ex)

     	        {   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameSeqNiGrupo: " + sw.getBuffer ().toString());

     		throw ex;

     	      }

     }//dameSeqNiGrupo

     

     public void rellenaDatosGrupos(Q02bGrupos grupo,Q02bTablaBDQ021HS00 tablaGrupos) throws Exception {

       	//se definen objetos necesarios.

       	try{

   	    	if (tr.isTraceActive())

   	    	{

   	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosGrupos: entrando");

   	    	}         	         

        	//se aaden los datos

   	    	tablaGrupos.setQ021HT00_NI(Q02bFormatData.checkLongNull(grupo.getNiGrupo()));   	    	

   	    	tablaGrupos.setQ021HT00_COD(Q02bFormatData.checkStringNull(grupo.getCodGrupo()));

   	    	tablaGrupos.setQ021HT00_DESC(Q02bFormatData.checkStringNull(grupo.getDescripcionGrupo()));

   	    	tablaGrupos.setUSER(new Long(this.getUser()));

   	    	

       	}catch(Exception ex){   	   

       		java.io.StringWriter sw = new java.io.StringWriter();

       		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

       		ex.printStackTrace(pw);

       		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaDatosGrupos: " + sw.getBuffer ().toString());

       		throw ex;

       	}finally{    		

   			if (tr.isTraceActive()){

   				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosGrupos: saliendo = " + tablaGrupos.getQ021HT00_NI());                

              }       	

       	}	

     }//rellenaDatosGrupos 

     

     public void rellenaDatosGruposModificar(Q02bGrupos grupo,Q02bTablaBDQ021HS00 tablaGrupos) throws Exception {

        	//se definen objetos necesarios.

        	try{

    	    	if (tr.isTraceActive())

    	    	{

    	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosGruposModificar: entrando");

    	    	}         	         

         	//se aaden los datos

    	    	tablaGrupos.setQ021HT00_NI(Q02bFormatData.checkLongNull(grupo.getNiGrupo()));   	    	

    	    	tablaGrupos.setQ021HT00_COD(Q02bFormatData.checkStringNull(grupo.getCodGrupo()));

    	    	tablaGrupos.setQ021HT00_DESC(Q02bFormatData.checkStringNull(grupo.getDescripcionGrupo()));

    	    	//tablaModulos.setUSER(new Long(this.getUser()));

    	    	

        	}catch(Exception ex){   	   

        		java.io.StringWriter sw = new java.io.StringWriter();

        		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

        		ex.printStackTrace(pw);

        		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaDatosGruposModificar: " + sw.getBuffer ().toString());

        		throw ex;

        	}finally{    		

    			if (tr.isTraceActive()){

    				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosGruposModificar: saliendo = " + tablaGrupos.getQ021HT00_NI());                

               }       	

        	}	

      }//rellenaDatosGruposModificar 

     

    public ArrayList obtenerGrupos(Q02bGrupos grupoFiltro) throws Exception {		

 		//se instancian los objetos necesarios para realizar la consulta.			

 		Q02bTablaBDQ021HS00 tablaGrupos=null;

 		ResultSet rs = null;

 		ArrayList listaGrupos = new ArrayList();

 		

 		try{

 	    	if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupos: entrando");

 			}

 	    	

 	    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	

 	    	tablaGrupos = new Q02bTablaBDQ021HS00(this.getConnection());

 	    	

 	    	//se aade la where

			this.rellenaFiltroGrupos(grupoFiltro, tablaGrupos);

 	    	tablaGrupos.setOrderBy(Q02bTablaBDQ021HS00.NOMCOLUMN_Q021HT00_NI + " DESC");

 	    	

 	    	//se realiza la select

 	    	rs = tablaGrupos.select();

 	    	//aadimos el cursos para luego poder liberarlo ( en el freeResources)

 	    	tablaGrupos.addResultSet(rs); 

 	    	//se trata el resultado obtenido aadiendolo a la lista de salida

 	    	listaGrupos = this.rellenaVOsGruposTabla(rs);

    	

 	    	return listaGrupos;    	

 		}catch(Exception ex){ 	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGrupos: " + sw.getBuffer ().toString());

     		throw ex;

 		}finally{

 		 	try{

 		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

 		 		tablaGrupos.freeResourcesNotConnection();	

 			 }catch(Exception ex)

 			 {

 			    if (tr.isTraceActive())

 			    {

 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGrupos: error liberando recursos.");

 	   	   	    }  

 			 }  		 			

 			 if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupos: saliendo.");                

 	         }   

 		}	

 	}//fin obtenerGrupos

    

    /**

     * Mtodo que dado el nmero interno del grupo 

     * recupera de la BBDD los datos de dicho grupo

     * @param niGrupo

     * @return

     */

   /* public Q02bGrupos obtenerGrupo(String niGrupo)throws Exception

    {

  	  if (tr.isTraceActive()){

 		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupo , ** dao niGrupo= "+ niGrupo + "  ** entrando");            

      }

  	  

  	  //se crean los objetos necesarios para realizar la select.

  	  Q02bTablaBDQ021HS00 Q02bTablaBDQ021HS00obj = null;

  	  Q02bGrupos grupoBD = null;

  	  ResultSet rs = null;   	  

        try{ 

          if (niGrupo!=null){           

        	  Q02bTablaBDQ021HS00obj = new Q02bTablaBDQ021HS00(this.getConnection());

          	

          	//se pone el filtro

        	  Q02bTablaBDQ021HS00obj.setQ021HT00_NI_WHERE(new Long(niGrupo));

        

          	rs = Q02bTablaBDQ021HS00obj.select();

          	Q02bTablaBDQ021HS00obj.addResultSet(rs);

          	grupoBD = new Q02bGrupos();

          	if (rs.next()){

          		grupoBD = this.rellenarVO(grupoBD,rs);

          	}

          }  

          return grupoBD;

          }catch(Exception ex){           	   

                 java.io.StringWriter sw = new java.io.StringWriter();

                 java.io.PrintWriter pw = new java.io.PrintWriter(sw);

                 ex.printStackTrace(pw);

                 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGrupo: " + sw.getBuffer ().toString());

                 throw ex;

          }finally{

       	   try{

       		   Q02bTablaBDQ021HS00obj.freeResourcesNotConnection();	

  				}catch(Exception ex){

  	   			if (tr.isTraceActive()){

  	   				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGrupo: error liberando recursos");

  	   		   	   }  

  				}  	

           	  if (tr.isTraceActive()){

           		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupo: saliendo");                

                }            	 

          }	  

    }//fin obtenerGrupo*/

    

    public Q02bGrupos obtenerGrupo(String niGrupo) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerGrupo , ** dao niGrupo= "+ niGrupo + "  ** entrando");

		}



		// se crean los objetos necesarios para realizar la select.

		Q02bTablaBDQ021HS01V01 Q02bTablaBDQ021HS01V01obj = null;

		Q02bGrupos grupoBD = null;

		ResultSet rs = null;

		try {

			if (niGrupo != null) {

				Q02bTablaBDQ021HS01V01obj = new Q02bTablaBDQ021HS01V01(this.getConnection());



				// se pone el filtro

				Q02bTablaBDQ021HS01V01obj.setQ021HT00_NI_WHERE(new Long(niGrupo));



				rs = Q02bTablaBDQ021HS01V01obj.select();

				Q02bTablaBDQ021HS01V01obj.addResultSet(rs);

				grupoBD = new Q02bGrupos();

				if (rs.next()) {

					this.rellenarVO(grupoBD, rs);

				}

			}

			return grupoBD;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":obtenerGrupo: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				Q02bTablaBDQ021HS01V01obj.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":obtenerGrupo: error liberando recursos");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerGrupo: saliendo");

			}

		}

	}// fin obtenerGrupo 



     

     /**

      * Funcin que inserta los datos del grupo pasado como parmetro en la BBDD

      * @param grupo - Datos del grupo a insertar 

      * @throws Exception

      */

     public int insertarGrupos(Q02bGrupos grupo) throws Exception {

    	int niGrupo = 0; 

    	Q02bTablaBDQ021HS00 tablaGrupos=null;

       	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGrupos: entrando");

	    	}

    		//se crea el objeto de tablasBD

	    	tablaGrupos = new Q02bTablaBDQ021HS00(this.getConnection());

      		//primero recuperamos el nmero interno que le corresponde

    	   	niGrupo = dameSeqNiGrupo(tablaGrupos);

         	grupo.setNiGrupo(Integer.toString(niGrupo));      	

      		//se aaden los datos a insertar

         	this.rellenaDatosGrupos(grupo, tablaGrupos);         	         

      		//se realiza la insert

      		tablaGrupos.insert();

      		return niGrupo;

     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarGrupos: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     	finally

     	{

     		try

     		{

     			tablaGrupos.freeResourcesNotConnection();	

     		}

     		catch(Exception ex)

     		{

     			if (tr.isTraceActive())

     			{

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarGrupos: error liberando recursos");

 		   	   }  

 		}  		

		if (tr.isTraceActive())

		{

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGrupos: saliendo");                

    		}       	

     	}

     } //insertarGrupos    

      

     /**

      * Funcin que borra el grupo pasado como parmetro de la BBDD

      * @param niGrupo - nmero interno del grupo a borrar

      * @throws Exception

      */

     public void borrarGrupos(String niGrupo) throws Exception {

      	if (tr.isTraceActive()){

      		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarGrupos: entrando");

      	}

      	Q02bTablaBDQ021HS00 Q02bTablaBDQ021HS00obj = null;

        try{       	

        	//se crean los objetos necesarios

         	Q02bTablaBDQ021HS00obj = new Q02bTablaBDQ021HS00(this.getConnection());   

         	

        	// segmento tecnico

            Q02bTablaBDQ021HS00obj.setUser(this.getUser());

         	

         	//se pone el filtro para la delete

         	Q02bTablaBDQ021HS00obj.setQ021HT00_NI_WHERE(Integer.parseInt(niGrupo));         	

         	

         	//se lanza el delete

          	Q02bTablaBDQ021HS00obj.delete();         	

         }

         catch(Exception ex)

         {

              java.io.StringWriter sw = new java.io.StringWriter();

              java.io.PrintWriter pw = new java.io.PrintWriter(sw);

              ex.printStackTrace(pw);

              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarGrupos: " + sw.getBuffer ().toString());

              throw ex;

         } 

         finally {

         	try{

         		Q02bTablaBDQ021HS00obj.freeResourcesNotConnection();	

         	}

         	catch(Exception ex) {

         		if (tr.isTraceActive()) {

         			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarGrupos: error liberando recursos");

         		}  

         	}  		

         	if (tr.isTraceActive()) {

         		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarGrupos: saliendo");                

            }     	   

         }

     }//fin borrarGrupos

     

     /**

      * Funcin que modifica los datos del grupo pasado como parmetro en la BBDD

      * @param grupo - Datos del grupo a modificar

      * @throws Exception

      */

     public void modificarGrupos(Q02bGrupos grupo) throws Exception {



      	if (tr.isTraceActive()){

  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarGrupos: entrando");

      	}

      	//Se instancian los objetos necesarios.

      	Q02bTablaBDQ021HS00 Q02bTablaBDQ021HS00obj = null;    

         	 try

         	 {     

         	 	//se crea el objeto de tablasBD

        		Q02bTablaBDQ021HS00obj = new Q02bTablaBDQ021HS00(this.getConnection());

        		

        		//segmento tecnico

             	//Q02bTablaBDQ022AS00obj.setUser(this.getUser());

        		  		

        		rellenaDatosGruposModificar(grupo,Q02bTablaBDQ021HS00obj);

        		Q02bTablaBDQ021HS00obj.setQ021HT00_NI_WHERE(Integer.parseInt(grupo.getNiGrupo()));

       		       		

        		//se realiza la update

        		Q02bTablaBDQ021HS00obj.update();

         	 }

         	 catch(Exception ex) {

         		java.io.StringWriter sw = new java.io.StringWriter();

         		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

         		ex.printStackTrace(pw);

         		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarGrupos: " + sw.getBuffer ().toString());

              throw ex;

         	 }

         	 finally {     

         		 try {

         			 Q02bTablaBDQ021HS00obj.freeResourcesNotConnection();	

         		 }

         		 catch(Exception ex) {

         			 if (tr.isTraceActive()) {

         				 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarGrupos: error liberando recursos");

         			 }  

         		 }  		  

         		 if (tr.isTraceActive()) {

         			 	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarGrupos: saliendo");                

                 }             

         	 }     

     } // fin modificarGrupos

     

     /**

      * Mtodo que llama a un DAO para insertar los roles para un grupo determinado

      * @param idGrupo nmero interno del grupo en bbdd.

      * @param listaRoles ArrayList con los nmeros internos de cada rol.

      * @throws Exception

      */

     public void insertarRolesGrupo(int niGrupo, ArrayList listaRoles) throws Exception {

     	Q02bTablaBDQ021KS00 tablaGruposRoles = null;

     	try{

     		if (tr.isTraceActive()){

       			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarRolesGrupo: entrando");

       		}    		

     		tablaGruposRoles = new Q02bTablaBDQ021KS00(this.getConnection());

     		//tablaProcesosRoles.setUSER(new Long(this.getUser()));     		

 			for (int i=0;i<listaRoles.size();i++){

 				tablaGruposRoles.setQ021HT00_NI(new Long(niGrupo));

 		    	tablaGruposRoles.setQ021GT00_NI(new Long((String) listaRoles.get(i)));

 	      		

 	      		//se realiza la insert

 		    	tablaGruposRoles.insert();

 			}

     	}catch(Exception ex){

 	        java.io.StringWriter sw = new java.io.StringWriter();

 	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

 	        ex.printStackTrace(pw);

 	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarRolesGrupo: " + sw.getBuffer ().toString());

 	        throw ex;                     

     	}finally{

  		    try{

  		    	tablaGruposRoles.freeResourcesNotConnection();

  		    }catch(Exception ex){

 			   if (tr.isTraceActive()){

 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarGruposRol: error liberando recursos");

 	   	   	   }  

  		    }  		  	       	

 	        if (tr.isTraceActive()){

 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGruposRol: saliendo.");

 	   		}

     	}

     }  

     

     /**

      * Mtodo que llama a un DAO para insertar los usuarios para un grupo determinado

      * @param idGrupo nmero interno del grupo en bbdd.

      * @param listaUsuarios ArrayList con los nmeros internos de cada usuario.

      * @throws Exception

      */

     public void insertarUsuariosGrupo(int niGrupo, ArrayList listaUsuarios) throws Exception {

     	Q02bTablaBDQ021JS00 tablaGruposUsuarios = null;

     	try{

     		if (tr.isTraceActive()){

       			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarUsuariosGrupo: entrando");

       		}    		

     		tablaGruposUsuarios = new Q02bTablaBDQ021JS00(this.getConnection());

     		//tablaProcesosRoles.setUSER(new Long(this.getUser()));     		

 			for (int i=0;i<listaUsuarios.size();i++){

 				tablaGruposUsuarios.setQ021HT00_NI(new Long(niGrupo));

 		    	tablaGruposUsuarios.setQ022FT00_NI(new Integer((String) listaUsuarios.get(i)));

 	      		

 	      		//se realiza la insert

 		    	tablaGruposUsuarios.insert();

 			}

     	}catch(Exception ex){

 	        java.io.StringWriter sw = new java.io.StringWriter();

 	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

 	        ex.printStackTrace(pw);

 	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarUsuariosGrupo: " + sw.getBuffer ().toString());

 	        throw ex;                     

     	}finally{

  		    try{

  		    	tablaGruposUsuarios.freeResourcesNotConnection();

  		    }catch(Exception ex){

 			   if (tr.isTraceActive()){

 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarGruposUsuario: error liberando recursos");

 	   	   	   }  

  		    }  		  	       	

 	        if (tr.isTraceActive()){

 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGruposUsuario: saliendo.");

 	   		}

     	}

     }    

     

     /**

      * Mtodo que devuelve una lista con los roles asignados a un grupo.

      * @param niGrupo nmero interno del grupo.

      * @return ArrayList con la lista de roles encontrados

      * @throws Exception

      */

     public ArrayList obtenerRolesSeleccionados(String niGrupo) throws Exception{

     	Q02bTablaBDQ021KS00 tablaBDRolesGrupos = null;

     	Q02bTablaBDQ021GS01V01 tablaBDRoles = null;

     	ResultSet rs = null;

     	ResultSet rs2 = null;

     	ArrayList listaRolesSeleccionados = new ArrayList();

     	

     	try{

 	    	if (tr.isTraceActive()){

 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRolesSeleccionados: entrando");

 	   		}

 	    	tablaBDRolesGrupos = new Q02bTablaBDQ021KS00(this.getConnection());

 	    		    	

 	    	tablaBDRolesGrupos.setDistinct(Q02bTablaBDQ021KS00.NOMCOLUMN_Q021GT00_NI);



 	    	tablaBDRolesGrupos.setQ021HT00_NI_WHERE(new Long(niGrupo));

 	    	

 	    	rs = tablaBDRolesGrupos.selectDistinct();

 	    	

       		while (rs.next()){

       			tablaBDRoles = new Q02bTablaBDQ021GS01V01(this.getConnection());	

       			tablaBDRoles.setQ021GT00_NI_WHERE(new Long(rs.getString(Q02bTablaBDQ021KS00.NOMCOLUMN_Q021GT00_NI)));

 				rs2 = tablaBDRoles.select();

 				tablaBDRoles.addResultSet(rs2);

 				if (rs2.next()) {

 					Q02bCodigoValor rol = new Q02bCodigoValor (rs2.getString(Q02bTablaBDQ021GS01V01.NOMCOLUMN_Q021GT00_NI),

 	      					rs2.getString(Q02bTablaBDQ021GS01V01.NOMCOLUMN_Q021GT00_DESC));

 					listaRolesSeleccionados.add(rol);

 				}

       		}       		

       		return listaRolesSeleccionados;

      	}catch(Exception ex){   	   

      		java.io.StringWriter sw = new java.io.StringWriter();

      		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

      		ex.printStackTrace(pw);

      		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerRolesSeleccionados: " + sw.getBuffer ().toString());

      		throw ex;

      	}finally{

      		try{

      			tablaBDRolesGrupos.freeResourcesNotConnection();	

      		}catch(Exception ex){

      			if (tr.isTraceActive()){

      				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerRolesSeleccionados: error liberando recursos");

  		   	   	}  

  			}  		

  			if (tr.isTraceActive()){

  				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRolesSeleccionados: saliendo");                

             }       	

      	}	

     }    

     

     /**

      * Mtodo que devuelve una lista con los roles no asignados a un grupo.

      * @param niGrupo nmero interno del grupo.

      * @return ArrayList con la lista de roles encontrados

      * @throws Exception

      */

     public ArrayList obtenerRolesNoSeleccionados(String niGrupo) throws Exception{

     	Q02bTablaBDQ021KS00 tablaBDRolesGrupos = null;

     	Q02bTablaBDQ021GS01V01 tablaBDRoles = null;

     	ResultSet rs = null;

     	ResultSet rs2 = null;

     	ArrayList listaRolesNoSeleccionados = new ArrayList();

     	

     	try{

 	    	if (tr.isTraceActive()){

 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRolesNoSeleccionados: entrando");

 	   		}

 	    	tablaBDRolesGrupos = new Q02bTablaBDQ021KS00(this.getConnection());

 	    	tablaBDRoles = new Q02bTablaBDQ021GS01V01(this.getConnection());	

 	    	

 	    	tablaBDRoles.setDistinct(Q02bTablaBDQ021KS00.NOMCOLUMN_Q021GT00_NI);

 	    	

 	    	StringBuffer where = new StringBuffer();

 	    	

 	    	where.append(Q02bTablaBDQ021KS00.NOMCOLUMN_Q021GT00_NI).append(" NOT IN (SELECT ").

 	    	append(Q02bTablaBDQ021KS00.NOMCOLUMN_Q021GT00_NI).append(" FROM ").

 	    	append(tablaBDRolesGrupos.getTableFrom()).append(" WHERE ").

 	    	append(Q02bTablaBDQ021KS00.NOMCOLUMN_Q021HT00_NI).append("=").append(niGrupo).append(")");

 	    	

 	    	rs = tablaBDRoles.selectDistinct(where.toString());

 	    	

       		while (rs.next()){	

       			tablaBDRoles.setQ021GT00_NI_WHERE(new Long(rs.getString(Q02bTablaBDQ021KS00.NOMCOLUMN_Q021GT00_NI)));

 				rs2 = tablaBDRoles.select();

 				tablaBDRoles.addResultSet(rs2);

 				if (rs2.next()) {

 					Q02bCodigoValor rol = new Q02bCodigoValor (rs2.getString(Q02bTablaBDQ021GS01V01.NOMCOLUMN_Q021GT00_NI),

 	      					rs2.getString(Q02bTablaBDQ021GS01V01.NOMCOLUMN_Q021GT00_DESC));

 					listaRolesNoSeleccionados.add(rol);

 				}

       		}

       		return listaRolesNoSeleccionados;

      	}catch(Exception ex){   	   

      		java.io.StringWriter sw = new java.io.StringWriter();

      		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

      		ex.printStackTrace(pw);

      		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerRolesNoSeleccionados: " + sw.getBuffer ().toString());

      		throw ex;

      	}finally{

      		try{

      			tablaBDRolesGrupos.freeResourcesNotConnection();	

      		}catch(Exception ex){

      			if (tr.isTraceActive()){

      				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerRolesNoSeleccionados: error liberando recursos");

  		   	   	}  

  			}  		

  			if (tr.isTraceActive()){

  				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRolesNoSeleccionados: saliendo");                

             }       	

      	}	

     }

     

     /**

      * Mtodo que devuelve una lista con los usuarios asignados a un grupo.

      * @param niGrupo nmero interno del grupo.

      * @return ArrayList con la lista de usuarios encontrados

      * @throws Exception

      */

     public ArrayList obtenerUsuariosSeleccionados(String niGrupo) throws Exception{

     	Q02bTablaBDQ021JS00 tablaBDUsuariosGrupos = null;

     	Q02bTablaBDQ022FS01V01 tablaBDUsuarios = null;

     	ResultSet rs = null;

     	ResultSet rs2 = null;

     	ArrayList listaUsuariosSeleccionados = new ArrayList();

     	

     	try{

 	    	if (tr.isTraceActive()){

 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuariosSeleccionados: entrando");

 	   		}

 	    	tablaBDUsuariosGrupos = new Q02bTablaBDQ021JS00(this.getConnection());

 	    		    	

 	    	tablaBDUsuariosGrupos.setDistinct(Q02bTablaBDQ021JS00.NOMCOLUMN_Q022FT00_NI);



 	    	tablaBDUsuariosGrupos.setQ021HT00_NI_WHERE(new Long(niGrupo));

 	    	

 	    	rs = tablaBDUsuariosGrupos.selectDistinct();

 	    	

       		while (rs.next()){

       			tablaBDUsuarios = new Q02bTablaBDQ022FS01V01(this.getConnection());	

       			tablaBDUsuarios.setQ022FT00_IDUSUARIO_WHERE(new Integer(rs.getString(Q02bTablaBDQ021JS00.NOMCOLUMN_Q022FT00_NI)));

 				rs2 = tablaBDUsuarios.select();

 				tablaBDUsuarios.addResultSet(rs2);

 				if (rs2.next()) {

 					Q02bCodigoValor usuario = new Q02bCodigoValor (rs2.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_IDUSUARIO),

 	      					rs2.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_NOMBRE_COMPLETO));

 					listaUsuariosSeleccionados.add(usuario);

 				}

       		}       		

       		return listaUsuariosSeleccionados;

      	}catch(Exception ex){   	   

      		java.io.StringWriter sw = new java.io.StringWriter();

      		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

      		ex.printStackTrace(pw);

      		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuariosSeleccionados: " + sw.getBuffer ().toString());

      		throw ex;

      	}finally{

      		try{

      			tablaBDUsuariosGrupos.freeResourcesNotConnection();	

      		}catch(Exception ex){

      			if (tr.isTraceActive()){

      				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuariosSeleccionados: error liberando recursos");

  		   	   	}  

  			}  		

  			if (tr.isTraceActive()){

  				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuariosSeleccionados: saliendo");                

             }       	

      	}	

     }    

     

     /**

      * Mtodo que devuelve una lista con los usuarios no asignados a un grupo.

      * @param niGrupo nmero interno del grupo.

      * @return ArrayList con la lista de usuarios encontrados

      * @throws Exception

      */

     public ArrayList obtenerUsuariosNoSeleccionados(String niGrupo) throws Exception{

    	 Q02bTablaBDQ021JS00 tablaBDUsuariosGrupos = null;

     	Q02bTablaBDQ022FS01V01 tablaBDUsuarios = null;

     	ResultSet rs = null;

     	ResultSet rs2 = null;

     	ArrayList listaUsuariosNoSeleccionados = new ArrayList();

     	

     	try{

 	    	if (tr.isTraceActive()){

 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuariosNoSeleccionados: entrando");

 	   		}

 	    	tablaBDUsuariosGrupos = new Q02bTablaBDQ021JS00(this.getConnection());

 	    	tablaBDUsuarios = new Q02bTablaBDQ022FS01V01(this.getConnection());	

 	    	

 	    	tablaBDUsuarios.setDistinct(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_IDUSUARIO);

 	    	

 	    	StringBuffer where = new StringBuffer();

 	    	

 	    	where.append(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_IDUSUARIO).append(" NOT IN (SELECT ").

 	    	append(Q02bTablaBDQ021JS00.NOMCOLUMN_Q022FT00_NI).append(" FROM ").

 	    	append(tablaBDUsuariosGrupos.getTableFrom()).append(" WHERE ").

 	    	append(Q02bTablaBDQ021JS00.NOMCOLUMN_Q021HT00_NI).append("=").append(niGrupo).append(")");

 	    	

 	    	rs = tablaBDUsuarios.selectDistinct(where.toString());

 	    	

       		while (rs.next()){	

       			tablaBDUsuarios.setQ022FT00_IDUSUARIO_WHERE(new Integer(rs.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_IDUSUARIO)));

 				rs2 = tablaBDUsuarios.select();

 				tablaBDUsuarios.addResultSet(rs2);

 				if (rs2.next()) {

 					Q02bCodigoValor usuario = new Q02bCodigoValor (rs2.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_IDUSUARIO),

 	      					rs2.getString(Q02bTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_NOMBRE_COMPLETO));

 					listaUsuariosNoSeleccionados.add(usuario);

 				}

       		}

       		return listaUsuariosNoSeleccionados;

      	}catch(Exception ex){   	   

      		java.io.StringWriter sw = new java.io.StringWriter();

      		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

      		ex.printStackTrace(pw);

      		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuariosNoSeleccionados: " + sw.getBuffer ().toString());

      		throw ex;

      	}finally{

      		try{

      			tablaBDUsuariosGrupos.freeResourcesNotConnection();	

      		}catch(Exception ex){

      			if (tr.isTraceActive()){

      				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuariosNoSeleccionados: error liberando recursos");

  		   	   	}  

  			}  		

  			if (tr.isTraceActive()){

  				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuariosNoSeleccionados: saliendo");                

             }       	

      	}	

     }

     

     /**

      * Mtodo que borra los roles asignados a un grupo determinado.

      * @param niGrupo

      * @throws Exception

      */

     public void borrarRolesGrupo(String niGrupo) throws Exception{

     	Q02bTablaBDQ021KS00 tablaBDRolesGrupos = null;

     	try{

 	    	if (tr.isTraceActive()){

 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarRolesGrupo: entrando");

 	   		}

 	    	tablaBDRolesGrupos = new Q02bTablaBDQ021KS00(this.getConnection());



 	    	tablaBDRolesGrupos.setQ021HT00_NI_WHERE(new Long(niGrupo));

       		

       		//se realiza la delete

 	    	tablaBDRolesGrupos.delete();

       			      		

      	}catch(Exception ex){   	   

      		java.io.StringWriter sw = new java.io.StringWriter();

      		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

      		ex.printStackTrace(pw);

      		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarRolesGrupo: " + sw.getBuffer ().toString());

      		throw ex;

      	}finally{

      		try{

      			tablaBDRolesGrupos.freeResourcesNotConnection();	

      		}catch(Exception ex){

      			if (tr.isTraceActive()){

      				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarRolesGrupo: error liberando recursos");

  		   	   	}  

  			}  		

  			if (tr.isTraceActive()){

  				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarRolesGrupo: saliendo");                

             }       	

      	}	

     }//fin borrarRolesGrupo

     

     /**

      * Mtodo que borra los usuarios asignados a un grupo determinado.

      * @param niGrupo

      * @throws Exception

      */

     public void borrarUsuariosGrupo(String niGrupo) throws Exception{

     	Q02bTablaBDQ021JS00 tablaBDUsuariosGrupos = null;

     	try{

 	    	if (tr.isTraceActive()){

 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarUsuariosGrupo: entrando");

 	   		}

 	    	tablaBDUsuariosGrupos = new Q02bTablaBDQ021JS00(this.getConnection());



 	    	tablaBDUsuariosGrupos.setQ021HT00_NI_WHERE(new Long(niGrupo));

       		

       		//se realiza la delete

 	    	tablaBDUsuariosGrupos.delete();

       			      		

      	}catch(Exception ex){   	   

      		java.io.StringWriter sw = new java.io.StringWriter();

      		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

      		ex.printStackTrace(pw);

      		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarUsuariosGrupo: " + sw.getBuffer ().toString());

      		throw ex;

      	}finally{

      		try{

      			tablaBDUsuariosGrupos.freeResourcesNotConnection();	

      		}catch(Exception ex){

      			if (tr.isTraceActive()){

      				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarUsuariosGrupo: error liberando recursos");

  		   	   	}  

  			}  		

  			if (tr.isTraceActive()){

  				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarUsuariosGrupo: saliendo");                

             }       	

      	}	

     }//fin borrarUsuariosGrupo

     

     /**

      * Mtodo que asigna un grupo a un rol.

      * @param niRol

      * @param niGrupo

      * @throws Exception

      */

     public void insertarGrupoRol(String idRol, String niGrupo) throws Exception{

     	Q02bTablaBDQ021KS00 tablaBDRolesGrupos = null;

     	try{

 	    	if (tr.isTraceActive()){

 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGrupoRol: entrando");

 	   		}

 	    	tablaBDRolesGrupos = new Q02bTablaBDQ021KS00(this.getConnection());



          	//se aaden los datos a insertar

 	    	tablaBDRolesGrupos.setQ021GT00_NI(new Long(idRol));

 	    	tablaBDRolesGrupos.setQ021HT00_NI(new Long(niGrupo));

       		

       		//se realiza la insert

 	    	tablaBDRolesGrupos.insert();

       			      		

      	}catch(Exception ex){   	   

      		java.io.StringWriter sw = new java.io.StringWriter();

      		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

      		ex.printStackTrace(pw);

      		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarGrupoRol: " + sw.getBuffer ().toString());

      		throw ex;

      	}finally{

      		try{

      			tablaBDRolesGrupos.freeResourcesNotConnection();	

      		}catch(Exception ex){

      			if (tr.isTraceActive()){

      				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarGrupoRol: error liberando recursos");

  		   	   	}  

  			}  		

  			if (tr.isTraceActive()){

  				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGrupoRol: saliendo");                

             }       	

      	}	

     }//fin insertarGrupoRol

     

     /**

      * Mtodo que asigna un grupo a un usuario.

      * @param niUsuario

      * @param niGrupo

      * @throws Exception

      */

     public void insertarGrupoUsuario(String idUsuario, String niGrupo) throws Exception{

     	Q02bTablaBDQ021JS00 tablaBDUsuariosGrupos = null;

     	try{

 	    	if (tr.isTraceActive()){

 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGrupoUsuario: entrando");

 	   		}

 	    	tablaBDUsuariosGrupos = new Q02bTablaBDQ021JS00(this.getConnection());



          	//se aaden los datos a insertar

 	    	tablaBDUsuariosGrupos.setQ022FT00_NI(new Integer(idUsuario));

 	    	tablaBDUsuariosGrupos.setQ021HT00_NI(new Long(niGrupo));

       		

       		//se realiza la insert

 	    	tablaBDUsuariosGrupos.insert();

       			      		

      	}catch(Exception ex){   	   

      		java.io.StringWriter sw = new java.io.StringWriter();

      		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

      		ex.printStackTrace(pw);

      		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarGrupoUsuario: " + sw.getBuffer ().toString());

      		throw ex;

      	}finally{

      		try{

      			tablaBDUsuariosGrupos.freeResourcesNotConnection();	

      		}catch(Exception ex){

      			if (tr.isTraceActive()){

      				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarGrupoUsuario: error liberando recursos");

  		   	   	}  

  			}  		

  			if (tr.isTraceActive()){

  				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGrupoUsuario: saliendo");                

             }       	

      	}	

     }//fin insertarGrupoUsuario



}

