package q02b.exe.grupos.beans;



import java.util.ArrayList;



import q02b.exe.arquitectura.beans.Q02bBaseBean;

import q02b.exe.grupos.dataobjects.Q02bGruposDataBaseDAO;

import q02b.exe.grupos.valueobjects.Q02bGrupos;

//import q02b.exe.procesos.dataobjects.Q02bProcesosDataBaseDAO;

//import q02b.exe.procesos.valueobjects.Q02bProcesos;



import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;



   

public class Q02bGruposBean extends Q02bBaseBean{

	private static final long serialVersionUID = 5474311672836163390L;

	protected Q02bGruposDataBaseDAO daoGrupos = null;

	final static String	LISTA_GRUPOS = "listaGrupos";

	

	/** Constructor vacio */

    public Q02bGruposBean() {

        super();

    }



    /**

     * Funcin que recupera los grupos

     * @return listaGrupos  -  Listado de grupos obtenidos

     * @throws Exception

     */

	public ArrayList obtenerGrupos(Q02bGrupos filtroGrupos) throws Exception 

	{

		 if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupos: entrando.");

	   		}  	  

		ArrayList listaGrupos = new ArrayList();

		boolean error = false;

		

		try{

			//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoGrupos = new Q02bGruposDataBaseDAO(this.getConn());				

			

			listaGrupos = daoGrupos.obtenerGrupos(filtroGrupos);

            return listaGrupos;              

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGrupos: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoGrupos.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGrupos: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupos: saliendo.");

	   		}

 	  	}

 	  } //fin obtenerGrupos 

	

	

	/**

     * Mtodo que dado el nmero interno del grupo 

     * recupera de la BBDD los datos de dicho grupo.

     * @param niGrupo

     * @return Grupo

     */

	/*public Q02bGrupos obtenerGrupo(String niGrupo)throws Exception{  	 

	    	boolean error = false;

	    	Q02bGrupos grupo = null;

	  	  	try  	  {

	  	  		if (tr.isTraceActive()){

	  	  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupo, ** niGrupo bean=" + niGrupo + " *** entrando");                

	  	  		}

	  	  		

	  	  		//se abre la conexin

	  	  		abrirConexion();

	  	  		

	  	  		//se instancia el dao pasandole la conexin			

	  	  		daoGrupos = new Q02bGruposDataBaseDAO(this.getConn());

	  	  		

	  	  		//Segmento tecnico 

	  			//daoPlazos.setUser(this.getAutenticador().getUser());

	  			//daoPlazos.setIdioma(this.getAutenticador().getIdioma());

	  			

	  	  		//se llama al mtodo del dao que recupera el plazo

	  	  		grupo = daoGrupos.obtenerGrupo(niGrupo);

	  	  		

	  	  		//se devuelve el cuestionario recuperado

	  	  		return grupo;

	  	  }catch(Exception ex){

	  		  	error= true;

	  		  	java.io.StringWriter sw = new java.io.StringWriter();

	          	java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          	ex.printStackTrace(pw);

	          	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGrupo: " + sw.getBuffer ().toString());

	          	throw ex;                     

	 	  }finally{

	 		  	try{

	 		  		daoGrupos.freeResourcesNotConnection();

	 		  	}catch(Exception ex){

				   if (tr.isTraceActive()){

					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGrupo: error liberando recursos");

		   	   	   }  

	 		  	}  		 

	 		  	//se cierra la conexin  

	 		  	cerrarConexion(error);	       	

		        if (tr.isTraceActive()){

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupo: saliendo.");

		   		}

	 	  }

	    }//fin obtenerGrupo*/

	

	 public Q02bGrupos obtenerGrupoModificacion(String niGrupo) throws Exception{

	    	boolean error = false;

	    	Q02bGrupos grupo = new Q02bGrupos();

	    	try{

	    		if (tr.isTraceActive()){

	      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupoModificacion: entrando");

	      		}

				abrirConexion();			

				this.daoGrupos = new Q02bGruposDataBaseDAO(this.getConn());

	            //Pasamos los perfiles del usuario e idioma

				this.daoGrupos.setUser(this.autenticador.getUser());

				this.daoGrupos.setIdioma(this.autenticador.getIdioma());

				

				grupo = daoGrupos.obtenerGrupo(niGrupo);

				

	            // Obtenemos los roles seleccionados para el grupo

				grupo.setListaRolesSeleccionados(this.obtenerRolesSeleccionados(niGrupo));

				

				// Obtenemos los roles no seleccionados

				grupo.setListaRoles(this.obtenerRolesNoSeleccionados(niGrupo));

				

				//Obtenemos los usuarios seleccionados para el grupo

				grupo.setListaUsuariosSeleccionados(this.obtenerUsuariosSeleccionados(niGrupo));

				

				//Obtenemos los usuarios no seleccionados

				grupo.setListaUsuarios(this.obtenerUsuariosNoSeleccionados(niGrupo));

				

				return grupo;

	    	}catch(Exception ex){

		 		error= true;

		        java.io.StringWriter sw = new java.io.StringWriter();

		        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

		        ex.printStackTrace(pw);

		        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGrupoModificacion: " + sw.getBuffer ().toString());

		        throw ex;                     

	    	}finally{

	    		try{

	    			this.daoGrupos.freeResourcesNotConnection();

	    		}catch(Exception ex){

	    		   if (tr.isTraceActive()){

	    			   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGrupoModificacion: error liberando recursos");

	    		   }  

	    		}  		 

	    	 	//se cierra la conexin  

	    	 	cerrarConexion(error);	       	

	    		if (tr.isTraceActive()){

	    			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupoModificacion saliendo.");

	    		}

	    	 }

	    }

	 

	 /**

	     * Mtodo que llama a un DAO para obtener la lista de roles seleccionados para un grupo

	     * @param niGrupo nmero interno del grupo en bbdd.

	     * @return ArrayList con la lista de roles asignados a un grupo

	     * @throws Exception

	     */

	    private ArrayList obtenerRolesSeleccionados(String niGrupo) throws Exception{

	    	try{

	    		if (tr.isTraceActive()){

	      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRolesSeleccionados: entrando");

	      		}

	    		this.daoGrupos = new Q02bGruposDataBaseDAO(this.getConn());

	    		this.daoGrupos.setUser(this.autenticador.getUser());

	    		this.daoGrupos.setIdioma(this.autenticador.getIdioma());

				

				return daoGrupos.obtenerRolesSeleccionados(niGrupo);

	    	}catch(Exception ex){

		        java.io.StringWriter sw = new java.io.StringWriter();

		        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

		        ex.printStackTrace(pw);

		        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerRolesSeleccionados: " + sw.getBuffer ().toString());

		        throw ex;                     

	    	}finally{

	 		    try{

	 		    	this.daoGrupos.freeResourcesNotConnection();

	 		    }catch(Exception ex){

				   if (tr.isTraceActive()){

					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerRolesSeleccionados: error liberando recursos");

		   	   	   }  

	 		    }  		         	

		        if (tr.isTraceActive()){

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRolesSeleccionados: saliendo.");

		   		}

	    	}

	    }  

	    

	    /**

	     * Mtodo que llama a un DAO para obtener la lista de roles no seleccionados para un grupo.

	     * @param niGrupo

	     * @return ArrayList con la lista de roles no asignados a un grupo.

	     * @throws Exception

	     */

	    private ArrayList obtenerRolesNoSeleccionados(String niGrupo) throws Exception{

	    	try{

	    		if (tr.isTraceActive()){

	      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRolesNoSeleccionados: entrando");

	      		}

	    		this.daoGrupos = new Q02bGruposDataBaseDAO(this.getConn());

	    		this.daoGrupos.setUser(this.autenticador.getUser());

	    		this.daoGrupos.setIdioma(this.autenticador.getIdioma());

				

				return this.daoGrupos.obtenerRolesNoSeleccionados(niGrupo);

	    	}catch(Exception ex){

		        java.io.StringWriter sw = new java.io.StringWriter();

		        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

		        ex.printStackTrace(pw);

		        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerRolesNoSeleccionados: " + sw.getBuffer ().toString());

		        throw ex;                     

	    	}finally{

	 		    try{

	 		    	this.daoGrupos.freeResourcesNotConnection();

	 		    }catch(Exception ex){

				   if (tr.isTraceActive()){

					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerRolesNoSeleccionados: error liberando recursos");

		   	   	   }  

	 		    }  		         	

		        if (tr.isTraceActive()){

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRolesNoSeleccionados: saliendo.");

		   		}

	    	}

	    }

	    

	    /**

	     * Mtodo que llama a un DAO para obtener la lista de usuarios seleccionados para un grupo

	     * @param niGrupo nmero interno del grupo en bbdd.

	     * @return ArrayList con la lista de usuarios asignados a un grupo

	     * @throws Exception

	     */

	    private ArrayList obtenerUsuariosSeleccionados(String niGrupo) throws Exception{

	    	try{

	    		if (tr.isTraceActive()){

	      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuariosSeleccionados: entrando");

	      		}

	    		this.daoGrupos = new Q02bGruposDataBaseDAO(this.getConn());

	    		this.daoGrupos.setUser(this.autenticador.getUser());

	    		this.daoGrupos.setIdioma(this.autenticador.getIdioma());

				

				return daoGrupos.obtenerUsuariosSeleccionados(niGrupo);

	    	}catch(Exception ex){

		        java.io.StringWriter sw = new java.io.StringWriter();

		        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

		        ex.printStackTrace(pw);

		        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuariosSeleccionados: " + sw.getBuffer ().toString());

		        throw ex;                     

	    	}finally{

	 		    try{

	 		    	this.daoGrupos.freeResourcesNotConnection();

	 		    }catch(Exception ex){

				   if (tr.isTraceActive()){

					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuariosSeleccionados: error liberando recursos");

		   	   	   }  

	 		    }  		         	

		        if (tr.isTraceActive()){

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuariosSeleccionados: saliendo.");

		   		}

	    	}

	    }  

	    

	    /**

	     * Mtodo que llama a un DAO para obtener la lista de usuarios no seleccionados para un grupo.

	     * @param niGrupo

	     * @return ArrayList con la lista de usuarios no asignados a un grupo.

	     * @throws Exception

	     */

	    private ArrayList obtenerUsuariosNoSeleccionados(String niGrupo) throws Exception{

	    	try{

	    		if (tr.isTraceActive()){

	      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuariosNoSeleccionados: entrando");

	      		}

	    		this.daoGrupos = new Q02bGruposDataBaseDAO(this.getConn());

	    		this.daoGrupos.setUser(this.autenticador.getUser());

	    		this.daoGrupos.setIdioma(this.autenticador.getIdioma());

				

				return this.daoGrupos.obtenerUsuariosNoSeleccionados(niGrupo);

	    	}catch(Exception ex){

		        java.io.StringWriter sw = new java.io.StringWriter();

		        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

		        ex.printStackTrace(pw);

		        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuariosNoSeleccionados: " + sw.getBuffer ().toString());

		        throw ex;                     

	    	}finally{

	 		    try{

	 		    	this.daoGrupos.freeResourcesNotConnection();

	 		    }catch(Exception ex){

				   if (tr.isTraceActive()){

					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuariosNoSeleccionados: error liberando recursos");

		   	   	   }  

	 		    }  		         	

		        if (tr.isTraceActive()){

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuariosNoSeleccionados: saliendo.");

		   		}

	    	}

	    }

	

	/**

     * Funcin que inserta los datos del grupo pasado como parmetro en la BBDD

     * @param grupo - Datos del grupo a insertar

     * @throws Exception

     */

      public void insertarGrupos(Q02bGrupos grupo) throws Exception {   	 

    	boolean error = false;

    	int idGrupo = 0;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGrupos: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			

			//se instancia el dao pasandole la conexin			

			daoGrupos = new Q02bGruposDataBaseDAO(this.getConn());

			

			//se pasan los parmetros de usuario e idioma

			daoGrupos.setUser(this.autenticador.getUser());

			daoGrupos.setIdioma(this.autenticador.getIdioma());

			

			//se llama la metodo del DAO que realiza la insert

			idGrupo = daoGrupos.insertarGrupos(grupo);

			

			//se llama al metodo para insertar los roles y los grupos

			daoGrupos.insertarRolesGrupo(idGrupo, grupo.getListaRolesSeleccionados());

			

			//se llama al metodo para insertar los usuarios y los grupos

			daoGrupos.insertarUsuariosGrupo(idGrupo, grupo.getListaUsuariosSeleccionados());

    	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarGrupos: " + sw.getBuffer ().toString());

	        throw ex;                     

 	  }finally{

 		    try{

 		    	daoGrupos.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarGrupos: error liberando recursos");

	   	   	   }  

 		    }  		 

 		  	//se cierra la conexin  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGrupos: saliendo.");

	   		}

 	  }

    }//fin insertarGrupos

      

      /**

       * Funcin que borra el grupo pasado como parmetro de la BBDD 

       * @param niGrupo - nmero interno del grupo a borrar

       * @throws Exception

       */

    public void borrarGrupos(String niGrupo) throws Exception { 

    		if (tr.isTraceActive()){

  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarGrupos: entrando");

    		}

    		boolean error = false;

    		try{

    			//se abre la conexin

    			abrirConexion();

   			

    			//se instancia el dao pasandole la conexin			

    			daoGrupos = new Q02bGruposDataBaseDAO(this.getConn());

  			

    			//Segmento tecnico 

    			//daoPlazos.setUser(this.getAutenticador().getUser());

    			//daoPlazos.setIdioma(this.getAutenticador().getIdioma()); 

    			daoGrupos.borrarRolesGrupo(niGrupo);

    			daoGrupos.borrarUsuariosGrupo(niGrupo);

				daoGrupos.borrarGrupos(niGrupo);   		 	  

    		}catch(Exception ex){

    			error= true;

    			java.io.StringWriter sw = new java.io.StringWriter();

    			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    			ex.printStackTrace(pw);

    			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarGrupos: " + sw.getBuffer ().toString());

    			throw ex;           

  	  

    		}finally{

    			try{

    				daoGrupos.freeResourcesNotConnection();

    			}catch(Exception ex){

    				if (tr.isTraceActive()){

    					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarGrupos: error liberando recursos");

  	   	   	   		}  

    			}  		 

   		  		//se cierra la conexin  

   		  		cerrarConexion(error);	       	

   		  		if (tr.isTraceActive()){

   		  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarGrupos: saliendo.");

   		  		}

    		}

    }//fin borrarGrupos

    

    /**

     * Funcin que modifica los datos del grupo pasado como parmetro en la BBDD

     * @param grupo - Datos del grupo a modificar 

     * @throws Exception

     */

    public void modificarGrupos(Q02bGrupos grupo) throws Exception {

   	 if (tr.isTraceActive()){

  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarGrupos: entrando");

  		}

   	 boolean error = false;

   	try{

   		//se abre la conexin

   		abrirConexion();

   		//se instancia el dao pasandole la conexin			

   		daoGrupos = new Q02bGruposDataBaseDAO(this.getConn());

		

   		//Segmento tecnico 

		//daoPlazos.setUser(this.getAutenticador().getUser());

   		//daoPlazos.setIdioma(this.getAutenticador().getIdioma()); 



   		//se llamaa la metodo del DAO que realiza la update

   		daoGrupos.modificarGrupos(grupo);

   		

   		//modificamos los roles asignados al grupo

		this.modificarRolesGrupo(grupo.getNiGrupo(),grupo.getListaRolesSeleccionados());

		

		//modificamos los usuarios asignados al grupo

		this.modificarUsuariosGrupo(grupo.getNiGrupo(),grupo.getListaUsuariosSeleccionados());

   		    	

   	}catch(Exception ex){

		 error= true;

         java.io.StringWriter sw = new java.io.StringWriter();

         java.io.PrintWriter pw = new java.io.PrintWriter(sw);

         ex.printStackTrace(pw);

         tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarGrupos: " + sw.getBuffer ().toString());

         throw ex;                     

	  }finally{

		 try{

			daoGrupos.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarGrupos: error liberando recursos");

	   	   	   }  

		   }  		 

		  	//se cierra la conexin  

		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarGrupos: saliendo.");

	   		}

	  }

   }//modificarGrupos

    

    /**

     * Mtodo que llama a un DAO para modificar los roles para un grupo determinado

     * @param niGrupo nmero interno del grupo en bbdd.

     * @param listaRoles ArrayList con los nmeros internos de cada rol.

     * @throws Exception

     */

    private void modificarRolesGrupo(String niGrupo, ArrayList listaRoles) throws Exception {

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarRolesGrupo: entrando");

      		}

    		this.daoGrupos = new Q02bGruposDataBaseDAO(this.getConn());

    		this.daoGrupos.setUser(this.autenticador.getUser());

			this.daoGrupos.setIdioma(this.autenticador.getIdioma());

			

			//Primero eliminamos los que tena asignados

			this.daoGrupos.borrarRolesGrupo(niGrupo);			

			

			// Ahora insertamos los nuevos

			for (int i=0;i<listaRoles.size();i++){

				this.daoGrupos.insertarGrupoRol((String)listaRoles.get(i),niGrupo);

			}

    	}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarRolesGrupo: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

 		    try{

 		    	this.daoGrupos.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarRolesGrupo: error liberando recursos");

	   	   	   }  

 		    }  		  	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarRolesGrupo: saliendo.");

	   		}

    	}

    }//fin modificarRolesGrupo

    

    /**

     * Mtodo que llama a un DAO para modificar los usuarios para un grupo determinado

     * @param niGrupo nmero interno del grupo en bbdd.

     * @param listaUsuarios ArrayList con los nmeros internos de cada usuario.

     * @throws Exception

     */

    private void modificarUsuariosGrupo(String niGrupo, ArrayList listaUsuarios) throws Exception {

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarUsuariosGrupo: entrando");

      		}

    		this.daoGrupos = new Q02bGruposDataBaseDAO(this.getConn());

    		this.daoGrupos.setUser(this.autenticador.getUser());

			this.daoGrupos.setIdioma(this.autenticador.getIdioma());

			

			//Primero eliminamos los que tena asignados

			this.daoGrupos.borrarUsuariosGrupo(niGrupo);			

			

			// Ahora insertamos los nuevos

			for (int i=0;i<listaUsuarios.size();i++){

				this.daoGrupos.insertarGrupoUsuario((String)listaUsuarios.get(i),niGrupo);

			}

    	}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarUsuariosGrupo: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

 		    try{

 		    	this.daoGrupos.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarUsuariosGrupo: error liberando recursos");

	   	   	   }  

 		    }  		  	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarUsuariosGrupo: saliendo.");

	   		}

    	}

    }//fin modificarUsuariosGrupo

    

    /**

     * Mtodo que llama a un DAO para obtener un objeto Q02bGrupos con los datos para la consulta.

     * @param niGrupo nmero interno del grupo en bbdd.

     * @return Objeto Q02bGrupo con los datos del grupo

     * @throws Exception

     */

    public Q02bGrupos obtenerGrupoConsulta (String niGrupo) throws Exception {		 	 

		//Definicin de variables que no se van a modificar

		final String 	TRACE_METODO 	= ":obtenerGrupo:";

		//Definicin de dems variables

		Q02bGrupos grupo = new Q02bGrupos();

		boolean	error = false;

		

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando.");

	   		}  

			//Se abre la conexin

			abrirConexion();

			//Se instancia el dao pasandole la conexin			

			daoGrupos = new Q02bGruposDataBaseDAO(this.getConn());

			//Se pasan los parmetros de usuario e idioma

			daoGrupos.setUser(this.autenticador.getUser());

			daoGrupos.setIdioma(this.autenticador.getIdioma());

						

			grupo = daoGrupos.obtenerGrupo(niGrupo);		

            

            // Obtenemos los roles seleccionados para el grupo

			grupo.setListaRolesSeleccionados(this.obtenerRolesSeleccionados(niGrupo));

			

			 // Obtenemos los usuarios seleccionados para el grupo

			grupo.setListaUsuariosSeleccionados(this.obtenerUsuariosSeleccionados(niGrupo));

			

			return grupo;              

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter 	sw = new java.io.StringWriter();

          java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoGrupos.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + " error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO  + " saliendo.");

	   		}

 	  	}

 	  }

}