package q02b.exe.ejecucionValidaciones.dataobjects;

import java.sql.Connection;
import java.util.ArrayList;

import q02b.exe.arquitectura.dataobjects.Q02bDataBaseDAO;
import q02b.exe.ejecucionValidaciones.valueobjects.Q02bEjecucionValidaciones;
import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ0299S00;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;



public class Q02bEjecucionValidacionesDataBaseDAO extends Q02bDataBaseDAO{
	private static final long serialVersionUID = -8520551641771839103L;
	private static Q70Traza tr = Q70Traza.getSingleton();
	private static final String COMPONENTE = "DAO_ACCESO_DATOS";
	//private static final String RECURSOS_EJECUCION_VALIDACIONES = "q02brecursosCuestionarios";

	public Q02bEjecucionValidacionesDataBaseDAO() {
        super();                
    }

    
    public Q02bEjecucionValidacionesDataBaseDAO(Connection conn) {
    	super(conn);     
    }
    
    // -------------------- INI - COMPROBAR LISTA ----------------
    /**
     * Devuelve un int del numero de registros que hay en la tabla
     * @return int
     * @generated
     */
    public int comprobarListaEjecucionValidaciones()
        throws Exception {
        final String TRACE_METODO = nombreClaseSinPackage +
            ":comprobarListaEjecucionValidaciones";

        if (tr.isTraceActive()) {
            tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +
                ": entrando en comprobarListaEjecucionValidaciones de Q02bEjecucionValidacionesDataBaseDAO");
        }

        //se instancian los objetos necesarios para realizar la consulta.	
        java.sql.ResultSet rs = null; // result set
        Q02bTablaBDQ0299S00 objTBD = null; // Objeto TablasBD de vista
        
        int numReg = 0;

        try {
        	
        	//se instancia la clase del tablasBD a llamar pasandole la conexion
            objTBD = new Q02bTablaBDQ0299S00(this.getConnection());
        	
        	//select count para ver cuantos registros hay en la tabla
            rs = objTBD.getCountValidaciones();
        	
            objTBD.addResultSet(rs);
            
            if (rs.next()){          		 
         	 	 numReg = rs.getInt(1);
         	}
            
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +
                    " : En comprobarListaEjecucionValidaciones del DAO, numReg = "+numReg);
            }
         
         }catch(Exception ex){
             java.io.StringWriter sw = new java.io.StringWriter();
             java.io.PrintWriter pw = new java.io.PrintWriter(sw);
             ex.printStackTrace(pw);
             tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCountValidaciones: " + sw.getBuffer ().toString());
             throw ex;
        } 
         finally {
            try {
                objTBD.freeResourcesNotConnection();
            } catch (Exception ex) {
                if (tr.isTraceActive()) {
                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR,
                        TRACE_METODO + ": error liberando recursos");
                }
            }
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.INFO,
                    TRACE_METODO + ": saliendo");
            }
        }
        return numReg;
    }
    // -------------------- FIN - OBTENER LISTA	 --------------------- 
    
    
//  -------------------- INI - PROCEDURE EJECUCION VALIDACIONES	 ---------------------    
public void procedureEjecucionValidaciones(Q02bEjecucionValidaciones filtroVO) throws Exception
{
	final String TRACE_METODO = nombreClaseSinPackage +
    ":procedureEjecucionValidaciones";
	if (tr.isTraceActive()) {
	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +
	        ": entrando ");
	}
	
	Q02bTablaBDQ0299S00 objTBD = null; // Objeto TablasBD de vista
	
	try {
    	//se instancia la clase del tablasBD a llamar pasandole la conexion
        objTBD = new Q02bTablaBDQ0299S00(this.getConnection());
    	
    	objTBD.procedureEjecucionValidaciones(filtroVO);
    }
    catch(Exception e)
    {
        e.printStackTrace();
    }
    if (tr.isTraceActive()) {
	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +
	        ": salimos");
	}
}
//-------------------- FIN - PROCEDURE EJECUCION VALIDACIONES	 --------------------- 
// -------------------- INI - DELETE TABLA Q0299S00 ----------------
public void deleteTablaQ0299S00()
    throws Exception {
    final String TRACE_METODO = nombreClaseSinPackage +
        ":deleteTablaQ0299S00";
    if (tr.isTraceActive()) {
        tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +
            ": entrando en deleteTablaQ0299S00 de Q02bEjecucionValidacionesDataBaseDAO");
    }
    Q02bTablaBDQ0299S00 objTBD = null; // Objeto TablasBD de vista
    try {
    	
    	//se instancia la clase del tablasBD a llamar pasandole la conexion
        objTBD = new Q02bTablaBDQ0299S00(this.getConnection());
    	
        objTBD.deleteTablaQ0299S00();
     
     }catch(Exception ex){
         java.io.StringWriter sw = new java.io.StringWriter();
         java.io.PrintWriter pw = new java.io.PrintWriter(sw);
         ex.printStackTrace(pw);
         tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":deleteTablaQ0299S00: " + sw.getBuffer ().toString());
         throw ex;
    } 
     finally {
        try {
            objTBD.freeResourcesNotConnection();
        } catch (Exception ex) {
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR,
                    TRACE_METODO + ": error liberando recursos");
            }
        }
        if (tr.isTraceActive()) {
            tr.trace(COMPONENTE, Q70TraceLevel.INFO,
                TRACE_METODO + ": saliendo");
        }
    }
   
}
// -------------------- FIN - DELETE TABLA Q0299S00 --------------------- 
//-------------------- INI - OBTENER LISTA ----------------
/**
 * Devuelve una lista segun un filtro
 * @param filtro - Q02bEjecucionValidaciones
 * @return ArrayList
 */
public ArrayList obtenerListaEjecucionValidaciones(Q02bEjecucionValidaciones filtro)
    throws Exception {
    final String TRACE_METODO = nombreClaseSinPackage +
        ":obtenerListaEjecucionValidaciones";
    if (tr.isTraceActive()) {
        tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +
            ": entrando");
    }
    //se instancian los objetos necesarios para realizar la consulta.	
    java.sql.ResultSet rs = null; // result set
    ArrayList lista = new ArrayList(); // lista de VO
    Q02bTablaBDQ0299S00 objTBD = null; // Objeto TablasBD de vista
    Q02bEjecucionValidaciones regVO = null; // VO
    String colPK = "";
    try {
        //se instancia la clase del tablasBD a llamar pasandole la conexion
        objTBD = new Q02bTablaBDQ0299S00(this.getConnection());
         //Hacemos primero un select count para ver si vaciamos la lista
        rs = objTBD.getCountValidaciones();
        int numReg = 0;
    	
        objTBD.addResultSet(rs);
        
        if (rs.next()){          		 
     	 	 numReg = rs.getInt(1);
     	}
        
        if (tr.isTraceActive()) {
            tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +
                " : En comprobarListaEjecucionValidaciones del DAO, numReg = "+numReg);
        }
        if(numReg > 0){
        	//se realiza la select
            rs = objTBD.selectValidaciones();
            objTBD.addResultSet(rs);
            
            //se trata el resultado obtenido a?adiendolo a la lista de salida
            while (rs.next()) {
                regVO = new Q02bEjecucionValidaciones();
                //se cargan en el objeto los datos recuperados            	 
                regVO.setIdValidacionBD(rs.getString(Q02bTablaBDQ0299S00.NOMCOLUMN_Q0299T00_VALIDACION));
                regVO.setTextoBD(rs.getString(Q02bTablaBDQ0299S00.NOMCOLUMN_Q0299T00_TEXTO));
                regVO.setGrupoBD(rs.getString(Q02bTablaBDQ0299S00.NOMCOLUMN_Q0299T00_GRUPO));
                
                regVO.setCuesBD(rs.getString(Q02bTablaBDQ0299S00.NOMCOLUMN_Q0299T00_CUES));
                
                regVO.setAnoBD(rs.getString(Q02bTablaBDQ0299S00.NOMCOLUMN_Q0299T00_ANO));
                
                regVO.setMesBD(rs.getString(Q02bTablaBDQ0299S00.NOMCOLUMN_Q0299T00_MES));
                
                regVO.setCodprovBD(rs.getString(Q02bTablaBDQ0299S00.NOMCOLUMN_Q0299T00_CODPROV));
                
                regVO.setNomprovBD(rs.getString(Q02bTablaBDQ0299S00.NOMCOLUMN_Q0299T00_NOMPROV));
                
                regVO.setCodmunBD(rs.getString(Q02bTablaBDQ0299S00.NOMCOLUMN_Q0299T00_CODMUN));
                
                regVO.setNommunBD(rs.getString(Q02bTablaBDQ0299S00.NOMCOLUMN_Q0299T00_NOMMUN));
                
                regVO.setLicenciaBD(rs.getString(Q02bTablaBDQ0299S00.NOMCOLUMN_Q0299T00_LICENCIA));
                
                regVO.setFecentBD(rs.getString(Q02bTablaBDQ0299S00.NOMCOLUMN_Q0299T00_FECENT));
                regVO.setColumnaPK(colPK);
                lista.add(regVO);
            }
        }
        
        else{
        	lista.clear();
        }
        
        if (tr.isTraceActive()) {
            tr.trace(COMPONENTE, Q70TraceLevel.INFO,
                TRACE_METODO + ": saliendo con lista.size(): "+lista.size());
        }        
    } catch (Exception ex) {
        java.io.StringWriter sw = new java.io.StringWriter();
        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
        ex.printStackTrace(pw);
        tr.trace(COMPONENTE, Q70TraceLevel.ERROR,
            TRACE_METODO + ": " + sw.getBuffer().toString());
        throw ex;
    } finally {
        try {
            objTBD.freeResourcesNotConnection();
        } catch (Exception ex) {
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR,
                    TRACE_METODO + ": error liberando recursos");
            }
        }
    }
    return lista;
}
// -------------------- FIN - OBTENER LISTA	 --------------------- 
}
