package q02b.exe.ejecucionValidaciones.beans;







import java.util.ArrayList;


import q02b.exe.arquitectura.beans.Q02bBaseBean;


import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;


import q02b.exe.ejecucionValidaciones.dataobjects.Q02bEjecucionValidacionesDataBaseDAO;
import q02b.exe.ejecucionValidaciones.valueobjects.Q02bEjecucionValidaciones;








   


public class Q02bEjecucionValidacionesBean extends Q02bBaseBean{


	private static final long serialVersionUID = 5474311672836163390L;


	protected Q02bEjecucionValidacionesDataBaseDAO daoEjecucionValidaciones = null;


	final static String	EJECUCION_VALIDACION = "ejecucionValidacion";
	
	final static String VARIABLE_LISTA = "listaEjecucionValidaciones";
	
	


	


	 /** Constructor vacio */


    public Q02bEjecucionValidacionesBean() {


        super();


    }

    
    
//  -------------------- INI - COMPROBAR LISTA

    /**

     * M?todo que se invoca desde un EJB para obtener un ArrayList

     * en funci?n de los par?metros del filtro

     * @return ArrayList

     * @throws Exception

     * @generated

     */

    public ArrayList comprobarListaEjecucionValidaciones(Q02bEjecucionValidaciones filtroVO)

        throws Exception {

        //Definici?n de constantes

        final String TRACE_METODO = nombreClaseSinPackage +

            ":comprobarListaEjecucionValidaciones";

        //Definici?n de variables

        ArrayList lista = new ArrayList();

        boolean error = false;


        // Variables de negocio

        Q02bEjecucionValidacionesDataBaseDAO dao = null;


        if (tr.isTraceActive()) {
            tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +
                ": entrando");
        }


        try {

            //Se abre la conexi?n

            abrirConexion();

            //Se instancia el dao pasandole la conexi?n			

            dao = new Q02bEjecucionValidacionesDataBaseDAO(this.getConn());

            //Se pasan los par?metros de usuario e idioma

            dao.setUser(this.autenticador.getUser());

            dao.setIdioma(this.autenticador.getIdioma());

            lista = dao.obtenerListaEjecucionValidaciones(filtroVO);

            if (tr.isTraceActive()) {

                tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +

                    ": -------EL NUMERO DE REGISTROS ES: "+lista.size()+
                    //Estos parametros son los del mantenimiento, no tienen que ver con lista
                    "--------- CON TIPO ENCUESTA = "+filtroVO.getTipoEncuesta()+
                    " -- ANYO = "+filtroVO.getAnyo()+
                    " -- MES = "+filtroVO.getMesSolicitud()+
                    " -- MUNICIPIO = "+filtroVO.getIdMunicipio());

            }
          
            return lista;
 
        } catch (Exception ex) {

            error = true;

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

                TRACE_METODO + ": " + sw.getBuffer().toString());

            throw ex;

        } finally {

            try {

                dao.freeResourcesNotConnection();

            } catch (Exception ex) {

                if (tr.isTraceActive()) {

                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

                        TRACE_METODO + ": error liberando recursos");

                }

            }


            //se cierra la conexi?n  

            cerrarConexion(error);



            if (tr.isTraceActive()) {

                tr.trace(COMPONENTE, Q70TraceLevel.INFO,

                    TRACE_METODO + ": saliendo");

            }

        }

    }

    // -------------------- FIN - COMPROBAR LISTA
     


    //  ------------------- INI - PROCESO LISTA


    /**


     * M?todo que se invoca desde un EJB para obtener un ArrayList


     * en funci?n de los par?metros del filtro


     * @return ArrayList


     */


    public ArrayList procesoEjecucionValidaciones(Q02bEjecucionValidaciones filtroVO)


        throws Exception {


        //Definici?n de constantes


        final String TRACE_METODO = nombreClaseSinPackage +


            ":procesoEjecucionValidaciones";


 
        //Definici?n de variables


        int numReg = 0;


        //int numMax = 0;


        ArrayList lista = new ArrayList();


        boolean error = false;

        

        // Variables de negocio


        Q02bEjecucionValidacionesDataBaseDAO dao = null;





        if (tr.isTraceActive()) {


            tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +


                ": entrando en procesoEjecucionValidaciones en Q02bEjecucionValidacionesBean");


        }





        try {


            //Se abre la conexi?n


            abrirConexion();


            //Se instancia el dao pasandole la conexi?n			


            dao = new Q02bEjecucionValidacionesDataBaseDAO(this.getConn());


            //Se pasan los par?metros de usuario e idioma


            dao.setUser(this.autenticador.getUser());


            dao.setIdioma(this.autenticador.getIdioma());


            numReg = dao.comprobarListaEjecucionValidaciones();

            
            if (tr.isTraceActive()) {

                tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +

                    ": -------EL NUMERO DE REGISTROS ES: "+numReg+
                    //Estos parametros son los del mantenimiento, no tienen que ver con numReg
                    "--------- CON TIPO ENCUESTA = "+filtroVO.getTipoEncuesta()+
                    " -- ANYO = "+filtroVO.getAnyo()+
                    " -- MES = "+filtroVO.getMesSolicitud()+
                    " -- MUNICIPIO = "+filtroVO.getIdMunicipio());

            }

          
            //Si es != 0 borro los datos de la tabla
            if(numReg != 0){
            	dao.deleteTablaQ0299S00();
            }
        
        	//Realizamos el proceso
        	dao.procedureEjecucionValidaciones(filtroVO);
        	
        	//vamos a obtener la lista que ha quedado en la tabla
            lista = dao.obtenerListaEjecucionValidaciones(filtroVO);
   

            return lista;

            

        } catch (Exception ex) {


            error = true;





            java.io.StringWriter sw = new java.io.StringWriter();


            java.io.PrintWriter pw = new java.io.PrintWriter(sw);


            ex.printStackTrace(pw);


            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,


                TRACE_METODO + ": " + sw.getBuffer().toString());


            throw ex;


        } finally {


            try {


                dao.freeResourcesNotConnection();


            } catch (Exception ex) {


                if (tr.isTraceActive()) {


                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR,


                        TRACE_METODO + ": error liberando recursos");


                }


            }




            //se cierra la conexi?n  


            cerrarConexion(error);





            if (tr.isTraceActive()) {


                tr.trace(COMPONENTE, Q70TraceLevel.INFO,


                    TRACE_METODO + ": saliendo");


            }


        }


    }


    // -------------------- FIN - PROCESO LISTA


}


