package q02b.exe.cuestionariosVTMAnu.beans;



import java.util.ArrayList;

import q02b.exe.arquitectura.beans.Q02bBaseBean;

//import q02b.exe.cuestionariosSMAnu.dataobjects.Q02bCuestionariosSMDataBaseDAO;

import q02b.exe.cuestionariosVTMAnu.dataobjects.Q02bCuestionariosVTMAnuDataBaseDAO;

import q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMAnu;

import q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMAnuFiltro;

import q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMFiltro;

//import q02b.exe.utils.Q02bConstantes;

//import q02b.exe.utils.Q02bFormatData;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import q02b.exe.arquitectura.utils.xml.Q02bXMLBuilder;

import org.w3c.dom.Document;

import org.w3c.dom.Element;

;

   

public class Q02bCuestionariosVTMAnuBean extends Q02bBaseBean{

	private static final long serialVersionUID = 5474311672836163390L;

	protected Q02bCuestionariosVTMAnuDataBaseDAO daoCuestionariosVTMAnu = null;

	 /** Constructor vacio */

    public Q02bCuestionariosVTMAnuBean() {

        super();

    }



        

	public ArrayList getCuestionariosVTM(Q02bCuestionarioVTMFiltro cuestionariosVTMFiltro) throws Exception 

	{

		 if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosVTM: entrando.");

	   		}  	  

		String idGrupo = null;	

		//int numReg = 0;		

		//String noRegRecuperados = "NoHayCuestionariosVTM";

		ArrayList listaCuestionariosVTM = new ArrayList();

		boolean error = false;

		

		try{

			//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionariosVTMAnu = new Q02bCuestionariosVTMAnuDataBaseDAO(this.getConn());

			

			idGrupo = daoCuestionariosVTMAnu.obtenerIdGrupoCuestionariosVTM(cuestionariosVTMFiltro);

			//numReg = daoCuestionariosVTMAnu.getCountCuestionariosVTM(cuestionariosVTMFiltro.getNiGrupoCuesVTMAnu());

		    		

			// Si el nmero de registros a devueltos es menor que el mximo permitido

            // y se ha devuelto registros

            //if(numReg > 0){

			if(idGrupo!=null && !idGrupo.equals("")){

          	  listaCuestionariosVTM = daoCuestionariosVTMAnu.getSelectCuestionariosVTM(idGrupo);

            }

            return listaCuestionariosVTM;              

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCuestionariosVTM: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoCuestionariosVTMAnu.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCuestionariosVTM: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosVTM: saliendo.");

	   		}

 	  	}

 	  } //fin getCuestionariosVTM 

    /**

     * Funcin que inserta los datos del cuestionario de Ayuntamientos Mensual pasada como parmetro en la BBDD

     * 

     * @param cuestionarioVTMAnu - Datos del cuestionario a insertar

     * 

     * @throws Exception

     */

    public String insertarCuestionarioVTMAnu(Q02bCuestionarioVTMAnu cuesVTMAnu) throws Exception {   	 

    	//se crean objetos necesarios.

    	String niCuestionarioVTMAnu = "";

    	boolean error = false;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioVTMAnu: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionariosVTMAnu = new Q02bCuestionariosVTMAnuDataBaseDAO(this.getConn());

//			se pasan los parmetros de usuario e idioma

			//daoCuestionariosVTMAnu.setUser(this.autenticador.getUser());

			//daoCuestionariosVTMAnu.setIdioma(this.autenticador.getIdioma());

			//se llamaa la metodo del DAO que realiza la insert

			niCuestionarioVTMAnu = daoCuestionariosVTMAnu.insertarCuestionarioVTMAnu(cuesVTMAnu);

			return niCuestionarioVTMAnu;

    	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioVTMAnu: " + sw.getBuffer ().toString());

	        throw ex;                     

 	  }finally{

 		    try{

 		    	daoCuestionariosVTMAnu.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioVTMAnu: error liberando recursos");

	   	   	   }  

 		    }  		 

 		  	//se cierra la conexin  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioVTMAnu: saliendo.");

	   		}

 	  }

    }//fin insertarCuestionarioVTMAnu

    

    /**

     * Funcin que borra el cuestionario pasado como parmetro de la BBDD

     * 

     * @param niCuestionarioVTMAnu - nmero interno del cuestionario a borrar

     * 

     * @throws Exception

     */

  public void borrarCuestionarioVTMAnu(String niCuestionarioVTMAnu,String niGrupoCuestionarioVTMAnu) throws Exception { 

	  	int numeroRegistros = 0;

  		if (tr.isTraceActive()){

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVTMAnu: entrando");

		}

  		boolean error = false;

  		try{

  			//se abre la conexin

 			abrirConexion();

 			

 			//se instancia el dao pasandole la conexin			

 			daoCuestionariosVTMAnu = new Q02bCuestionariosVTMAnuDataBaseDAO(this.getConn());

			

 			//Segmento tecnico 

 			//daoCuestionariosSMAnu.setUser(this.getAutenticador().getUser());

 			//daoCuestionariosSMAnu.setIdioma(this.getAutenticador().getIdioma()); 



 			//se comprueba el numero de cuestionarios que tiene el grupo de cuestionarios

 			numeroRegistros = daoCuestionariosVTMAnu.getNumCuestionariosVTM(niGrupoCuestionarioVTMAnu);

 			if (numeroRegistros==1)

 				{

 					daoCuestionariosVTMAnu.borrarCuestionarioVTMAnu(niCuestionarioVTMAnu,niGrupoCuestionarioVTMAnu);

 					daoCuestionariosVTMAnu.borrarGrupoCuestionarioVTMAnu(niGrupoCuestionarioVTMAnu);

 				}

 			else 

 				{

 					daoCuestionariosVTMAnu.borrarCuestionarioVTMAnu(niCuestionarioVTMAnu,niGrupoCuestionarioVTMAnu);

 				}

 		 	  

  		}catch(Exception ex){

  			error= true;

  			java.io.StringWriter sw = new java.io.StringWriter();

  			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

  			ex.printStackTrace(pw);

  			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioSMAnu: " + sw.getBuffer ().toString());

  			throw ex;           

	  

  		}finally{

  			try{

  				daoCuestionariosVTMAnu.freeResourcesNotConnection();

  			}catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioVTMAnu: error liberando recursos");

	   	   	   }  

  			}  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVTMAnu: saliendo.");

	   		}

 	  }

  }//fin borrarCuestionarioVTMAnu

    /**

     * Funcin que modifica los datos del cuestionario pasado como parmetro en la BBDD

     * 

     * @param cuestionarioVTMAnu - Datos del cuestionario a modificar

     * 

     * @throws Exception

     */

    public void modificarCuestionarioVTMAnu(Q02bCuestionarioVTMAnu cuestionarioVTMAnu) throws Exception {

   	 if (tr.isTraceActive()){

  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVTMAnu: entrando");

  		}

   	 boolean error = false;

   	try{

   		//se abre la conexin

   		abrirConexion();

   		//se instancia el dao pasandole la conexin			

   		daoCuestionariosVTMAnu = new Q02bCuestionariosVTMAnuDataBaseDAO(this.getConn());

			// Segmento tecnico 

			//daoCuestionariosVTMAnu.setUser(this.getAutenticador().getUser());

			//daoCuestionariosVTMAnu.setIdioma(this.getAutenticador().getIdioma()); 



   		//se llamaa la metodo del DAO que realiza la update

   		daoCuestionariosVTMAnu.modificarCuestionarioVTMAnu(cuestionarioVTMAnu);

   		    	

   	}catch(Exception ex){

		  error= true;

         java.io.StringWriter sw = new java.io.StringWriter();

         java.io.PrintWriter pw = new java.io.PrintWriter(sw);

         ex.printStackTrace(pw);

         tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVTMAnu: " + sw.getBuffer ().toString());

         throw ex;                     

	  }finally{

		 try{

			daoCuestionariosVTMAnu.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVTMAnu: error liberando recursos");

	   	   	   }  

		   }  		 

		  	//se cierra la conexin  

		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVTMAnu: saliendo.");

	   		}

	  }

   }





    /**

     * Mtodo que dado el nmero interno del cuestionario recuperar de la BBDD

     * los datos de dicho cuestionario.

     * @param niCuestionarioVTMAnu

     * @return

     */

	public Q02bCuestionarioVTMAnu obtenerCuestionarioVTMAnu(String niCuestionarioVTMAnu,String niGrupoCuestionarioVTMAnu)throws Exception{  	 

	    	boolean error = false;

	    	Q02bCuestionarioVTMAnu cuestionarioVTMAnu = null;

	  	  	try  	  {

	  	  		if (tr.isTraceActive()){

	  	  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVTMAnu, ** niCuestionarioVTMAnu bean=" + niCuestionarioVTMAnu + ", niGrupoCuestionarioVTMAnu =" + niGrupoCuestionarioVTMAnu+ " *** entrando");                

	  	  		}

	  	  		//se abre la conexin

	  	  		abrirConexion();

	  	  		//se instancia el dao pasandole la conexin			

	  	  		daoCuestionariosVTMAnu = new Q02bCuestionariosVTMAnuDataBaseDAO(this.getConn());

	  	  		//Segmento tecnico 

	  			//daoCuestionariosVTMAnu.setUser(this.getAutenticador().getUser());

	  			//daoCuestionariosVTMAnu.setIdioma(this.getAutenticador().getIdioma()); 

	  	  		//se llama al mtodo del dao recupera el cuestionario

	  	  		cuestionarioVTMAnu = daoCuestionariosVTMAnu.obtenerCuestionarioVTMAnu(niCuestionarioVTMAnu,niGrupoCuestionarioVTMAnu);

	  	  		//se devuelve el cuestionario recuperado

	  	  		return cuestionarioVTMAnu;

	  	  }catch(Exception ex){

	  		  	error= true;

	  		  	java.io.StringWriter sw = new java.io.StringWriter();

	          	java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          	ex.printStackTrace(pw);

	          	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVTMAnu: " + sw.getBuffer ().toString());

	          	throw ex;                     

	 	  }finally{

	 		  	try{

	 		  		daoCuestionariosVTMAnu.freeResourcesNotConnection();

	 		  	}catch(Exception ex){

				   if (tr.isTraceActive()){

					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVTMAnu: error liberando recursos");

		   	   	   }  

	 		  	}  		 

	 		  	//se cierra la conexin  

	 		  	cerrarConexion(error);	       	

		        if (tr.isTraceActive()){

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVTMAnu: saliendo.");

		   		}

	 	  }

	    }//fin obtenerCuestionarioVTMAnu

	    

	    

	    

     /**

     * Funcin que inserta/modifica los datos del grupo de cuestionarios de Ayuntamientos Mensual a partir de los Datos Contenidos en el filtro

     * 

     * @param cuestionarioVTMAnuFiltro - Datos del grupo de cuestionarios a insertar

     * 

     * @throws Exception

     */

    public String altaModifGrupoCuestionariosVTMAnu(Q02bCuestionarioVTMAnuFiltro cuesVTMAnuFiltro) throws Exception {   	 

    	//se crean objetos necesarios.

    	//Q02bCuestionarioVTMAnuFiltro grupoCuestionarioVTMAnuConNi = null;

    	String niGrupoCuesVTMAnu = null;

    	boolean error = false;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionariosVTMAnu = new Q02bCuestionariosVTMAnuDataBaseDAO(this.getConn());

//			se pasan los parmetros de usuario e idioma

			//daoCuestionariosVTMAnu.setUser(this.autenticador.getUser());

			//daoCuestionariosVTMAnu.setIdioma(this.autenticador.getIdioma());

			//se llamaa la metodo del DAO que realiza la insert

			niGrupoCuesVTMAnu =daoCuestionariosVTMAnu.altaModifGrupoCuestionariosVTMAnu(cuesVTMAnuFiltro);

			return niGrupoCuesVTMAnu;

			

    	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: " + sw.getBuffer ().toString());

	        throw ex;                     

 	  }finally{

 		    try{

 		    	daoCuestionariosVTMAnu.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: error liberando recursos");

	   	   	   }  

 		    }  		 

 		  	//se cierra la conexin  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioVTMAnu: saliendo.");

	   		}

 	  }

    }//fin altaModifGrupoCuestionariosVTMAnu

    

     /**

     * Funcin que obtiene los  meses para el municipio y ano seleccionados, en los que no se han introducido cuestionarios

     * 

     * @param codProv , codMuni, ano, idioma

     * 

     * @throws Exception

     */

    public String obtenerAnosSinActuacionesParaMuni(String codProv,String codMuni,String ano,String idioma) throws Exception {   	 

	boolean error = false;

    	String msgAnos = null;

    	

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionariosVTMAnu = new Q02bCuestionariosVTMAnuDataBaseDAO(this.getConn());

//			se pasan los parmetros de usuario e idioma

			//daoCuestionariosVTMAnu.setUser(this.autenticador.getUser());

			//daoCuestionariosVTMAnu.setIdioma(this.autenticador.getIdioma());

			//se llamaa la metodo del DAO que realiza la insert

			msgAnos =daoCuestionariosVTMAnu.obtenerAnosSinActuacionesParaMuni(codProv,codMuni,ano,idioma);

			return msgAnos;

			

    	}catch(Exception ex){

	 		error= true;

	        		java.io.StringWriter sw = new java.io.StringWriter();

	        		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        		ex.printStackTrace(pw);

	        		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: " + sw.getBuffer ().toString());

	        		throw ex;                     

 	  }finally{

 		    try{

 		    	daoCuestionariosVTMAnu.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: error liberando recursos");

	   	   	   }  

 		    }  		 

 		    //se cierra la conexin  

 		    cerrarConexion(error);	       	

	        	   if (tr.isTraceActive())

	        	   {

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: saliendo.");

	   	  }

 	  }

    }//fin obtenerMeseSinCuesVTMAnuParaMuniYAno

    

    /**

     * Funcin que obtiene el campo Realiza Actuacin  para el municipio y ao seleccionados

     * 

     * @param codProv , codMuni, ano

     * 

     * @throws Exception

     */

    public String obtenerCampoRealizaActuacionDeGrupoConMuniAno(String codProv,String codMuni,String ano) throws Exception {   	 

	boolean error = false;

    	

    	try{

    		if (tr.isTraceActive())

    		{

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoRealizaActuacionDeGrupoConMuniAno: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionariosVTMAnu = new Q02bCuestionariosVTMAnuDataBaseDAO(this.getConn());

//			se pasan los parmetros de usuario e idioma

			//daoCuestionariosVTMAnu.setUser(this.autenticador.getUser());

			//daoCuestionariosVTMAnu.setIdioma(this.autenticador.getIdioma());

			//se llamaa la metodo del DAO que realiza la insert

			return daoCuestionariosVTMAnu.obtenerCamporRealizaActuacionDeGrupoConMuniAno(codProv,codMuni,ano);

			

			

    	}catch(Exception ex){

	 		error= true;

	        		java.io.StringWriter sw = new java.io.StringWriter();

	        		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        		ex.printStackTrace(pw);

	        		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoRealizaActuacionDeGrupoConMuniAno: " + sw.getBuffer ().toString());

	        		throw ex;                     

 	  }finally{

 		    try{

 		    	daoCuestionariosVTMAnu.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoRealizaActuacionDeGrupoConMuniAno: error liberando recursos");

	   	   	   }  

 		    }  		 

 		    //se cierra la conexin  

 		    cerrarConexion(error);	       	

	        	   if (tr.isTraceActive())

	        	   {

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoRealizaActuacionDeGrupoConMuniAno.");

	   	  }

 	  }

    }//fin obtenerCampoRealizaActuacionDeGrupoConMuniAno

    

        /**Metodo que se encarga de devolver un XML con los datos principales de los cuestionarios a firmar que no estn ya firmados.

	* @param ArrayList ArrayList arrCuestionariosVTMAnuFirma

	* @throws Exception

       */

    public Document obtenerXmlFirmaCuestionariosVTMAnu(ArrayList arrCuestionariosVTMAnuFirma ) throws Exception{

        //Definicion de constantes

        final String TRACE_METODO = nombreClaseSinPackage +":obtenerXmlFirmaCuestionariosVTMAnu:";



        //Variable que indica si se ha producido un error

        boolean error = false;

        

        Document docCuestionariosVTMAnuFirmar = null;

        Q02bCuestionarioVTMAnu cuestionarioVTMAnuBD = null;

        

        if (tr.isTraceActive()) 

        {

            	tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": entrando");

            	tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +": ArrayList ="+ (arrCuestionariosVTMAnuFirma==null?"Es nulo":Integer.toString(arrCuestionariosVTMAnuFirma.size())));

        }

        try {

        	if(arrCuestionariosVTMAnuFirma !=null)

        	{

        		

        		Q02bXMLBuilder xml = new Q02bXMLBuilder();

            		Element document = xml.createTag("DOCUMENT");

        		for(int i =0;i<arrCuestionariosVTMAnuFirma.size();i++)

        		{

        			cuestionarioVTMAnuBD = (Q02bCuestionarioVTMAnu)arrCuestionariosVTMAnuFirma.get(i);

        			//MODIFICACION -> Se firman todos otra vez

        			//Slo se van a firmar los que no estn ya firmados

        			//tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": Fec. Firma del elemento  "+ i + "=" +cuestionarioVTMAnuBD.getFecFirma() );

        			//if(Q02bFormatData.esVacio(cuestionarioVTMAnuBD.getFecFirma()))

        			//{

	        			//tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": Se genera XML del elemento "+ i);

	        			Element cuestionario = xml.createTag("CUESTIONARIO");

	                    			xml.addChild(document, cuestionario);

	                    			/*xml.addChild(cuestionario, xml.createTag("IDEN_LICEN",cuestionarioVTMAnuBD.getIdenLicen() , true));

	                    			xml.addChild(cuestionario, xml.createTag("LOCAL_OBRA",cuestionarioVTMAnuBD.getLocalObra(), true));

	                    			xml.addChild(cuestionario, xml.createTag("RS_PROMO", cuestionarioVTMAnuBD.getRsPromo(), true));*/

	                    		//}

        		}

        		xml.setRootTag(document);

        		

        		

        		docCuestionariosVTMAnuFirmar= xml.getDocument();

        		

        	}

        	//Se devuelve el document

        	return docCuestionariosVTMAnuFirmar;

        }

        catch (Exception ex) 

        {

	            error = true;

	            java.io.StringWriter sw = new java.io.StringWriter();

	            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	            ex.printStackTrace(pw);

	            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

	                TRACE_METODO + ": " + sw.getBuffer().toString());

	            throw ex;

        } 

    }

    

    /**

     * Funcin que inserta la firma del grupo de cuestionarios de Ayuntamientos Mensual pasada como parmetro

     * 

     * @param niGrupoCuesVTMAnu - Ni del grupo de cuestionarios

     * @param xmlFirmaGrupoCuestionariosVTMAnu - Firma del grupo de cuestionarios

     * 

     * @throws Exception

     */

    public void guardarFirmaGrupoCuestionariosVTMAnu(String niGrupoCuesVTMAnu,String xmlFirmaGrupoCuestionariosVTMAnu) throws Exception {   	 

    	boolean error = false;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: entrando");

      		}

  		//se abre la conexin

		abrirConexion();

		//se instancia el dao pasandole la conexin			

		daoCuestionariosVTMAnu = new Q02bCuestionariosVTMAnuDataBaseDAO(this.getConn());

//		se pasan los parmetros de usuario e idioma

		//daoCuestionariosVTMAnu.setUser(this.autenticador.getUser());

		//daoCuestionariosVTMAnu.setIdioma(this.autenticador.getIdioma());

		//se llamaa la metodo del DAO que realiza las modificaciones en la base de datos

		daoCuestionariosVTMAnu.guardarFirmaGrupoCuestionariosVTMAnu(niGrupoCuesVTMAnu,xmlFirmaGrupoCuestionariosVTMAnu);

    	}catch(Exception ex){

	 	 error= true;

		 java.io.StringWriter sw = new java.io.StringWriter();

		 java.io.PrintWriter pw = new java.io.PrintWriter(sw);

		 ex.printStackTrace(pw);

		 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: " + sw.getBuffer ().toString());

		  throw ex;                     

 	  }finally{

 		    try{

 		    	daoCuestionariosVTMAnu.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: error liberando recursos");

	   	   	   }  

 		    }  		 

 		  	

 		  //se cierra la conexin  

 		 cerrarConexion(error);	       	

	        	if (tr.isTraceActive())

	        	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: saliendo.");

	   	}

 	  }

    }//fin guardarFirmaGrupoCuestionariosVTMAnu  

    

    

    public void borrarTodosCuestionarioVTMAnu(String niGrupoCuestionarioVTMAnu) throws Exception {



   	 

  

    	if (tr.isTraceActive()){

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: entrando");

		}

    	 boolean error = false;

    	 try{

    		 

    		 

    		 //se abre la conexin

   			abrirConexion();

   			//se instancia el dao pasandole la conexin			

   			daoCuestionariosVTMAnu = new Q02bCuestionariosVTMAnuDataBaseDAO(this.getConn());

			// Segmento tecnico 



   			 daoCuestionariosVTMAnu.borrarTodosCuestionarioVTMAnu(niGrupoCuestionarioVTMAnu);

   			daoCuestionariosVTMAnu.modificarDatosFirmaGrupoCuestionarioVTMMen(niGrupoCuestionarioVTMAnu);

   		 	  

    	 }catch(Exception ex){

		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoCuestionariosVTMAnu.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVTMAnu: saliendo.");

	   		}

 	  }



     }//fin borrarTodosCuestionarioVTMAnu

    

    /**

     * Funcin que recupera el nmero de cuestionarios de OM 

     * 

     * @param cuestionarioVTMAnu - Datos del cuestionario a actualizar

     * 

     * @throws Exception

     */

      public int getNumCuestionariosPortada(String territorio, String municipio, String anyoReferencia,String mesReferencia) throws Exception {   	 

    	//se crean objetos necesarios.

    	int numCuestionariosOM=0;	        	         

    	boolean error = false;

    	

    	try{

    		 

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionariosVTMAnu = new Q02bCuestionariosVTMAnuDataBaseDAO(this.getConn());

			

			numCuestionariosOM = daoCuestionariosVTMAnu.getNumCuestionariosOM(territorio, municipio, anyoReferencia, mesReferencia);

			    			   			

			return numCuestionariosOM;

    	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: " + sw.getBuffer ().toString());

	        throw ex;                     

 	  }finally{

 		    try{

 		    	daoCuestionariosVTMAnu.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: error liberando recursos");

	   	   	   }  

 		    }  		 

 		  	//se cierra la conexin  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: saliendo.");

	   		}

 	  }

    }//fin getNumCuestionariosPortada 

      

      public String getConcedidoGrupoCuesVTM(String territorio, String municipio, String anyoReferencia,String mesReferencia) throws Exception {   	 

        	//se crean objetos necesarios.

        	String concedidoLicenInicial="";	        	         

        	boolean error = false;

        	

        	try{

        		 

        		if (tr.isTraceActive()){

          			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: entrando");

          		}

    	  		//se abre la conexin

    			abrirConexion();

    			//se instancia el dao pasandole la conexin			

    			daoCuestionariosVTMAnu = new Q02bCuestionariosVTMAnuDataBaseDAO(this.getConn());

    			

    			concedidoLicenInicial = daoCuestionariosVTMAnu.getConcedidoGrupoCuesVTM(territorio, municipio, anyoReferencia, mesReferencia);

    			    			   			

    			return concedidoLicenInicial;

        	}catch(Exception ex){

    	 		error= true;

    	        java.io.StringWriter sw = new java.io.StringWriter();

    	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    	        ex.printStackTrace(pw);

    	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: " + sw.getBuffer ().toString());

    	        throw ex;                     

     	  }finally{

     		    try{

     		    	daoCuestionariosVTMAnu.freeResourcesNotConnection();

     		    }catch(Exception ex){

    			   if (tr.isTraceActive()){

    				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: error liberando recursos");

    	   	   	   }  

     		    }  		 

     		  	//se cierra la conexin  

     		    cerrarConexion(error);	       	

    	        if (tr.isTraceActive()){

    	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: saliendo.");

    	   		}

     	  }

        } 



      

      /**

       * Funcin que modifica el campo Q022BT00_CONCEDIDO_LICEN 

       * 

       * @param niGrupoCuesVTM  - el ni del grupo a modificar

       * @param valorPrevSuelo - nuevo valor del campo

       * @param mes - mes del grupo de cuestionarios 

       * 

       * @throws Exception

       */

        public void modificarGrupoCuestionariosVTM(String niGrupoCuesVTM, String valorRealizaActu, String mes, String obs) throws Exception {   	 

        	boolean error = false;

        	try{

      		if (tr.isTraceActive()){

        			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarGrupoCuestionariosVTM: entrando");

        		}

  	  		//se abre la conexin

  			abrirConexion();

  			//se instancia el dao pasandole la conexin			

  			daoCuestionariosVTMAnu = new Q02bCuestionariosVTMAnuDataBaseDAO(this.getConn());



  			daoCuestionariosVTMAnu.modificarGrupoCuestionariosVTM(niGrupoCuesVTM, valorRealizaActu, mes, obs);

  	  	}catch(Exception ex){

  	 		error= true;

  	        java.io.StringWriter sw = new java.io.StringWriter();

  	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

  	        ex.printStackTrace(pw);

  	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarGrupoCuestionariosVTM: " + sw.getBuffer ().toString());

  	        throw ex;                     

   	  }finally{

   		    try{

   		    	daoCuestionariosVTMAnu.freeResourcesNotConnection();

   		    }catch(Exception ex){

  			   if (tr.isTraceActive()){

  				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarGrupoCuestionariosVTM: error liberando recursos");

  	   	   	   }  

   		    }  		 

   		  	//se cierra la conexin  

   		    cerrarConexion(error);	       	

  	        if (tr.isTraceActive()){

  	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarGrupoCuestionariosVTM: saliendo.");

  	   		}

   	  }

      }//fin modificarConcedidoLicenCuestionarioSM

        

        public String getNiGrupoCuesVTM(String territorio, String municipio, String anyoReferencia, String mesReferencia) throws Exception

        {

        	String niGrupoCuesVTMAnu = "";

        	boolean error = false;

            {          	              	

          	try{

          		 

          		if (tr.isTraceActive()){

            			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNiGrupoCuesVTM: entrando");

            		}

      	  		//se abre la conexin

      			abrirConexion();

      			//se instancia el dao pasandole la conexin			

      			daoCuestionariosVTMAnu = new Q02bCuestionariosVTMAnuDataBaseDAO(this.getConn());

      			

      			niGrupoCuesVTMAnu = daoCuestionariosVTMAnu.getNiGrupoCuesVTM(territorio, municipio, anyoReferencia, mesReferencia);

      			    			   			

      			return niGrupoCuesVTMAnu;

          	}catch(Exception ex){

      	 		error= true;

      	        java.io.StringWriter sw = new java.io.StringWriter();

      	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

      	        ex.printStackTrace(pw);

      	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNiGrupoCuesVTM: " + sw.getBuffer ().toString());

      	        throw ex;                     

       	    }finally{

       		    try{

       		    	daoCuestionariosVTMAnu.freeResourcesNotConnection();

       		    }catch(Exception ex){

      			   if (tr.isTraceActive()){

      				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNiGrupoCuesVTM: error liberando recursos");

      	   	   	   }  

       		    }  		 

       		  	//se cierra la conexin  

       		    cerrarConexion(error);	       	

      	        if (tr.isTraceActive()){

      	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNiGrupoCuesVTM: saliendo.");

      	   		}

       	    }  	

            }

        }//fin getNiGRupoCuesSM

}



		





