package q02b.exe.contactos.dataobjects;



import java.sql.Connection;

import java.sql.PreparedStatement;

import java.sql.ResultSet;

import java.util.ArrayList;



import q02b.exe.arquitectura.dataobjects.Q02bDataBaseDAO;

import q02b.exe.contactos.valueobjects.Q02bContactos;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022KS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022KS01V01;

import q02b.exe.utils.Q02bConstantes;

import q02b.exe.utils.Q02bFormatData;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;



public class Q02bContactosDataBaseDAO extends Q02bDataBaseDAO {

	private static final long serialVersionUID = -8520551641771839103L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "DAO_ACCESO_DATOS";



	public Q02bContactosDataBaseDAO() {

		super();

	}



	public Q02bContactosDataBaseDAO(Connection conn) {

		super(conn);

	}



	public void rellenaFiltroContactos(Q02bContactos contactoFiltro, Q02bTablaBDQ022KS01V01 tablaContactos) throws Exception {

		// Definicin de variables que no se van a modificar

		final String TRACE_METODO = ":rellenaFiltroContactos:";

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ TRACE_METODO + " entrando");

			}

			if (contactoFiltro != null) {

				if (!Q02bFormatData.esVacio(contactoFiltro.getCodProvincia())) {

					tablaContactos.setQ022KT00_PROV_WHERE(contactoFiltro.getCodProvincia());

				}

				if (!Q02bFormatData.esVacio(contactoFiltro.getCodMunicipio())) {

					tablaContactos.setQ022KT00_MUNI_WHERE(contactoFiltro.getCodMunicipio());

				}

				if (!Q02bFormatData.esVacio(contactoFiltro.getIdOficina())) {

					tablaContactos.setQ022HT00_ID_OFI_WHERE(Integer.parseInt(contactoFiltro.getIdOficina()));

				}

				if (!Q02bFormatData.esVacio(contactoFiltro.getIdInformante())) {

					tablaContactos.setQ022KT00_ID_INF_WHERE(Integer.parseInt(contactoFiltro.getIdInformante()));

				}

				if (!Q02bFormatData.esVacio(contactoFiltro.getIdAgente())) {

					tablaContactos.setQ022KT00_ID_AGEN_WHERE(Integer.parseInt(contactoFiltro.getIdAgente()));

				}

				if (!Q02bFormatData.esVacio(contactoFiltro.getTipoContacto())) {

					tablaContactos.setQ022KT00_TCON_WHERE(new Long(contactoFiltro.getTipoContacto()));

				}

				if (!Q02bFormatData.esVacio(contactoFiltro.getFechaContacto())) {

					tablaContactos.setQ022KT00_FECC_WHERE(Q02bFormatData.parseDate(contactoFiltro.getFechaContacto()));

				}

				tablaContactos.setOrderBy(tablaContactos.NOMCOLUMN_NORA_T17_PROVINCIA_DS + ", " + tablaContactos.NOMCOLUMN_NORA_T17_MUNICIPIO_DS + ", " 

						+ tablaContactos.NOMCOLUMN_Q022HT00_ID_OFI + " , " + tablaContactos.NOMCOLUMN_Q022KT00_ID_INF + " , " 

						+ tablaContactos.NOMCOLUMN_Q022KT00_ID_AGEN + " , " + tablaContactos.NOMCOLUMN_Q022KT00_TCON + " , " 

						+ tablaContactos.NOMCOLUMN_Q022KT00_FECC);

			}

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ TRACE_METODO + sw.getBuffer().toString());

			throw ex;

		} finally {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ TRACE_METODO + " saliendo");

			}

		}

	}// fin rellenaFiltroContactos



	private ArrayList rellenaVOsContactos(ResultSet rs) throws Exception {

		Q02bContactos contacto;

		ArrayList listaContactos = new ArrayList();

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":rellenaVOsContactos: entrando");

			}

			while (rs.next()) {

				// se cargan en el objeto contacto los datos recuperados

				contacto = new Q02bContactos();

				rellenarVOContactos(contacto, rs);

				listaContactos.add(contacto);

			}

			return listaContactos;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":rellenaVOsContactos: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":rellenaVOsContactos: saliendo");

			}

		}

	}// fin rellenaVOsContactos(rs)



	private void rellenarVOContactos(Q02bContactos contacto, ResultSet rs) throws Exception {

		try {

			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName()	+ ":rellenarVOContactos: Hay Datos");

			contacto.setIdContacto(rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022KT00_ID_CONT));

			contacto.setCodProvincia(rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022KT00_PROV));

			contacto.setProvincia(rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_NORA_T17_PROVINCIA_DS));

			contacto.setCodMunicipio(rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022KT00_MUNI));

			contacto.setMunicipio(rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_NORA_T17_MUNICIPIO_DS));

			contacto.setIdInformante(rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022KT00_ID_INF));

			//cuando se creen los buscadores se podr quitar el if

			if (rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022IT00_NOMB)!=null){

				contacto.setInformante(rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022IT00_NOMB) + " " + rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022IT00_APE1) + " " 

					+ rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022IT00_APE2));

			}

			contacto.setIdAgente(rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022KT00_ID_AGEN));

			//cuando se creen los buscadores se podr quitar el if

			if (rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022JT00_NOMB)!=null){

				contacto.setAgente(rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022JT00_NOMB) + " " + rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022JT00_APE1) + " " 

					+ rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022JT00_APE2));

			}

			contacto.setTipoContacto(rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022KT00_TCON));

			contacto.setNombreTipoContactoES(rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022YT00_COD_DESCC));

			contacto.setNombreTipoContactoEU(rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022YT00_COD_DESCE));

			contacto.setFechaContacto(Q02bFormatData.formatearFecha( Q02bFormatData.checkStringNull( rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022KT00_FECC)), Q02bConstantes.FORMATO_FECHA_FORMAT_DATA, this.getIdioma()));

			contacto.setRazonContacto(rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022KT00_RCON));

			contacto.setFechaProxContacto(Q02bFormatData.formatearFecha( Q02bFormatData.checkStringNull( rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022KT00_FECR)), Q02bConstantes.FORMATO_FECHA_FORMAT_DATA, this.getIdioma()));

			contacto.setObservaciones(rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022KT00_OBSHR));

			contacto.setIdOficina(rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022HT00_ID_OFI));

			contacto.setOficinaES(rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022HT00_DESC));

			contacto.setOficinaEU(rs.getString(Q02bTablaBDQ022KS01V01.COLUMN_Q022HT00_DESC_EUS));

		} catch (Exception e) {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":rellenarVOContactos: error " + e.getMessage());

			}

		}

	} // fin rellenaVOsContactos(contacto, rs)



	private int dameSeqNiContactos(Q02bTablaBDQ022KS00 tablaContactos) throws Exception {

		int idContactos = 1;

		ResultSet rs = null;

		PreparedStatement prepStmt = null;

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":dameSeqNiContactos: entrando");

			}

			StringBuffer query = new StringBuffer(" SELECT Q022KQ00.NEXTVAL FROM DUAL ");

			prepStmt = this.getConnection().prepareStatement(query.toString());

			rs = prepStmt.executeQuery();

			tablaContactos.addResultSet(rs);

			tablaContactos.addStatement(prepStmt);

			if (rs.next()) {

				idContactos = rs.getInt(1);

			}

			return idContactos;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":dameSeqNiContactos: " + sw.getBuffer().toString());

			throw ex;

		}

	}// dameSegNiContactos



	public void rellenaDatosContactos(Q02bContactos contacto, Q02bTablaBDQ022KS00 tablaContactos) throws Exception {

		// se definen objetos necesarios.

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":rellenaDatosContactos: entrando");

			}

			// se aaden los datos

			tablaContactos.setQ022KT00_ID_CONT(Q02bFormatData.checkIntegerNull(contacto.getIdContacto()));

			tablaContactos.setQ022KT00_PROV(Q02bFormatData.checkStringNull(contacto.getCodProvincia()));

			tablaContactos.setQ022KT00_MUNI(Q02bFormatData.checkStringNull(contacto.getCodMunicipio()));

			tablaContactos.setQ022HT00_ID_OFI(Q02bFormatData.checkIntegerNull(contacto.getIdOficina()));

			tablaContactos.setQ022KT00_FECC(Q02bFormatData.parseDate(contacto.getFechaContacto()));

			tablaContactos.setQ022KT00_FECR(Q02bFormatData.parseDate(contacto.getFechaProxContacto()));

			tablaContactos.setQ022KT00_ID_AGEN(Q02bFormatData.checkIntegerNull(contacto.getIdAgente()));

			tablaContactos.setQ022KT00_ID_INF(Q02bFormatData.checkIntegerNull(contacto.getIdInformante()));

			tablaContactos.setQ022KT00_OBSHR(Q02bFormatData.checkStringNull(contacto.getObservaciones()));

			tablaContactos.setQ022KT00_RCON(Q02bFormatData.checkStringNull(contacto.getRazonContacto()));

			tablaContactos.setQ022YT00_NI_TIPO_CON(Q02bFormatData.checkLongNull(contacto.getTipoContacto()));

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":rellenaDatosContactos: "+ sw.getBuffer().toString());

			throw ex;

		} finally {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":rellenaDatosContactos: saliendo = "+ tablaContactos.getQ022KT00_ID_CONT());

			}

		}

	}// rellenaDatosContactos



	public ArrayList obtenerContactos(Q02bContactos contacto) throws Exception {

		// se instancian los objetos necesarios para realizar la consulta.

		Q02bTablaBDQ022KS01V01 tablaContactos = null;

		ResultSet rs = null;

		ArrayList listaContactos = new ArrayList();



		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":getContactos: entrando");

			}



			// se instancia la clase del tablas bd a llamar pasandole la conexion

			tablaContactos = new Q02bTablaBDQ022KS01V01(this.getConnection());



			// se aade la where

			this.rellenaFiltroContactos(contacto, tablaContactos);



			// se realiza la select

			rs = tablaContactos.select();

			// aadimos el cursos para luego poder liberarlo ( en el freeResources)

			tablaContactos.addResultSet(rs);

			// se trata el resultado obtenido aadiendolo a la lista de salida

			listaContactos = this.rellenaVOsContactos(rs);



			return listaContactos;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":getContactos: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				// liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

				tablaContactos.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":getContactos: error liberando recursos.");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":getContactos: saliendo.");

			}

		}

	}// fin obtenerContactos



	/**

	 * Funcin que inserta los datos del contacto pasado como parmetro en la BBDD

	 * @param contacto - Datos del contacto a insertar

	 * @throws Exception

	 */

	public void insertarContactos(Q02bContactos contacto) throws Exception {

		int idContactos = 0;

		Q02bTablaBDQ022KS00 tablaContactos = null;

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":insertarContactos: entrando");

			}

			// se crea el objeto de tablasBD

			tablaContactos = new Q02bTablaBDQ022KS00(this.getConnection());

			// primero recuperamos el nmero interno que le corresponde

			idContactos = dameSeqNiContactos(tablaContactos);

			contacto.setIdContacto(Integer.toString(idContactos));

			// se aaden los datos a insertar

			this.rellenaDatosContactos(contacto, tablaContactos);

			// se realiza la insert

			tablaContactos.insert();

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":insertarContactos: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				tablaContactos.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE,Q70TraceLevel.ERROR,this.getClass().getName()+ ":insertarContactos: error liberando recursos");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":insertarContactos: saliendo");

			}

		}

	} // insertarContactos



	/**

	 * Mtodo que dado el nmero interno del contacto recupera de la BBDD los datos de dicho contacto

	 * @param idContacto

	 * @return

	 */

	public Q02bContactos obtenerContacto(String idContacto) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerContacto , ** dao idContacto= "+ idContacto + "  ** entrando");

		}

		// se crean los objetos necesarios para realizar la select.

		Q02bTablaBDQ022KS01V01 Q02bTablaBDQ022KS01V01obj = null;

		Q02bContactos contactoBD = null;

		ResultSet rs = null;

		try {

			if (idContacto != null) {

				Q02bTablaBDQ022KS01V01obj = new Q02bTablaBDQ022KS01V01(this.getConnection());



				// se pone el filtro

				Q02bTablaBDQ022KS01V01obj.setQ022KT00_ID_CONT_WHERE(new Integer(idContacto));



				rs = Q02bTablaBDQ022KS01V01obj.select();

				Q02bTablaBDQ022KS01V01obj.addResultSet(rs);

				contactoBD = new Q02bContactos();

				if (rs.next()) {

					this.rellenarVOContactos(contactoBD, rs);

				}

			}

			return contactoBD;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":obtenerContacto: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				Q02bTablaBDQ022KS01V01obj.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":obtenerContacto: error liberando recursos");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerContacto: saliendo");

			}

		}

	}// fin obtenerContacto



	/**

	 * Funcin que borra el contacto pasado como parmetro de la BBDD

	 * @param idContacto - nmero interno del contacto a borrar

	 * @throws Exception

	 */

	public void borrarContactos(String idContacto) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":borrarContactos: entrando");

		}

		Q02bTablaBDQ022KS00 Q02bTablaBDQ022KS00obj = null;

		try {

			// se crean los objetos necesarios

			Q02bTablaBDQ022KS00obj = new Q02bTablaBDQ022KS00(this.getConnection());



			// se pone el filtro para la delete

			Q02bTablaBDQ022KS00obj.setQ022KT00_ID_CONT_WHERE(Integer.parseInt(idContacto));



			// se lanza el delete

			Q02bTablaBDQ022KS00obj.delete();

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":borrarContactos: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				Q02bTablaBDQ022KS00obj.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":borrarContactos: error liberando recursos");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":borrarContactos: saliendo");

			}

		}

	}// fin borrarContactos



	/**

	 * Funcin que modifica los datos del contacto pasado como parmetro en la BBDD

	 * @param contacto - Datos del contacto a modificar

	 * @throws Exception

	 */

	public void modificarContactos(Q02bContactos contacto) throws Exception {



		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":modificarContactos: entrando");

		}

		// Se instancian los objetos necesarios.

		Q02bTablaBDQ022KS00 Q02bTablaBDQ022KS00obj = null;

		try {

			// se crea el objeto de tablasBD

			Q02bTablaBDQ022KS00obj = new Q02bTablaBDQ022KS00(this.getConnection());



			rellenaDatosContactos(contacto, Q02bTablaBDQ022KS00obj);

			Q02bTablaBDQ022KS00obj.setQ022KT00_ID_CONT_WHERE(Integer.parseInt(contacto.getIdContacto()));



			// se realiza la update

			Q02bTablaBDQ022KS00obj.update();

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":modificarContactos: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				Q02bTablaBDQ022KS00obj.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":modificarContactos: error liberando recursos");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":modificarContactos: saliendo");

			}

		}

	} // fin modificarContactos



}

