package q02b.exe.contactos.beans;



import java.util.ArrayList;



import q02b.exe.arquitectura.beans.Q02bBaseBean;

import q02b.exe.contactos.dataobjects.Q02bContactosDataBaseDAO;

import q02b.exe.contactos.valueobjects.Q02bContactos;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;



public class Q02bContactosBean extends Q02bBaseBean {

	private static final long serialVersionUID = 5474311672836163390L;



	protected Q02bContactosDataBaseDAO daoContactos = null;



	final static String LISTA_CONTACTOS = "listaContactos";



	/** Constructor vacio */

	public Q02bContactosBean() {

		super();

	}



	/**

	 * Funcin que recupera los contactos

	 * 

	 * @return listaContactos - Listado de contactos obtenidos

	 * @throws Exception

	 */

	public ArrayList obtenerContactos(Q02bContactos contacto) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerContactos: entrando.");

		}

		ArrayList listaContactos = new ArrayList();

		boolean error = false;



		try {

			// se abre la conexin

			abrirConexion();

			// se instancia el dao pasandole la conexin

			daoContactos = new Q02bContactosDataBaseDAO(this.getConn());



			// Segmento tecnico

			// daoContactos.setUser(this.getAutenticador().getUser());

			// daoContactos.setIdioma(this.getAutenticador().getIdioma());



			listaContactos = daoContactos.obtenerContactos(contacto);

			return listaContactos;

		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":obtenerContactos: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				daoContactos.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE,Q70TraceLevel.ERROR,this.getClass().getName()+ ":obtenerContactos: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerContactos: saliendo.");

			}

		}

	} // fin obtenerContactos



	/**

	 * Funcin que inserta los datos del contacto pasado como parmetro en la BBDD

	 * @param contacto - Datos del contacto a insertar

	 * @throws Exception

	 */

	public void insertarContactos(Q02bContactos contacto) throws Exception {

		boolean error = false;

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":insertarContactos: entrando");

			}

			// se abre la conexin

			abrirConexion();



			// se instancia el dao pasandole la conexin

			daoContactos = new Q02bContactosDataBaseDAO(this.getConn());



			// se pasan los parmetros de usuario e idioma

			// daoContactos.setUser(this.autenticador.getUser());

			// daoContactos.setIdioma(this.autenticador.getIdioma());



			// se llama la metodo del DAO que realiza la insert

			daoContactos.insertarContactos(contacto);

		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":insertarContactos: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				daoContactos.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE,Q70TraceLevel.ERROR,this.getClass().getName()+ ":insertarContactos: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":insertarContactos: saliendo.");

			}

		}

	}// fin insertarContactos



	/**

	 * Mtodo que dado el nmero interno del contacto recupera de la BBDD los datos de dicho contacto.

	 * @param idContacto

	 * @return contacto

	 */

	public Q02bContactos obtenerContacto(String idContacto) throws Exception {

		boolean error = false;

		Q02bContactos contacto = null;

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerContacto, ** idContacto bean="	+ idContacto + " *** entrando");

			}



			// se abre la conexin

			abrirConexion();



			// se instancia el dao pasandole la conexin

			daoContactos = new Q02bContactosDataBaseDAO(this.getConn());



			// Segmento tecnico

			// daoContactos.setUser(this.getAutenticador().getUser());

			// daoContactos.setIdioma(this.getAutenticador().getIdioma());



			// se llama al mtodo del dao que recupera el contacto

			contacto = daoContactos.obtenerContacto(idContacto);



			// se devuelve el contacto recuperado

			return contacto;

		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":obtenerContacto: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				daoContactos.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":obtenerContacto: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":obtenerContacto: saliendo.");

			}

		}

	}// fin obtenerContacto



	/**

	 * Funcin que borra el contacto pasado como parmetro de la BBDD

	 * @param idContacto - nmero interno del contacto a borrar

	 * @throws Exception

	 */

	public void borrarContactos(String idContacto) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":borrarContactos: entrando");

		}

		boolean error = false;

		try {

			// se abre la conexin

			abrirConexion();



			// se instancia el dao pasandole la conexin

			daoContactos = new Q02bContactosDataBaseDAO(this.getConn());



			// Segmento tecnico

			// daoContactos.setUser(this.getAutenticador().getUser());

			// daoContactos.setIdioma(this.getAutenticador().getIdioma());



			daoContactos.borrarContactos(idContacto);

		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":borrarContactos: " + sw.getBuffer().toString());

			throw ex;



		} finally {

			try {

				daoContactos.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":borrarContactos: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":borrarContactos: saliendo.");

			}

		}

	}// fin borrarContactos



	/**

	 * Funcin que modifica los datos del contacto pasado como parmetro en la BBDD

	 * 

	 * @param contacto - Datos del contacto a modificar

	 * @throws Exception

	 */

	public void modificarContactos(Q02bContactos contacto) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":modificarContactos: entrando");

		}

		boolean error = false;

		try {

			// se abre la conexin

			abrirConexion();

			// se instancia el dao pasandole la conexin

			daoContactos = new Q02bContactosDataBaseDAO(this.getConn());



			// Segmento tecnico

			// daoContactos.setUser(this.getAutenticador().getUser());

			// daoContactos.setIdioma(this.getAutenticador().getIdioma());



			// se llamaa la metodo del DAO que realiza la update

			daoContactos.modificarContactos(contacto);



		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":modificarContactos: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				daoContactos.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":modificarContactos: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":modificarContactos: saliendo.");

			}

		}

	}// modificarContactos



}