package q02b.exe.comun.dataobjects;



import java.sql.Connection;

import java.sql.ResultSet;

import java.sql.PreparedStatement;

import java.util.ArrayList;

 

import q02b.exe.arquitectura.dataobjects.Q02bDataBaseDAO;

    

import q02b.exe.comun.valueobjects.Q02bBuscadorGeneral;

import q02b.exe.comun.valueobjects.Q02bBuscadorGeneralCombo;

import q02b.exe.comun.valueobjects.Q02bBuscadorGeneralFiltro;

import q02b.exe.comun.valueobjects.Q02bBuscadorGeneralSelect;



import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

import es.ejie.frmk.listeners.base.Q70ListenerUtils;

  

import q02b.exe.utils.Q02bFormatData;

  

public class Q02bBuscadorGeneralDataBaseDAO extends Q02bDataBaseDAO{

	

	private static final long serialVersionUID = 1L;

	//Se definen las variables que no se van a modificar

	private static Q70Traza 	tr 			= Q70Traza.getSingleton();

	private static final String COMPONENTE 	= "DAO_ACCESO_DATOS";



	//CONSTRUCTORES

	public Q02bBuscadorGeneralDataBaseDAO() {

        super();                

    }



    public Q02bBuscadorGeneralDataBaseDAO(Connection conn) {

    	super(conn);     

    }

    //FIN CONSTRUCTORES

    

    /**

     * Mtodo que obtiene el nmero de registro que se obtiene de la base de datos

     * 

     * @param buscadorGeneralFiltro

     * @param buscadorGeneralSelect

     * 

     * @return devuelve nmero de registros de la BBDD del buscador general

     * 

     * @throws Exception

     */

     public int getCountBuscadorGeneral(Q02bBuscadorGeneralFiltro buscadorGeneralFiltro, Q02bBuscadorGeneralSelect buscadorGeneralSelect) throws Exception {    	    

 		//Definicin de variables que no se van a modificar

 		final String 	TRACE_METODO 	= ":getCountBuscadorGeneral:";

 		final String 	TRUE 			= "true";

    	//Se crean las objetos necesarios

    	int 						numReg 		= 0;  	      

    	//Objetos necesarios para lanzar la query

    	PreparedStatement 			prepStmt 	= null;

    	ResultSet 					rs 			= null; 

        StringBuffer				query		= new StringBuffer("");

        StringBuffer				queryWhere	= new StringBuffer("");

        StringBuffer				querySelect	= new StringBuffer("");

        try{

        	if (tr.isTraceActive()){

    			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando");   			

    		}        	

        	//Se genera la parte select 

        	querySelect.append(" SELECT COUNT(*) FROM ").append(buscadorGeneralSelect.getTable());    	

        	//Se pega la parte where

        	queryWhere.append(" WHERE (1=1) ");

        	queryWhere.append(obtenerWhereBuscadorGeneral(buscadorGeneralFiltro,buscadorGeneralSelect));

			//Se comprueba si se ha introducido una where optativa a travs de una columna

        	if(!Q02bFormatData.esVacio(buscadorGeneralSelect.getTableColumnWhere()) && !Q02bFormatData.esVacio(buscadorGeneralSelect.getSourceValueColumnWhere())){

        		if(TRUE.equals(buscadorGeneralSelect.getTableColumnWhereNumeric())){

        			queryWhere.append(" AND ").append(buscadorGeneralSelect.getTableColumnWhere());

        			queryWhere.append(" = ").append(buscadorGeneralSelect.getSourceValueColumnWhere());

        		} else {

        			queryWhere.append(" AND UPPER(").append(buscadorGeneralSelect.getTableColumnWhere()).append(") like '%").append(buscadorGeneralSelect.getSourceValueColumnWhere()).append("%'");

        		}

        	}

        	//Se comprueba si hay una where opcional

        	if(!Q02bFormatData.esVacio(buscadorGeneralSelect.getOptionalWhere())){

            	if(buscadorGeneralSelect.getOptionalWhere().indexOf("\"")>0){

            		buscadorGeneralSelect.setOptionalWhere(buscadorGeneralSelect.getOptionalWhere().replaceAll("\"","'"));

            	}

        		queryWhere.append(" AND ").append(buscadorGeneralSelect.getOptionalWhere());

        	}

        	//Se genera toda la select

        	query.append(querySelect.toString()).append(queryWhere.toString());

        	//Se realiza un prepareStatement para lanzar la query

       	 	prepStmt 	= this.getConnection().prepareStatement(query.toString());

       	 	rs 			= prepStmt.executeQuery(); 

        	//Se recupera el resultado

        	if (rs.next()){          		 

        	 	 numReg =  rs.getInt(1);

        	}

        	return numReg;

        }catch(Exception ex){

            java.io.StringWriter 	sw = new java.io.StringWriter();

            java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

            String[] aux = query.toString().split("AND");           

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO +aux[0]);

			for (int i= 1; i<aux.length; i++)

			{

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO  + " AND " + aux[i] );            

            }

            throw ex;

       }finally{

    	   try{

    		   rs.close();

    		   prepStmt.close();	

    	   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + " error liberando recursos");

	   	   	   }  

		   }  		

    	   if (tr.isTraceActive()){

    		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " saliendo");                

           }           

       }      

    }//fin getCountBuscadorGeneral()

     

     /**

      * Mtodo que obtiene un String con la parte where a realizar

      * 

      * @param solicitudFiltro

      * @param tablaBD

      * 

      * @throws Exception

      */

      public String obtenerWhereBuscadorGeneral(Q02bBuscadorGeneralFiltro buscadorGeneralFiltro,Q02bBuscadorGeneralSelect buscadorGeneralSelect)throws Exception{

 		//Definicin de variables que no se van a modificar

 		final String 	TRACE_METODO 		= ":obtenerWhereBuscadorGeneral:";

 		final String 	IDIOMA_ES 			= "IDIOMA_ES";

 		final String 	IDIOMA_EU 			= "IDIOMA_EU";

 		//StringBuffer en el que se almacenar la where

 		StringBuffer   where				= new StringBuffer("");

 		//Array donde se guardarn las columnas del idioma

 		String[]	   columnasIdioma		= null;

 		String[] 	   columnas 			= null;

    	try{

    		if (tr.isTraceActive()){

		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando");                

		    } 

    		//Slo entraremos si existen datos

	    	if(buscadorGeneralFiltro!=null &&  buscadorGeneralSelect!=null){

	    		//Se comprueba si tenemos columnas de idioma

	    		if(!Q02bFormatData.esVacio(buscadorGeneralSelect.getTableColumnsIdioma())){

	    			columnasIdioma = buscadorGeneralSelect.getTableColumnsIdioma().split(",");

	    			columnas 	= new String[1];

	    			columnas[0] = buscadorGeneralSelect.getTableColumns();

	    		} else {

	    			//Se obtienen las columnas

	    			columnas = buscadorGeneralSelect.getTableColumns().split(",");

	    		}

	    		if (!Q02bFormatData.esVacio(buscadorGeneralFiltro.getCodigo())){

	    			where.append(" AND UPPER(").append(columnas[0]).append(") like ('%").append(buscadorGeneralFiltro.getCodigo()).append("%')");

	    		}

	    		if (!Q02bFormatData.esVacio(buscadorGeneralFiltro.getDescripcionA())){

	    			if(columnasIdioma == null){

	    				where.append(" AND  UPPER(").append(columnas[1]).append(") like ('%").append(buscadorGeneralFiltro.getDescripcionA()).append("%')");

	    			} else {

	       	    		if(this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_ES))){

	       	    			where.append(" AND  UPPER(").append(columnasIdioma[0]).append(") like ('%").append(buscadorGeneralFiltro.getDescripcionA()).append("%')");

	    	    		} else if (this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_EU))){

	    	    			where.append(" AND  UPPER(").append(columnasIdioma[1]).append(") like ('%").append(buscadorGeneralFiltro.getDescripcionA()).append("%')");

	    	    		}

	    			}

	    		}

	    		if (!Q02bFormatData.esVacio(buscadorGeneralFiltro.getDescripcionB())){

	    			if(columnasIdioma == null){

	    				where.append(" AND  UPPER(").append(columnas[2]).append(") like ('%").append(buscadorGeneralFiltro.getDescripcionB()).append("%')");

	    			} else {

	    				if(this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_ES))){

	       	    			where.append(" AND  UPPER(").append(columnasIdioma[2]).append(") like ('%").append(buscadorGeneralFiltro.getDescripcionB()).append("%')");

	    	    		} else if (this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_EU))){

	    	    			where.append(" AND  UPPER(").append(columnasIdioma[3]).append(") like ('%").append(buscadorGeneralFiltro.getDescripcionB()).append("%')");

	    	    		}

	    			}

	    		}

	    		if (!Q02bFormatData.esVacio(buscadorGeneralFiltro.getComboA())){

	    			where.append(" AND ").append(buscadorGeneralSelect.getTableNiCombo()).append(" = ").append(buscadorGeneralFiltro.getComboA());

	    		}

	    	}

	    	//Se devuelve

	    	return where.toString();

    	}catch(Exception ex){    	 	   

	       java.io.StringWriter sw = new java.io.StringWriter();

	       java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

	       ex.printStackTrace(pw);

	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() 		+ TRACE_METODO + sw.getBuffer ().toString());

	       throw ex;

		}finally{			 	

			if (tr.isTraceActive()){

		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() 	+ TRACE_METODO + " saliendo");                

		    }    				

		}

    }//fin obtenerWhereBuscadorGeneral()

     

    

    /**

     * Mtodo que devuelve un arrayList relleno de objetos Solicitud

     * a partir de la query que se lance en la base de datos

     * 

     * @param buscadorGeneralFiltro

     * @param buscadorGeneralSelect

     * 

     * @return ArrayList

     * 

     * @throws Exception

     */

     public ArrayList getSelectBuscadorGeneral(Q02bBuscadorGeneralFiltro buscadorGeneralFiltro, Q02bBuscadorGeneralSelect buscadorGeneralSelect) throws Exception {		

 		//Definicin de variables que no se van a modificar

 		final String 	TRACE_METODO 	= ":getSelectBuscadorGeneral:";

 		final String 	TRUE 			= "true";

 		//Devuelve la lista de objetos

		ArrayList 				lista 			= new ArrayList();

    	//Objetos necesarios para lanzar la query

    	PreparedStatement 		prepStmt 		= null;

    	ResultSet 				rs 				= null; 

        StringBuffer			query			= new StringBuffer("");

        StringBuffer			querySelect		= new StringBuffer("");

        StringBuffer			queryWhere		= new StringBuffer("");

        StringBuffer			queryOrderBy 	= new StringBuffer("");

        

		try{

	    	if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando");

			}

	    	//Se realiza la select

	    	querySelect.append("SELECT ").append(buscadorGeneralSelect.getTableNi()).append(", ");

	    	//Se aaden las columnas

	    	querySelect.append(this.obtenerColumnasBuscadorGeneral(buscadorGeneralSelect.getTableColumnsIdioma(),buscadorGeneralSelect.getTableColumns()));

	    	//Columnas Extra

	    	if(!Q02bFormatData.esVacio(buscadorGeneralSelect.getTableColumnsExtra()) 

	    			|| !Q02bFormatData.esVacio(buscadorGeneralSelect.getTableColumnsIdiomaExtra())){

	    		querySelect.append(",").append(this.obtenerColumnasBuscadorGeneralExtra(buscadorGeneralSelect.getTableColumnsIdiomaExtra(),buscadorGeneralSelect.getTableColumnsExtra()));

	    	}

	    	//Se pega la from

	    	querySelect.append(" FROM ").append(buscadorGeneralSelect.getTable());

        	//Se pega la parte where

        	queryWhere.append(" WHERE (1=1) ");

        	queryWhere.append(obtenerWhereBuscadorGeneral(buscadorGeneralFiltro,buscadorGeneralSelect));

        	//Se comprueba si se ha introducido una where optativa a travs de una columna

        	if(!Q02bFormatData.esVacio(buscadorGeneralSelect.getTableColumnWhere()) && !Q02bFormatData.esVacio(buscadorGeneralSelect.getSourceValueColumnWhere())){

        		queryWhere.append(" AND ").append(buscadorGeneralSelect.getTableColumnWhere());

        		if(TRUE.equals(buscadorGeneralSelect.getTableColumnWhereNumeric())){

        			queryWhere.append(" = ").append(buscadorGeneralSelect.getSourceValueColumnWhere());

        		} else {

        			//queryWhere.append(" like '%").append(buscadorGeneralSelect.getSourceValueColumnWhere()).append("%'");

        			queryWhere.append(" UPPER(").append(buscadorGeneralSelect.getTableColumnWhere()).append(") like '%").append(buscadorGeneralSelect.getSourceValueColumnWhere()).append("%'");

        		}

        	}

        	//Se comprueba si hay una where opcional

	    	if(!Q02bFormatData.esVacio(buscadorGeneralSelect.getOptionalWhere())){

	    		if(buscadorGeneralSelect.getOptionalWhere().indexOf("\"")>0){

	    			buscadorGeneralSelect.setOptionalWhere(buscadorGeneralSelect.getOptionalWhere().replaceAll("\"","'"));

	    		}

	    		queryWhere.append(" AND ").append(buscadorGeneralSelect.getOptionalWhere());

	    	}	

        	//Se realiza el order by

        	if(!Q02bFormatData.esVacio(buscadorGeneralSelect.getTableOrderByClause())){

        		queryOrderBy.append(" ORDER BY ");

        		queryOrderBy.append(buscadorGeneralSelect.getTableOrderByClause());

        		if(!Q02bFormatData.esVacio(buscadorGeneralSelect.getTableOrdenOrderBy())){

        			queryOrderBy.append(" ").append(buscadorGeneralSelect.getTableOrdenOrderBy());

        		}

        	}

        	//Se genera toda la select

        	query.append(querySelect.toString()).append(queryWhere.toString()).append(queryOrderBy.toString());

        	//Se realiza un prepareStatement para lanzar la query

       	 	prepStmt 	= this.getConnection().prepareStatement(query.toString());

       	 	rs 			= prepStmt.executeQuery();

	    	//Se trata el resultado obtenido aadiendolo a la lista de salida

	    	lista 		= this.rellenaVOsBuscadorGeneralTabla(rs, buscadorGeneralSelect);

	    	//Se devuelve la lista

	    	return lista;    	

		}catch(Exception ex){ 	   

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

			 String[] aux = query.toString().split("AND");

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO +aux[0]);

			for (int i= 1; i<aux.length; i++)

			{

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO  + " AND " + aux[i] );            

            }

			throw ex;

		}finally{

		 	try{

	    		   rs.close();

	    		   prepStmt.close();	

			 }catch(Exception ex){

			    if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + " error liberando recursos.");

	   	   	    }  

			 }  		 			

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " saliendo.");                

	         }   

		}	

    }//fin getSelectBuscadorGeneral()

     

     /**

      * Mtodo que devuelve un String con las columnas

      * @param 	String tableColumnsIdioma

      * @param 	String tableColumns

      * @return String

      * @throws Exception

      */

     private String obtenerColumnasBuscadorGeneral(String tableColumnsIdioma, String tableColumns) throws Exception{

  		//Definicin de variables que no se van a modificar

  		final String 	TRACE_METODO 	= ":obtenerColumnasBuscadorGeneral:";

 		final String    IDIOMA_ES 		= "IDIOMA_ES";

 		final String 	IDIOMA_EU 		= "IDIOMA_EU";

        //Arrays con las columnas

        String[] 		columnas 	 	= null;

        //Columnas a devolver

        StringBuffer	querySelect		= new StringBuffer("");

  		try{

	    	if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando");

			}

	    	//Se mira si no tenemos columnas con idioma

	    	if(!Q02bFormatData.esVacio(tableColumnsIdioma)){

	    		querySelect.append(tableColumns).append(",");

	    		columnas = tableColumnsIdioma.split(",");

	    		if(this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_ES))){

	    			//Se pegan las columnas

			    	for(int i=0;i<columnas.length;i+=2){

			    		querySelect.append(columnas[i]);

			    		if(i<(columnas.length-2)){

			    			querySelect.append(", ");

			    		}

			    	}

	    		} else if(this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_EU))){

	    			//Se pegan las columnas

			    	for(int i=1;i<columnas.length;i+=2){

			    		querySelect.append(columnas[i]);

			    		if(i<(columnas.length-2)){

			    			querySelect.append(", ");

			    		}

			    	}			

	    		}

	    	}else if(!Q02bFormatData.esVacio(tableColumns)){

		    	//Se obtienen las columnas

		    	columnas = tableColumns.split(",");

		    	//Se pegan las columnas

		    	for(int i=0;i<columnas.length;i++){

		    		querySelect.append(columnas[i]);

		    		if(i!=(columnas.length-1)){

		    			querySelect.append(", ");

		    		}

		    	}

	    	}

	    	return querySelect.toString();

  		}catch(Exception ex){ 	   

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

			throw ex;

		}finally{			 	

  			if (tr.isTraceActive()){

  		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " saliendo");                

  		    }    				

  		}  

     }

     

     /**

      * Mtodo que devuelve un String con las columnas

      * @param 	String tableColumnsIdioma

      * @param 	String tableColumns

      * @return String

      * @throws Exception

      */

     private String obtenerColumnasBuscadorGeneralExtra(String tableColumnsIdioma, String tableColumns) throws Exception{

  		//Definicin de variables que no se van a modificar

  		final String 	TRACE_METODO 	= ":obtenerColumnasBuscadorGeneralExtra:";

 		final String    IDIOMA_ES 		= "IDIOMA_ES";

 		final String 	IDIOMA_EU 		= "IDIOMA_EU";

        //Arrays con las columnas

        String[] 		columnas 	 	= null;

        //Columnas a devolver

        StringBuffer	querySelect		= new StringBuffer("");

  		try{

	    	if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando");

			}

	    	//Columnas sin idioma

	    	if(!Q02bFormatData.esVacio(tableColumns)){

		    	//Se obtienen las columnas

		    	columnas = tableColumns.split(",");

		    	//Se pegan las columnas

		    	for(int i=0;i<columnas.length;i++){

		    		querySelect.append(columnas[i]);

		    		if(i!=(columnas.length-1)){

		    			querySelect.append(", ");

		    		}

		    	}

	    	}

	    	//Se mira si no tenemos columnas con idioma

	    	if(!Q02bFormatData.esVacio(tableColumnsIdioma)){

	    		if(!Q02bFormatData.esVacio(tableColumns)){

	    			querySelect.append(", ");

	    		}

	    		columnas = tableColumnsIdioma.split(",");

	    		if(this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_ES))){

	    			//Se pegan las columnas

			    	for(int i=0;i<columnas.length;i+=2){

			    		querySelect.append(columnas[i]);

			    		if(i<(columnas.length-2)){

			    			querySelect.append(", ");

			    		}

			    	}

	    		} else if(this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_EU))){

	    			//Se pegan las columnas

			    	for(int i=1;i<columnas.length;i+=2){

			    		querySelect.append(columnas[i]);

			    		if(i<(columnas.length-2)){

			    			querySelect.append(", ");

			    		}

			    	}			

	    		}

	    	}

	    	return querySelect.toString();

  		}catch(Exception ex){ 	   

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

			throw ex;

		}finally{			 	

  			if (tr.isTraceActive()){

  		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " saliendo");                

  		    }    				

  		}  

     }

     

     /**

      * Mtodo que devuelve un arrayList relleno de objetos BuscadorGeneralCombo

      * a partir de la query que se lance en la base de datos

      * 

      * @param buscadorGeneralSelect

      * 

      * @return ArrayList

      * 

      * @throws Exception

      */

    public ArrayList getSelectBuscadorGeneralCombo(Q02bBuscadorGeneralSelect buscadorGeneralSelect) throws Exception {

 		//Definicin de variables que no se van a modificar

 		final String 			TRACE_METODO 	= ":getSelectBuscadorGeneralCombo:";

 		final String 			IDIOMA_ES 		= "IDIOMA_ES";

 		final String 			IDIOMA_EU 		= "IDIOMA_EU";

 		final String 			FALSE		 	= "false";

 		//Devuelve la lista de objetos

		ArrayList 				lista 			= new ArrayList();

    	//Objetos necesarios para lanzar la query

    	PreparedStatement 		prepStmt 		= null;

    	ResultSet 				rs 				= null; 

        StringBuffer			query			= new StringBuffer("");

        StringBuffer			querySelect		= new StringBuffer("");

        StringBuffer			queryWhere		= new StringBuffer("");

        

		try{

	    	if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando");

			}

	    	//Se realiza la select

	    	querySelect.append("SELECT ").append(buscadorGeneralSelect.getComboValueColumn()).append(", ");

	    	//Si no se quiere control idiomtico (por defecto est as), simplemente se busca por la columna

	    	if(FALSE.equals(buscadorGeneralSelect.getComboIdioma())){

	    		querySelect.append(buscadorGeneralSelect.getComboLabelColumn());

	    	} else {//Si se quiere control idiomtico quiere decir que se han introducido dos columnas que corresponden a cada uno de los idiomas

	    		String[] columnasIdioma = buscadorGeneralSelect.getComboLabelColumn().split(",");

	    		//Si el idioma es ES cogemos la primera columna

	    		if(this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_ES))){

	    			querySelect.append(columnasIdioma[0]);

	    		} else if(this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_EU))){

	    			//Si el idioam es EU cogemos la segunda columna

	    			querySelect.append(columnasIdioma[1]);

	    		}

	    	}

	    	//Se pega la from

	    	querySelect.append(" FROM ").append(buscadorGeneralSelect.getTableCombo());

	    	//Se aade la clasula where

	    	queryWhere.append(" WHERE (1=1) ");

	    	//Se comprueba si se ha introducido dicha clasula

	    	if(!Q02bFormatData.esVacio(buscadorGeneralSelect.getComboOptionalWhere())){

	    		if(buscadorGeneralSelect.getComboOptionalWhere().indexOf("\"")>0){

	    			buscadorGeneralSelect.setComboOptionalWhere(buscadorGeneralSelect.getComboOptionalWhere().replaceAll("\"","'"));

	    		}

	    		queryWhere.append(" AND ").append(buscadorGeneralSelect.getComboOptionalWhere());

	    	}	

	    	//Se genera toda la select

        	query.append(querySelect.toString()).append(queryWhere.toString());

        	//Se realiza un prepareStatement para lanzar la query

       	 	prepStmt 	= this.getConnection().prepareStatement(query.toString());

       	 	rs 			= prepStmt.executeQuery();

	    	//Se trata el resultado obtenido aadiendolo a la lista de salida

	    	lista 		= this.rellenaVOsBuscadorGeneralCombo(rs, buscadorGeneralSelect);

	    	//Se devuelve la lista

	    	return lista; 

		}catch(Exception ex){ 	   

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

			throw ex;

		}finally{

		 	try{

	    		   rs.close();

	    		   prepStmt.close();	

			 }catch(Exception ex){

			    if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + " error liberando recursos.");

	   	   	    }  

			 }  		 			

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " saliendo.");                

	         }   

		}

    }//fin getSelectBuscadorGeneralCombo()

    

    /**

     * Mtodo que recorre el ResultSet obtenido de lanzar la query y carga

     * el arrayList con la informacin necesaria de la base de datos

     * 

     * @param ResultSet rs

     * 

     * @return ArrayList

     * 

     * @throws Exception

     */

     private ArrayList rellenaVOsBuscadorGeneralCombo(ResultSet rs, Q02bBuscadorGeneralSelect buscadorGeneralSelect) throws Exception{

    	 //Definicin de variables que no se van a modificar

  		final String 	TRACE_METODO 		= ":rellenaVOsBuscadorGeneralCombo:";

 		final String 	IDIOMA_ES 			= "IDIOMA_ES";

 		final String 	IDIOMA_EU 			= "IDIOMA_EU";

 		final String 	FALSE		 		= "false";

 		final String 	TRUE		 		= "true";

  		//Definicin del objeto lista

     	ArrayList 		lista 				= new ArrayList();

     	String[]		columnasIdioma      = null;

     	try{

     		if (tr.isTraceActive()){

 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando");                

 		    } 

     		//Si se tiene control idiomtico, se obtienen las columnas de idioma

     		if(TRUE.equals(buscadorGeneralSelect.getComboIdioma())){

     			columnasIdioma = buscadorGeneralSelect.getComboLabelColumn().split(",");

     		}

 	    	//Mientras haya datos

     		while (rs.next()){	

     	    	Q02bBuscadorGeneralCombo buscadorGeneralCombo = new Q02bBuscadorGeneralCombo();

 	        	//Se carga en el objeto con los datos recuperados

     	    	buscadorGeneralCombo.setNumInterno(rs.getString(buscadorGeneralSelect.getComboValueColumn()));

     	    	//Si no se tiene control idiomtico se entra

     	    	if(FALSE.equals(buscadorGeneralSelect.getComboIdioma())){

     	    		buscadorGeneralCombo.setDescripcion(rs.getString(buscadorGeneralSelect.getComboLabelColumn()));

     	    	} else {

    	    		//Si el idioma es ES cogemos la primera columna

    	    		if(this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_ES))){

    	    			buscadorGeneralCombo.setDescripcion(rs.getString(columnasIdioma[0]));

    	    		} else if(this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_EU))){

    	    			//Si el idioam es EU cogemos la segunda columna

    	    			buscadorGeneralCombo.setDescripcion(rs.getString(columnasIdioma[1]));

    	    		}

     	    	}

     	    	//Se aade a la lista el objeto

     			lista.add(buscadorGeneralCombo);

 			}  	  

     		//Se devuelve la lista

     		return lista;

     	}catch(Exception ex){    	 	   

  	       java.io.StringWriter sw = new java.io.StringWriter();

  	       java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

  	       ex.printStackTrace(pw);

  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

  	       throw ex;

  		}finally{			 	

  			if (tr.isTraceActive()){

  		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " saliendo");                

  		    }    				

  		}  	 

     }

    

    /**

     * Mtodo que recorre el ResultSet obtenido de lanzar la query y carga

     * el arrayList con la informacin necesaria de la base de datos

     * 

     * @param ResultSet rs

     * 

     * @return ArrayList

     * 

     * @throws Exception

     */

     private ArrayList rellenaVOsBuscadorGeneralTabla(ResultSet rs, Q02bBuscadorGeneralSelect buscadorGeneralSelect) throws Exception{

 		//Definicin de variables que no se van a modificar

 		final String 	TRACE_METODO 		= ":rellenaVOsBuscadorGeneralTabla:";

 		final String 	IDIOMA_ES 			= "IDIOMA_ES";

 		final String 	IDIOMA_EU 			= "IDIOMA_EU";

 		//Definicin del objeto lista

    	ArrayList 		lista 				= new ArrayList();

    	//Array donde se guardan las columnas idiomticas

    	String[] columnasIdioma				= null;

    	String[] columnas 					= null;

    	//Array donde se guardan las columnas idiomticas

    	String[] columnasIdiomaExtra		= null;

    	String[] columnasExtra 				= null;

    	try{

    		if (tr.isTraceActive()){

		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando");                

		    } 

    		//Se comprueba si tenemos columnas de idioma

    		if(!Q02bFormatData.esVacio(buscadorGeneralSelect.getTableColumnsIdioma())){

    			columnasIdioma = buscadorGeneralSelect.getTableColumnsIdioma().split(",");

    			columnas 	= new String[1];

    			columnas[0] = buscadorGeneralSelect.getTableColumns();

    		} else {

    			//Se obtienen las columnas

    			columnas = buscadorGeneralSelect.getTableColumns().split(",");

    		}

    		//Se comprueba si tenemos columnas extra

    		if(!Q02bFormatData.esVacio(buscadorGeneralSelect.getTableColumnsExtra())){

    			columnasExtra = buscadorGeneralSelect.getTableColumnsExtra().split(",");

    		}

    		if(!Q02bFormatData.esVacio(buscadorGeneralSelect.getTableColumnsIdiomaExtra())){

    			columnasIdiomaExtra = buscadorGeneralSelect.getTableColumnsIdiomaExtra().split(",");

    		}

	    	//Mientras haya datos

    		while (rs.next()){	

    	    	Q02bBuscadorGeneral buscadorGeneral = new Q02bBuscadorGeneral();

	        	//Se carga en el objeto con los datos recuperados

    	    	buscadorGeneral.setNumInterno(rs.getString(buscadorGeneralSelect.getTableNi()));

    	    	buscadorGeneral.setCodigo(rs.getString(columnas[0]));

    	    	//Si no tenemos columnas de idioma se comportar de este modo

    	    	if(columnasIdioma==null){

	    	    	buscadorGeneral.setDescripcionA(rs.getString(columnas[1]));

	    	    	if(columnas.length == 3) {

	    	    		buscadorGeneral.setDescripcionB(rs.getString(columnas[2]));

	    	    	} else if(columnas.length == 4) {

	    	    		buscadorGeneral.setDescripcionB(rs.getString(columnas[2]));

	    	    		buscadorGeneral.setComboA(rs.getString(columnas[3]));

	    	    	}  	    	

    	    	} else {//Si hemos introducido columnas idiomticas se comporta de este otro modo

    	    		if(this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_ES))){

    	    			buscadorGeneral.setDescripcionA(rs.getString(columnasIdioma[0]));

    	    		} else if (this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_EU))){

    	    			buscadorGeneral.setDescripcionA(rs.getString(columnasIdioma[1]));

    	    		}

	    	    	if(columnasIdioma.length == 4) {

	    	    		if(this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_ES))){

	    	    			buscadorGeneral.setDescripcionB(rs.getString(columnasIdioma[2]));

	    	    		} else if (this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_EU))){

	    	    			buscadorGeneral.setDescripcionB(rs.getString(columnasIdioma[3]));

	    	    		}	    	    			    	    	

	    	    	} else if(columnasIdioma.length == 6) {

	    	    		if(this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_ES))){

	    	    			buscadorGeneral.setDescripcionB(rs.getString(columnasIdioma[2]));

	    	    			buscadorGeneral.setComboA(rs.getString(columnasIdioma[4]));

	    	    		} else if (this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_EU))){

	    	    			buscadorGeneral.setDescripcionB(rs.getString(columnasIdioma[3]));

	    	    			buscadorGeneral.setComboA(rs.getString(columnasIdioma[5]));

	    	    		}

	    	    	}

    	    	}

    	    	//INICIO: COLUMNAS EXTRA

    	    	if(columnasExtra!=null){

    	    		buscadorGeneral.setDescripcionExtraA(rs.getString(columnasExtra[0]));

    	    		if(columnasExtra.length==2){

    	    			buscadorGeneral.setDescripcionExtraB(rs.getString(columnasExtra[1]));

    	    		}else if(columnasExtra.length==3){

    	    			buscadorGeneral.setDescripcionExtraB(rs.getString(columnasExtra[1]));

    	    			buscadorGeneral.setDescripcionExtraC(rs.getString(columnasExtra[2]));

    	    		}

    	    	}

    	    	if(columnasIdiomaExtra!=null){

    	    		if(columnasExtra==null){

	    	    		if(this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_ES))){

	    	    			buscadorGeneral.setDescripcionExtraA(rs.getString(columnasIdiomaExtra[0]));

	    	    		} else if (this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_EU))){

	    	    			buscadorGeneral.setDescripcionExtraA(rs.getString(columnasIdiomaExtra[1]));

	    	    		}

	    	    		if(columnasIdiomaExtra.length==4){

	    	    			if(this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_ES))){

	        	    			buscadorGeneral.setDescripcionExtraB(rs.getString(columnasIdiomaExtra[2]));

	        	    		} else if (this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_EU))){

	        	    			buscadorGeneral.setDescripcionExtraB(rs.getString(columnasIdiomaExtra[3]));

	        	    		}

	    	    		}else if(columnasIdiomaExtra.length==6){

	    	    			if(this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_ES))){

	        	    			buscadorGeneral.setDescripcionExtraB(rs.getString(columnasIdiomaExtra[2]));

	        	    			buscadorGeneral.setDescripcionExtraC(rs.getString(columnasIdiomaExtra[4]));

	        	    		} else if (this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_EU))){

	        	    			buscadorGeneral.setDescripcionExtraB(rs.getString(columnasIdiomaExtra[3]));

	        	    			buscadorGeneral.setDescripcionExtraC(rs.getString(columnasIdiomaExtra[5]));

	        	    		}

	    	    		}

    	    		}else if(columnasExtra.length==1){

    	    			if(this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_ES))){

	    	    			buscadorGeneral.setDescripcionExtraB(rs.getString(columnasIdiomaExtra[0]));

	    	    		} else if (this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_EU))){

	    	    			buscadorGeneral.setDescripcionExtraB(rs.getString(columnasIdiomaExtra[1]));

	    	    		}

	    	    		if(columnasIdiomaExtra.length==4){

	    	    			if(this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_ES))){

	        	    			buscadorGeneral.setDescripcionExtraC(rs.getString(columnasIdiomaExtra[2]));

	        	    		} else if (this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_EU))){

	        	    			buscadorGeneral.setDescripcionExtraC(rs.getString(columnasIdiomaExtra[3]));

	        	    		}

	    	    		}

    	    		}else if(columnasExtra.length==2){

    	    			if(this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_ES))){

	    	    			buscadorGeneral.setDescripcionExtraC(rs.getString(columnasIdiomaExtra[0]));

	    	    		} else if (this.idioma.equals(Q70ListenerUtils.getApplicationProperty(IDIOMA_EU))){

	    	    			buscadorGeneral.setDescripcionExtraC(rs.getString(columnasIdiomaExtra[1]));

	    	    		}

    	    		}

    	    	}

    	    	//FIN: COLUMNAS EXTRA

    	    	//Se aade a la lista el objeto

    			lista.add(buscadorGeneral);

			}  	  

    		//Se devuelve la lista

    		return lista;

    	}catch(Exception ex){    	 	   

 	       java.io.StringWriter sw = new java.io.StringWriter();

 	       java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

 	       ex.printStackTrace(pw);

 	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

 	       throw ex;

 		}finally{			 	

 			if (tr.isTraceActive()){

 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " saliendo");                

 		    }    				

 		}

    }//fin rellenaVOsBuscadorGeneralTabla()    



}//fin de clase.

