package q02b.exe.comun.beans;



import java.util.ArrayList;



import q02b.exe.arquitectura.beans.Q02bBaseBean;

import q02b.exe.comun.valueobjects.Q02bMailTo;

import q02b.exe.utils.Q02bMailUtils;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.listeners.base.Q70ListenerUtils;



public class Q02bMailToBean extends Q02bBaseBean{



	private static final long serialVersionUID = 3394757413314128326L;

	

	/** Constructor vacio */

    public Q02bMailToBean() {

        super();

    }

    

    /**

     * Mtodo que llama a un DAO para mandar un email.

     * @param 

     * @return

     * @throws Exception

     */

    public void enviarEmailContacto(Q02bMailTo email) throws Exception{

    	//Variables que no se van a modificar

    	final String METODO_TRAZA 				= ":enviarEmailContacto:";	

    	final String SEPARADOR 					= ":"; 

		final String CARRIAGE_RETURN 			= "\n"; 

		

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + METODO_TRAZA +  ":entrando");

      		}

    		

    		String CUERPO_NOMBRE_APELLIDOS 	= Q70GestorMensajesi18n.getSingleton().getMessage("q02brecursosCuestionarios","comun.nombreApellidos","es");

    		String CUERPO_EMAIL 				= Q70GestorMensajesi18n.getSingleton().getMessage("q02brecursosCuestionarios","comun.email", "es");

    		String CUERPO_ASUNTO 				= Q70GestorMensajesi18n.getSingleton().getMessage("q02brecursosCuestionarios","comun.object", "es");

    		String CUERPO_TEXTO 				= Q70GestorMensajesi18n.getSingleton().getMessage("q02brecursosCuestionarios","comun.body", "es");

    		

    		//Variable que contiene el mensaje

    		StringBuffer mensaje = new StringBuffer();

    		// Nombre y apellidos 

       		mensaje.append(CUERPO_NOMBRE_APELLIDOS).append(SEPARADOR).append(email.getNombreApellidos()).append(CARRIAGE_RETURN);

       		// Email 

      		mensaje.append(CUERPO_EMAIL).append(SEPARADOR).append(email.getRemitente()).append(CARRIAGE_RETURN);      		

      		// Asunto 

      		mensaje.append(CUERPO_ASUNTO).append(SEPARADOR).append(email.getSubject()).append(CARRIAGE_RETURN);

      		// Texto  

    		mensaje.append(CUERPO_TEXTO).append(SEPARADOR).append(CARRIAGE_RETURN).append(email.getBody());

    		if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + "MENSAJE " + mensaje);

	   		}

    		  		

    		//Se instancia la clase

//    		Se instancia la clase con el constructor vaco

    		Q02bMailUtils mailUtil=new Q02bMailUtils();

    		//Se asocian los parmetros

    		mailUtil.setSubject(email.getSubject());

    		mailUtil.setBody(mensaje.toString());

    		mailUtil.setRemitente(email.getRemitente());

    		//ArrayList con los destinatarios

    		//ArrayList con los destinatarios

    		ArrayList destinatarios = new ArrayList();

    		destinatarios.add(Q70ListenerUtils.getApplicationProperty("EMAIL_CONTACTO"));

    		mailUtil.setListaDestinatarios(destinatarios);

    		if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + "CONTACTO " + destinatarios.get(0).toString());

	   		}

    		mailUtil.setAttachment(null);

    		mailUtil.setIdioma("es");

      		//Se enva el correo

    		mailUtil.enviarMail();		

    			

    	}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":enviarEmailContacto: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":enviarEmailContacto: saliendo");

	   		}

    	}

    	

    }

}