package q02b.exe.comun.beans;



import java.util.ArrayList;



import q02b.exe.arquitectura.beans.Q02bBaseBean;

 

import q02b.exe.comun.Q02bAplicException;

import q02b.exe.comun.valueobjects.Q02bBuscadorGeneralFiltro;

import q02b.exe.comun.valueobjects.Q02bBuscadorGeneralSelect;

import q02b.exe.comun.dataobjects.Q02bBuscadorGeneralDataBaseDAO;





import q02b.exe.utils.Q02bConstantes;



import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;



public class Q02bBuscadorGeneralBean extends Q02bBaseBean{

	

	private static final long serialVersionUID = 1L;

	//Se definen objetos comunes a todos los mtodos

	protected Q02bBuscadorGeneralDataBaseDAO  buscadorGeneralDataBaseDAO  = null;

       

    /** Constructor vacio */

    public Q02bBuscadorGeneralBean() {

        super();

    }

   

    /**

	 * Obtener la lista de datos del buscador general que cumplan 

	 * los datos del filtro pasado como parmetro. Del mismo modo

	 * se envan los datos para conocer la tabla y los campos.

     * 

     * @param buscadorGeneralFiltro

     * @param buscadorGeneralSelect

     * 

     * @return devuelve un ArrayList con los datos del buscador general

     * 

     * @throws Exception

     */

     public ArrayList obtenerDatosBuscadorGeneral(Q02bBuscadorGeneralFiltro buscadorGeneralFiltro,Q02bBuscadorGeneralSelect buscadorGeneralSelect) throws Exception {		 	 

		//Definicin de variables que no se van a modificar

		final String 	TRACE_METODO 		= ":obtenerDatosBuscadorGeneral:";

		final String	NUM_MAX_REG			= "q02b.comun.buscadorGeneral.num_max_reg";

		//Definicin de dems variables

    	int 			numReg 				= 0;

		int 			numMax 				= 0;

		ArrayList 		lista 				= new ArrayList();

		boolean 		error 				= false;

		

		try{

			if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando.");

	   		}  

			//Se abre la conexin

			abrirConexion();

			//Se instancia el dao pasandole la conexin			

			buscadorGeneralDataBaseDAO = new Q02bBuscadorGeneralDataBaseDAO(this.getConn());

			//Se pasan los parmetros de usuario e idioma

			buscadorGeneralDataBaseDAO.setUser(this.autenticador.getUser());

			buscadorGeneralDataBaseDAO.setIdioma(this.autenticador.getIdioma());

			//Se llamar al dao para obtener el nmero de registros que cumplen el filtro

			numReg = buscadorGeneralDataBaseDAO.getCountBuscadorGeneral(buscadorGeneralFiltro,buscadorGeneralSelect);
 
            if (numReg == 0) {

                //no existen registros para el criterio introducido

                //se lanza la exception con el mensaje de error

                throw new Q02bAplicException("error.oi.noExistenRegistros");

            } 

            else

            {

				//se comprueba que el n reg recuperados no es superior al limite impuesto

				numMax = Integer.valueOf(Q02bConstantes.getString(NUM_MAX_REG)).intValue();

				// Si el nmero de registros devueltos es menor que el mximo permitido

	            // y se ha devuelto registros

	            if(numReg <= numMax){

	          	   lista = buscadorGeneralDataBaseDAO.getSelectBuscadorGeneral(buscadorGeneralFiltro,buscadorGeneralSelect);            	

	            }else{

                    //el n? de reg es superior al permitido. 

                    //se lanza la exception con el mensaje de error	            			            		

                    throw new Q02bAplicException("error.oi.limite.registros");

	            }

            }

            //Se devuelve la lista

            return lista;              

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter 	sw = new java.io.StringWriter();

          java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			buscadorGeneralDataBaseDAO.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + " error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO  + " saliendo.");

	   		}

 	  	}

 	  } //fin obtenerDatosBuscadorGeneral

     

     /**

 	  * Obtener la lista de datos del buscador general que rellena el combo

      * 

      * @param buscadorGeneralSelect

      * 

      * @return devuelve un ArrayList con los datos del buscador general

      * 

      * @throws Exception

      */

      public ArrayList obtenerDatosBuscadorGeneralCombo(Q02bBuscadorGeneralSelect buscadorGeneralSelect) throws Exception {		 	 

 		//Definicin de variables que no se van a modificar

 		final String 	TRACE_METODO 		= ":obtenerDatosBuscadorGeneralCombo:";

 		//Variables a utilizar

 		ArrayList 		lista 				= new ArrayList();

 		boolean 		error 				= false;

 		

 		try{

 			if (tr.isTraceActive()){

 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando.");

 	   		}  

 			//Se abre la conexin

 			abrirConexion();

 			//Se instancia el dao pasandole la conexin			

 			buscadorGeneralDataBaseDAO = new Q02bBuscadorGeneralDataBaseDAO(this.getConn());

 			//Se pasan los parmetros de usuario e idioma

 			buscadorGeneralDataBaseDAO.setUser(this.autenticador.getUser());

 			buscadorGeneralDataBaseDAO.setIdioma(this.autenticador.getIdioma());

 			//Se llamar al dao para obtener el nmero de registros que cumplen el filtro

           	lista = buscadorGeneralDataBaseDAO.getSelectBuscadorGeneralCombo(buscadorGeneralSelect);            	

            //Se devuelve la lista

            return lista;              

 	  } catch(Exception ex){

  		  error= true;

           java.io.StringWriter sw = new java.io.StringWriter();

           java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

           ex.printStackTrace(pw);

           tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + sw.getBuffer ().toString());

           throw ex;                     

  	  }finally{

  		 try{

  			buscadorGeneralDataBaseDAO.freeResourcesNotConnection();

 		   }catch(Exception ex){

 			   if (tr.isTraceActive()){

 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + TRACE_METODO + " error liberando recursos");

 	   	   	   }  

 		   }  		 

  		  	//se cierra la conexin  

  		  	cerrarConexion(error);	       	

 	        if (tr.isTraceActive()){

 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO  + " saliendo.");

 	   		}

  	  	}

  	  } //fin obtenerDatosBuscadorGeneralCombo

    

}

