package q02b.exe.comun;

/** Excepcin que deben lanzar cualquier clase cuando se produzca una excepcin en la aplicacion q02b. De este modo

 * homogeneizamos la manera de lanzar excepciones.

 * @author Leire.Uriarte

 * @version 1.0

 */

public class Q02bAplicException extends Exception {

   

	private static final long serialVersionUID = -2489530251674812241L;



	/**

     * Esta propiedad puede contener el objeto Exception causante de este Q02bAplicException. Si la excepcin

     * ha sido creada sin basarse en ningn objeto exception, su valor ser null.

     */

    protected Exception exception = null;

    

    /** Holds value of property codigo. */

    protected int codigo = 0;

    

    protected String codApp=null;

    

    /** Esta propiedad indica si la excepcin ha sido esperada (true) o inesperada (false) */

    protected boolean esperada = true;

    

    /**

     * Parmetros para sustituir en el mensaje de error mediante la clase MessageFormat estndar de java

     */

    protected Object[] params = null;

    

    /** Crea una excepcin  a partir de una SQLException.

     * @param exception  Excepcin cuasante de este Q02bAplicException

     */

    public Q02bAplicException(java.sql.SQLException exception) {

        super( exception.getClass().getName() + " : " + exception.getMessage() );

        fillInStackTrace();

        this.exception = exception;

    }

    /** Crea una excepcin  a partir de una NamingException.

     * @param exception  Excepcin cuasante de este Q02bAplicException

     */

    public Q02bAplicException(javax.naming.NamingException exception) {

        super( exception.getClass().getName() + " : " + exception.getMessage() );

        fillInStackTrace();

        this.exception = exception;

    }

    

    /** Crea una excepcin DAO a partir de un mensaje

     * @param mensaje Mensaje descriptivo de la excepcin

     */

    public Q02bAplicException( String mensaje ) {

        super( mensaje );

        fillInStackTrace();

    }

    

    /** Crea una excepcin  a partir de una NamingException.

     * @param exception  Excepcin cuasante de este Q02bAplicException

     */

    public Q02bAplicException( Exception exception ) {

        super( exception.getClass().getName() + " : " + exception.getMessage() );

        fillInStackTrace();

        this.exception = exception;

    }

    

    /** Crea una excepcin  a partir de una Q02bAplicException. En este caso, cogeremos el mismo

     * mensaje de la excepcin recibida.

     * @param exception  Excepcin cuasante de este DAOExcepcion

     */

    public Q02bAplicException( Q02bAplicException exception ) {

        super( exception.getClass().getName() + " : " + exception.getMessage() );

        fillInStackTrace();

        this.exception = exception;

    }

    

    

    /** Crea una excepcina partir de una SQLException.

     * @param exception  Excepcin cuasante de este Q02bAplicException

     * @param codigo Cdigo de error

     */

    public Q02bAplicException(java.sql.SQLException exception , int codigo) {

        super( exception.getClass().getName() + " : " + exception.getMessage() );

        fillInStackTrace();

        this.exception = exception;

        this.codigo = codigo;

    }

    /** Crea una excepcin  a partir de una NamingException.

     * @param exception  Excepcin cuasante de este Q02bAplicException

     * @param codigo Cdigo de error

     */

    public Q02bAplicException(javax.naming.NamingException exception , int codigo) {

        super( exception.getClass().getName() + " : " + exception.getMessage() );

        fillInStackTrace();

        this.exception = exception;

        this.codigo = codigo;

    }

    

    /** Crea una excepcin a partir de un mensaje

     * @param mensaje Mensaje descriptivo de la excepcin

     * @param codigo Cdigo de error

     */

    public Q02bAplicException( String mensaje , int codigo) {

        super( mensaje );

        fillInStackTrace();

        this.codigo = codigo;

    }

    

    public Q02bAplicException( String mensaje , int codigo,String codApp) {

        this(mensaje,codigo);

        this.codApp=codApp;

    }

    

    /** Crea una excepcin a partir de una NamingException.

     * @param exception  Excepcin cuasante de este Q02bAplicException

     * @param codigo Cdigo de error

     */

    public Q02bAplicException( Exception exception , int codigo) {

        super( exception.getClass().getName() + " : " + exception.getMessage() );

        fillInStackTrace();

        this.exception = exception;

        this.codigo = codigo;

    }

    

    public Q02bAplicException( Exception exception , int codigo,String codApp) {

        this(exception,codigo);

        this.codApp=codApp;

    }

    

    /** Crea una excepcin  a partir de una Q02bAplicException. En este caso, cogeremos el mismo

     * mensaje de la excepcin recibida.

     * @param exception  Excepcin cuasante de este Q02bAplicException

     * @param codigo Cdigo de error

     * @param params Parmetros para sustituir en el mensaje de error si se procesa mediante ErrorFactory

     */

    public Q02bAplicException( Q02bAplicException exception , int codigo,Object[] params) {

        this(exception,codigo);

        this.params = params;

    }

    

    /** Crea una excepcin  a partir de una Q02bAplicException. En este caso, cogeremos el mismo

     * mensaje de la excepcin recibida.

     * @param exception  Excepcin cuasante de este DAOExcepcion

     * @param codigo Cdigo de error

     */

    public Q02bAplicException( Q02bAplicException exception , int codigo) {

        super( exception.getClass().getName() + " : " + exception.getMessage() );

        fillInStackTrace();

        this.exception = exception;

        this.codigo = codigo;

    }

    

    /**

     * Crea una excepcin a partir de una Q02bAplicException con un cdigo de error y un cdigo de aplicacin

     * @param exception Excepcin producida

     * @param codigo Cdigo de error

     * @param codApp Cdigo de aplicacin

     */

    public Q02bAplicException( Q02bAplicException exception , int codigo,String codApp) {

        this(exception,codigo);

        this.codApp=codApp;

    }

    

    /**

     * Crea una excepcin  a partir de una Q02bAplicException con un cdigo de error y un cdigo de aplicacin

     * @param exception Excepcin producida

     * @param codigo Cdigo de error

     * @param codApp Cdigo de aplicacin

     * @param params Parmetros para sustituir en el mensaje de error si se procesa mediante ErrorFactory

     */

    public Q02bAplicException( Q02bAplicException exception , int codigo,String codApp,Object[] params) {

        this(exception,codigo,codApp);

        this.params = params;

    }

    

    /*****/

    

    /** Crea una excepcin  a partir de una SQLException.

     * @param exception  Excepcin cuasante de este Q02bAplicException

     * @param esperada False si es una excepcin inesperada

     */

    public Q02bAplicException(java.sql.SQLException exception,boolean esperada) {

        this(exception);

        this.esperada = esperada;

    }

    /** Crea una excepcin  a partir de una NamingException.

     * @param exception  Excepcin cuasante de este Q02bAplicException

     * @param esperada False si es una excepcin inesperada

     */

    public Q02bAplicException(javax.naming.NamingException exception,boolean esperada) {

        this(exception);

        this.esperada = esperada;

    }

    

    /** Crea una excepcin a partir de un mensaje

     * @param mensaje Mensaje descriptivo de la excepcin

     */

    public Q02bAplicException( String mensaje , boolean esperada) {

        this(mensaje);

        this.esperada = esperada;

    }

    

    /** Crea una excepcin DAO a partir de una NamingException.

     * @param exception  Excepcin cuasante de este DAOExcepcion

     */

    public Q02bAplicException( Exception exception,boolean esperada ) {

        this(exception);

        this.esperada = esperada;

    }

    

    /** Crea una excepcin DAO a partir de una Q02bAplicException. En este caso, cogeremos el mismo

     * mensaje de la excepcin recibida.

     * @param exception  Excepcin cuasante de este Q02bAplicException

     * @param esperada False si es una excepcin inesperada

     */

    public Q02bAplicException( Q02bAplicException exception ,boolean esperada) {

        this(exception);

        this.esperada = esperada;

    }

    

    

    /** Crea una excepcin  a partir de una SQLException.

     * @param exception  Excepcin cuasante de este Q02bAplicException

     * @param codigo Cdigo de error

     * @param esperada False si es una excepcin inesperada

     */

    public Q02bAplicException(java.sql.SQLException exception , int codigo,boolean esperada) {

        this(exception,codigo);

        this.esperada = esperada;

    }

    

    /** Crea una excepcin  a partir de una SQLException.

     * @param exception  Excepcin cuasante de este Q02bAplicException

     * @param codigo Cdigo de error

     * @param esperada False si es una excepcin inesperada

     * @param params Parmetros para sustituir en el mensaje de error si se procesa mediante ErrorFactory

     */

    public Q02bAplicException(java.sql.SQLException exception , int codigo,boolean esperada,Object[] params) {

        this(exception,codigo,esperada);

        this.params = params;

        

    }

    

    /** Crea una excepcin  a partir de una NamingException.

     * @param exception  Excepcin cuasante de este Q02bAplicException

     * @param codigo Cdigo de error

     */

    public Q02bAplicException(javax.naming.NamingException exception , int codigo , boolean esperada) {

        this(exception,codigo);

        this.esperada = esperada;

    }

    

    /** Crea una excepcin  a partir de una NamingException.

     * @param exception  Excepcin cuasante de este Q02bAplicException

     * @param codigo Cdigo de error

     */

    public Q02bAplicException(javax.naming.NamingException exception , int codigo , boolean esperada,Object[] params) {

        this(exception,codigo,esperada);

        this.params = params;

        

    }

    

    /** Crea una excepcin  a partir de un mensaje

     * @param mensaje Mensaje descriptivo de la excepcin

     * @param codigo Cdigo de error

     * @param esperada False si es una excepcin inesperada

     */

    public Q02bAplicException( String mensaje , int codigo,boolean esperada) {

        this( mensaje , codigo);

        this.esperada = esperada;

    }

    

    public Q02bAplicException( String mensaje , int codigo,boolean esperada,Object[] params) {

        this( mensaje , codigo,esperada);

        this.params = params;

        

    }

    

    public Q02bAplicException( String mensaje , int codigo,boolean esperada,String codApp) {

        this(mensaje,codigo,esperada);

        this.codApp = codApp;

    }

    

    public Q02bAplicException( String mensaje , int codigo,boolean esperada,String codApp,Object[] params) {

        this(mensaje,codigo,esperada,codApp);

        this.params = params;

        

    }

    

    /** Crea una excepcin a partir de una NamingException.

     * @param exception  Excepcin cuasante de este Q02bAplicException

     * @param codigo Cdigo de error

     * @param esperada False si es una excepcin inesperada

     */

    public Q02bAplicException( Exception exception , int codigo,boolean esperada) {

        this(exception,codigo);

        this.esperada = esperada;

    }

    

    public Q02bAplicException( Exception exception , int codigo,boolean esperada,Object[] params) {

        this(exception,codigo);

        this.esperada = esperada;

        this.params = params;

    }

    

    /** Crea una excepcin  a partir de una Q02bAplicException. En este caso, cogeremos el mismo

     * mensaje de la excepcin recibida.

     * @param exception  Excepcin cuasante de este Q02bAplicException

     * @param codigo Cdigo de error

     * @param esperada False si es una excepcin inesperada

     */

    public Q02bAplicException( Q02bAplicException exception , int codigo,boolean esperada) {

        this(exception,codigo);

        this.esperada = esperada;

    }

    

    public Q02bAplicException( Q02bAplicException exception , int codigo,boolean esperada,Object[] params) {

        this(exception,codigo,esperada);

        this.params = params;

    }

    

    /** Crea una excepcin DAO a partir de una ExcepcionDAO. En este caso, cogeremos el mismo

     * mensaje de la excepcin recibida.

     * @param exception  Excepcin cuasante de este DAOExcepcion

     * @param codigo Cdigo de error

     * @param esperada False si es una excepcin inesperada

     */

    public Q02bAplicException( Q02bAplicException exception , int codigo,boolean esperada,String codApp) {

        this(exception,codigo,esperada);

        this.codApp= codApp;

    }

    

    public Q02bAplicException( Q02bAplicException exception , int codigo,boolean esperada,String codApp,Object[] params) {

        this(exception,codigo,esperada,codApp);

        this.params = params;

        

    }

    

    /*****/

    

    /** Getter for property codigo.

     * @return Value of property codigo.

     */

    public int getCodigo() {

        return this.codigo;

    }

    

    /** Setter for property codigo.

     * @param codigo New value of property codigo.

     */

    public void setCodigo(int codigo) {

        this.codigo = codigo;

    }

    

    /**

     * Devuelve la excepcin original (la causante). Si es null, significa que este objeto es la excepcin

     * original

     * @return Exception Excepcin original, o null, si sta es la orginal

     */

    public Exception getException(){

        return exception;

    }



    /** Getter for property esperada.

     * @return Value of property esperada.

     */

    public boolean isEsperada() {

        return this.esperada;

    }

    

    /** Setter for property esperada.

     * @param esperada New value of property esperada.

     */

    public void setEsperada(boolean esperada) {

        this.esperada = esperada;

    }



	public void printStackTrace(java.io.PrintWriter out){

		super.printStackTrace(out);



		if(exception!=null){

			out.println("Causada por:");

			exception.printStackTrace(out);

		}

	}



	public void printStackTrace(java.io.PrintStream out){

		super.printStackTrace(out);



		if(exception!=null){

			out.println("Causada por:");

			exception.printStackTrace(out);

		}

	}



	public void printStackTrace(){

		super.printStackTrace();



		if(exception!=null){

			//System.err.println("Causada por:");

			exception.printStackTrace();

		}

	}



    

	/**

	 * @return Returns the codApp.

	 */

	public String getCodApp() {

		return codApp;

	}

	/**

	 * @param codApp The codApp to set.

	 */

	public void setCodApp(String codApp) {

		this.codApp = codApp;

	}

	

    public Object[] getParams() {

        return params;

    }

}

