package q02b.exe.ayuntamiento.dataobjects;



import java.sql.Connection;

import java.sql.PreparedStatement;

import java.sql.ResultSet;

import java.util.ArrayList;



import q02b.exe.arquitectura.dataobjects.Q02bDataBaseDAO;

import q02b.exe.ayuntamiento.valueobjects.Q02bAyuntamiento;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022MS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022MS01V01;

import q02b.exe.utils.Q02bFormatData;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;



public class Q02bAyuntamientoDataBaseDAO extends Q02bDataBaseDAO {

	private static final long serialVersionUID = -8520551641771839103L;



	private static Q70Traza tr = Q70Traza.getSingleton();



	private static final String COMPONENTE = "DAO_ACCESO_DATOS";



	public Q02bAyuntamientoDataBaseDAO() {

		super();

	}



	public Q02bAyuntamientoDataBaseDAO(Connection conn) {

		super(conn);

	}



	public void rellenaFiltroAyuntamiento(Q02bAyuntamiento ayuntamientoFiltro, Q02bTablaBDQ022MS01V01 tablaAyuntamiento) throws Exception {

		// Definicin de variables que no se van a modificar

		final String TRACE_METODO = ":rellenaFiltroAyuntamiento:";

		StringBuffer addWhere = new StringBuffer();

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ TRACE_METODO + " entrando");

			}

			if (ayuntamientoFiltro != null) {

				if (!Q02bFormatData.esVacio(ayuntamientoFiltro.getCodProvincia())) {

					tablaAyuntamiento.setQ022MT00_PROV_WHERE(ayuntamientoFiltro.getCodProvincia());

				}

				if (!Q02bFormatData.esVacio(ayuntamientoFiltro.getCodMunicipio())) {

					tablaAyuntamiento.setQ022MT00_MUNI_WHERE(ayuntamientoFiltro.getCodMunicipio());

				}

				if (!Q02bFormatData.esVacio(ayuntamientoFiltro.getDescripcionEs())) {

	                addWhere.append(" AND ( (TRANSLATE(UPPER(");

	                addWhere.append(Q02bTablaBDQ022MS01V01.NOMCOLUMN_Q022MT00_DESC);

	                addWhere.append("),'','AEIOUAEIOU')) LIKE  '%");

	                addWhere.append(Q02bFormatData.convertirMaysculaSinAcento(ayuntamientoFiltro.getDescripcionEs()));

	                addWhere.append("%' ) ");

	            }

				if (!Q02bFormatData.esVacio(ayuntamientoFiltro.getDescripcionEu())) {

	                addWhere.append(" AND ( (TRANSLATE(UPPER(");

	                addWhere.append(Q02bTablaBDQ022MS01V01.NOMCOLUMN_Q022MT00_DESC_EUS);

	                addWhere.append("),'','AEIOUAEIOU')) LIKE  '%");

	                addWhere.append(Q02bFormatData.convertirMaysculaSinAcento(ayuntamientoFiltro.getDescripcionEu()));

	                addWhere.append("%' ) ");

	            }

				tablaAyuntamiento.setOrderBy(tablaAyuntamiento.NOMCOLUMN_NORA_T17_PROVINCIA_DS + ", " + tablaAyuntamiento.NOMCOLUMN_NORA_T17_MUNICIPIO_DS);

				tablaAyuntamiento.setAditionalWhere(addWhere.toString());

			}

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ TRACE_METODO + sw.getBuffer().toString());

			throw ex;

		} finally {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ TRACE_METODO + " saliendo");

			}

		}

	}// fin rellenaFiltroAyuntamiento



	private ArrayList rellenaVOsAyuntamiento(ResultSet rs) throws Exception {

		Q02bAyuntamiento ayuntamiento;

		ArrayList listaAyuntamiento = new ArrayList();

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":rellenaVOsAyuntamiento: entrando");

			}

			while (rs.next()) {

				// se cargan en el objeto ayuntamiento los datos recuperados

				ayuntamiento = new Q02bAyuntamiento();

				rellenarVOAyuntamiento(ayuntamiento, rs);

				listaAyuntamiento.add(ayuntamiento);

			}

			return listaAyuntamiento;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":rellenaVOsAyuntamiento: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":rellenaVOsAyuntamiento: saliendo");

			}

		}

	}// fin rellenaVOsAyuntamiento(rs)



	private void rellenarVOAyuntamiento(Q02bAyuntamiento ayuntamiento, ResultSet rs) throws Exception {

		try {

			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName()	+ ":rellenarVOAyuntamiento: Hay Datos");

			ayuntamiento.setIdAyuntamiento(rs.getString(Q02bTablaBDQ022MS01V01.NOMCOLUMN_Q022MT00_ID_AYUN));

			ayuntamiento.setCodProvincia(rs.getString(Q02bTablaBDQ022MS01V01.NOMCOLUMN_Q022MT00_PROV));

			ayuntamiento.setProvincia(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_NORA_T17_PROVINCIA_DS));

			ayuntamiento.setCodMunicipio(rs.getString(Q02bTablaBDQ022MS01V01.NOMCOLUMN_Q022MT00_MUNI));

			ayuntamiento.setMunicipio(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_NORA_T17_MUNICIPIO_DS));

			ayuntamiento.setDescripcionEs(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_Q022MT00_DESC));

			ayuntamiento.setDescripcionEu(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_Q022MT00_DESC_EUS));

			ayuntamiento.setVia(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_Q022MT00_TVIA));

			ayuntamiento.setCalle(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_Q022MT00_CALLE));

			ayuntamiento.setBloque(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_Q022MT00_BLOQ));

			ayuntamiento.setNumero(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_Q022MT00_NUME));

			ayuntamiento.setBis(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_Q022MT00_BIS));

			ayuntamiento.setEscalera(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_Q022MT00_ESCA));

			ayuntamiento.setPiso(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_Q022MT00_PISO));

			ayuntamiento.setMano(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_Q022MT00_MANO));

			ayuntamiento.setPuerta(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_Q022MT00_PUER));

			ayuntamiento.setCodigoPostal(rs.getString(Q02bTablaBDQ022MS01V01.NOMCOLUMN_Q022MT00_CODP));

			ayuntamiento.setComplDireccion(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_Q022MT00_CDIR));

			ayuntamiento.setEmail(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_Q022MT00_EMAIL));

			ayuntamiento.setTelefono1(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_Q022MT00_TELF1));

			ayuntamiento.setTelefono2(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_Q022MT00_TELF2));

			ayuntamiento.setFax(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_Q022MT00_FAX));

			ayuntamiento.setWeb(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_Q022MT00_WEB));

			ayuntamiento.setLocalizacion(rs.getString(Q02bTablaBDQ022MS01V01.COLUMN_NORA_T17_LOCALIZACION));

		} catch (Exception e) {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":rellenarVOAyuntamiento: error " + e.getMessage());

			}

		}

	} // fin rellenaVOsAyuntamiento(ayuntamiento, rs)



	private int dameSeqNiAyuntamiento(Q02bTablaBDQ022MS00 tablaAyuntamiento) throws Exception {

		int niAyuntamiento = 1;

		ResultSet rs = null;

		PreparedStatement prepStmt = null;

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":dameSeqNiAyuntamiento: entrando");

			}

			StringBuffer query = new StringBuffer(" SELECT Q022MQ00.NEXTVAL FROM DUAL ");

			prepStmt = this.getConnection().prepareStatement(query.toString());

			rs = prepStmt.executeQuery();

			tablaAyuntamiento.addResultSet(rs);

			tablaAyuntamiento.addStatement(prepStmt);

			if (rs.next()) {

				niAyuntamiento = rs.getInt(1);

			}

			return niAyuntamiento;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":dameSeqNiAyuntamiento: " + sw.getBuffer().toString());

			throw ex;

		}

	}// dameSegNiAyuntamiento



	public void rellenaDatosAyuntamiento(Q02bAyuntamiento ayuntamiento,	Q02bTablaBDQ022MS00 tablaAyuntamiento) throws Exception {

		// se definen objetos necesarios.

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":rellenaDatosAyuntamiento: entrando");

			}

			// se aaden los datos

			tablaAyuntamiento.setQ022MT00_ID_AYUN(Q02bFormatData.checkIntegerNull(ayuntamiento.getIdAyuntamiento()));

			tablaAyuntamiento.setQ022MT00_PROV(Q02bFormatData.checkStringNull(ayuntamiento.getCodProvincia()));

			tablaAyuntamiento.setQ022MT00_MUNI(Q02bFormatData.checkStringNull(ayuntamiento.getCodMunicipio()));

			tablaAyuntamiento.setQ022MT00_DESC(Q02bFormatData.checkStringNull(ayuntamiento.getDescripcionEs()));

			tablaAyuntamiento.setQ022MT00_DESC_EUS(Q02bFormatData.checkStringNull(ayuntamiento.getDescripcionEu()));

			tablaAyuntamiento.setQ022MT00_TVIA(Q02bFormatData.checkStringNull(ayuntamiento.getVia()));

			tablaAyuntamiento.setQ022MT00_CALLE(Q02bFormatData.checkLongNull(ayuntamiento.getCalle()));

			tablaAyuntamiento.setQ022MT00_BLOQ(Q02bFormatData.checkStringNull(ayuntamiento.getBloque()));

			tablaAyuntamiento.setQ022MT00_NUME(Q02bFormatData.checkIntegerNull(ayuntamiento.getNumero()));

			tablaAyuntamiento.setQ022MT00_BIS(Q02bFormatData.checkStringNull(ayuntamiento.getBis()));

			tablaAyuntamiento.setQ022MT00_ESCA(Q02bFormatData.checkStringNull(ayuntamiento.getEscalera()));

			tablaAyuntamiento.setQ022MT00_PISO(Q02bFormatData.checkStringNull(ayuntamiento.getPiso()));

			tablaAyuntamiento.setQ022MT00_MANO(Q02bFormatData.checkStringNull(ayuntamiento.getMano()));

			tablaAyuntamiento.setQ022MT00_PUER(Q02bFormatData.checkStringNull(ayuntamiento.getPuerta()));

			tablaAyuntamiento.setQ022MT00_CODP(Q02bFormatData.checkStringNull(ayuntamiento.getCodigoPostal()));

			tablaAyuntamiento.setQ022MT00_CDIR(Q02bFormatData.checkStringNull(ayuntamiento.getComplDireccion()));

			tablaAyuntamiento.setQ022MT00_EMAIL(Q02bFormatData.checkStringNull(ayuntamiento.getEmail()));

			tablaAyuntamiento.setQ022MT00_TELF1(Q02bFormatData.checkIntegerNull(ayuntamiento.getTelefono1()));

			tablaAyuntamiento.setQ022MT00_TELF2(Q02bFormatData.checkIntegerNull(ayuntamiento.getTelefono2()));

			tablaAyuntamiento.setQ022MT00_FAX(Q02bFormatData.checkIntegerNull(ayuntamiento.getFax()));

			tablaAyuntamiento.setQ022MT00_WEB(Q02bFormatData.checkStringNull(ayuntamiento.getWeb()));

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":rellenaDatosAyuntamiento: "+ sw.getBuffer().toString());

			throw ex;

		} finally {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":rellenaDatosAyuntamiento: saliendo = "+ tablaAyuntamiento.getQ022MT00_ID_AYUN());

			}

		}

	}// rellenaDatosAyuntamiento



	public ArrayList getAyuntamientos(Q02bAyuntamiento ayuntamiento) throws Exception {

		// se instancian los objetos necesarios para realizar la consulta.

		Q02bTablaBDQ022MS01V01 tablaAyuntamiento = null;

		ResultSet rs = null;

		ArrayList listaAyuntamientos = new ArrayList();



		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":getAyuntamientos: entrando");

			}



			// se instancia la clase del tablas bd a llamar pasandole la conexion

			tablaAyuntamiento = new Q02bTablaBDQ022MS01V01(this.getConnection());



			// se aade la where

			this.rellenaFiltroAyuntamiento(ayuntamiento, tablaAyuntamiento);



			// se realiza la select

			rs = tablaAyuntamiento.select();

			// aadimos el cursos para luego poder liberarlo ( en el freeResources)

			tablaAyuntamiento.addResultSet(rs);

			// se trata el resultado obtenido aadiendolo a la lista de salida

			listaAyuntamientos = this.rellenaVOsAyuntamiento(rs);



			return listaAyuntamientos;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":getAyuntamientos: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				// liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

				tablaAyuntamiento.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":getAyuntamientos: error liberando recursos.");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":getAyuntamientos: saliendo.");

			}

		}

	}// fin getAyuntamientos



	/**

	 * Funcin que inserta los datos del ayuntamiento pasado como parmetro en la BBDD

	 * 

	 * @param ayuntamiento - Datos del ayuntamiento a insertar

	 * @throws Exception

	 */

	public void insertarAyuntamiento(Q02bAyuntamiento ayuntamiento) throws Exception {

		int niAyuntamiento = 0;

		Q02bTablaBDQ022MS00 tablaAyuntamiento = null;

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":insertarAyuntamiento: entrando");

			}

			// se crea el objeto de tablasBD

			tablaAyuntamiento = new Q02bTablaBDQ022MS00(this.getConnection());

			// primero recuperamos el nmero interno que le corresponde

			niAyuntamiento = dameSeqNiAyuntamiento(tablaAyuntamiento);

			ayuntamiento.setIdAyuntamiento(Integer.toString(niAyuntamiento));

			// se aaden los datos a insertar

			this.rellenaDatosAyuntamiento(ayuntamiento, tablaAyuntamiento);

			// se realiza la insert

			tablaAyuntamiento.insert();

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":insertarAyuntamiento: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				tablaAyuntamiento.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE,Q70TraceLevel.ERROR,this.getClass().getName()+ ":insertarAyuntamiento: error liberando recursos");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":insertarAyuntamiento: saliendo");

			}

		}

	} // insertarAyuntamiento



	/**

	 * Mtodo que dado el nmero interno del ayuntamiento recupera de la BBDD

	 * los datos de dicho ayuntamiento

	 * 

	 * @param idAyuntamiento

	 * @return

	 */

	public Q02bAyuntamiento obtenerAyuntamiento(String idAyuntamiento) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerAyuntamiento , ** dao idAyuntamiento= "+ idAyuntamiento + "  ** entrando");

		}



		// se crean los objetos necesarios para realizar la select.

		Q02bTablaBDQ022MS01V01 Q02bTablaBDQ022MS01V01obj = null;

		Q02bAyuntamiento ayuntamientoBD = null;

		ResultSet rs = null;

		try {

			if (idAyuntamiento != null) {

				Q02bTablaBDQ022MS01V01obj = new Q02bTablaBDQ022MS01V01(this.getConnection());



				// se pone el filtro

				Q02bTablaBDQ022MS01V01obj.setQ022MT00_ID_AYUN_WHERE(new Integer(idAyuntamiento));



				rs = Q02bTablaBDQ022MS01V01obj.select();

				Q02bTablaBDQ022MS01V01obj.addResultSet(rs);

				ayuntamientoBD = new Q02bAyuntamiento();

				if (rs.next()) {

					this.rellenarVOAyuntamiento(ayuntamientoBD, rs);

				}

			}

			return ayuntamientoBD;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":obtenerAyuntamiento: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				Q02bTablaBDQ022MS01V01obj.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":obtenerAyuntamiento: error liberando recursos");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerAyuntamiento: saliendo");

			}

		}

	}// fin obtenerAyuntamiento



	/**

	 * Funcin que borra el ayuntamiento pasado como parmetro de la BBDD

	 * @param idAyuntamiento - nmero interno del ayuntamiento a borrar

	 * @throws Exception

	 */

	public void borrarAyuntamiento(String idAyuntamiento) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":borrarAyuntamiento: entrando");

		}

		Q02bTablaBDQ022MS00 Q02bTablaBDQ022MS00obj = null;

		try {

			// se crean los objetos necesarios

			Q02bTablaBDQ022MS00obj = new Q02bTablaBDQ022MS00(this.getConnection());



			// segmento tecnico

			//Q02bTablaBDQ022MS00obj.setUser(this.getUser());



			// se pone el filtro para la delete

			Q02bTablaBDQ022MS00obj.setQ022MT00_ID_AYUN_WHERE(Integer.parseInt(idAyuntamiento));



			// se lanza el delete

			Q02bTablaBDQ022MS00obj.delete();

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":borrarAyuntamiento: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				Q02bTablaBDQ022MS00obj.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":borrarAyuntamiento: error liberando recursos");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":borrarAyuntamiento: saliendo");

			}

		}

	}// fin borrarAyuntamiento



	/**

	 * Funcin que modifica los datos del ayuntamiento pasado como parmetro en la BBDD

	 * 

	 * @param ayuntamiento - Datos del ayuntamiento a modificar

	 * @throws Exception

	 */

	public void modificarAyuntamiento(Q02bAyuntamiento ayuntamiento) throws Exception {



		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":modificarAyuntamiento: entrando");

		}

		// Se instancian los objetos necesarios.

		Q02bTablaBDQ022MS00 Q02bTablaBDQ022MS00obj = null;

		try {

			// se crea el objeto de tablasBD

			Q02bTablaBDQ022MS00obj = new Q02bTablaBDQ022MS00(this.getConnection());



			// segmento tecnico

			// Q02bTablaBDQ022MS00obj.setUser(this.getUser());



			rellenaDatosAyuntamiento(ayuntamiento, Q02bTablaBDQ022MS00obj);

			Q02bTablaBDQ022MS00obj.setQ022MT00_ID_AYUN_WHERE(Integer.parseInt(ayuntamiento.getIdAyuntamiento()));



			// se realiza la update

			Q02bTablaBDQ022MS00obj.update();

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":modificarAyuntamiento: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				Q02bTablaBDQ022MS00obj.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":modificarAyuntamiento: error liberando recursos");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":modificarAyuntamiento: saliendo");

			}

		}

	} // fin modificarAyuntamiento



}

