/*

 * XMLBuilder.java

 *

 * Created on 4 de julio de 2003, 8:54

 */

package q02b.exe.arquitectura.utils.xml;





import org.w3c.dom.*;

/**

 * Esta clase encapsula las APIs de XML de jakarta, y permite crear un documento XML sin necesidad de conocer dichas APIs.

 * <p>

 * Ejemplo de utilizacin: <br>

 * <pre>

 * //Instanciacin del objeto

 * XMLBuilder xml = new XMLBuilder(); 

 * 

 * //Creamos el tag <DOCUMENTO>

 * Element document = xml.createTag("DOCUMENTO");



 * //Creamos el tag <CUSTOMER>

 * Element customer= xml.createTag("CUSTOMER");

 * 

 * //Aadimos el tag customer al tag document

 * xml.addChild(document,customer);

 * //document.appendChild(customer);

 * 

 * //Creamos el tag <NAME>

 * Element name = xml.createTag("NAME");

 * 

 * //Aadimos al tag <name> o un tag <LASTNAME>pepito</pepito> 

 * xml.addChild( name , xml.createTag("LASTNAME" , "pepito" , false ) );

 * //name.appendChild( xml.createTag("LASTNAME" , "pepito" , false ) );

 * 

 * //Aadimos al tag <name> o un tag <FIRSTNAME>iturri</pepito> 

 * xml.addChild( name , xml.createTag("FIRSTNAME" , "iturri" , false ) );

 * //name.appendChild( xml.createTag("FIRSTNAME" , "iturri" , false ) );

 * 

 * //Aadimos el tag <NAME> como hijo de <CUSTOMER>

 * xml.addChild(customer,name);

 * //document.appendChild( name );

 * 

 *

 * //Creamos un tag <ADDRESS>

 * Element address = xml.createTag("ADDRESS");

 * 

 * //Creamos un tag <STREET><![CDATA[calle manolete n 2]]></STREET>

 * xml.addChild( address , xml.createTag("STREET" , "calle manolete n 2" , true ) );

 * //address.appendChild( xml.createTag("STREET" , "calle manolete n 2" , true ) );

 * 

 * //Creamos un tag <POSTAL>48910</POSTAL>

 * xml.addChild( address , xml.createTag("POSTAL" , "48910" , false ) );

 * //address.appendChild( xml.createTag("POSTAL" , "48910" , false ) );

 * 

 * //Creamos un tag <LOCATION>Sestao</LOCATION>

 * xml.addChild( address , xml.createTag("LOCATION" , "Sestao" , false ) );

 * //address.appendChild( xml.createTag("LOCATION" , "Sestao" , false ) );

 * 

 * //Aadimos el tag address como hijo de customer

 * xml.addChild(customer,address);

 * //document.appendChild( address );

 * 

 *

 * //Creamos el tag <ORDERS>

 * Element orders = xml.createTag("ORDERS");

 * Element item = null;

 * 

 * //Creamos un tag <ITEM>

 * item = xml.createTag("ITEM");

 * 

 * //Aadimos un tag <PRODUCT>ijito</PRODUCT> como hijo de ITEM

 * xml.addChild( item , xml.createTag("PRODUCT" , "ijito" , false ) );

 * //item.appendChild( xml.createTag("PRODUCT" , "ijito" , false ) );

 * 

 * //Aadimos un tag <PRICE>2000</PRICE> como hijo de ITEM

 * xml.addChild( item , xml.createTag("PRICE" , "2000" , false ) );

 * //item.appendChild( xml.createTag("PRICE" , "2000" , false ) );

 * 

 * //Aadimos un atributo orderId al tag item, de manera que queda: <ITEM orderID="1">

 * xml.addAttribute(item,"orderId","1");

 * //item.setAttribute("orderId","1");

 * 

 * //Aadimos el tag item como hijo de orders

 * xml.addChild(orders,item);

 * //orders.appendChild(item);

 * 

 * 

 * //Creamos otro item

 * item = xml.createTag("ITEM");

 * 

 * xml.addChild( item , xml.createTag("PRODUCT" , "acero&hierro" , true ) );

 * //item.appendChild( xml.createTag("PRODUCT" , "ijito" , false ) );

 * 

 * xml.addChild( item , xml.createTag("PRICE" , "8745" , false ) );

 * //item.appendChild( xml.createTag("PRICE" , "2000" , false ) );

 * 

 * xml.addAttribute(item,"orderId","2");

 * //item.setAttribute("orderId","2");

 * 

 * xml.addChild(orders,item);

 * //orders.appendChild(item);

 * 

 * 

 * //Aadimos el tag orders como hijo del tag <DOCUMENTO>

 * xml.addChild(document,orders);

 * //document.appendChild( orders );

 * 

 * //Establecemos el tag DOCUMENTO como raz del documento XML

 * xml.setRootTag(document);

 * //xml.getDocument().appendChild(document);

 * 

 * //Serializamos  el documento xml creado

 * System.out.println(xml.toString("ISO-8859-1",false));

 * 

 * //Buscamos el tag PRODUCTO cuyo tag padre ITEM tiene un atributo orderId con valor 1.

 * System.out.println(xml.getNodeValue(xml.searchNode("//ITEM[@orderId='1']/PRODUCT")));

 * //System.out.println(xml.searchNode("//ITEM[@orderId='1']/PRODUCT").getFirstChild().getNodeValue());

 *

 * Nota: el cdigo comentado es el equivalente usando directamente las apis de jakarta.

 * </pre>

 * @author  sergio.navarro

 */

public class Q02bXMLBuilder {

    

    /** Documento xml que se va creando. */

    private Document document = null;

    

    /** 

	 * Constructor vaco que se encarga de instanciar un nuevo documento y lo asigna a la propiedad document. 

	 */

    public Q02bXMLBuilder() throws javax.xml.parsers.ParserConfigurationException{

        setDocument(Q02bXMLUtils.getDocumentBuilder().newDocument());

    }

    

	/**

     * Constructor en el que asignamos un objeto document.

	 * @param document Objeto Document sobre el que queremos crear el xml.

	 */

    public Q02bXMLBuilder(Document document) {

        this.document = document;

    }

    

    /** Getter for property document.

     * @return Value of property document.

     */

    public final Document getDocument() {

        return this.document;

    }

    

    /** Setter for property document.

     * @param document New value of property document.

     */

    public final void setDocument(Document document) {

        this.document = document;

    }

    

	/**

	 * Crea un tag XML con el nombre indicado. El tag creado no se incluye en el documento. Esto se hace llamando al mtodo

	 * addChild. 

	 * @param name Nombre del tag a crear.

	 */

    public final Element createTag(String name){

        return document.createElement(name);

    }

    

	/**

	 * Crea un tag XML con el nombre y valor indicados. El tag creado no se incluye en el documento. Esto se hace llamando al mtodo

	 * addChild. 

	 * @param name Nombre del tag a crear.

	 * @param value Valor del tag a crear.

	 * @param useCDATA Habr que pasar true, cuando el valor del tag pueda contener caracteres XML no vlidos.

	 */

    public final Element createTag(String name , String value , boolean useCDATA){

        Element element = document.createElement(name);

        

        if(useCDATA){

            element.appendChild(document.createCDATASection(value));

        }else{

            element.appendChild(document.createTextNode(value));

        }

        

        return element;

    }

    

	/**

	 * Establece el tag raz del documento XML

	 * @param root Tag raz.

	 */

    public final void setRootTag(Node root){

        document.appendChild(root);

    }

    

	/**

	 * Aade un tag como hijo de otro tag. Si el tag padre ya tiene hijos, el nuevo hijo aadir despus de los hijos actuales.

	 * @param parent Nodo padre

	 * @param newChild Nodo hijo

	 */

    public final void addChild(Node parent,Node newChild){

        parent.appendChild(newChild);

    }

    

	/**

	 * Aade un tag como hijo de otro tag. El hijo se insertar antes del nodo before, que deber ser ya hijo del nodo parent.

	 * @param parent Nodo padre

	 * @param newChild Nodo hijo

	 * @param before Nodo antes del cual se colocar el nuevo hijo.

	 */

    public final void addChildBefore(Node parent,Node newChild,Node before){

        parent.insertBefore(newChild,before);

    }   

    

	/**

	 * Crea un atributo de un tag. Este atributo no se asigna a ningn nodo. Habr que asignarlo mediante el mtodo addAttribute.

	 * @param name Nombre del atributo.

	 * @param value Valor del atributo.

	 */

    public final Attr createAttribute(String name,String value){

        Attr attribute = document.createAttribute(name);

        attribute.setValue(value);

        

        return attribute;

    }

    

	/**

	 * Crea un atributo de un tag. Este atributo se asigna al nodo element.

	 * @param element Nodo al cual asignar el atributo.

	 * @param name Nombre del atributo.

	 * @param value Valor del atributo.

	 */

    public final void addAttribute(Element element,String attributeName,String attributeValue){

        element.setAttribute(attributeName,attributeValue);

    }

    

	/**

	 * Asigna un atributo a un tag.

	 * @param element Nodo al cual asignar el atributo.

	 * @param attribute Atributo que se asignar al tag

	 */

    public final void addAttribute(Element element,Attr attribute){

        element.setAttributeNode(attribute);

    }

    

	/**

	 * Elimina un tag.

	 * @param node Tag a eliminar

	 */

    public final void removeTag(Node node){

        node.getParentNode().removeChild(node);

    }

    

	/**

	 * Crea una copia de un tag.

	 * @param node Tag a duplicar

	 * @param deep Si es true, la copia incluir todos los nodos hijos de forma recursiva.

	 */

    public final Node cloneTag(Node node,boolean deep){

        return node.cloneNode(deep);

    }

    

	/**

	 * Busca un tag a partir otro tag. La sintaxis de la cadena de bsqueda estar en formato XPATH.

	 * @param xpathSearch Cadena XPATH de bsqueda

	 * @param root Nodo a partir del cul realizar la bsqueda

	 */

    public final Node searchNode(String xpathSearch,Node root) throws javax.xml.parsers.ParserConfigurationException,javax.xml.transform.TransformerException{

        return Q02bXMLUtils.XPATH.selectSingleNode(root,xpathSearch);

    }





	/**

	 * Busca un tag en todo el documento. La sintaxis de la cadena de bsqueda estar en formato XPATH.

	 * @param xpathSearch Cadena XPATH de bsqueda

	 */

    public final Node searchNode(String xpathSearch) throws javax.xml.parsers.ParserConfigurationException,javax.xml.transform.TransformerException{

        return Q02bXMLUtils.XPATH.selectSingleNode(document,xpathSearch);

    }

    

	/**

	 * Busca una lista de tags a partir otro tag. La sintaxis de la cadena de bsqueda estar en formato XPATH.

	 * @param xpathSearch Cadena XPATH de bsqueda

	 * @param root Nodo a partir del cul realizar la bsqueda

	 */

    public final NodeList searchNodes(String xpathSearch,Node root) throws javax.xml.parsers.ParserConfigurationException,javax.xml.transform.TransformerException{

        return Q02bXMLUtils.XPATH.selectNodeList(root,xpathSearch);

    }



	/**

	 * Busca una lista de tags en todo el documento. La sintaxis de la cadena de bsqueda estar en formato XPATH.

	 * @param xpathSearch Cadena XPATH de bsqueda

	 */

    public final NodeList searchNodes(String xpathSearch) throws javax.xml.parsers.ParserConfigurationException,javax.xml.transform.TransformerException{

        return Q02bXMLUtils.XPATH.selectNodeList(document,xpathSearch);

    }

    

	/**

	 * Serializa el documento xml. La serializacin inclurir la cabecera de declaracin XML, y el encoding ser el definido en 

	 * la constante Q02bXMLUtils.DEFAULT_ENCODING

	 */

    public final String toString(){

        try{

            return toString(Q02bXMLUtils.DEFAULT_ENCODING,false);

        }catch(java.io.IOException ex){

            return ex.getLocalizedMessage();

        }catch(javax.xml.parsers.ParserConfigurationException ex){

            return ex.getLocalizedMessage();

        }

    }

    

	/**

	 * Serializa el documento xml.

	 * @param encoding Encoding a usar en la serializacin

	 * @param omitXmlDeclaration Si es true, no se incluir en la serializacin la cabecera de declaracin XML

	 */

    public final String toString(String encoding , boolean omitXmlDeclaration) throws java.io.IOException,javax.xml.parsers.ParserConfigurationException{

        java.io.ByteArrayOutputStream sw = new java.io.ByteArrayOutputStream();

        Q02bXMLUtils.serializeXML(document,new java.io.PrintStream( sw ) , encoding , omitXmlDeclaration);

        

        return sw.toString(encoding);

    }

    

	/**

	 * Devuelve el valor de un tag.

	 * @param node Tag

	 * @return Valor del tag

	 */

    public final String getNodeValue(Node node){

        return node.getFirstChild().getNodeValue();

    }

    

/*    public static void main(String[] args) throws Throwable{

        XMLBuilder xml = new XMLBuilder(); 

        

        Element document = xml.createTag("DOCUMENT");

        Element customer= xml.createTag("CUSTOMER");

        

        xml.addChild(document,customer);

        //document.appendChild(customer);

        

        Element name = xml.createTag("NAME");

        

        xml.addChild( name , xml.createTag("LASTNAME" , "pepito" , false ) );

        //name.appendChild( xml.createTag("LASTNAME" , "pepito" , false ) );

        

        xml.addChild( name , xml.createTag("FIRSTNAME" , "iturri" , false ) );

        //name.appendChild( xml.createTag("FIRSTNAME" , "iturri" , false ) );

        

        xml.addChild(customer,name);

        //document.appendChild( name );

        

        

        Element address = xml.createTag("ADDRESS");

        

        xml.addChild( address , xml.createTag("STREET" , "calle manolete n 2" , true ) );

        //address.appendChild( xml.createTag("STREET" , "calle manolete n 2" , true ) );

        

        xml.addChild( address , xml.createTag("POSTAL" , "48910" , false ) );

        //address.appendChild( xml.createTag("POSTAL" , "48910" , false ) );

        

        xml.addChild( address , xml.createTag("LOCATION" , "Sestao" , false ) );

        //address.appendChild( xml.createTag("LOCATION" , "Sestao" , false ) );

        

        xml.addChild(customer,address);

        //document.appendChild( address );

        

        

        Element orders = xml.createTag("ORDERS");

        Element item = null;

        

        item = xml.createTag("ITEM");

        

        xml.addChild( item , xml.createTag("PRODUCT" , "ijito" , false ) );

        //item.appendChild( xml.createTag("PRODUCT" , "ijito" , false ) );

        

        xml.addChild( item , xml.createTag("PRICE" , "2000" , false ) );

        //item.appendChild( xml.createTag("PRICE" , "2000" , false ) );

        

        xml.addAttribute(item,"orderId","1");

        //item.setAttribute("orderId","1");

        

        xml.addChild(orders,item);

        //orders.appendChild(item);

        

        

        item = xml.createTag("ITEM");

        

        xml.addChild( item , xml.createTag("PRODUCT" , "acero&hierro" , true ) );

        //item.appendChild( xml.createTag("PRODUCT" , "ijito" , false ) );

        

        xml.addChild( item , xml.createTag("PRICE" , "8745" , false ) );

        //item.appendChild( xml.createTag("PRICE" , "2000" , false ) );

        

        xml.addAttribute(item,"orderId","2");

        //item.setAttribute("orderId","2");

        

        xml.addChild(orders,item);

        //orders.appendChild(item);

        

        

        xml.addChild(document,orders);

        //document.appendChild( orders );

        

        xml.setRootTag(document);

        //xml.getDocument().appendChild(document);

        

        System.out.println(xml.toString("ISO-8859-1",false));

        

        System.out.println(xml.getNodeValue(xml.searchNode("//ITEM[@orderId='1']/PRODUCT")));

        //System.out.println(xml.searchNode("//ITEM[@orderId='1']/PRODUCT").getFirstChild().getNodeValue());

    }

*/    

}

