/*

 * DataBaseConnectionLocatos.java

 *

 * Created on 27 de junio de 2001, 14:02

 */



package q02b.exe.arquitectura.resourcelocators;



import java.sql.Connection;

import java.sql.SQLException;



import es.ejie.frmk.conectores.conectorJDBC.Q70ConectorJDBC;

import es.ejie.frmk.listeners.base.Q70ListenerUtils;







/**

 * Clase encargada de la localizacin de conexiones a bases de datos.

 * Esta clase obtiene una conexin a una base de datos, bien a

 * travs de JDBC bien a travs de un pool de conexiones J2EE.

 * Toda la informacin necesaria para establecer la conexin

 * <b>debe obtenerse del mdulo de configuracin</b> aunque

 * actualmente se obtenga de un fichero de propiedades.

 * Un ejemplo del fichero de propiedades podra ser:

 *

 *

 * #

 * # Fichero de propiedades para conexin BBDD

 * # Este es un substituto temporal al mdulo de configuracin

 * # AV, SJC, 2001-05

 *

 * #Si es SI, vamos por jdbc. Si no existe, o no es SI, vamos por pool

 * db2.usejdbc=SI

 * #ID por defecto.

 * bd.idConex=db2

 *

 * # URL  de la base de datos db2 para cuando vamos por jdbc

 * db2.url=jdbc:db2://hostBBK2.BBK.es:446/DB2E

 *

 * # Usuario para acceder a la base de datos db2 cuando vamos por jdbc

 * db2.user=47f8dls

 *

 * # Password para acceder a la base de datos db2 cuando vamos por jdbc

 * db2.password=jf99xl

 *

 * # Driver a utilizar para la base de datos db2

 * db2.driver=com.ibm.db2.jcc.DB2Driver

 *

 * # Nombre del pool de conexiones para la base de datos db2

 * db2.poolName=jdbc/bbknet3

 *

 * #Si es true, se habilita el debug de conexiones de base de datos, controlado por la clase PoolManager

 * db2.connDebugEnabled=true

 * 

 * # Indica que el nmero mximo de conexiones concurrentes ser 1.

 * db2.maxConnections=1

 *

 * @author A. Vieiro SJC Spain $Author: Leire.uriarte $

 * @version 2001-05 Alpha $Version$ $Revision: 1 $ $Date: 14/04/09 15:23 $

 */

public final class Q02bDatabaseConnectionLocator {

    

    /** El fichero de propiedades con informacin.

     * Esto debe substituirse por un acceso al sistema de

     * configuracin.

     */



	 

    public static Connection getConnection( ) throws SQLException, Exception {

    	String clave = Q70ListenerUtils.getApplicationProperty("DatabaseConnectioLocator",null,"Q02B_JNDI_DATASOURCE");    	

    	return Q70ConectorJDBC.getSingleton().getConnection(clave);

    }

    

    

    public static Connection getJDBCConnection() throws SQLException {

        String url = "";

        String driver = null;

        String user = null;

        String pwd = null;

        Connection conn = null;

        //oracle.url=jdbc:oracle:thin:@(description=(address=(host=ieoracledesa)(protocol=tcp)(port=1521))(connect_data=(sid=ORCOR)))

        url = "jdbc:oracle:thin:@(description=(address=(host=ieoracledesa)(protocol=tcp)(port=1521))(connect_data=(sid=ORCOR)))";

        driver = "oracle.jdbc.OracleDriver";

        user = "Q02B";

        pwd = "Q02B";

                

        try {

            Class.forName( driver );           

            conn = java.sql.DriverManager.getConnection( url, user, pwd );                

            conn.setAutoCommit(true);

            return conn;

           

        }

        catch( Throwable e ) {

            e.printStackTrace( System.err );

            throw new SQLException( "Acceso por JDBC a: " + e.getMessage()  );

        }

        

    }



    

   

    

}

