/*

 * BaseJspBean.java

 *

 * Created on 5 de febrero de 2002, 13:21

 */



package q02b.exe.arquitectura.beans;



import java.sql.Connection;

import java.util.Map;



import javax.servlet.http.HttpServletRequest;

import javax.servlet.http.HttpServletResponse;

import javax.servlet.http.HttpSession;



import q02b.exe.arquitectura.dataobjects.Q02bDAOException;

import q02b.exe.arquitectura.webCommon.utils.gdtp.Q02bGenericDataTransferProtocol;

import es.ejie.frmk.conectores.conectorJDBC.Q70ConectorJDBC;



import es.ejie.frmk.listeners.base.Q70ListenerUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;



import q02b.exe.comun.Q02bAutenticador;



/**

 * Clase base para los beans que se usan "directamente" en los jsp.<br>

 * Contiene un objeto request y un objeto response <b> que no se serializan</b>. A partir del objeto

 * request, el bean puede obtener informacin para realizar las acciones que tenga encomendadas. A travs

 * del objeto response, el bean puede incluso redireccionar la peticin a otro jsp.

 * <p>

 * La manera de instaciar un bean desde un jsp es con el tag UseBean

 * Una vez instanciado, hay que llamar al mtodo init(Request, Response) y si esto devuelve true, hacer un return.<br>

 * if( bean.init(request,response) ) return; <br>

 * Si queremos que el bean sea de sesin, pero hay que diferenciarlo entre ventanas, usar

 * if( bean.init(request,response,"nombreEnSesion") ) return; <br>

 * <p>

 * Si este bean guarda objetos en la sesin, lo podemos hacer de 2 formas: <br>

 * 1.- Mediante la propiedad session

 * 2.- Mediante el mtodo setValueToSession si queremos que se diferencie el contenido de la sesin entre dos ventanas

 * del navegador.

 * <p>

 * Contiene una propiedad esttica log que contendr el objeto log a utilizar para escribir trazas. Antes de utilizar el objeto

 * log, tiene que haber sido inicializado llamando al mtodo esttico initLog

 * @author  sergio.navarro

 * @version 1.0

 */

public abstract class Q02bBaseBean implements java.io.Serializable{

    /** Nombre de la cookie que guarda el nombre de la ventana para la gestin multiventana*/

    public static final String ID_NOMBRE_VENTANA = "NOMBRE_VENTANA";

    protected static final String COMPONENTE = "BEAN_ACCESO_DATOS";	

    protected String Q02_JNDI_DATASOURCE = Q70ListenerUtils.getApplicationProperty("Q02bCentrosBean",null,"Q02_JNDI_DATASOURCE");

    protected HttpSession httpSession = null;   

    /** Este string guarda el nombre de la ventana, que se recoge de la cookie NOMBRE_VENTANA para la gestin multiventana*/

    protected String nombreVentana = null;

    protected Q02bGenericDataTransferProtocol gdtp = null;

    /** Holds value of property request. */

    protected transient HttpServletRequest request;

    protected Connection conn = null;

    /** Holds value of property response. */

    protected transient HttpServletResponse response;

    /** Variable que contiene informacin del contexto de la aplicacin */   

    protected Q02bAutenticador autenticador	= null;

    

    /** Objeto log que utilizarn todos los beans. Se inicializa con el metodo setLog() */

    protected static Q70Traza tr = Q70Traza.getSingleton();

    

    /** Holds value of property nombreClaseSinPackage. */

    protected String nombreClaseSinPackage;

    

    /** Crea una instancia de la clase y llama al mtodo initNombreClaseSinPackage*/

    public Q02bBaseBean() {

        super();

        

        initNombreClaseSinPackage();

    }

    

    protected void finalize () throws Exception {

    	try{

	        if (!this.conn.isClosed() ) {

	        	 this.conn.close();

	        	 tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":conexin NO CERRADA: " );

	        }

    	}catch(Exception ex){}

    }



    public Q02bBaseBean(HttpServletRequest request,HttpServletResponse response) throws q02b.exe.arquitectura.dataobjects.Q02bDAOException{

        this();

        init(request,response);

    }

    

    /**

	 * @param conn The conn to set.

	 */

	public void setConn(Connection conn) {

		this.conn = conn;

	}



	/**

	 * @return Returns the conn.

	 */

	public Connection getConn() {

		return conn;

	}



	

    

    /** Getter for property request.

     * @return Value of property request.

     */

    public HttpServletRequest getRequest() {

        return request;

    }

    

    /** Setter for property request.

     * @param request New value of property request.

     */

    public void setRequest(HttpServletRequest request) {

        this.request = request;

    }

    

    /** Getter for property response.

     * @return Value of property response.

     */

    public HttpServletResponse getResponse() {

        return response;

    }

    

    /** Setter for property response.

     * @param response New value of property response.

     */

    public void setResponse(HttpServletResponse response) {

        this.response = response;

    }

    

    /**

     * Este mtodo se utiliza en los bean tontos, cuando se quiere que el bean sea multiventana. Es decir, que en diferentes ventanas de la misma sesin,

     * el bean sea diferente (una nueva instancia). <p>

     * En esta clase, este mtodo simplemente llama al mtodo init(Request, Response).

     * @param request Para la propiedad request del objeto

     * @param response Para la propiedad response del objeto

     * @return boolean true si se ha hecho un forward.

     *

     *

     */

    public boolean init(HttpServletRequest request,HttpServletResponse response) throws q02b.exe.arquitectura.dataobjects.Q02bDAOException{

        return init(request,response);

    }

    

   

    public void abrirConexion() throws Exception{

		try{

			this.conn = Q70ConectorJDBC.getSingleton().getConnection(Q02_JNDI_DATASOURCE);

			this.conn.setAutoCommit(false);			

		}catch(Exception ex){

			java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":abrirConexion: " + sw.getBuffer ().toString());

			}

            throw ex;

		}

	}

	

	public void cerrarConexion(boolean error) throws Exception{

		 //Si el bean hace la gestin de la conexin

      try{

         if (error){

        	 this.conn.rollback();

         }else{

        	 this.conn.commit();

         }

         try{

        	 this.conn.close();

        	 tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":cerrarrConexion: cerrada." );

         }catch(Exception e){

        	 java.io.StringWriter sw = new java.io.StringWriter();

             java.io.PrintWriter pw = new java.io.PrintWriter(sw);

             e.printStackTrace(pw);

             tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":cerrarrConexion: error cerrando la conexin." + sw.getBuffer ().toString());             

             throw e; 

         }

      }catch(Exception e){

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          e.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":cerrarrConexion: " + sw.getBuffer ().toString());

          throw e;

      }finally{

    	  tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":cerrarrConexion: saliendo." );

      }

	}

    

   

    

    /**

     * Obtiene un objeto log. Debe haberse inicializado llamando al mtodo initLog.

     * @return Value of property log.

     */

    public static Q70Traza getLog() {

        return tr;

    }

    

    

    /**

     * Inicializa la propiedad esttica log.

     * @param log New value of property log.

     */

    public static void initLog(Q70Traza newTr) {

        tr = newTr;

    }

    

    /** Getter for property nombreClaseSinPackage.

     * @return Value of property nombreClaseSinPackage.

     */

    public String getNombreClaseSinPackage() {

        return this.nombreClaseSinPackage;

    }

    

    /** 

     * Inicializa la propiedad nombreClaseSinPackage

     */

    public void initNombreClaseSinPackage() {

        String nombreFiltrado;

        String nombreClase = getClass().getName();

        

        try {

            if (nombreClase != null){

                nombreFiltrado = nombreClase.substring( nombreClase.lastIndexOf(".") + 1);

            }

            else{

                nombreFiltrado = "ClaseDesconocida";

            }

        }catch (java.lang.Exception e){

            nombreFiltrado = "ClaseDesconocida";

        }

        

        nombreClaseSinPackage = nombreFiltrado;

    }

    

    public void setGDTP(Q02bGenericDataTransferProtocol GDTP ){

    	this.gdtp = GDTP;    

    }

    //recupera el GDTP de local, de la sesin o de la request:

    protected Q02bGenericDataTransferProtocol getGDTP() throws Q02bDAOException{

    	try{

            if  ( this.gdtp == null){

                httpSession = request.getSession();

                if ( httpSession.getAttribute("GDTP") != null ){

                    this.gdtp = ( Q02bGenericDataTransferProtocol )httpSession.getAttribute("GDTP");

                }else{



                    String data = request.getParameter("GDTP_DATA");

                    if(data==null){

                            data = request.getParameter("GDTP_DATA_1");		

                    }

                    if(data!=null){

                            this.gdtp = Q02bGenericDataTransferProtocol.parse(data);			

                    }	

                }

            }

            return this.gdtp;

    	}catch(Exception e){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            e.printStackTrace(pw);

            throw new Q02bDAOException(e);                                                                                                    

    	}    

    }  

    protected Map getMapaDatos()throws Q02bDAOException{

       return this.getGDTP().getGroupPropertyMap("APP_DATA");    

    }

    protected String getParametro(String nombre)throws Q02bDAOException{

   	 return (String)this.getMapaParametros().get(nombre);

   }

    

    protected Map getMapaParametros()throws Q02bDAOException{

        return this.getGDTP().getGroupPropertyMap("APP_PARAMETERS");    

    }



    protected Q02bGenericDataTransferProtocol respuestaOK(){



		Q02bGenericDataTransferProtocol gdtpRespuesta = new Q02bGenericDataTransferProtocol();

		gdtpRespuesta.addGroup("RESULT_1");	

		gdtpRespuesta.addProperty("RESULT_1","RESULT","OK");		

		return gdtpRespuesta;

    }

    

    protected Q02bGenericDataTransferProtocol respuestaNoOK(){

//    	Crear GDTP

		Q02bGenericDataTransferProtocol gdtpRespuesta = new Q02bGenericDataTransferProtocol();

		gdtpRespuesta.addGroup("RESULT_1");

		gdtpRespuesta.addProperty("RESULT_1","RESULT","NOK");

		

		return gdtpRespuesta;

    }



      

   /**

    * Procesa una excepcin llamando a ErrorFactory.

   * @param ex Excepcin a procesar

   * @return Mapa con los datos de la excecpcin

   * @throws Q02bDAOException Si se produce algn error

   */

     protected Q02bGenericDataTransferProtocol processException(Throwable ex, String aplicacion) throws Q02bDAOException{

          try{

          	Q02bGenericDataTransferProtocol gdtpRespuesta = new Q02bGenericDataTransferProtocol();



          	gdtpRespuesta = processException(ex, aplicacion,gdtpRespuesta,null);

  	        

  			return gdtpRespuesta;

          }catch(Q02bDAOException exc){

              throw exc;

          }catch(Exception exc){

              throw new Q02bDAOException(exc);

          }

      }

     

     /**

      * Procesa una excepcin llamando a ErrorFactory.

     * @param ex Excepcin a procesar

     * @return Mapa con los datos de la excecpcin

     * @throws Q02bDAOException Si se produce algn error

     */

       protected Q02bGenericDataTransferProtocol processException(Throwable ex) throws Exception{

            return this.processException(ex,null);

        }

       

       protected Q02bGenericDataTransferProtocol processException(Throwable ex, String aplicacion, Q02bGenericDataTransferProtocol gdtpRespuesta) throws Exception{

       		return processException(ex, aplicacion,gdtpRespuesta,null);      	

       }

       

       

       protected Q02bGenericDataTransferProtocol processException(Throwable ex, String aplicacion, Q02bGenericDataTransferProtocol gdtpRespuesta,Object[] arguments) throws Q02bDAOException{

           try{        				  

           	if (gdtpRespuesta==null){ gdtpRespuesta = new Q02bGenericDataTransferProtocol();}

   	        

   	        int i = 1;

   	        while (gdtpRespuesta.getGroupPropertyMap("ERROR_" + i)!=null){

   	        	i++;

   	        }

   			return gdtpRespuesta;

          

           }catch(Exception exc){

               throw new Q02bDAOException(exc);

           }

       }

       

       /** Obtener y dar valor al autenticador */

       public Q02bAutenticador getAutenticador() {

   		return this.autenticador;

	   }

	   public void setAutenticador(Q02bAutenticador autenticador) {

	   		this.autenticador = autenticador;

	   }   

}