package q02b.exe.agentes.dataobjects;



import java.sql.Connection;

import java.sql.PreparedStatement;

import java.sql.ResultSet;

import java.util.ArrayList;



import q02b.exe.arquitectura.dataobjects.Q02bDataBaseDAO;

import q02b.exe.agentes.valueobjects.Q02bAgentes;

import q02b.exe.agentes.valueobjects.Q02bFiltroAgentes;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022JS01V01;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022JS00; 

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022ZS00;

import q02b.exe.utils.Q02bFormatData;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;







public class Q02bAgentesDataBaseDAO extends Q02bDataBaseDAO{

	private static final long serialVersionUID = -8520551641771839103L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "DAO_ACCESO_DATOS";

	



	public Q02bAgentesDataBaseDAO() {

        super();                

    }



    

    public Q02bAgentesDataBaseDAO(Connection conn) {

    	super(conn);     

    }



    private ArrayList rellenaVOsAgentes( ResultSet rs ) throws Exception{

    	Q02bAgentes agentes;

     	ArrayList listaAgentes = new ArrayList();

     	try{

     		//String idiomaEu=q02b.exe.utils.Q02bConstantes.getString("idioma.eu");

     		if (tr.isTraceActive()){

 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsAgentes: entrando");                

 		    } 

     		while (rs.next()){	 

 	        	//se cargan en el objeto cuestionario los datos recuperados

     			agentes = new Q02bAgentes();

     			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":rellenarVOsAgentes: Hay Datos");

     			agentes.setIdAgente(rs.getString(Q02bTablaBDQ022JS01V01.NOMCOLUMN_Q022JT00_ID_AGEN ));

     			agentes.setNomb(rs.getString(Q02bTablaBDQ022JS01V01.NOMCOLUMN_Q022JT00_NOMB));

     			agentes.setApe1(rs.getString(Q02bTablaBDQ022JS01V01.NOMCOLUMN_Q022JT00_APE1));

     			agentes.setApe2(rs.getString(Q02bTablaBDQ022JS01V01.NOMCOLUMN_Q022JT00_APE2));

     			agentes.setCodag(rs.getString(Q02bTablaBDQ022JS01V01.NOMCOLUMN_Q022JT00_CODAG));

     			agentes.setCodjf(rs.getString(Q02bTablaBDQ022JS01V01.NOMCOLUMN_Q022JT00_CODJF));

     						

     			/*agentes.setApe1(rs.getString(Q02bTablaBDQ022JS01V01.COLUMN_Q022JT00_APE1));

     			agentes.setApe2(rs.getString(Q02bTablaBDQ022JS01V01.COLUMN_Q022JT00_APE2));

     			agentes.setCodag(rs.getString(Q02bTablaBDQ022JS01V01.COLUMN_Q022JT00_CODAG));

     			agentes.setCodjf(rs.getString(Q02bTablaBDQ022JS01V01.COLUMN_Q022JT00_CODJF));

     			agentes.setNomb(rs.getString(Q02bTablaBDQ022JS01V01.COLUMN_Q022JT00_NOMB));

     			agentes.setEmaila(rs.getString(Q02bTablaBDQ022JS01V01.COLUMN_Q022JT00_EMAILA));

     			agentes.setIdOfi(rs.getString(Q02bTablaBDQ022JS01V01.COLUMN_Q022JT00_ID_OFI));     			

     			agentes.setTelf1a(rs.getString(Q02bTablaBDQ022JS01V01.COLUMN_Q022JT00_TELF1A));

     			agentes.setTelf2a(rs.getString(Q02bTablaBDQ022JS01V01.COLUMN_Q022JT00_TELF2A));

     			agentes.setDescProvincia(rs.getString(Q02bTablaBDQ022JS01V01.NOMCOLUMN_NORA_T17_PROVINCIA_DS));

     			agentes.setDescMunicipio(rs.getString(Q02bTablaBDQ022JS01V01.NOMCOLUMN_NORA_T17_MUNICIPIO_DS));

			   	if (Q02bFormatData.esNull(this.getIdioma()).equals(idiomaEu))

     			//if (this.getIdioma()==null)

     			//	 agentes.setDescOficina(rs.getString(Q02bTablaBDQ022JS01V01.NOMCOLUMN_Q022HT00_DESC));

     			//else if (this.getIdioma().equals(idiomaEu))

			   		agentes.setDescOficina(rs.getString(Q02bTablaBDQ022JS01V01.NOMCOLUMN_Q022HT00_DESC_EUS));

			   	else agentes.setDescOficina(rs.getString(Q02bTablaBDQ022JS01V01.NOMCOLUMN_Q022HT00_DESC));*/

			   

     			listaAgentes.add(agentes);

   			}  	  

     		return listaAgentes;

     	}catch(Exception ex){    	 	   

  	       java.io.StringWriter sw = new java.io.StringWriter();

  	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);

  	       ex.printStackTrace(pw);

  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenarVOsAgentes: " + sw.getBuffer ().toString());

  	       throw ex;

  		}finally{			 	

  			if (tr.isTraceActive()){

  		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsAgentes: saliendo");                

  		    }    				

  		}

     }//fin rellenarVOsAgentesVista(rs) 

    

     private Q02bAgentes  tratarRs(ResultSet rs) throws Exception

     {

    	tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":tratarRs: entrando");           

    	Q02bAgentes agentes = new Q02bAgentes();     

   	  	if (rs.next())

   	  	{	 

   	  		tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":tratarRs: Hay registro");                

   	  		try{

	   	  		tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":rellenarVOsagentes: Hay Datos"); 

	   	  		agentes.setIdAgente(rs.getString(Q02bTablaBDQ022JS00.NOMCOLUMN_Q022JT00_ID_AGEN));

	   	  		agentes.setApe1(rs.getString(Q02bTablaBDQ022JS00.NOMCOLUMN_Q022JT00_APE1));

	   	  		agentes.setApe2(rs.getString(Q02bTablaBDQ022JS00.NOMCOLUMN_Q022JT00_APE2));

	   	  		agentes.setCodag(rs.getString(Q02bTablaBDQ022JS00.NOMCOLUMN_Q022JT00_CODAG));

	   	  		agentes.setCodjf(rs.getString(Q02bTablaBDQ022JS00.NOMCOLUMN_Q022JT00_CODJF));

	   	  		agentes.setEmaila(rs.getString(Q02bTablaBDQ022JS00.NOMCOLUMN_Q022JT00_EMAILA));

	   	  		//agentes.setIdOfi(rs.getString(Q02bTablaBDQ022JS00.NOMCOLUMN_Q022JT00_ID_OFI));

	   	  		agentes.setNomb(rs.getString(Q02bTablaBDQ022JS00.NOMCOLUMN_Q022JT00_NOMB));

	   	  		agentes.setTelf1a(rs.getString(Q02bTablaBDQ022JS00.NOMCOLUMN_Q022JT00_TELF1A));

	   	  		agentes.setTelf2a(rs.getString(Q02bTablaBDQ022JS00.NOMCOLUMN_Q022JT00_TELF2A)); 

			   	/*plazos.setFechaAlta(Q02bFormatData.formatearFecha( Q02bFormatData.checkStringNull( rs.getString( Q02bTablaBDQ022AS00.NOMCOLUMN_Q022AT00_FEC_ALTA)), Q02bConstantes.FORMATO_FECHA_FORMAT_DATA, this.getIdioma()));

			   	*/

   	  		}catch (Exception e) {

   	  			if (tr.isTraceActive()){

   	  				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":tratarRs: error "+ e.getMessage());

   	  			}  

   	  		}  	

   	  	}

   	  	return agentes;

     }//tratarRS

     

    private int dameSeqNiAgentes(Q02bTablaBDQ022JS00 tablaAgentes) throws Exception 

     {

    	int niAgente=1;

     	ResultSet rs = null;

       	PreparedStatement prepStmt =null;	

     	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameSeqNiAgentes: entrando");

	    	}

    		StringBuffer query = new StringBuffer(" SELECT Q022JQ00.NEXTVAL FROM DUAL ");

         	prepStmt = this.getConnection().prepareStatement(query.toString());         	

         	rs = prepStmt.executeQuery();

         	tablaAgentes.addResultSet(rs);

         	tablaAgentes.addStatement(prepStmt);        	

         	if (rs.next()){

         		niAgente = rs.getInt(1);

         		

         	}	         	

         	return niAgente;

        }

	        catch(Exception ex)

     	        {   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameSeqNiAgentes: " + sw.getBuffer ().toString());

     		throw ex;

     	      }

     }//dameSegNiAgentes

     

    public void rellenaDatosAgentes(Q02bAgentes agente,Q02bTablaBDQ022JS00 tablaAgentes, boolean esAlta) throws Exception {

       	//se definen objetos necesarios.

       	try{

   	    	if (tr.isTraceActive())

   	    	{

   	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosAgentes: entrando");

   	    	}         	         

        	//se aaden los datos

   	    	//TODO

   	    	//OJOOOO MODIFICAR

   	    	//tablaAgentes.setQ022JT00_ID_OFI(Q02bFormatData.checkIntegerNull(agente.getIdOfi()));   	    	

   	    	tablaAgentes.setQ022JT00_APE1(agente.getApe1());

   	    	tablaAgentes.setQ022JT00_APE2(agente.getApe2());

   	    	tablaAgentes.setQ022JT00_CODAG(agente.getCodag());

   	    	tablaAgentes.setQ022JT00_CODJF(agente.getCodjf());

   	    	tablaAgentes.setQ022JT00_EMAILA(agente.getEmaila());

  	    	tablaAgentes.setQ022JT00_ID_AGEN(Q02bFormatData.checkIntegerNull(agente.getIdAgente()));   	    	

   	    	tablaAgentes.setQ022JT00_NOMB(agente.getNomb());   	    

   	    	//if(!Q02bFormatData.esNull(agente.getTelf1a()).equals(""))

   	    		tablaAgentes.setQ022JT00_TELF1A(Q02bFormatData.checkIntegerNull(agente.getTelf1a()));

   	    	//if(!Q02bFormatData.esNull(agente.getTelf2a()).equals(""))

   	    		//tablaAgentes.setQ022JT00_TELF2A(Integer.parseInt(agente.getTelf2a()));

   	    		tablaAgentes.setQ022JT00_TELF2A(Q02bFormatData.checkIntegerNull(agente.getTelf2a()));

   	    	   	    	

       	}catch(Exception ex){   	   

       		java.io.StringWriter sw = new java.io.StringWriter();

       		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

       		ex.printStackTrace(pw);

       		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaDatosAgentes: " + sw.getBuffer ().toString());

       		throw ex;

       	}finally{    		

   			if (tr.isTraceActive()){

   				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosAgentes: saliendo = " + tablaAgentes.getQ022JT00_ID_AGEN());

   						

              }       	

       	}	

     }//rellenaDatosAgente 

     

    public ArrayList getAgentes(Q02bFiltroAgentes filtroAgentesVO) throws Exception {		

 		//se instancian los objetos necesarios para realizar la consulta.			

    	//Q02bTablaBDQ022JS00 tablaAgentes=null;

    	Q02bTablaBDQ022JS01V01 tablaAgentes=null;

 		ResultSet rs = null;

 		ArrayList listaAgentes = new ArrayList();

 		

 		try{

 	    	if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getAgentes: entrando");

 			}

 	    	

 	    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	

 	    	//tablaAgentes = new Q02bTablaBDQ022JS00(this.getConnection());

 	    	tablaAgentes = new Q02bTablaBDQ022JS01V01(this.getConnection());

 	    	

 	    	

 	    	

 	    	//this.rellenaFiltroAgentes(filtroAgentesVO, tabla022IS01V01);

 	    	this.rellenaFiltroAgentes(filtroAgentesVO, tablaAgentes);

 	    	   	

 	    	StringBuffer distinctBuffer = new StringBuffer();  

 	    	distinctBuffer.append(tablaAgentes.NOMCOLUMN_Q022JT00_APE1);

 	    	distinctBuffer.append(",");

 	    	distinctBuffer.append(tablaAgentes.NOMCOLUMN_Q022JT00_APE2);

 	    	distinctBuffer.append(",");

 	    	distinctBuffer.append(tablaAgentes.NOMCOLUMN_Q022JT00_NOMB );

 	    	distinctBuffer.append(",");

 	    	distinctBuffer.append(tablaAgentes.NOMCOLUMN_Q022JT00_CODAG );

 	    	distinctBuffer.append(",");

 	    	distinctBuffer.append(tablaAgentes.NOMCOLUMN_Q022JT00_CODJF); 

 	    	distinctBuffer.append(","); 

 	    	distinctBuffer.append(tablaAgentes.NOMCOLUMN_Q022JT00_ID_AGEN);

 	    	//se realiza la select 	    	

 	    	tablaAgentes.setDistinct(distinctBuffer.toString());

 	    	tablaAgentes.setOrderBy(" Q022JT00_APE1 ");

 	    		    	

 	    	rs = tablaAgentes.selectDistinct() ;

 	    	//aadimos el cursos para luego poder liberarlo ( en el freeResources)

 	    	tablaAgentes.addResultSet(rs); 

 	    	//se trata el resultado obtenido aadiendolo a la lista de salida

 	    	listaAgentes = this.rellenaVOsAgentes(rs);

    	

 	    	return listaAgentes;    	

 		}catch(Exception ex){ 	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getAgentes: " + sw.getBuffer ().toString());

     		throw ex;

 		}finally{

 		 	try{

 		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

 		 		tablaAgentes.freeResourcesNotConnection();	

 			 }catch(Exception ex)

 			 {

 			    if (tr.isTraceActive())

 			    {

 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getAgentes: error liberando recursos.");

 	   	   	    }  

 			 }  		 			

 			 if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getAgentes: saliendo.");                

 	         }   

 		}	

 	}//fin getAgentes

    

    /**

     * Mtodo que dado el nmero interno del plazo 

     * recupera de la BBDD los datos de dicho plazo

     * @param niAgente

     * @return

     */

    public Q02bAgentes obtenerAgente(String idAgente)throws Exception

    {

  	  if (tr.isTraceActive()){

 		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAgente , ** dao niAgente= "+  idAgente + "  ** entrando");            

      }

  	  

  	  //se crean los objetos necesarios para ralizar la select.

  	  Q02bTablaBDQ022JS00 Q02bTablaBDQ022J00obj = null;

  	  Q02bAgentes agenteBD = null;

  	  ResultSet rs = null;   	  

        try{ 

          if (idAgente!=null){           

        	  Q02bTablaBDQ022J00obj = new Q02bTablaBDQ022JS00(this.getConnection());

          	

          	//se pone el filtro

        	  Q02bTablaBDQ022J00obj.setQ022JT00_ID_AGEN_WHERE (new Integer(idAgente));

        

          	rs = Q02bTablaBDQ022J00obj.select();

          	Q02bTablaBDQ022J00obj.addResultSet(rs); 

          	agenteBD = tratarRs(rs);

          }  

          return agenteBD;

          }catch(Exception ex){           	   

                 java.io.StringWriter sw = new java.io.StringWriter();

                 java.io.PrintWriter pw = new java.io.PrintWriter(sw);

                 ex.printStackTrace(pw);

                 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAgente: " + sw.getBuffer ().toString());

                 throw ex;

          }finally{

       	   try{

       		Q02bTablaBDQ022J00obj.freeResourcesNotConnection();	

  				}catch(Exception ex){

  	   			if (tr.isTraceActive()){

  	   				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAgente: error liberando recursos");

  	   		   	   }  

  				}  	

           	  if (tr.isTraceActive()){

           		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazo: saliendo");                

                }            	 

          }	  

          

    }//fin obtenerAgente

     

     /**

      * Funcin que inserta los datos del agente pasado como parmetro en la BBDD

      * @param agente - Datos del agente a insertar 

      * @throws Exception

      */

     public String insertarAgentes(Q02bAgentes agente) throws Exception {

    	int niAgente = 0; 

    	Q02bTablaBDQ022JS00 tablaAgentes=null;

       	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarAgentes: entrando");

	    	}

    		//se crea el objeto de tablasBD

	    	tablaAgentes = new Q02bTablaBDQ022JS00(this.getConnection());

      		//primero recuperamos el nmero interno que le corresponde

	    	niAgente = dameSeqNiAgentes(tablaAgentes);

	    	agente.setIdAgente(Integer.toString(niAgente));      	

      		//se aaden los datos a insertar

         	this.rellenaDatosAgentes(agente, tablaAgentes,true);         	         

      		//se realiza la insert

         	tablaAgentes.insert();

         	return Integer.toString(niAgente);    	

     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarAgentes: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     	finally

     	{

     		try

     		{

     			tablaAgentes.freeResourcesNotConnection();	

     		}

     		catch(Exception ex)

     		{

     			if (tr.isTraceActive())

     			{

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarAgentes: error liberando recursos");

 		   	   }  

 		}  		

		if (tr.isTraceActive())

		{

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarAgentes: saliendo");                

    		}       	

     	}

     } //insertarAgentes   

      

     /**

      * Funcin que borra el agente pasado como parmetro de la BBDD

      * @param idAgente - nmero interno del plazo a borrar

      * @throws Exception

      */

    public void borrarAgentes(String idAgente) throws Exception {

      	if (tr.isTraceActive()){

      		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarAgentes: entrando");

      	}

      	Q02bTablaBDQ022JS00 Q02bTablaBDQ022JS00obj = null;

      	Q02bTablaBDQ022ZS00 Q02bTablaBDQ022ZS00obj = null;

        try{       	

        	//se crean los objetos necesarios

        	Q02bTablaBDQ022JS00obj = new Q02bTablaBDQ022JS00(this.getConnection());  

        	Q02bTablaBDQ022ZS00obj = new Q02bTablaBDQ022ZS00(this.getConnection());  

         	

        	// segmento tecnico

        	Q02bTablaBDQ022JS00obj.setUser(this.getUser());

        	Q02bTablaBDQ022ZS00obj.setUser(this.getUser());

         	

         	//se pone el filtro para la delete

        	Q02bTablaBDQ022JS00obj.setQ022JT00_ID_AGEN_WHERE(Integer.parseInt(idAgente));    

        	Q02bTablaBDQ022ZS00obj.setQ022JT00_ID_AGEN_WHERE(Integer.parseInt(idAgente));    

         	

         	//se lanza el delete

        	Q02bTablaBDQ022JS00obj.delete();

        	Q02bTablaBDQ022ZS00obj.delete();

         }

         catch(Exception ex)

         {

              java.io.StringWriter sw = new java.io.StringWriter();

              java.io.PrintWriter pw = new java.io.PrintWriter(sw);

              ex.printStackTrace(pw);

              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarAgentes: " + sw.getBuffer ().toString());

              throw ex;

         } 

         finally {

         	try{

         		Q02bTablaBDQ022JS00obj.freeResourcesNotConnection();

         		Q02bTablaBDQ022ZS00obj.freeResourcesNotConnection();

         	}

         	catch(Exception ex) {

         		if (tr.isTraceActive()) {

         			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarAgentes: error liberando recursos");

         		}  

         	}  		

         	if (tr.isTraceActive()) {

         		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarAgentes: saliendo");                

            }     	   

         }

     }//fin borrarAgentes

     

     /**

      * Funcin que modifica los datos del agente pasado como parmetro en la BBDD

      * @param agente - Datos del agente a modificar

      * @throws Exception

      */

     public void modificarAgentes(Q02bAgentes agente) throws Exception {



      	if (tr.isTraceActive()){

  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarAgentes: entrando");

      	}

      	//Se instancian los objetos necesarios.

      	Q02bTablaBDQ022JS00 Q02bTablaBDQ022JS00obj = null;    

         	 try

         	 {     

         	 	//se crea el objeto de tablasBD

         		Q02bTablaBDQ022JS00obj = new Q02bTablaBDQ022JS00(this.getConnection());

        		

        		//segmento tecnico

             	//Q02bTablaBDQ022AS00obj.setUser(this.getUser());

        		  		

        		rellenaDatosAgentes(agente,Q02bTablaBDQ022JS00obj,false);

        		Q02bTablaBDQ022JS00obj.setQ022JT00_ID_AGEN_WHERE(Integer.parseInt(agente.getIdAgente()));

       		       		

        		//se realiza la update

        		Q02bTablaBDQ022JS00obj.update();

         	 }

         	 catch(Exception ex) {

         		java.io.StringWriter sw = new java.io.StringWriter();

         		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

         		ex.printStackTrace(pw);

         		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarAgentes: " + sw.getBuffer ().toString());

              throw ex;

         	 }

         	 finally {     

         		 try {

         			Q02bTablaBDQ022JS00obj.freeResourcesNotConnection();	

         		 }

         		 catch(Exception ex) {

         			 if (tr.isTraceActive()) {

         				 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarAgentes: error liberando recursos");

         			 }  

         		 }  		  

         		 if (tr.isTraceActive()) {

         			 	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarAgentes: saliendo");                

                 }             

         	 }     

     } // fin modificarAgentes

     

     /**

      * Mtodo que rellena el tablasBD con los datos del filtro de objeto que contiene

      * los criterios de bsqueda introducidos por el usuario

      * 

      * @param filtroAgentesVO

      * @param tablaBD

      * 

      * @throws Exception

      */

    public void rellenaFiltroAgentes(Q02bFiltroAgentes filtroAgentesVO, Q02bTablaBDQ022JS01V01 tabla022JS01V01)throws Exception

    {

     //Definicin de variables que no se van a modificar

     final String TRACE_METODO = ":rellenaFiltroInformantes:";

     StringBuffer sbDescripcion=null;

     StringBuffer sbNombre=null;

     StringBuffer sbApellido=null;

     StringBuffer sbCodag=null;

     StringBuffer sbAditionalWhere=new StringBuffer(" ");

     

    	try{

    		if (tr.isTraceActive()){

		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando");                

    		} 

    		if(!Q02bFormatData.esNull(filtroAgentesVO.getDescripcion()).equals("")){

    			sbDescripcion = new StringBuffer(" AND TRANSLATE(UPPER(Q022HT00_DESC),'','AEIOUAEIOU') like '%' || ");

    			sbDescripcion.append("TRANSLATE(UPPER('").append(filtroAgentesVO.getDescripcion()).append("'),'','AEIOUAEIOU') || '%'");

    		}

    		if(!Q02bFormatData.esNull(filtroAgentesVO.getNomb()).equals("")){

    			sbNombre = new StringBuffer(" AND TRANSLATE(UPPER(Q022JT00_NOMB),'','AEIOUAEIOU') like '%' || ");

    			sbNombre.append("TRANSLATE(UPPER('").append(filtroAgentesVO.getNomb()).append("'),'','AEIOUAEIOU') || '%'");

    		}

    		if(!Q02bFormatData.esNull(filtroAgentesVO.getApe1() ).equals("")){

    			sbApellido = new StringBuffer(" AND TRANSLATE(UPPER(Q022JT00_APE1),'','AEIOUAEIOU') like '%' || ");

    			sbApellido.append("TRANSLATE(UPPER('").append(filtroAgentesVO.getApe1()).append("'),'','AEIOUAEIOU') || '%'");

    		}

    	

    		if(!Q02bFormatData.esNull(filtroAgentesVO.getCodag() ).equals("")){

    			 sbCodag = new StringBuffer(" AND TRANSLATE(UPPER(Q022JT00_CODAG),'','AEIOUAEIOU') like '%' || ");

    			 sbCodag.append("TRANSLATE(UPPER('").append(filtroAgentesVO.getCodag()).append("'),'','AEIOUAEIOU') || '%'");

    		}

    		    		

    		if(!Q02bFormatData.esNull(filtroAgentesVO.getIdOfi() ).equals("")){

    			tabla022JS01V01.setQ022JT00_ID_OFI_WHERE(Integer.parseInt(filtroAgentesVO.getIdOfi()));
            }
    		

    		if(!Q02bFormatData.esNull(filtroAgentesVO.getCodProv()).equals("")){

    			tabla022JS01V01.setQ022HT00_PROV_WHERE(filtroAgentesVO.getCodProv());
            }
    		if(!Q02bFormatData.esNull(filtroAgentesVO.getCodMuni()).equals("")){

    			tabla022JS01V01.setQ022HT00_MUNI_WHERE(filtroAgentesVO.getCodMuni());
            }
    		

    		if(sbDescripcion!=null){

    			//tabla022JS01V01.setAditionalWhere(sbDescripcion.toString());

    			sbAditionalWhere=sbDescripcion;
            }
    		if(sbNombre!=null){

    			sbAditionalWhere=sbAditionalWhere.append(sbNombre);

    			//tabla022JS01V01.setAditionalWhere(sbNombre.toString());
            }
    		if(sbApellido!=null){

    			sbAditionalWhere=sbAditionalWhere.append(sbApellido);

    			//tabla022JS01V01.setAditionalWhere(sbApellido.toString());
            }
    		if(sbApellido!=null){

    			sbAditionalWhere=sbAditionalWhere.append(sbApellido);

    			//tabla022JS01V01.setAditionalWhere(sbCodag.toString());
            }
    		if(sbCodag!=null){

    			sbAditionalWhere=sbAditionalWhere.append(sbCodag);
            }
    		 if (sbAditionalWhere != null){ 

    			 tabla022JS01V01.setAditionalWhere(sbAditionalWhere.toString());
             }
    		

    		//tabla022IS01V01.setOrderBy();

	    	}	    	

    	catch(Exception ex)

    	{    	 	   

	       java.io.StringWriter sw = new java.io.StringWriter();

	       java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

	       ex.printStackTrace(pw);

	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() 		+ TRACE_METODO + sw.getBuffer ().toString());

	       throw ex;

	}finally

	{			 	

		if (tr.isTraceActive())

		{

		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() 	+ TRACE_METODO + " saliendo");                

		 }    				

	}

    }//fin rellenaFiltroPeriodosSinLicencia()

    

}

