package q02b.exe.agentes.beans;



import java.util.ArrayList;

import java.util.HashMap;



import q02b.exe.arquitectura.beans.Q02bBaseBean;

import q02b.exe.agentes.dataobjects.Q02bAgentesDataBaseDAO;

import q02b.exe.agentes.valueobjects.Q02bAgentes;

import q02b.exe.agentes.valueobjects.Q02bFiltroAgentes;

//import q02b.exe.informantes.valueobjects.Q02bFiltroInformantes;

import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;



   

public class Q02bAgentesBean extends Q02bBaseBean{

	private static final long serialVersionUID = 5474311672836163390L;

	protected Q02bAgentesDataBaseDAO daoAgentes = null;

	final static String	LISTA_PLAZOS = "listaAgentes";

	

	/** Constructor vacio */

    public Q02bAgentesBean() {

        super();

    }



    /**

     * Funcin que recupera los agentes

     * @return listaAgentes  -  Listado de agentes obtenidos

     * @throws Exception

     */

    public ArrayList getAgentes(HashMap mapaFiltroAgentes) throws Exception 

	{

    	Q02bFiltroAgentes filtroAgentesVO = null;

		 if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getAgentes: entrando.");

	   		}  	  

		ArrayList listaAgentes = new ArrayList();

		boolean error = false;

		

		try{

			//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoAgentes = new Q02bAgentesDataBaseDAO(this.getConn());

			

			//Segmento tecnico 

  			//daoAgentes.setUser(this.getAutenticador().getUser());

  			daoAgentes.setIdioma(this.getAutenticador().getIdioma());

//			Pasamos del hashMap recibido al valueObject

			filtroAgentesVO = (Q02bFiltroAgentes) Q02bVoUtils.getValueObject(mapaFiltroAgentes,"q02b.exe.agentes.valueobjects.Q02bFiltroAgentes");

			

			listaAgentes = daoAgentes.getAgentes(filtroAgentesVO);

            return listaAgentes;              

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getAgentes: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoAgentes.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getAgentes: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getAgentes: saliendo.");

	   		}

 	  	}

 	  } //fin getPlazos 

	

	

	/**

     * Mtodo que dado el nmero interno del agente 

     * recupera de la BBDD los datos de dicho cuestionario.

     * @param idAgente

     * @return agente

     */

	public Q02bAgentes obtenerAgente(String idAgente)throws Exception{  	 

	    	boolean error = false;

	    	Q02bAgentes agente = null;

	  	  	try  	  {

	  	  		if (tr.isTraceActive()){

	  	  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAgente, ** idAgente bean=" + idAgente + " *** entrando");                

	  	  		}

	  	  		

	  	  		//se abre la conexin

	  	  		abrirConexion();

	  	  		

	  	  		//se instancia el dao pasandole la conexin			

	  	  		daoAgentes = new Q02bAgentesDataBaseDAO(this.getConn());

	  	  		

	  	  		//Segmento tecnico 

	  			//daoAgentes.setUser(this.getAutenticador().getUser());

	  			daoAgentes.setIdioma(this.getAutenticador().getIdioma());

	  			

	  	  		//se llama al mtodo del dao que recupera el agente

	  	  		agente = daoAgentes.obtenerAgente(idAgente);

	  	  		

	  	  		//se devuelve el cuestionario recuperado

	  	  		return agente;

	  	  }catch(Exception ex){

	  		  	error= true;

	  		  	java.io.StringWriter sw = new java.io.StringWriter();

	          	java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          	ex.printStackTrace(pw);

	          	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAgente: " + sw.getBuffer ().toString());

	          	throw ex;                     

	 	  }finally{

	 		  	try{

	 		  		daoAgentes.freeResourcesNotConnection();

	 		  	}catch(Exception ex){

				   if (tr.isTraceActive()){

					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAgente: error liberando recursos");

		   	   	   }  

	 		  	}  		 

	 		  	//se cierra la conexin  

	 		  	cerrarConexion(error);	       	

		        if (tr.isTraceActive()){

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAgente: saliendo.");

		   		}

	 	  }

	    }//fin obtenerPlazo

	

	/**

     * Funcin que inserta los datos del agente pasado como parmetro en la BBDD

     * @param agente - Datos del agente a insertar

     * @throws Exception

     */

      public String insertarAgentes(Q02bAgentes agente) throws Exception {   	 

    	boolean error = false;

    	String idAgente= null;	

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarAgentes: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			

			//se instancia el dao pasandole la conexin			

			daoAgentes = new Q02bAgentesDataBaseDAO(this.getConn());

			

			//se pasan los parmetros de usuario e idioma

			//daoAgentes.setUser(this.autenticador.getUser());

			daoAgentes.setIdioma(this.autenticador.getIdioma());

			

			//se llama la metodo del DAO que realiza la insert

			idAgente=daoAgentes.insertarAgentes(agente);

			return (idAgente);

    	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarAgentes: " + sw.getBuffer ().toString());

	        throw ex;                     

 	  }finally{

 		    try{

 		    	daoAgentes.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarAgentes: error liberando recursos");

	   	   	   }  

 		    }  		 

 		  	//se cierra la conexin  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarAgentes: saliendo.");

	   		}

 	  }

    }//fin insertarAgentes

      

      /**

       * Funcin que borra el agente pasado como parmetro de la BBDD 

       * @param idAgente - nmero interno del agente a borrar

       * @throws Exception

       */

      public void borrarAgentes(String idAgente) throws Exception { 

    		if (tr.isTraceActive()){

  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarAgentes: entrando");

    		}

    		boolean error = false;

    		try{

    			//se abre la conexin

    			abrirConexion();

   			

    			//se instancia el dao pasandole la conexin			

    			daoAgentes = new Q02bAgentesDataBaseDAO(this.getConn());

  			

    			//Segmento tecnico 

    			//daoAgentes.setUser(this.getAutenticador().getUser());

    			daoAgentes.setIdioma(this.getAutenticador().getIdioma()); 



    			daoAgentes.borrarAgentes(idAgente);   		 	  

    		}catch(Exception ex){

    			error= true;

    			java.io.StringWriter sw = new java.io.StringWriter();

    			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    			ex.printStackTrace(pw);

    			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarAgentes: " + sw.getBuffer ().toString());

    			throw ex;           

  	  

    		}finally{

    			try{

    				daoAgentes.freeResourcesNotConnection();

    			}catch(Exception ex){

    				if (tr.isTraceActive()){

    					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarAgentes: error liberando recursos");

  	   	   	   		}  

    			}  		 

   		  		//se cierra la conexin  

   		  		cerrarConexion(error);	       	

   		  		if (tr.isTraceActive()){

   		  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarAgentes: saliendo.");

   		  		}

    		}

    }//fin borrarAgentes

    

    /**

     * Funcin que modifica los datos del cuestionario pasado como parmetro en la BBDD

     * @param cuestionarioVTMAnu - Datos del cuestionario a modificar 

     * @throws Exception

     */

    public void modificarAgentes(Q02bAgentes agente) throws Exception {

   	 if (tr.isTraceActive()){

  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarAgentes: entrando");

  		}

   	 boolean error = false;

   	try{

   		//se abre la conexin

   		abrirConexion();

   		//se instancia el dao pasandole la conexin			

   		daoAgentes = new Q02bAgentesDataBaseDAO(this.getConn());

		

   		//Segmento tecnico 

		//daoAgentes.setUser(this.getAutenticador().getUser());

   		daoAgentes.setIdioma(this.getAutenticador().getIdioma()); 



   		//se llamaa la metodo del DAO que realiza la update

   		daoAgentes.modificarAgentes(agente);

   		    	

   	}catch(Exception ex){

		 error= true;

         java.io.StringWriter sw = new java.io.StringWriter();

         java.io.PrintWriter pw = new java.io.PrintWriter(sw);

         ex.printStackTrace(pw);

         tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarAgentes: " + sw.getBuffer ().toString());

         throw ex;                     

	  }finally{

		 try{

			daoAgentes.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarAgentes: error liberando recursos");

	   	   	   }  

		   }  		 

		  	//se cierra la conexin  

		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarAgentes: saliendo.");

	   		}

	  }

   }//modificarAgentes

}