set time on;

set echo on;

set feedback 1;

spool /aplic/q02b/scripts/q022ct00.lst;

SELECT TO_CHAR(SYSDATE,'DD-MM-YYYY:HH24:MI:SS') || 'INI Q022CT00' from dual;
 
WHENEVER SQLERROR EXIT SQL.SQLCODE;
 
CREATE TABLE q02b.q022ct00
(
    q022ct00_id_grupo                NUMBER(8)                       NOT NULL
  , q022ct00_ano                     NUMBER(4)                       NOT NULL
  , q022ct00_realiza_actuacion       NUMBER(1)                       DEFAULT 1 NOT NULL
  , q022ct00_fec_alta                DATE                            
  , q022ct00_fec_mod                 DATE                            
  , q22ct00_mes                      NUMBER(2)                       
  , mun_prov                         VARCHAR2(2)                     
  , mun_muni                         VARCHAR2(3)                     
  , q022ct00_obssu                   VARCHAR2(250)                   
  , q022ct00_ncus                    NUMBER(2)                       
  , q022ct00_usu_alta                VARCHAR2(250)                   
  , q022ct00_usu_modif               VARCHAR2(250)                   
)
ORGANIZATION        HEAP
NOMONITORING
PARALLEL
(
  DEGREE            1
  INSTANCES         1
)
NOCACHE
PCTUSED             40
PCTFREE             10
INITRANS            1
MAXTRANS            255
STORAGE
(
  INITIAL           131072
  NEXT              40960
  MINEXTENTS        1
  MAXEXTENTS        UNLIMITED
  PCTINCREASE       50
  FREELISTS         1
  FREELIST GROUPS   1
  BUFFER_POOL       "DEFAULT"
)
LOGGING
TABLESPACE          q0201e00
;

COMMENT ON TABLE q02b.q022ct00 IS 'Cuestionarios SM: Cabecera Grupo de Cuestionarios de Suelo Municipal (recogida especial y mensual)';

COMMENT ON COLUMN q02b.q022ct00.q022ct00_usu_alta IS 'Usuario que da el alta';

COMMENT ON COLUMN q02b.q022ct00.q022ct00_usu_modif IS 'Usuario que modifica';

COMMENT ON COLUMN q02b.q022ct00.q022ct00_id_grupo IS 'Codigo del Grupo de Cuestionarios';

COMMENT ON COLUMN q02b.q022ct00.q022ct00_ano IS 'Ano del Grupo de Cuestionarios';

COMMENT ON COLUMN q02b.q022ct00.q022ct00_realiza_actuacion IS 'Indicativo de si se han realizado actuaciones';

COMMENT ON COLUMN q02b.q022ct00.q022ct00_fec_alta IS 'Fecha de Alta##FEC#insert:sysdate#update:null';

COMMENT ON COLUMN q02b.q022ct00.q022ct00_fec_mod IS 'Fecha de Modificacin##FEC#insert:null#update:sysdate';

COMMENT ON COLUMN q02b.q022ct00.q22ct00_mes IS 'Mes del periodo del cuestionario';

COMMENT ON COLUMN q02b.q022ct00.mun_prov IS 'Cdigo de Provincia del Grupo de Cuestionarios';

COMMENT ON COLUMN q02b.q022ct00.mun_muni IS 'Cdigo de Municipio del Grupo de Cuestionarios';

COMMENT ON COLUMN q02b.q022ct00.q022ct00_obssu IS 'Observaciones sobre la no existencia de actuaciones de suelo';

COMMENT ON COLUMN q02b.q022ct00.q022ct00_ncus IS 'Nmero de cuestionarios existenten para un territorio, municipio y ao';

CREATE UNIQUE INDEX q02b.pk_q022ct00 ON q02b.q022ct00
(
    q022ct00_id_grupo
)
PARALLEL
(
  DEGREE            1
  INSTANCES         1
)
PCTFREE             10
INITRANS            2
MAXTRANS            255
STORAGE
(
  INITIAL           131072
  NEXT              40960
  MINEXTENTS        1
  MAXEXTENTS        unlimited
  PCTINCREASE       50
  FREELISTS         1
  FREELIST GROUPS   1
  BUFFER_POOL       "DEFAULT"
)
LOGGING
TABLESPACE          q0202e00
;

ALTER TABLE q02b.q022ct00 ADD CONSTRAINT pk_q022ct00 PRIMARY KEY
(
    q022ct00_id_grupo
)
NOT DEFERRABLE
INITIALLY IMMEDIATE
ENABLE NOVALIDATE;


commit;
SELECT TO_CHAR(SYSDATE,'DD-MM-YYYY:HH24:MI:SS')  ||  'FIN Q022CT00' from dual;

spool off;
set echo off;

exit;
