set time on;

set echo on;

set feedback 1;

spool /aplic/q02b/scripts/q022bt00.lst;

SELECT TO_CHAR(SYSDATE,'DD-MM-YYYY:HH24:MI:SS') || 'INI Q022BT00' from dual;
 
WHENEVER SQLERROR EXIT SQL.SQLCODE;
 
CREATE TABLE q02b.q022bt00
(
    q022bt00_id_grupo                NUMBER(8)                       NOT NULL
  , q022bt00_ano                     NUMBER(4)                       NOT NULL
  , q022bt00_mes                     NUMBER(2)                       
  , q022bt00_concedido_licen         NUMBER(1)                       DEFAULT 1 NOT NULL
  , q022bt00_fec_alta                DATE                            
  , q022bt00_fec_mod                 DATE                            
  , fca02t00_codprovinc              VARCHAR2(2)                     NOT NULL
  , fca02t00_codmunicip              VARCHAR2(3)                     NOT NULL
  , q022bt00_fec_firma               DATE                            
  , q022bt00_xml_firmado             CLOB                            
  , q022bt00_user_firma              VARCHAR2(200)                   
  , q022bt00_obssu                   VARCHAR2(250)                   
  , q022bt00_usu_alta                VARCHAR2(250)                   
  , q022bt00_usu_modif               VARCHAR2(250)                   
)
ORGANIZATION        HEAP
NOMONITORING
PARALLEL
(
  DEGREE            1
  INSTANCES         1
)
NOCACHE
PCTUSED             40
PCTFREE             10
INITRANS            1
MAXTRANS            255
STORAGE
(
  INITIAL           131072
  NEXT              40960
  MINEXTENTS        1
  MAXEXTENTS        UNLIMITED
  PCTINCREASE       50
  FREELISTS         1
  FREELIST GROUPS   1
  BUFFER_POOL       "DEFAULT"
)
LOGGING
TABLESPACE          q0201e00
;

COMMENT ON TABLE q02b.q022bt00 IS 'Cuestionarios Obra Mayor: Cabecera de Grupo de Cuestionarios de Licencias de Obra Mayor ( Ayuntamientos - Mensual )';

COMMENT ON COLUMN q02b.q022bt00.q022bt00_usu_alta IS 'Usuario que da el alta';

COMMENT ON COLUMN q02b.q022bt00.q022bt00_usu_modif IS 'Usuario que modifica';

COMMENT ON COLUMN q02b.q022bt00.q022bt00_id_grupo IS 'Codigo del Grupo de Cuestionarios';

COMMENT ON COLUMN q02b.q022bt00.q022bt00_ano IS 'Ano del Grupo de Cuestionarios';

COMMENT ON COLUMN q02b.q022bt00.q022bt00_mes IS 'Mes del Grupo de Cuestionarios';

COMMENT ON COLUMN q02b.q022bt00.q022bt00_concedido_licen IS 'Indicativo de si se han concedido licencias en el Grupo de Cuestionarios';

COMMENT ON COLUMN q02b.q022bt00.q022bt00_fec_alta IS 'Fecha de Alta##FEC#insert:sysdate#update:null';

COMMENT ON COLUMN q02b.q022bt00.q022bt00_fec_mod IS 'Fecha de Modificacin##FEC#insert:null#update:sysdate';

COMMENT ON COLUMN q02b.q022bt00.fca02t00_codprovinc IS 'Cdigo de Provincia del Grupo de Cuestionarios';

COMMENT ON COLUMN q02b.q022bt00.fca02t00_codmunicip IS 'Cdigo de Municipio del Grupo de Cuestionarios';

COMMENT ON COLUMN q02b.q022bt00.q022bt00_fec_firma IS 'Fecha de Firma del Grupo de Cuestionarios';

COMMENT ON COLUMN q02b.q022bt00.q022bt00_xml_firmado IS 'Xml con un resmen de los datos ms importantes de los cuestionarios que se firman';

COMMENT ON COLUMN q02b.q022bt00.q022bt00_user_firma IS 'Usuario que firma los cuestionarios';

COMMENT ON COLUMN q02b.q022bt00.q022bt00_obssu IS 'Observaciones sobre la no existencia de actuaciones de suelo';

CREATE UNIQUE INDEX q02b.pk_q022bt00 ON q02b.q022bt00
(
    q022bt00_id_grupo
)
PARALLEL
(
  DEGREE            1
  INSTANCES         1
)
PCTFREE             10
INITRANS            2
MAXTRANS            255
STORAGE
(
  INITIAL           131072
  NEXT              40960
  MINEXTENTS        1
  MAXEXTENTS        unlimited
  PCTINCREASE       50
  FREELISTS         1
  FREELIST GROUPS   1
  BUFFER_POOL       "DEFAULT"
)
LOGGING
TABLESPACE          q0202e00
;

ALTER TABLE q02b.q022bt00 ADD CONSTRAINT pk_q022bt00 PRIMARY KEY
(
    q022bt00_id_grupo
)
NOT DEFERRABLE
INITIALLY IMMEDIATE
ENABLE NOVALIDATE;



commit;
SELECT TO_CHAR(SYSDATE,'DD-MM-YYYY:HH24:MI:SS')  ||  'FIN Q022BT00' from dual;

spool off;
set echo off;

exit;
