-- TABLA PARA LA PANTALLA DE ESTADISTICAS
DROP TABLE Q0298T00;

CREATE TABLE Q0298T00
(
  TH_ID				NUMBER(2,0)		NOT NULL,
  MUNICIPIO_ID		NUMBER(4,0)		NOT NULL,
  MUNICIPIO			VARCHAR2(200)	NOT NULL,
  COMARCA_ID		NUMBER(4,0)		NOT NULL,
  COMARCA_EU_ES		VARCHAR2(200)	NOT NULL,
  AF_ID     		NUMBER(2,0),	
  AF_EU_ES			VARCHAR2(200),
  TAMANO_ID			NUMBER(1,0),
  TAMANO_EU_ES		VARCHAR2(200)
)
TABLESPACE Q0201E00;

-- PK
ALTER TABLE Q0298T00 ADD (
  CONSTRAINT PK_Q0298T00
 PRIMARY KEY
 (TH_ID, MUNICIPIO_ID)  USING INDEX 
     TABLESPACE Q0202E00);

     
COMMENT ON TABLE Q0298T00 IS 'Tamanyo de municipios';

COMMENT ON COLUMN Q0298T00.TH_ID 			IS 'ID del territorio';
COMMENT ON COLUMN Q0298T00.MUNICIPIO_ID 	IS 'ID del municipio';
COMMENT ON COLUMN Q0298T00.MUNICIPIO 		IS 'Nombre del municipio';
COMMENT ON COLUMN Q0298T00.COMARCA_ID 		IS 'ID de la comarca';
COMMENT ON COLUMN Q0298T00.COMARCA_EU_ES 	IS 'Nombre de la comarca';
COMMENT ON COLUMN Q0298T00.AF_ID		 	IS 'ID del area funcional';
COMMENT ON COLUMN Q0298T00.AF_EU_ES 		IS 'Nombre del area funcional';
COMMENT ON COLUMN Q0298T00.TAMANO_ID 		IS 'Identificador de rango de tamanyo del municipio';
COMMENT ON COLUMN Q0298T00.TAMANO_EU_ES 	IS 'Descripcin de rango de tamanyo del municipio';