CREATE OR REPLACE FUNCTION obtenerRutaDoc (idDoc IN NUMBER,idIdioma IN NUMBER)
	   RETURN VARCHAR AS
BEGIN
	 DECLARE
	 --Constantes
	 NODO_PADRE      CONSTANT NUMBER(3) := 0;
	 CAS			 CONSTANT NUMBER(1) := 0;
 	 EUS			 CONSTANT NUMBER(1) := 1;

	 CURSOR nodos (idNodo NUMBER,idIdioma NUMBER)
	 IS SELECT REL.ARB_ID_022 AS cod_nodo_padre,
	           DECODE(idIdioma,CAS,ARBOL.ARB_DESC_020,ARBOL.ARB_DESE_020) AS des_nodo_padre
	 	FROM Q0222S00 REL,
		     Q0220S00 ARBOL
		WHERE REL.DOC_ID_022=idDoc
		  AND REL.ARB_ID_022=ARBOL.ARB_ID_020;

	 DATOS_NODO_PADRE    VARCHAR2(120);

	 COD_NODO_PADRE		 NUMBER(3);
	 DES_NODO_PADRE      VARCHAR2(100);

	 RUTA				 VARCHAR2(4000):='';
	 RUTA_TOTAL			 VARCHAR2(8000):='';




BEGIN

	 --DBMS_OUTPUT.Put_Line('hola mundo SOY EL DOC '||idDoc);


	 OPEN nodos(idDoc,idIdioma);


	 LOOP

		 FETCH nodos INTO COD_NODO_PADRE,DES_NODO_PADRE;
		 EXIT WHEN nodos%NOTFOUND;

		 RUTA:=COD_NODO_PADRE||'@'||DES_NODO_PADRE;

		 WHILE (COD_NODO_PADRE!=NODO_PADRE)
		 LOOP
		  	--buscar datos nodo padre
			 --DBMS_OUTPUT.Put_Line('nodo padre'||COD_NODO_PADRE);

			 DATOS_NODO_PADRE:=obtenerDatosNodoPadre(COD_NODO_PADRE,idIdioma);

			 --DBMS_OUTPUT.Put_Line('DATOS_NODO_PADRE'||DATOS_NODO_PADRE);

			 COD_NODO_PADRE:=TO_NUMBER(SUBSTR(DATOS_NODO_PADRE,0,INSTR(DATOS_NODO_PADRE,'@')-1));

	 		 RUTA:=RUTA||'&'||DATOS_NODO_PADRE;

		 END LOOP;


		 RUTA_TOTAL:=RUTA_TOTAL||'$'||RUTA;

		 RUTA:='';

		 --DBMS_OUTPUT.Put_Line('RUTA'||RUTA);
		 --DBMS_OUTPUT.Put_Line('RUTA_TOTAL'||RUTA_TOTAL);
	 END LOOP;

	 CLOSE nodos;

	 --DBMS_OUTPUT.Put_Line('RETORNO'||RUTA_TOTAL);

	 RETURN RUTA_TOTAL;

END;
END;
/

