CREATE OR REPLACE PROCEDURE q02b_asigna_permisos_q02a
   IS
      l_user              VARCHAR2 (30);
      l_permisos          VARCHAR2 (100);
      l_inv_count         PLS_INTEGER;
      l_inv_index_count   PLS_INTEGER;
      l_inv_count_prev    PLS_INTEGER;
      l_max_ciclo         PLS_INTEGER    := 5;
      b_hay_compilar      BOOLEAN;
      l_contador          PLS_INTEGER;
   BEGIN
      -- Obtener el nombre del usuario
      l_user := USER;
      l_contador := 1;

      -- Codigo que debe ser asignados a Q02A
      FOR reg IN (SELECT   object_type,
                           object_name
                      FROM user_objects
                     WHERE object_type IN
                              ('FUNCTION',
                               'PACKAGE',
                               'PROCEDURE',
                               'TABLE',
                               'VIEW',
                               'SEQUENCE'
                              )
			      and upper(object_name) <> 'Q02B_ASIGNA_PERMISOS_Q02A'
                  ORDER BY object_type,
                           object_name)
      LOOP

         DBMS_OUTPUT.put_line ('--------------------');
         DBMS_OUTPUT.put_line (   'Asignando permisos '
                               || reg.object_name
                              || ' ['
                             || reg.object_type
                              || ']'
                              );

         BEGIN

          if reg.object_type = 'VIEW' THEN
                  l_permisos := 'SELECT';
          elsif   reg.object_type = 'SEQUENCE' THEN
                  l_permisos := 'SELECT';
          elsif reg.object_type = 'TABLE' THEN
                  l_permisos := 'SELECT,INSERT,UPDATE,DELETE';
          else
             l_permisos := 'EXECUTE';
          end if;


            EXECUTE IMMEDIATE    'grant '
                              || l_permisos
                              || ' on '
                              || reg.object_name
                              || ' to Q02A';
         EXCEPTION
            WHEN OTHERS
           THEN
              DBMS_OUTPUT.put_line (   'ERROR asigando permisos a '
                                    || reg.object_name
                                     || ' - '
                                    || SQLERRM
                                   );
         END;
      END LOOP;

      DBMS_OUTPUT.put_line
         ('**********************************************************************'
         );
   END q02b_asigna_permisos_q02a;
/