DROP TABLE Q021MT00 CASCADE CONSTRAINTS;
CREATE TABLE Q021MT00
(
  Q021MT00_ID          NUMBER(8)                NOT NULL,
  Q022FT00_IDUSUARIO   NUMBER(8)                NOT NULL,
  FCA02T00_CODPROVINC  VARCHAR2(2)              NOT NULL,
  FCA02T00_CODMUNICIP  VARCHAR2(3)              NOT NULL
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q021MT00 IS 'Usuarios Provincia-Municipio';

COMMENT ON COLUMN Q021MT00.Q021MT00_ID IS 'Nmero interno de la realacin Usu-Prov-Muni';

COMMENT ON COLUMN Q021MT00.Q022FT00_IDUSUARIO IS 'Nmero interno del Usuario';

COMMENT ON COLUMN Q021MT00.FCA02T00_CODPROVINC IS 'Nmero interno de la Provincia';

COMMENT ON COLUMN Q021MT00.FCA02T00_CODMUNICIP IS 'Nmero interno del Municipio';


ALTER TABLE Q021MT00 ADD (
  CONSTRAINT PK_Q021MT00
 PRIMARY KEY
 (Q021MT00_ID)  USING INDEX 
     TABLESPACE Q0202E00);
     

ALTER TABLE Q021MT00 ADD (
  CONSTRAINT FK_Q021FT00_02 
 FOREIGN KEY (Q022FT00_IDUSUARIO) 
 REFERENCES Q022FT00 (Q022FT00_IDUSUARIO));

CREATE OR REPLACE SYNONYM Q021MS00 FOR Q021MT00;

GRANT DELETE, INSERT, SELECT, UPDATE ON  Q021MT00 TO Q02A;


DROP SEQUENCE Q021MQ00;
CREATE SEQUENCE Q021MQ00
  START WITH 1
  MAXVALUE 999999999999999999999999999
  MINVALUE 1
  NOCYCLE
  CACHE 20
  NOORDER;


