CREATE OR REPLACE VIEW Q021FV01
(Q021FT00_NI, Q021FT00_COD, Q021FT00_RUTAP, Q021ET00_NI, Q021FT00_DESC, 
 Q021FT00_DESC_EUS, Q021FT00_USU_ALTA, Q021FT00_TST_ALTA, Q021FT00_USU_MODIF, Q021FT00_TST_MODIF, 
 Q021FT00_DESC_MENU, Q021ET00_CODIGO, Q021ET00_DESC, Q021FT00_NI_MULTIPLE)
AS 
SELECT
  Q021FT00_NI           , 
  Q021FT00_COD           ,
  Q021FT00_RUTAP         ,
  Q021FT00.Q021ET00_NI            ,
  Q021FT00_DESC          ,
  Q021FT00_DESC_EUS      ,
  Q021FT00_USU_ALTA      ,
  Q021FT00_TST_ALTA      ,
  Q021FT00_USU_MODIF     ,
  Q021FT00_TST_MODIF     ,  
  Q021FT00_DESC_MENU     ,
  Q021ET00.Q021ET00_CODIGO, Q021ET00.Q021ET00_DESC,
  Q021FT00_NI||'#'||Q021FT00_DESC
  FROM Q021FT00, Q021ET00
  WHERE Q021FT00.Q021ET00_NI=Q021ET00.Q021ET00_NI
/


CREATE OR REPLACE VIEW Q021FV02
(Q021ET00_IND_INACTIVO, Q021ET00_NI, Q021ET00_DESC, Q021ET00_CODIGO, Q021FT00_NI, 
 Q021FT00_COD, Q021FT00_RUTAP, Q021FT00_DESC, Q021FT00_DESC_EUS)
AS 
select modulo.Q021ET00_IND_INACTIVO ,modulo.Q021ET00_NI, 
modulo.Q021ET00_DESC, modulo.Q021ET00_CODIGO, 
proceso.Q021FT00_NI, proceso.Q021FT00_COD, proceso.Q021FT00_RUTAP, proceso.Q021FT00_DESC, proceso.Q021FT00_DESC_EUS
from 
q021et00 modulo, q021ft00 proceso
where
proceso.Q021ET00_NI=modulo.Q021ET00_NI
/


CREATE OR REPLACE VIEW Q021GV01
(Q021GT00_NI, Q021GT00_COD, Q021GT00_DESC, Q021GT00_NI_MULTIPLE)
AS 
select Q021GT00_NI, Q021GT00_COD, Q021GT00_DESC, Q021GT00_NI||'#'||Q021GT00_DESC
from Q021GT00
order  by Q021GT00_DESC
/


CREATE OR REPLACE VIEW Q021HV01
(Q021HT00_NI, Q021HT00_COD, Q021HT00_DESC, Q021HT00_NI_MULTIPLE)
AS 
select Q021HT00_NI, Q021HT00_COD, Q021HT00_DESC, Q021HT00_NI||'#'||Q021HT00_DESC
from Q021HT00
order  by Q021HT00_DESC
/


CREATE OR REPLACE VIEW Q022AV01
(Q022AT00_NIPLAZO, Q022AT00_ANO, MUN_PROV, MUN_MUNI, Q022AT00_PLAZO, 
 Q022AT00_PLAZO_DIA, Q022AT00_FEC_ALTA, Q022AT00_FEC_MOD, Q022NT00_CODIGO, PROVINCIA_DS_O, 
 MUNICIPIO_DS_O, Q022NT00_DESC_ES, Q022NT00_DESC_EU)
AS 
SELECT 
  Q022AT00_NIPLAZO   ,
  Q022AT00_ANO       ,
  MUN_PROV           ,
  MUN_MUNI           ,
  Q022AT00_PLAZO     ,
  Q022AT00_PLAZO_DIA ,
  Q022AT00_FEC_ALTA  ,
  Q022AT00_FEC_MOD   ,
  Q022AT00.Q022NT00_CODIGO , 
  NORA_T17_PROVINCIA.DS_O,
  NORA_T17_MUNICIPIO.DS_O,
  Q022NT00.Q022NT00_DESC_ES,
  Q022NT00.Q022NT00_DESC_EU
FROM 
Q022AT00,
NORA_T17_PROVINCIA, 
NORA_T17_MUNICIPIO, Q022NT00 
WHERE
Q022AT00.MUN_PROV =NORA_T17_PROVINCIA.ID (+) and
Q022AT00.MUN_MUNI =NORA_T17_MUNICIPIO.ID(+) and
Q022AT00.MUN_PROV  =NORA_T17_MUNICIPIO.PROVINCIA_ID (+) and
Q022AT00.Q022NT00_CODIGO=Q022NT00.Q022NT00_CODIGO(+)
/


CREATE OR REPLACE VIEW Q022DV01
(Q022BT00_ID_GRUPO, Q022DT00_ID_CUES, Q022DT00_IDEN_LICEN, Q022DT00_FEC_ENT, Q022DT00_ESTADO_LICEN, 
 Q022DT00_CAUSA_BAJA, Q022DT00_ENTI, Q022DT00_TVIA, Q022DT00_CALLE, Q022DT00_POR_CL_POR, 
 Q022DT00_BLOQ, Q022DT00_NUME, Q022DT00_BIS, Q022DT00_CDIR, Q022DT00_RS_PROMO, 
 Q022DT00_CIF_DNI, Q022DT00_MUN_PROV, Q022DT00_MUN_MUNI, Q022DT00_ENTI_PRO, Q022DT00_TVIA_PRO, 
 Q022DT00_CALLE_PRO, Q022DT00_POR_CL_POR_PRO, Q022DT00_BLOQ_PRO, Q022DT00_NUME_PRO, Q022DT00_BIS_PRO, 
 Q022DT00_CDIR_PRO, Q022DT00_TLF, Q022DT00_MAIL, Q022DT00_FAX, Q022DT00_WEB, 
 Q022DT00_PRESUPUESTO, Q022DT00_F_INI, Q022DT00_F_FIN, Q022DT00_TIPO_OBRA, Q022DT00_USO_RES, 
 Q022DT00_ACTIVIDAD, Q022DT00_NVN, Q022DT00_NVR, Q022DT00_NVL, Q022DT00_NVVPO, 
 Q022DT00_NVVS, Q022DT00_NVPOT, Q022DT00_NVALDOT, Q022DT00_NVREAL, Q022DT00_NVVTMG, 
 Q022DT00_NVVTME, Q022DT00_NTOT, Q022DT00_NSP45, Q022DT00_NSP75, Q022DT00_NSP90, 
 Q022DT00_NSP120, Q022DT00_NSPT, Q022DT00_PRINC_USO, Q022DT00_PU_ESPECIF, Q022DT00_PRECIO_MED, 
 Q022DT00_OBS, Q022BT00_ANO, Q022BT00_MES, Q022BT00_CONCEDIDO_LICEN, Q022BT00_FEC_ALTA, 
 Q022BT00_FEC_MOD, FCA02T00_CODPROVINC, FCA02T00_CODMUNICIP, Q022BT00_FEC_FIRMA, Q022BT00_XML_FIRMADO, 
 Q022BT00_USER_FIRMA)
AS 
select  Q022DT00.Q022BT00_ID_GRUPO        , 
 Q022DT00_ID_CUES         , 
 Q022DT00_IDEN_LICEN      , 
 Q022DT00_FEC_ENT         , 
 Q022DT00_ESTADO_LICEN    , 
 Q022DT00_CAUSA_BAJA      , 
 Q022DT00_ENTI            , 
 Q022DT00_TVIA            , 
 Q022DT00_CALLE           , 
 Q022DT00_POR_CL_POR      , 
 Q022DT00_BLOQ            , 
 Q022DT00_NUME            , 
 Q022DT00_BIS             , 
 Q022DT00_CDIR            , 
 Q022DT00_RS_PROMO        , 
 Q022DT00_CIF_DNI         , 
 Q022DT00_MUN_PROV        , 
 Q022DT00_MUN_MUNI        , 
 Q022DT00_ENTI_PRO        , 
 Q022DT00_TVIA_PRO        , 
 Q022DT00_CALLE_PRO       , 
 Q022DT00_POR_CL_POR_PRO  , 
 Q022DT00_BLOQ_PRO        , 
 Q022DT00_NUME_PRO        , 
 Q022DT00_BIS_PRO         , 
 Q022DT00_CDIR_PRO        , 
 Q022DT00_TLF             , 
 Q022DT00_MAIL            , 
 Q022DT00_FAX             , 
 Q022DT00_WEB             , 
 Q022DT00_PRESUPUESTO     , 
 Q022DT00_F_INI           , 
 Q022DT00_F_FIN           , 
 Q022DT00_TIPO_OBRA       , 
 Q022DT00_USO_RES         , 
 Q022DT00_ACTIVIDAD       , 
 Q022DT00_NVN             , 
 Q022DT00_NVR             , 
 Q022DT00_NVL             , 
 Q022DT00_NVVPO           , 
 Q022DT00_NVVS            , 
 Q022DT00_NVPOT           , 
 Q022DT00_NVALDOT         , 
 Q022DT00_NVREAL          , 
 Q022DT00_NVVTMG          , 
 Q022DT00_NVVTME          , 
 Q022DT00_NTOT            , 
 Q022DT00_NSP45           , 
 Q022DT00_NSP75           , 
 Q022DT00_NSP90           , 
 Q022DT00_NSP120          , 
 Q022DT00_NSPT            , 
 Q022DT00_PRINC_USO       , 
 Q022DT00_PU_ESPECIF      , 
 Q022DT00_PRECIO_MED      , 
 Q022DT00_OBS             ,  
 Q022BT00_ANO             ,  
 Q022BT00_MES             ,  
 Q022BT00_CONCEDIDO_LICEN ,  
 Q022BT00_FEC_ALTA        ,  
 Q022BT00_FEC_MOD         ,  
 FCA02T00_CODPROVINC      ,  
 FCA02T00_CODMUNICIP      ,  
 Q022BT00_FEC_FIRMA       ,  
 Q022BT00_XML_FIRMADO     ,  
 Q022BT00_USER_FIRMA 
 from   Q022DT00, Q022BT00
 WHERE  Q022DT00.Q022BT00_ID_GRUPO=Q022BT00.Q022BT00_ID_GRUPO
/


CREATE OR REPLACE VIEW Q022DV02
(Q022BT00_ID_GRUPO, Q022DT00_ID_CUES, Q022DT00_IDEN_LICEN, Q022DT00_FEC_ENT, Q022DT00_ESTADO_LICEN, 
 Q022DT00_CAUSA_BAJA, Q022DT00_ENTI, Q022DT00_TVIA, Q022DT00_CALLE, Q022DT00_POR_CL_POR, 
 Q022DT00_BLOQ, Q022DT00_NUME, Q022DT00_BIS, Q022DT00_CDIR, Q022DT00_RS_PROMO, 
 Q022DT00_CIF_DNI, Q022DT00_MUN_PROV, Q022DT00_MUN_MUNI, Q022DT00_ENTI_PRO, Q022DT00_TVIA_PRO, 
 Q022DT00_CALLE_PRO, Q022DT00_POR_CL_POR_PRO, Q022DT00_BLOQ_PRO, Q022DT00_NUME_PRO, Q022DT00_BIS_PRO, 
 Q022DT00_CDIR_PRO, Q022DT00_TLF, Q022DT00_MAIL, Q022DT00_FAX, Q022DT00_WEB, 
 Q022DT00_PRESUPUESTO, Q022DT00_F_INI, Q022DT00_F_FIN, Q022DT00_TIPO_OBRA, Q022DT00_USO_RES, 
 Q022DT00_ACTIVIDAD, Q022DT00_NVN, Q022DT00_NVR, Q022DT00_NVL, Q022DT00_NVVPO, 
 Q022DT00_NVVS, Q022DT00_NVPOT, Q022DT00_NVALDOT, Q022DT00_NVREAL, Q022DT00_NVVTMG, 
 Q022DT00_NVVTME, Q022DT00_NTOT, Q022DT00_NSP45, Q022DT00_NSP75, Q022DT00_NSP90, 
 Q022DT00_NSP120, Q022DT00_NSPT, Q022DT00_PRINC_USO, Q022DT00_PU_ESPECIF, Q022DT00_PRECIO_MED, 
 Q022DT00_OBS, Q022DT00_NORA_T17_LOCALIZACION, Q022DT00_DIR_PRO_EXTERNO, Q022DT00_DIR_NUEVA)
AS 
SELECT 
  Q022BT00_ID_GRUPO        ,
  Q022DT00_ID_CUES         ,
  Q022DT00_IDEN_LICEN      ,
  Q022DT00_FEC_ENT         ,
  Q022DT00_ESTADO_LICEN    ,
  Q022DT00_CAUSA_BAJA      ,
  Q022DT00_ENTI            ,
  Q022DT00_TVIA            ,
  Q022DT00_CALLE           ,
  Q022DT00_POR_CL_POR      ,
  Q022DT00_BLOQ            ,
  Q022DT00_NUME            ,
  Q022DT00_BIS             ,
  Q022DT00_CDIR            ,
  Q022DT00_RS_PROMO        ,
  Q022DT00_CIF_DNI         ,
  Q022DT00_MUN_PROV        ,
  Q022DT00_MUN_MUNI        ,
  Q022DT00_ENTI_PRO        ,
  Q022DT00_TVIA_PRO        ,
  Q022DT00_CALLE_PRO       ,
  Q022DT00_POR_CL_POR_PRO  ,
  Q022DT00_BLOQ_PRO        ,
  Q022DT00_NUME_PRO        ,
  Q022DT00_BIS_PRO         ,
  Q022DT00_CDIR_PRO        ,
  Q022DT00_TLF             ,
  Q022DT00_MAIL            ,
  Q022DT00_FAX             ,
  Q022DT00_WEB             ,
  Q022DT00_PRESUPUESTO     ,
  Q022DT00_F_INI           ,
  Q022DT00_F_FIN           ,
  Q022DT00_TIPO_OBRA       ,
  Q022DT00_USO_RES         ,
  Q022DT00_ACTIVIDAD       ,
  Q022DT00_NVN             ,
  Q022DT00_NVR             ,
  Q022DT00_NVL             ,
  Q022DT00_NVVPO           ,
  Q022DT00_NVVS            ,
  Q022DT00_NVPOT           ,
  Q022DT00_NVALDOT         ,
  Q022DT00_NVREAL          ,
  Q022DT00_NVVTMG          ,
  Q022DT00_NVVTME          ,
  Q022DT00_NTOT            ,
  Q022DT00_NSP45           ,
  Q022DT00_NSP75           ,
  Q022DT00_NSP90           ,
  Q022DT00_NSP120          ,
  Q022DT00_NSPT            ,
  Q022DT00_PRINC_USO       ,
  Q022DT00_PU_ESPECIF      ,
  Q022DT00_PRECIO_MED      ,
  Q022DT00_OBS  ,
  CASE WHEN ( TRIM(Q022DT00_CALLE) = 0 OR TRIM(Q022DT00_CALLE) = '' OR TRIM(Q022DT00_CALLE) IS NULL) THEN NORA_T17_LOCALIDAD.DS_O
       ELSE NORA_T17_LOCALIDAD.DS_O  || DECODE(NORA_T17_LOCALIDAD.DS_O,'','',', ')  || NORA_T17_CALLE.DS_O || ' ' ||  DECODE ( Q022DT00_BLOQ, '0' , '','','', 'Bloque:'||Q022DT00_BLOQ)  || ' '  || DECODE ( Q022DT00_NUME, '0' , '','','',  'N:'||Q022DT00_NUME) || ' '||  DECODE( Q022DT00_BIS, '0','','','','Bis: '||Q022DT00_BIS)
  END DIRECCION,
  Q022DT00_DIR_PRO_EXTERNO,
  Q022DT00_DIR_NUEVA   
FROM Q022DT00, NORA_T17_LOCALIDAD,NORA_T17_CALLE 
where Q022DT00.Q022DT00_ENTI=NORA_T17_LOCALIDAD.ID(+)   and
Q022DT00.Q022DT00_CALLE=NORA_T17_CALLE.ID(+)
/


CREATE OR REPLACE VIEW Q022DV03
(LIC_CLAVE1, LIC_CLAVE2, LIC_CLAVE3, LIC_TERR, LIC_MUN, 
 LIC_ANNO, LIC_MES, LIC_MLIC, LIC_NCUL, LIC_CULN, 
 LIC_CLIC, LIC_FENT, LIC_SITLIC, LIC_CBAJA, LIC_ENTI, 
 LIC_ENTID, LIC_TVIA, LIC_CALLE, LIC_CALLED, LIC_BLOQ, 
 LIC_NUME, LIC_BIS, LIC_CDIR, LIC_NOMBRE, LIC_CIF, 
 LIC_PROVD, LIC_PROV_P, LIC_MUNID_P, LIC_MUNI_P, LIC_TVIA_P, 
 LIC_CALLED_P, LIC_CALLE_P, LIC_BLOQ_P, LIC_NUME_P, LIC_BIS_P, 
 LIC_CDIR_P, LIC_TELF, LIC_FAX, LIC_EMAIL, LIC_WEB, 
 LIC_PSPO, LIC_FINIC, LIC_FFIN, LIC_TIPOM, LIC_RESID, 
 LIC_USEDI, LIC_NVIN, LIC_NVIR, LIC_NLIBRE, LIC_NVPOG, 
 LIC_NVPOE, LIC_NVPOT, LIC_NALOD, LIC_NREAL, LIC_NVTMG, 
 LIC_NVTME, LIC_NVTOT, LIC_NSP45, LIC_NSP75, LIC_NSP90, 
 LIC_NSP90M, LIC_NSPT, LIC_USOV, LIC_OTRU, LIC_PRECIO, 
 LIC_OBSLI)
AS 
select
Q022DT00.Q022BT00_ID_GRUPO      		, 
Q022DT00.Q022DT00_ID_CUES       					,
Q022BT00.FCA02T00_CODMUNICIP ||  Q022BT00.Q022BT00_ANO || Q022BT00.Q022BT00_MES || obtener_culn(Q022DT00.Q022BT00_ID_GRUPO,Q022DT00.Q022DT00_ID_CUES)	,
Q022BT00.FCA02T00_CODPROVINC			, 
Q022BT00.FCA02T00_CODMUNICIP			,
Q022BT00.Q022BT00_ANO					, 
Q022BT00.Q022BT00_MES					, 
Q022BT00.Q022BT00_CONCEDIDO_LICEN		,
CONTADOR.num 							,
obtener_culn(Q022DT00.Q022BT00_ID_GRUPO,Q022DT00.Q022DT00_ID_CUES),
Q022DT00_IDEN_LICEN    					,      
Q022DT00_FEC_ENT       					,      
Q022DT00_ESTADO_LICEN  					,      
Q022DT00_CAUSA_BAJA    					,      
Q022DT00_ENTI          					,   
NORA_T17_LOCALIDAD.DS_O					,   
Q022DT00_TVIA          					,      
Q022DT00_CALLE         					, 
NORA_T17_CALLE.DS_O						,   
Q022DT00_BLOQ          					,      
Q022DT00_NUME          					,      
Q022DT00_BIS           					,      
Q022DT00_CDIR          					,      
Q022DT00_RS_PROMO      					,      
Q022DT00_CIF_DNI       					,
NORA_T17_PROVINCIA.DS_O					,       
Q022DT00_MUN_PROV      					,
NORA_T17_MUNICIPIO.DS_O                    ,       
Q022DT00_MUN_MUNI                          ,      
Q022DT00_TVIA_PRO                          , 
NORA_T17_CALLE_PROMO.DS_O                ,         
Q022DT00_CALLE_PRO                         ,      
Q022DT00_BLOQ_PRO                          ,      
Q022DT00_NUME_PRO                          ,      
Q022DT00_BIS_PRO                           ,      
Q022DT00_CDIR_PRO                          ,      
Q022DT00_TLF                               ,      
Q022DT00_FAX                               , 
Q022DT00_MAIL                              ,      
Q022DT00_WEB                               ,          
Q022DT00_PRESUPUESTO                       ,      
Q022DT00_F_INI                             ,      
Q022DT00_F_FIN                             ,      
Q022DT00_TIPO_OBRA                         ,      
Q022DT00_USO_RES                           ,      
Q022DT00_ACTIVIDAD                         ,      
Q022DT00_NVN                               ,      
Q022DT00_NVR                               ,      
Q022DT00_NVL                               ,      
Q022DT00_NVVPO                             ,      
Q022DT00_NVVS                              ,      
Q022DT00_NVPOT                             ,      
Q022DT00_NVALDOT                           ,          
Q022DT00_NVREAL                            ,      
Q022DT00_NVVTMG                            ,      
Q022DT00_NVVTME                            ,      
Q022DT00_NTOT                              ,      
Q022DT00_NSP45                             ,      
Q022DT00_NSP75                             ,      
Q022DT00_NSP90                             ,      
Q022DT00_NSP120                            ,      
Q022DT00_NSPT                              ,      
Q022DT00_PRINC_USO                         ,      
Q022DT00_PU_ESPECIF                        ,      
Q022DT00_PRECIO_MED                        ,      
Q022DT00_OBS              
from Q022DT00, Q022BT00, NORA_T17_CALLE, NORA_T17_PROVINCIA, NORA_T17_MUNICIPIO, NORA_T17_CALLE NORA_T17_CALLE_PROMO,
(select Q022BT00_ID_GRUPO, count(*) num from Q022dT00
group by Q022BT00_ID_GRUPO)  CONTADOR, NORA_T17_LOCALIDAD
where Q022DT00.Q022BT00_ID_GRUPO=Q022BT00.Q022BT00_ID_GRUPO and
Q022DT00.Q022DT00_CALLE=NORA_T17_CALLE.ID(+) and 
Q022DT00.Q022DT00_MUN_PROV=NORA_T17_PROVINCIA.ID (+) and
Q022DT00.Q022DT00_MUN_MUNI=NORA_T17_MUNICIPIO.ID(+) and
Q022DT00.Q022DT00_MUN_PROV=NORA_T17_MUNICIPIO.PROVINCIA_ID (+) and
Q022DT00.Q022DT00_CALLE_PRO= NORA_T17_CALLE_PROMO.ID(+) and
Q022DT00.Q022BT00_ID_GRUPO=CONTADOR.Q022BT00_ID_GRUPO (+) and 
Q022DT00.Q022DT00_ENTI=NORA_T17_LOCALIDAD.ID(+)
/

COMMENT ON COLUMN Q022DV03.LIC_CLAVE1 IS '#INF#LIC_CLAVE1#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_CLAVE2 IS '#INF#LIC_CLAVE2#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_CLAVE3 IS '#INF#LIC_CLAVE3#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_TERR IS '#INF#LIC_TERR#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_MUN IS '#INF#LIC_MUN#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_ANNO IS '#INF#LIC_ANNO#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_MES IS '#INF#LIC_MES#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_MLIC IS '#INF#LIC_MLIC#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NCUL IS '#INF#LIC_NCUL#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_CULN IS '#INF#LIC_CULN#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_CLIC IS '#INF#LIC_CLIC#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_FENT IS '#INF#LIC_FENT#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_SITLIC IS '#INF#LIC_SITLIC#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_CBAJA IS '#INF#LIC_CBAJA#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_ENTI IS '#INF#LIC_ENTI#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_ENTID IS '#INF#LIC_ENTID#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_TVIA IS '#INF#LIC_TVIA#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_CALLE IS '#INF#LIC_CALLE#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_CALLED IS '#INF#LIC_CALLED#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_BLOQ IS '#INF#LIC_BLOQ#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NUME IS '#INF#LIC_NUME#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_BIS IS '#INF#LIC_BIS#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_CDIR IS '#INF#LIC_CDIR#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NOMBRE IS '#INF#LIC_NOMBRE#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_CIF IS '#INF#LIC_CIF#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_PROVD IS '#INF#LIC_PROVD#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_PROV_P IS '#INF#LIC_PROV_P#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_MUNID_P IS '#INF#LIC_MUNID_P#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_MUNI_P IS '#INF#LIC_MUNI_P#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_TVIA_P IS '#INF#LIC_TVIA_P#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_CALLED_P IS '#INF#LIC_CALLED_P#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_CALLE_P IS '#INF#LIC_CALLE_P#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_BLOQ_P IS '#INF#LIC_BLOQ_P#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NUME_P IS '#INF#LIC_NUME_P#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_BIS_P IS '#INF#LIC_BIS_P#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_CDIR_P IS '#INF#LIC_CDIR_P#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_TELF IS '#INF#LIC_TELF#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_FAX IS '#INF#LIC_FAX#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_EMAIL IS '#INF#LIC_EMAIL#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_WEB IS '#INF#LIC_WEB#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_PSPO IS '#INF#LIC_PSPO#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_FINIC IS '#INF#LIC_FINIC#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_FFIN IS '#INF#LIC_FFIN#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_TIPOM IS '#INF#LIC_TIPOM#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_RESID IS '#INF#LIC_RESID#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_USEDI IS '#INF#LIC_USEDI#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NVIN IS '#INF#LIC_NVIN#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NVIR IS '#INF#LIC_NVIR#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NLIBRE IS '#INF#LIC_NLIBRE#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NVPOG IS '#INF#LIC_NVPOG#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NVPOE IS '#INF#LIC_NVPOE#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NVPOT IS '#INF#LIC_NVPOT#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NALOD IS '#INF#LIC_NALOD#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NREAL IS '#INF#LIC_NREAL1#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NVTMG IS '#INF#LIC_NVTMG#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NVTME IS '#INF#LIC_NVTME#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NVTOT IS '#INF#LIC_NVTOT#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NSP45 IS '#INF#LIC_NSP45#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NSP75 IS '#INF#LIC_NSP75#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NSP90 IS '#INF#LIC_NSP90#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NSP90M IS '#INF#LIC_NSP90M#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_NSPT IS '#INF#LIC_NSPT#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_USOV IS '#INF#LIC_USOV#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_OTRU IS '#INF#LIC_OTRU#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_PRECIO IS '#INF#LIC_PRECIO#INF#'
/

COMMENT ON COLUMN Q022DV03.LIC_OBSLI IS '#INF#LIC_OBSLI#INF#'
/


CREATE OR REPLACE VIEW Q022DV04
(Q022BT00_ID_GRUPO, Q022DT00_ID_CUES, Q022DT00_IDEN_LICEN, Q022DT00_FEC_ENT, Q022DT00_ESTADO_LICEN, 
 Q022DT00_CAUSA_BAJA, Q022DT00_ENTI, DESC_LOCALIDAD, Q022DT00_TVIA, Q022DT00_CALLE, 
 Q022DT00_POR_CL_POR, Q022DT00_BLOQ, Q022DT00_NUME, Q022DT00_BIS, Q022DT00_CDIR, 
 Q022DT00_RS_PROMO, Q022DT00_CIF_DNI, Q022DT00_MUN_PROV, Q022DT00_MUN_MUNI, Q022DT00_ENTI_PRO, 
 Q022DT00_TVIA_PRO, Q022DT00_CALLE_PRO, Q022DT00_POR_CL_POR_PRO, Q022DT00_BLOQ_PRO, Q022DT00_NUME_PRO, 
 Q022DT00_BIS_PRO, Q022DT00_CDIR_PRO, Q022DT00_TLF, Q022DT00_MAIL, Q022DT00_FAX, 
 Q022DT00_WEB, Q022DT00_PRESUPUESTO, Q022DT00_F_INI, Q022DT00_F_FIN, Q022DT00_TIPO_OBRA, 
 Q022DT00_USO_RES, Q022DT00_ACTIVIDAD, Q022DT00_NVN, Q022DT00_NVR, Q022DT00_NVL, 
 Q022DT00_NVVPO, Q022DT00_NVVS, Q022DT00_NVPOT, Q022DT00_NVALDOT, Q022DT00_NVREAL, 
 Q022DT00_NVVTMG, Q022DT00_NVVTME, Q022DT00_NTOT, Q022DT00_NSP45, Q022DT00_NSP75, 
 Q022DT00_NSP90, Q022DT00_NSP120, Q022DT00_NSPT, Q022DT00_PRINC_USO, Q022DT00_PU_ESPECIF, 
 Q022DT00_PRECIO_MED, Q022DT00_OBS, Q022BT00_ANO, Q022BT00_MES, Q022BT00_CONCEDIDO_LICEN, 
 Q022BT00_FEC_ALTA, Q022BT00_FEC_MOD, FCA02T00_CODPROVINC, DESC_PROV, FCA02T00_CODMUNICIP, 
 DESC_MUNI, Q022BT00_FEC_FIRMA, Q022BT00_XML_FIRMADO, Q022BT00_USER_FIRMA)
AS 
select
 Q022BT00_ID_GRUPO  ,
 Q022DT00_ID_CUES         , 
 Q022DT00_IDEN_LICEN      , 
 Q022DT00_FEC_ENT         , 
 Q022DT00_ESTADO_LICEN    , 
 Q022DT00_CAUSA_BAJA      , 
 Q022DT00_ENTI            , 
 NORA_T17_LOCALIDAD.DS_O DESC_LOCALIDAD, 
 Q022DT00_TVIA            , 
 Q022DT00_CALLE           , 
 Q022DT00_POR_CL_POR      , 
 Q022DT00_BLOQ            , 
 Q022DT00_NUME            , 
 Q022DT00_BIS             , 
 Q022DT00_CDIR            , 
 Q022DT00_RS_PROMO        , 
 Q022DT00_CIF_DNI         , 
 Q022DT00_MUN_PROV        ,
 Q022DT00_MUN_MUNI        , 
 Q022DT00_ENTI_PRO        , 
 Q022DT00_TVIA_PRO        , 
 Q022DT00_CALLE_PRO       , 
 Q022DT00_POR_CL_POR_PRO  , 
 Q022DT00_BLOQ_PRO        , 
 Q022DT00_NUME_PRO        , 
 Q022DT00_BIS_PRO         , 
 Q022DT00_CDIR_PRO        , 
 Q022DT00_TLF             , 
 Q022DT00_MAIL            , 
 Q022DT00_FAX             , 
 Q022DT00_WEB             , 
 Q022DT00_PRESUPUESTO     , 
 Q022DT00_F_INI           , 
 Q022DT00_F_FIN           , 
 Q022DT00_TIPO_OBRA       , 
 Q022DT00_USO_RES         , 
 Q022DT00_ACTIVIDAD       , 
 Q022DT00_NVN             , 
 Q022DT00_NVR             , 
 Q022DT00_NVL             , 
 Q022DT00_NVVPO           , 
 Q022DT00_NVVS            , 
 Q022DT00_NVPOT           , 
 Q022DT00_NVALDOT         , 
 Q022DT00_NVREAL          , 
 Q022DT00_NVVTMG          , 
 Q022DT00_NVVTME          , 
 Q022DT00_NTOT            , 
 Q022DT00_NSP45           , 
 Q022DT00_NSP75           , 
 Q022DT00_NSP90           , 
 Q022DT00_NSP120          , 
 Q022DT00_NSPT            , 
 Q022DT00_PRINC_USO       , 
 Q022DT00_PU_ESPECIF      , 
 Q022DT00_PRECIO_MED      , 
 Q022DT00_OBS             ,  
 Q022BT00_ANO             ,  
 Q022BT00_MES             ,  
 Q022BT00_CONCEDIDO_LICEN ,  
 Q022BT00_FEC_ALTA        ,  
 Q022BT00_FEC_MOD         ,  
 FCA02T00_CODPROVINC      ,  
 NORA_T17_PROVINCIA.DS_O DESC_PROV, 
 FCA02T00_CODMUNICIP      ,  
 NORA_T17_MUNICIPIO.DS_O DESC_MUNI,
 Q022BT00_FEC_FIRMA       ,  
 Q022BT00_XML_FIRMADO     ,  
 Q022BT00_USER_FIRMA 
from Q022DV01,
NORA_T17_PROVINCIA,
NORA_T17_MUNICIPIO,
NORA_T17_LOCALIDAD
where
Q022DV01.FCA02T00_CODPROVINC = NORA_T17_PROVINCIA.ID AND 
Q022DV01.FCA02T00_CODPROVINC = NORA_T17_MUNICIPIO.PROVINCIA_ID AND
Q022DV01.FCA02T00_CODMUNICIP = NORA_T17_MUNICIPIO.ID AND
Q022DV01.Q022DT00_ENTI=NORA_T17_LOCALIDAD.ID(+)
/


CREATE OR REPLACE VIEW Q022EV01
(Q022CT00_ID_GRUPO, Q022CT00_ANO, Q22CT00_MES, MUN_PROV, MUN_MUNI, 
 Q022ET00_ID_CUES, Q022CT00_REALIZA_ACTUACION, Q022CT00_FEC_ALTA, Q022CT00_FEC_MOD, Q022ET00_CLASU, 
 Q022ET00_SUPSU, Q022ET00_SUPTE, Q022ET00_VALSU, Q022ET00_NVPOG, Q022ET00_NVPOE, 
 Q022ET00_NVTMG, Q022ET00_NVTME, Q022ET00_NALOD, Q022ET00_NREAL, Q022ET00_NVTOT, 
 Q022ET00_FEC_ALTA, Q022ET00_FEC_MOD, Q022ET00_FEC_BAJA, Q022ET00_FIRMADO, Q022ET00_CDEXP, 
 Q022ET00_NVPOT, Q022ET00_NLIBRE, Q022ET00_OBSSU, Q022ET00_FADQ, Q022ET00_ENTI, 
 Q022ET00_TVIA, Q022ET00_CALLE, Q022ET00_POR_CL_POR, Q022ET00_BLOQ, Q022ET00_NUME, 
 Q022ET00_BIS, Q022ET00_CDIR, Q022ET00_TIPADQ)
AS 
SELECT 
    Q022CT00.Q022CT00_ID_GRUPO,
    Q022CT00.Q022CT00_ANO,
    Q022CT00.Q22CT00_MES,
    Q022CT00.MUN_PROV,
    Q022CT00.MUN_MUNI,
    Q022ET00.Q022ET00_ID_CUES,
    Q022CT00_REALIZA_ACTUACION,    
    Q022CT00_FEC_ALTA,
    Q022CT00_FEC_MOD,
    Q022ET00_CLASU,
    Q022ET00_SUPSU,
    Q022ET00_SUPTE,
    Q022ET00_VALSU,
    Q022ET00_NVPOG,
    Q022ET00_NVPOE,
    Q022ET00_NVTMG,
    Q022ET00_NVTME,
    Q022ET00_NALOD,
    Q022ET00_NREAL,
    Q022ET00_NVTOT,
    Q022ET00_FEC_ALTA,
    Q022ET00_FEC_MOD,
    Q022ET00_FEC_BAJA,
    Q022ET00_FIRMADO,
    Q022ET00_CDEXP,
    Q022ET00_NVPOT,
    Q022ET00_NLIBRE,
    Q022ET00_OBSSU,
    Q022ET00_FADQ,
    Q022ET00_ENTI,
    Q022ET00_TVIA,
    Q022ET00_CALLE,
    Q022ET00_POR_CL_POR,
    Q022ET00_BLOQ,
    Q022ET00_NUME,
    Q022ET00_BIS,
    Q022ET00_CDIR,
    Q022ET00_TIPADQ 
FROM  Q022CT00, Q022ET00
WHERE Q022CT00.Q022CT00_ID_GRUPO =Q022ET00.Q022CT00_ID_GRUPO
/


CREATE OR REPLACE VIEW Q022EV02
(Q022CT00_ID_GRUPO, MUN_PROV, MUN_MUNI, Q022CT00_ANO, Q22CT00_MES, 
 Q022ET00_ID_CUES, Q022ET00_CLASU, Q022ET00_SUPSU, Q022ET00_SUPTE, Q022ET00_VALSU, 
 Q022ET00_NVPOG, Q022ET00_NVPOE, Q022ET00_NVTMG, Q022ET00_NVTME, Q022ET00_NALOD, 
 Q022ET00_NREAL, Q022ET00_NVTOT, Q022ET00_FEC_ALTA, Q022ET00_FEC_MOD, Q022ET00_FEC_BAJA, 
 Q022ET00_FIRMADO, Q022ET00_CDEXP, Q022ET00_NVPOT, Q022ET00_NLIBRE, Q022ET00_OBSSU, 
 Q022ET00_FADQ, Q022ET00_ENTI, Q022ET00_TVIA, Q022ET00_CALLE, Q022ET00_POR_CL_POR, 
 Q022ET00_BLOQ, Q022ET00_NUME, Q022ET00_BIS, Q022ET00_CDIR, Q022ET00_TIPADQ, 
 Q022ET00_NORA_T17_LOCALIZACION, Q022ET00_DIR_NUEVA)
AS 
select 
  Q022CS00.Q022CT00_ID_GRUPO   ,
   MUN_PROV,
  MUN_MUNI,
  Q022CT00_ANO,
  Q22CT00_MES        ,
  Q022ET00_ID_CUES    ,
  Q022ET00_CLASU      ,
  Q022ET00_SUPSU      ,
  Q022ET00_SUPTE      ,
  Q022ET00_VALSU      ,
  Q022ET00_NVPOG      ,
  Q022ET00_NVPOE      ,
  Q022ET00_NVTMG      ,
  Q022ET00_NVTME      ,
  Q022ET00_NALOD      ,
  Q022ET00_NREAL      ,
  Q022ET00_NVTOT      ,
  Q022ET00_FEC_ALTA   ,
  Q022ET00_FEC_MOD    ,
  Q022ET00_FEC_BAJA   ,
  Q022ET00_FIRMADO    ,
  Q022ET00_CDEXP      ,
  Q022ET00_NVPOT      ,
  Q022ET00_NLIBRE     ,
  Q022ET00_OBSSU      ,
  Q022ET00_FADQ       ,
  Q022ET00_ENTI       ,
  Q022ET00_TVIA       ,
  Q022ET00_CALLE      ,
  Q022ET00_POR_CL_POR ,
  Q022ET00_BLOQ       ,
  Q022ET00_NUME       ,
  Q022ET00_BIS        ,
  Q022ET00_CDIR       ,
  Q022ET00_TIPADQ ,
  CASE WHEN ( TRIM(Q022ET00_CALLE) = 0 OR TRIM(Q022ET00_CALLE) = '' OR TRIM(Q022ET00_CALLE) IS NULL) THEN NORA_T17_LOCALIDAD.DS_O
       ELSE NORA_T17_LOCALIDAD.DS_O  || DECODE(NORA_T17_LOCALIDAD.DS_O,'','',', ')  || NORA_T17_CALLE.DS_O || ' ' ||  DECODE ( Q022ET00_BLOQ, '0' , '',  Q022ET00_BLOQ)  || ' '  || DECODE ( Q022ET00_NUME, '0' , '',  Q022ET00_NUME) || ' '||  DECODE( Q022ET00_BIS, '0','',Q022ET00_BIS)
  END DIRECCION,
  Q022ET00_DIR_NUEVA  
from Q022CS00 ,Q022ES00, NORA_T17_LOCALIDAD,NORA_T17_CALLE 
where 
Q022CS00.Q022CT00_ID_GRUPO=Q022ES00.Q022CT00_ID_GRUPO and
Q022ES00.Q022ET00_ENTI=NORA_T17_LOCALIDAD.ID(+)   and
Q022ES00.Q022ET00_CALLE=NORA_T17_CALLE.ID(+)
/


CREATE OR REPLACE VIEW Q022EV03
(SUE_CLAVE1, SUE_CLAVE2, SUE_CLAVE3, SUE_TERR, SUE_MUN, 
 SUE_ANNO, SUE_MES, SUE_MSUE, SUE_NCUS, SUE_CUSN, 
 SUE_CDEXP, SUE_CLASU, SUE_FADQ, SUE_TIPADQ, SUE_ENTI, 
 SUE_ENTID, SUE_TVIA, SUE_CALLE, SUE_CALLED, SUE_BLOQ, 
 SUE_NUME, SUE_BIS, SUE_CDIR, SUE_SUPSU, SUE_SUPTE, 
 SUE_VALSU, SUE_NLIBRE, SUE_NVPOG, SUE_NVPOE, SUE_NVPOT, 
 SUE_NALOD, SUE_NREAL, SUE_NVTMG, SUE_NVTME, SUE_NVTOT, 
 SUE_OBSSU)
AS 
SELECT 
 Q022ET00.Q022CT00_ID_GRUPO         ,
 Q022ET00_ID_CUES                   ,
 Q022CT00.MUN_MUNI || Q022CT00.Q022CT00_ANO || Q022CT00.Q22CT00_MES || obtener_cusn(Q022ET00.Q022CT00_ID_GRUPO,Q022ET00.Q022ET00_ID_CUES) ,
 Q022CT00.MUN_PROV                  , 
 Q022CT00.MUN_MUNI                  , 
 Q022CT00.Q022CT00_ANO              , 
 Q022CT00.Q22CT00_MES               ,
 Q022CT00.Q022CT00_REALIZA_ACTUACION, 
 Q022CT00.Q022CT00_NCUS             , 
 obtener_cusn(Q022ET00.Q022CT00_ID_GRUPO,Q022ET00.Q022ET00_ID_CUES) ,
 Q022ET00_CDEXP                     , 
 Q022ET00_CLASU                     , 
 Q022ET00_FADQ                      ,
 Q022ET00_TIPADQ                    ,
 Q022ET00_ENTI                      , 
 NORA_T17_LOCALIDAD.DS_O            ,
 Q022ET00_TVIA                      , 
 Q022ET00_CALLE                     ,
 NORA_T17_CALLE.DS_O                , 
 Q022ET00_BLOQ                      , 
 Q022ET00_NUME                      , 
 Q022ET00_BIS                       , 
 Q022ET00_CDIR                      , 
 Q022ET00_SUPSU                     , 
 Q022ET00_SUPTE                     , 
 Q022ET00_VALSU                     , 
 Q022ET00_NLIBRE                    ,
 Q022ET00_NVPOG                     , 
 Q022ET00_NVPOE                     ,
 Q022ET00_NVPOT                     , 
 Q022ET00_NALOD                     ,
 Q022ET00_NREAL                     ,
 Q022ET00_NVTMG                     , 
 Q022ET00_NVTME                     , 
 Q022ET00_NVTOT                     , 
 Q022ET00_OBSSU  
 FROM    Q022ET00, Q022CT00, NORA_T17_CALLE, NORA_T17_LOCALIDAD
 where Q022ET00.Q022CT00_ID_GRUPO=Q022CT00.Q022CT00_ID_GRUPO  and
 Q022ET00.Q022ET00_CALLE =NORA_T17_CALLE.ID(+) and
 Q022ET00.Q022ET00_ENTI=NORA_T17_LOCALIDAD.ID(+)
/

COMMENT ON COLUMN Q022EV03.SUE_CLAVE1 IS '#INF#SUE_CLAVE1#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_CLAVE2 IS '#INF#SUE_CLAVE2#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_CLAVE3 IS '#INF#SUE_CLAVE3#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_TERR IS '#INF#SUE_TERR#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_MUN IS '#INF#SUE_mun#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_ANNO IS '#INF#SUE_ANNO#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_MES IS '#INF#SUE_MES#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_MSUE IS '#INF#SUE_MSUE#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NCUS IS '#INF#SUE_NCUS#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_CUSN IS '#INF#SUE_CUSN#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_CDEXP IS '#INF#SUE_CDEXP#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_CLASU IS '#INF#SUE_CLASU#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_FADQ IS '#INF#SUE_FADQ#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_TIPADQ IS '#INF#SUE_TIPADQ#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_ENTI IS '#INF#SUE_ENTI#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_ENTID IS '#INF#SUE_ENTID#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_TVIA IS '#INF#SUE_TVIA#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_CALLE IS '#INF#SUE_CALLE#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_CALLED IS '#INF#SUE_CALLED#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_BLOQ IS '#INF#SUE_BLOQ#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NUME IS '#INF#SUE_NUME#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_BIS IS '#INF#SUE_BIS#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_CDIR IS '#INF#SUE_CDIR#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_SUPSU IS '#INF#SUE_SUPSU#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_SUPTE IS '#INF#SUE_SUPTE#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_VALSU IS '#INF#SUE_VALSU#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NLIBRE IS '#INF#SUE_NLIBRE#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NVPOG IS '#INF#SUE_NVPOG#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NVPOE IS '#INF#SUE_NVPOE#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NVPOT IS '#INF#SUE_NVPOT#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NALOD IS '#INF#SUE_NALOD#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NREAL IS '#INF#SUE_NREAL#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NVTMG IS '#INF#SUE_NVTMG#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NVTME IS '#INF#SUE_NVTME#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_NVTOT IS '#INF#SUE_NVTOT#INF#'
/

COMMENT ON COLUMN Q022EV03.SUE_OBSSU IS '#INF#SUE_OBSSU#INF#'
/


CREATE OR REPLACE VIEW Q022EV04
(Q022CT00_ID_GRUPO, Q022CT00_ANO, Q22CT00_MES, MUN_PROV, DESC_PROV, 
 MUN_MUNI, DESC_MUNI, Q022ET00_ID_CUES, Q022CT00_REALIZA_ACTUACION, Q022CT00_FEC_ALTA, 
 Q022CT00_FEC_MOD, Q022ET00_CLASU, Q022ET00_SUPSU, Q022ET00_SUPTE, Q022ET00_VALSU, 
 Q022ET00_NVPOG, Q022ET00_NVPOE, Q022ET00_NVTMG, Q022ET00_NVTME, Q022ET00_NALOD, 
 Q022ET00_NREAL, Q022ET00_NVTOT, Q022ET00_FEC_ALTA, Q022ET00_FEC_MOD, Q022ET00_FEC_BAJA, 
 Q022ET00_FIRMADO, Q022ET00_CDEXP, Q022ET00_NVPOT, Q022ET00_NLIBRE, Q022ET00_OBSSU, 
 Q022ET00_FADQ, Q022ET00_ENTI, DESC_LOCALIDAD, Q022ET00_TVIA, Q022ET00_CALLE, 
 Q022ET00_POR_CL_POR, Q022ET00_BLOQ, Q022ET00_NUME, Q022ET00_BIS, Q022ET00_CDIR, 
 Q022ET00_TIPADQ)
AS 
select
    Q022EV01.Q022CT00_ID_GRUPO,
    Q022EV01.Q022CT00_ANO,
    Q022EV01.Q22CT00_MES,
    Q022EV01.MUN_PROV,
    NORA_T17_PROVINCIA.DS_O DESC_PROV,
    Q022EV01.MUN_MUNI,
    NORA_T17_MUNICIPIO.DS_O DESC_MUNI,
    Q022EV01.Q022ET00_ID_CUES,
    Q022CT00_REALIZA_ACTUACION,    
    Q022CT00_FEC_ALTA,
    Q022CT00_FEC_MOD,
    Q022ET00_CLASU,
    Q022ET00_SUPSU,
    Q022ET00_SUPTE,
    Q022ET00_VALSU,
    Q022ET00_NVPOG,
    Q022ET00_NVPOE,
    Q022ET00_NVTMG,
    Q022ET00_NVTME,
    Q022ET00_NALOD,
    Q022ET00_NREAL,
    Q022ET00_NVTOT,
    Q022ET00_FEC_ALTA,
    Q022ET00_FEC_MOD,
    Q022ET00_FEC_BAJA,
    Q022ET00_FIRMADO,
    Q022ET00_CDEXP,
    Q022ET00_NVPOT,
    Q022ET00_NLIBRE,
    Q022ET00_OBSSU,
    Q022ET00_FADQ,
    Q022ET00_ENTI,
    NORA_T17_LOCALIDAD.DS_O DESC_LOCALIDAD, 
    Q022ET00_TVIA,
    Q022ET00_CALLE,
    Q022ET00_POR_CL_POR,
    Q022ET00_BLOQ,
    Q022ET00_NUME,
    Q022ET00_BIS,
    Q022ET00_CDIR,
    Q022ET00_TIPADQ 
from Q022EV01,
NORA_T17_PROVINCIA,
NORA_T17_MUNICIPIO,
NORA_T17_LOCALIDAD
where
Q022EV01.MUN_PROV = NORA_T17_PROVINCIA.ID AND 
Q022EV01.MUN_PROV = NORA_T17_MUNICIPIO.PROVINCIA_ID AND
Q022EV01.MUN_MUNI = NORA_T17_MUNICIPIO.ID AND
Q022EV01.Q022ET00_ENTI=NORA_T17_LOCALIDAD.ID(+)
/


CREATE OR REPLACE VIEW Q022FV01
(Q022FT00_IDUSUARIO, Q022FT00_NOMBRE, Q022FT00_APELLIDO1, Q022FT00_APELLIDO2, Q022FT00_NIF, 
 Q022FT00_EMAIL, Q022FT00_PASSWORD, MUN_PROV, DESC_PROV, MUN_MUNI, 
 DESC_MUNI, Q022FT00_FECHA_ACTIVACION, Q022FT00_FECHA_DESACTIVACION, Q021AT00_CODPERFIL, Q022FT00_NI_MULTIPLE, 
 Q022FT00_NOMBRE_COMPLETO)
AS 
select
Q022FT00_IDUSUARIO,
Q022FT00_NOMBRE,
Q022FT00_APELLIDO1,
Q022FT00_APELLIDO2,
Q022FT00_NIF,
Q022FT00_EMAIL,
Q022FT00_PASSWORD,
MUN_PROV,
provincias.DS_O,
MUN_MUNI,
municipios.DS_O,
Q022FT00_FECHA_ACTIVACION,
Q022FT00_FECHA_DESACTIVACION,
Q021AT00_CODPERFIL,
Q022FT00_IDUSUARIO||'#'||Q022FT00_NOMBRE||' '||Q022FT00_APELLIDO1||' '||Q022FT00_APELLIDO2,
Q022FT00_NOMBRE||' '||Q022FT00_APELLIDO1||' '||Q022FT00_APELLIDO2
FROM Q022FT00 usuarios,
NORA_T17_PROVINCIA provincias,
NORA_T17_MUNICIPIO municipios
WHERE 
usuarios.MUN_PROV= provincias.ID(+)
AND
usuarios.MUN_MUNI= municipios.ID(+)
AND
usuarios.MUN_PROV= municipios.PROVINCIA_ID(+)
/


CREATE OR REPLACE VIEW Q022FV02
(Q022FT00_IDUSUARIO, Q022FT00_NOMBRE_COMP, Q022FT00_FECHA_ACTIVACION, Q022FT00_FECHA_DESACTIVACION, Q021HT00_NI, 
 Q021HT00_COD, Q021GT00_NI, Q021GT00_COD, Q021GT00_DESC, Q021FT00_NI, 
 Q021FT00_COD, Q021FT00_DESC, Q021ET00_NI, Q021ET00_CODIGO, Q021ET00_DESC, 
 Q021ET00_IND_INACTIVO)
AS 
select usuarios.Q022FT00_IDUSUARIO ,Q022FT00_NOMBRE||' '||Q022FT00_APELLIDO1||' '||Q022FT00_APELLIDO2, 
usuarios.Q022FT00_FECHA_ACTIVACION, usuarios.Q022FT00_FECHA_DESACTIVACION,
grupo_usu.Q021HT00_NI, grupo.Q021HT00_COD, grupo_rol.Q021GT00_NI, rol.Q021GT00_COD, rol.Q021GT00_DESC,
rol_proc.Q021FT00_NI, proc.Q021FT00_COD, proc.Q021FT00_DESC, proc.Q021ET00_NI, modulo.Q021ET00_CODIGO, modulo.Q021ET00_DESC, modulo.Q021ET00_IND_INACTIVO
from
q022ft00 usuarios,  q021jt00 grupo_usu, 
q021ht00 grupo,  q021kt00 grupo_rol, q021gt00 rol, q021lt00 rol_proc, q021ft00 proc, q021et00 modulo
where
usuarios.Q022FT00_IDUSUARIO=grupo_usu.Q022FT00_NI and
grupo_usu.Q021HT00_NI=grupo.Q021HT00_NI and
grupo.Q021HT00_NI=grupo_rol.Q021HT00_NI  and
grupo_rol.Q021GT00_NI=rol.Q021GT00_NI and
rol.Q021GT00_NI=rol_proc.Q021GT00_NI and
rol_proc.Q021FT00_NI=proc.Q021FT00_NI and
proc.Q021ET00_NI=modulo.Q021ET00_NI
/


CREATE OR REPLACE VIEW Q022GV01
(ALQ_CLAVE1, ALQ_CLAVE2, ALQ_CLAVE3, ALQ_TERR, ALQ_MUN, 
 ALQ_ANNO, ALQ_MES, ALQ_MALQ, ALQ_ANORF, ALQ_PRV1A, 
 ALQ_ADQVI1, ALQ_NADQ1, ALQ_PROVI1, ALQ_NPRO1, ALQ_OTRVI1, 
 ALQ_NOTR1, ALQ_OTRLT1, ALQ_NTOT1, ALQ_PRV4A, ALQ_ADQVI4, 
 ALQ_NADQ4, ALQ_PROVI4, ALQ_NPRO4, ALQ_OTRVI4, ALQ_NOTR4, 
 ALQ_OTRLT4, ALQ_NTOT4, ALQ_TALQ, ALQ_NALQ, ALQ_NSP45, 
 ALQ_NSP75, ALQ_NSP90, ALQ_NSP90M, ALQ_NSPT, ALQ_NRSP45, 
 ALQ_NRSP75, ALQ_NRSP90, ALQ_NRSP90M, ALQ_NRSPT, ALQ_NOCUP, 
 ALQ_NDESA, ALQ_NDESO, ALQ_NDESOT, ALQ_NOCUT, ALQ_DESOTR, 
 ALQ_NLIBRE, ALQ_NVPOG, ALQ_NVPOE, ALQ_NVPOT, ALQ_NALOD, 
 ALQ_NREAL, ALQ_NVTMG, ALQ_NVTME, ALQ_NVTOT, ALQ_NANT60M, 
 ALQ_NANT30, ALQ_NANT10, ALQ_NANT10M, ALQ_NANTT, ALQ_OBSAL)
AS 
SELECT
  Q022GT00_ID_CUES         , 
  Q022GT00_ID_CUES         ,
  Q022GT00_MUN_MUNI || (Q022GT00_ANO)-1              ,
  Q022GT00_MUN_PROV        , 
  Q022GT00_MUN_MUNI        , 
  Q022GT00_ANO             , 
  1                        ,
  Q022GT00_CONCEDIDO_LICEN , 
  (Q022GT00_ANO)-1         ,
  Q022GT00_PRV1A           , 
  Q022GT00_ADQVI1          , 
  Q022GT00_NADQ1           , 
  Q022GT00_PROVI1          , 
  Q022GT00_NPRO1           , 
  Q022GT00_OTRVI1          , 
  Q022GT00_NOTR1           , 
  Q022GT00_OTRLT1          , 
  Q022GT00_NTOT1           , 
  Q022GT00_PRV4A           , 
  Q022GT00_ADQVI4          , 
  Q022GT00_NADQ4           , 
  Q022GT00_PROVI4          , 
  Q022GT00_NPRO4           , 
  Q022GT00_OTRVI4          , 
  Q022GT00_NOTR4           ,
  Q022GT00_OTRLT4          ,  
  Q022GT00_NTOT4           , 
  Q022GT00_TALQ            , 
  Q022GT00_NALQ            , 
  Q022GT00_NSP45           , 
  Q022GT00_NSP75           , 
  Q022GT00_NSP90           , 
  Q022GT00_NSP90M          , 
  Q022GT00_NSPT            , 
  Q022GT00_NRSP45          , 
  Q022GT00_NRSP75          , 
  Q022GT00_NRSP90          , 
  Q022GT00_NRSP90M         , 
  Q022GT00_NRSPT           , 
  Q022GT00_NOCUP           , 
  Q022GT00_NDESA           , 
  Q022GT00_NDESO           , 
  Q022GT00_NDESOT          ,
  Q022GT00_NOCUT           , 
  Q022GT00_DESOTR          ,
  Q022GT00_NLIBRE          ,  
  Q022GT00_NVPOG           , 
  Q022GT00_NVPOE           , 
  Q022GT00_NVPOT           , 
  Q022GT00_NALOD           , 
  Q022GT00_NREAL           , 
  Q022GT00_NVTMG           , 
  Q022GT00_NVTME           , 
  Q022GT00_NVTOT           , 
  Q022GT00_NANT60M         , 
  Q022GT00_NANT30          , 
  Q022GT00_NANT10          , 
  Q022GT00_NANT10M         , 
  Q022GT00_NANTT           , 
  Q022GT00_OBSAL                       
FROM  Q022GT00
/

COMMENT ON COLUMN Q022GV01.ALQ_CLAVE1 IS '#INF#ALQ_CLAVE1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_CLAVE2 IS '#INF#ALQ_CLAVE2#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_CLAVE3 IS '#INF#ALQ_CLAVE3#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_TERR IS '#INF#ALQ_TERR#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_MUN IS '#INF#ALQ_MUN#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_ANNO IS '#INF#ALQ_ANNO#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_MES IS '#INF#ALQ_MES#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_MALQ IS '#INF#ALQ_MALQ#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_ANORF IS '#INF#ALQ_ANORF#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_PRV1A IS '#INF#ALQ_PRV1A#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_ADQVI1 IS '#INF#ALQ_ADQVI1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NADQ1 IS '#INF#ALQ_NADQ1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_PROVI1 IS '#INF#ALQ_PROVI1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NPRO1 IS '#INF#ALQ_NPRO1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_OTRVI1 IS '#INF#ALQ_OTRVI1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NOTR1 IS '#INF#ALQ_NOTR1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_OTRLT1 IS '#INF#ALQ_OTRLT1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NTOT1 IS '#INF#ALQ_NTOT1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_PRV4A IS '#INF#ALQ_PRV4A#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_ADQVI4 IS '#INF#ALQ_ADQVI4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NADQ4 IS '#INF#ALQ_NADQ4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_PROVI4 IS '#INF#ALQ_PROVI4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NPRO4 IS '#INF#ALQ_NPRO4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_OTRVI4 IS '#INF#ALQ_OTRVI4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NOTR4 IS '#INF#ALQ_NOTR4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_OTRLT4 IS '#INF#ALQ_OTRLT4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NTOT4 IS '#INF#ALQ_NTOT4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_TALQ IS '#INF#ALQ_TALQ#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NALQ IS '#INF#ALQ_NALQ#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NSP45 IS '#INF#ALQ_NSP45#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NSP75 IS '#INF#ALQ_NSP75#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NSP90 IS '#INF#ALQ_NSP90#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NSP90M IS '#INF#ALQ_NSP90M#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NSPT IS '#INF#ALQ_NSPT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NRSP45 IS '#INF#ALQ_NRSP45#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NRSP75 IS '#INF#ALQ_NRSP75#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NRSP90 IS '#INF#ALQ_NRSP90#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NRSP90M IS '#INF#ALQ_NRSP90M#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NRSPT IS '#INF#ALQ_NRSPT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NOCUP IS '#INF#ALQ_NOCUP#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NDESA IS '#INF#ALQ_NDESA#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NDESO IS '#INF#ALQ_ndeso#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NDESOT IS '#INF#ALQ_NDESOT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NOCUT IS '#INF#ALQ_NOCUT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_DESOTR IS '#INF#ALQ_DESOTR#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NLIBRE IS '#INF#ALQ_NLIBRE#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NVPOG IS '#INF#ALQ_NVPOG#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NVPOE IS '#INF#ALQ_NVPOE#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NVPOT IS '#INF#ALQ_NVPOT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NALOD IS '#INF#ALQ_NALOD#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NREAL IS '#INF#ALQ_NREAL#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NVTMG IS '#INF#ALQ_NVTMG#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NVTME IS '#INF#ALQ_NVTME#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NVTOT IS '#INF#ALQ_NVTOT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NANT60M IS '#INF#ALQ_NANT60M#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NANT30 IS '#INF#ALQ_NANT30#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NANT10 IS '#INF#ALQ_NANT10#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NANT10M IS '#INF#ALQ_NANT10M#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NANTT IS '#INF#ALQ_NANTT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_OBSAL IS '#INF#ALQ_OBSAL#INF#'
/


CREATE OR REPLACE VIEW Q022HV01
(Q022HT00_ID_OFI, Q022HT00_PROV, Q022HT00_MUNI, Q022HT00_DESC, Q022HT00_DESC_EUS, 
 Q022HT00_TVIA, Q022HT00_CALLE, Q022HT00_BLOQ, Q022HT00_NUME, Q022HT00_BIS, 
 Q022HT00_ESCA, Q022HT00_PISO, Q022HT00_MANO, Q022HT00_PUER, Q022HT00_CODP, 
 Q022HT00_CDIR, Q022HT00_DEPA, Q022HT00_EMAILD, Q022HT00_TELF1D, Q022HT00_TELF2D, 
 Q022HT00_FAXD, Q022HT00_WEB, NORA_T17_PROVINCIA_DS, NORA_T17_MUNICIPIO_DS, NORA_T17_LOCALIZACION)
AS 
SELECT                      
  Q022HT00_ID_OFI   ,      
  Q022HT00_PROV     ,      
  Q022HT00_MUNI     ,      
  Q022HT00_DESC     ,      
  Q022HT00_DESC_EUS ,      
  Q022HT00_TVIA     ,      
  Q022HT00_CALLE    ,      
  Q022HT00_BLOQ     ,      
  Q022HT00_NUME     ,      
  Q022HT00_BIS      ,      
  Q022HT00_ESCA     ,      
  Q022HT00_PISO     ,      
  Q022HT00_MANO     ,      
  Q022HT00_PUER     ,      
  Q022HT00_CODP     ,      
  Q022HT00_CDIR     ,      
  Q022HT00_DEPA     ,      
  Q022HT00_EMAILD   ,      
  Q022HT00_TELF1D   ,      
  Q022HT00_TELF2D   ,      
  Q022HT00_FAXD     ,      
  Q022HT00_WEB   ,
  NORA_T17_PROVINCIA.DS_O,
  NORA_T17_MUNICIPIO.DS_O, Q022HT00_TVIA || ' ' || NORA_T17_CALLE.DS_O || ' ' ||  Q022HT00_BLOQ || ' '  ||  Q022HT00_NUME || ' '||  Q022HT00_BIS          
FROM Q022HT00,
 NORA_T17_PROVINCIA, NORA_T17_MUNICIPIO,  NORA_T17_CALLE 
WHERE
Q022HT00.Q022HT00_PROV =NORA_T17_PROVINCIA.ID (+) and
Q022HT00.Q022HT00_MUNI =NORA_T17_MUNICIPIO.ID(+) and
Q022HT00.Q022HT00_PROV=NORA_T17_MUNICIPIO.PROVINCIA_ID (+) and
Q022HT00.Q022HT00_CALLE  =NORA_T17_CALLE.ID(+)
/


CREATE OR REPLACE VIEW Q022IV01
(Q022IT00_ID_INF, Q022IT00_ID_OFI, Q022IT00_NOMB, Q022IT00_APE1, Q022IT00_APE2, 
 Q022IT00_CARGO, Q022IT00_DEPA, Q022IT00_EMAIL, Q022IT00_TELF1, Q022IT00_TELF2, 
 Q022IT00_FAX, Q022IT00_FELEC, Q022IT00_PRINCPL, Q022HT00_PROV, Q022HT00_MUNI, 
 Q022HT00_DESC, Q022HT00_DESC_EUS, NORA_T17_PROVINCIA_DS, NORA_T17_MUNICIPIO_DS, Q022IT00_DNI)
AS 
SELECT 
  Q022IT00_ID_INF   ,
  Q022IT00_ID_OFI   ,
  Q022IT00_NOMB     ,
  Q022IT00_APE1     ,
  Q022IT00_APE2     ,
  Q022IT00_CARGO    ,
  Q022IT00_DEPA     ,
  Q022IT00_EMAIL    ,
  Q022IT00_TELF1    ,
  Q022IT00_TELF2    ,
  Q022IT00_FAX      ,
  Q022IT00_FELEC    ,
  Q022IT00_PRINCPL  ,    
  Q022HT00_PROV    ,
  Q022HT00_MUNI    ,
  Q022HT00_DESC    ,
  Q022HT00_DESC_EUS,
  NORA_T17_PROVINCIA.DS_O, 
  NORA_T17_MUNICIPIO.DS_O,
  Q022IT00_DNI
FROM Q022IT00, Q022HT00, NORA_T17_PROVINCIA, NORA_T17_MUNICIPIO
WHERE Q022IT00.Q022IT00_ID_OFI=Q022HT00.Q022HT00_ID_OFI AND
Q022HT00.Q022HT00_PROV =NORA_T17_PROVINCIA.ID (+) and
Q022HT00.Q022HT00_MUNI =NORA_T17_MUNICIPIO.ID(+) and
Q022HT00.Q022HT00_PROV =NORA_T17_MUNICIPIO.PROVINCIA_ID (+)
/


CREATE OR REPLACE VIEW Q022IV02
(Q022IT00_ID_INF, Q022IT00_ID_OFI, Q022IT00_NOMB, Q022IT00_APE1, Q022IT00_APE2, 
 Q022IT00_CARGO, Q022IT00_DEPA, Q022IT00_EMAIL, Q022IT00_TELF1, Q022IT00_TELF2, 
 Q022IT00_FAX, Q022IT00_FELEC, Q022IT00_PRINCPL, Q022IT00_DNI, FCA02T00_CODMUNICIP, 
 FCA02T00_CODPROVINC, MUN_MUNI, MUN_PROV, Q021AT00_CODPERFIL, Q022FT00_FECHA_ACTIVACION, 
 Q022FT00_FECHA_DESACTIVACION, Q022FT00_IDUSUARIO, Q022FT00_PASSWORD)
AS 
SELECT
 Q022IT00_ID_INF   ,
 Q022IT00_ID_OFI   ,
 Q022IT00_NOMB     ,
 Q022IT00_APE1     ,
 Q022IT00_APE2     ,
 Q022IT00_CARGO    ,
 Q022IT00_DEPA     ,
 Q022IT00_EMAIL    ,
 Q022IT00_TELF1    ,
 Q022IT00_TELF2    ,
 Q022IT00_FAX      ,
 Q022IT00_FELEC    ,
 Q022IT00_PRINCPL  ,
 Q022IT00_DNI    ,
 Q022FT00.FCA02T00_CODMUNICIP, Q022FT00.FCA02T00_CODPROVINC,
 Q022FT00.MUN_MUNI, Q022FT00.MUN_PROV, Q022FT00.Q021AT00_CODPERFIL, 
 Q022FT00.Q022FT00_FECHA_ACTIVACION, Q022FT00.Q022FT00_FECHA_DESACTIVACION, 
 Q022FT00.Q022FT00_IDUSUARIO, Q022FT00.Q022FT00_PASSWORD   
FROM Q022IT00, Q022FT00
WHERE Q022IT00.Q022IT00_DNI= Q022FT00.Q022FT00_NIF
/


CREATE OR REPLACE VIEW Q022JV01
(Q022JT00_ID_AGEN, Q022JT00_ID_OFI, Q022JT00_NOMB, Q022JT00_APE1, Q022JT00_APE2, 
 Q022JT00_CODAG, Q022JT00_CODJF, Q022JT00_EMAILA, Q022JT00_TELF1A, Q022JT00_TELF2A, 
 Q022HT00_PROV, Q022HT00_MUNI, Q022HT00_DESC, Q022HT00_DESC_EUS, NORA_T17_PROVINCIA_DS, 
 NORA_T17_MUNICIPIO_DS)
AS 
SELECT 
  Q022JT00.Q022JT00_ID_AGEN  ,
  Q022ZT00.Q022HT00_ID_OFI   ,
  Q022JT00_NOMB     ,
  Q022JT00_APE1     ,
  Q022JT00_APE2     ,
  Q022JT00_CODAG    ,
  Q022JT00_CODJF    ,
  Q022JT00_EMAILA   ,
  Q022JT00_TELF1A   ,
  Q022JT00_TELF2A   ,   
  Q022HT00_PROV    ,
  Q022HT00_MUNI    ,
  Q022HT00_DESC    ,
  Q022HT00_DESC_EUS,
  NORA_T17_PROVINCIA.DS_O, 
  NORA_T17_MUNICIPIO.DS_O
FROM Q022JT00, Q022HT00, NORA_T17_PROVINCIA, NORA_T17_MUNICIPIO,Q022ZT00
WHERE 
Q022JT00.Q022JT00_ID_AGEN=Q022ZT00.Q022JT00_ID_AGEN (+) and
Q022ZT00.Q022HT00_ID_OFI=Q022HT00.Q022HT00_ID_OFI (+) AND
--Q022JT00.Q022JT00_ID_OFI=Q022HT00.Q022HT00_ID_OFI AND
Q022HT00.Q022HT00_PROV =NORA_T17_PROVINCIA.ID (+) and
Q022HT00.Q022HT00_MUNI =NORA_T17_MUNICIPIO.ID(+) and
Q022HT00.Q022HT00_PROV =NORA_T17_MUNICIPIO.PROVINCIA_ID (+)
/


CREATE OR REPLACE VIEW Q022MV01
(Q022MT00_ID_AYUN, Q022MT00_PROV, Q022MT00_MUNI, Q022MT00_DESC, Q022MT00_DESC_EUS, 
 Q022MT00_TVIA, Q022MT00_CALLE, Q022MT00_BLOQ, Q022MT00_NUME, Q022MT00_BIS, 
 Q022MT00_ESCA, Q022MT00_PISO, Q022MT00_MANO, Q022MT00_PUER, Q022MT00_CODP, 
 Q022MT00_CDIR, Q022MT00_EMAIL, Q022MT00_TELF1, Q022MT00_TELF2, Q022MT00_FAX, 
 Q022MT00_WEB, NORA_T17_PROVINCIA_DS, NORA_T17_MUNICIPIO_DS, NORA_T17_LOCALIZACION)
AS 
select  Q022MT00_ID_AYUN   ,
  Q022MT00_PROV      ,
  Q022MT00_MUNI      ,
  Q022MT00_DESC      ,
  Q022MT00_DESC_EUS  ,
  Q022MT00_TVIA      ,
  Q022MT00_CALLE     ,
  Q022MT00_BLOQ      ,
  Q022MT00_NUME      ,
  Q022MT00_BIS       ,
  Q022MT00_ESCA      ,
  Q022MT00_PISO      ,
  Q022MT00_MANO      ,
  Q022MT00_PUER      ,
  Q022MT00_CODP      ,
  Q022MT00_CDIR      ,
  Q022MT00_EMAIL     ,
  Q022MT00_TELF1     ,
  Q022MT00_TELF2     ,
  Q022MT00_FAX       ,
  Q022MT00_WEB       ,
  NORA_T17_PROVINCIA.DS_O,
  NORA_T17_MUNICIPIO.DS_O, Q022MT00_TVIA || ' ' || NORA_T17_CALLE.DS_O || ' ' ||  Q022MT00_BLOQ || ' '  ||  Q022MT00_NUME || ' '||  Q022MT00_BIS
from Q022MT00, NORA_T17_PROVINCIA, NORA_T17_MUNICIPIO,  NORA_T17_CALLE 
WHERE
Q022MT00.Q022MT00_PROV =NORA_T17_PROVINCIA.ID (+) and
Q022MT00.Q022MT00_MUNI =NORA_T17_MUNICIPIO.ID(+) and
Q022MT00.Q022MT00_PROV=NORA_T17_MUNICIPIO.PROVINCIA_ID (+) and
Q022MT00.Q022MT00_CALLE =NORA_T17_CALLE.ID(+)
/





CREATE OR REPLACE VIEW Q022ZV01
(Q022HT00_ID_OFI, Q022JT00_ID_AGEN, Q022HT00_DESC, Q022HT00_DESC_EUS, Q022HT00_PROV, 
 Q022HT00_MUNI, NORA_T17_MUNICIPIO_DS, NORA_T17_PROVINCIA_DS)
AS 
select
Q022ZT00.Q022HT00_ID_OFI,
Q022ZT00.Q022JT00_ID_AGEN,
Q022HT00.Q022HT00_DESC, 
Q022HT00.Q022HT00_DESC_EUS, 
Q022HT00.Q022HT00_PROV,
Q022HT00.Q022HT00_MUNI,
NORA_T17_MUNICIPIO.DS_O,
NORA_T17_PROVINCIA.DS_O
from Q022ZT00, Q022HT00,
NORA_T17_PROVINCIA,NORA_T17_MUNICIPIO
where 
Q022ZT00.Q022HT00_ID_OFI=Q022HT00.Q022HT00_ID_OFI and
Q022HT00.Q022HT00_PROV =NORA_T17_PROVINCIA.ID (+) and
Q022HT00.Q022HT00_MUNI=NORA_T17_MUNICIPIO.ID(+) and
Q022HT00.Q022HT00_PROV=NORA_T17_MUNICIPIO.PROVINCIA_ID (+)
/


CREATE OR REPLACE VIEW Q022KV01
(Q022KT00_ID_CONT, Q022KT00_PROV, Q022KT00_MUNI, Q022KT00_ID_INF, Q022KT00_ID_AGEN, 
 Q022KT00_TCON, Q022KT00_FECC, Q022KT00_RCON, Q022KT00_FECR, Q022KT00_OBSHR, 
 Q022HT00_ID_OFI, NORA_T17_PROVINCIA_DS, NORA_T17_MUNICIPIO_DS, Q022HT00_DESC, Q022HT00_DESC_EUS, 
 Q022IT00_APE1, Q022IT00_APE2, Q022IT00_NOMB, Q022JT00_APE1, Q022JT00_APE2, 
 Q022JT00_NOMB, Q022YT00_COD, Q022YT00_COD_DESCC, Q022YT00_COD_DESCE)
AS 
select
Q022KT00_ID_CONT     , 
Q022KT00_PROV         ,
Q022KT00_MUNI         ,
Q022KT00_ID_INF       ,
Q022KT00_ID_AGEN      ,
Q022YT00_NI_TIPO_CON         ,
Q022KT00_FECC         ,
Q022KT00_RCON         ,
Q022KT00_FECR         ,
Q022KT00_OBSHR        ,
Q022KT00.Q022HT00_ID_OFI     ,
NORA_T17_PROVINCIA.DS_O,
NORA_T17_MUNICIPIO.DS_O   , 
Q022HT00.Q022HT00_DESC, Q022HT00.Q022HT00_DESC_EUS ,
Q022IT00.Q022IT00_APE1, Q022IT00.Q022IT00_APE2, Q022IT00.Q022IT00_NOMB,
Q022JT00.Q022JT00_APE1, Q022JT00.Q022JT00_APE2, Q022JT00.Q022JT00_NOMB ,
TT_HRC_TIPO_CON.Q022YT00_COD, TT_HRC_TIPO_CON.Q022YT00_COD_DESCC, TT_HRC_TIPO_CON.Q022YT00_COD_DESCE
from   Q022KT00  , NORA_T17_PROVINCIA,NORA_T17_MUNICIPIO,  Q022HT00, Q022IT00, Q022JT00,TT_HRC_TIPO_CON
WHERE
Q022KT00.Q022KT00_PROV=NORA_T17_PROVINCIA.ID (+) and
Q022KT00.Q022KT00_MUNI=NORA_T17_MUNICIPIO.ID(+) and
Q022KT00.Q022KT00_PROV=NORA_T17_MUNICIPIO.PROVINCIA_ID (+) and
Q022KT00.Q022HT00_ID_OFI=Q022HT00.Q022HT00_ID_OFI (+) AND 
Q022KT00.Q022KT00_ID_INF= Q022IT00.Q022IT00_ID_INF(+) AND
Q022KT00.Q022KT00_ID_AGEN= Q022JT00.Q022JT00_ID_AGEN (+)   AND
Q022KT00.Q022YT00_NI_TIPO_CON =TT_HRC_TIPO_CON.Q022YT00_NI(+)
/


CREATE OR REPLACE VIEW Q022LV01
(Q022LT00_ID_RESUL, Q022LT00_PROV, Q022LT00_MUNI, Q022LT00_OTRF, Q022LT00_NRESPH, 
 Q022LT00_NRESPV, Q022LT00_NRESPS, Q022LT00_NRESPA, Q022LT00_NRESPT, Q022LT00_NRESPP, 
 Q022LT00_OBSHR, Q022HT00_ID_OFI, Q022YT00_NI_FORMA, Q022YT00_NI_RESUL_ENC, Q022YT00_NI_SITU_INSP, 
 Q022YT00_NI_RESUL_INSP, NORA_T17_PROVINCIA_DS, NORA_T17_MUNICIPIO_DS, Q022HT00_DESC, Q022HT00_DESC_EUS, 
 Q022YT00_COD_FORMA, Q022YT00_DESC_FORMA, Q022YT00_DESCE_FORMA, Q022YT00_COD_RESUL_ENC, Q022YT00_DESC_RESUL_ENC, 
 Q022YT00_DESCE_RESUL_ENC, Q022YT00_COD_SITU_INSP, Q022YT00_DESC_SITU_INSP, Q022YT00_DESCE_SITU_INSP, Q022YT00_COD_RESUL_INSP, 
 Q022YT00_DESC_RESUL_INSP, Q022YT00_DESCE_RESUL_INSP)
AS 
select
Q022LT00_ID_RESUL    , 
Q022LT00_PROV         ,
Q022LT00_MUNI         ,
Q022LT00_OTRF       ,
Q022LT00_NRESPH      ,
Q022LT00_NRESPV         ,
Q022LT00_NRESPS         ,
Q022LT00_NRESPA         ,
Q022LT00_NRESPT         ,
Q022LT00_NRESPP        ,
Q022LT00_OBSHR          ,
Q022LT00.Q022HT00_ID_OFI     ,
TT_HRU_FORMA.Q022YT00_NI    ,
TT_HRU_RESUL_ENC.Q022YT00_NI,
TT_HRU_SITU_INSP.Q022YT00_NI,
TT_HRU_RESUL_INSP.Q022YT00_NI,
NORA_T17_PROVINCIA.DS_O,
NORA_T17_MUNICIPIO.DS_O,
Q022HT00.Q022HT00_DESC, Q022HT00.Q022HT00_DESC_EUS ,
TT_HRU_FORMA.Q022YT00_COD, TT_HRU_FORMA.Q022YT00_DESC, TT_HRU_FORMA.Q022YT00_DESC_EUS,
TT_HRU_RESUL_ENC.Q022YT00_COD, TT_HRU_RESUL_ENC.Q022YT00_DESC, TT_HRU_RESUL_ENC.Q022YT00_DESC_EUS,
TT_HRU_SITU_INSP.Q022YT00_COD, TT_HRU_SITU_INSP.Q022YT00_DESC, TT_HRU_SITU_INSP.Q022YT00_DESC_EUS,
TT_HRU_RESUL_INSP.Q022YT00_COD, TT_HRU_RESUL_INSP.Q022YT00_DESC, TT_HRU_RESUL_INSP.Q022YT00_DESC_EUS
from   Q022LT00  , Q022HT00, NORA_T17_PROVINCIA,NORA_T17_MUNICIPIO, TT_HRU_FORMA, TT_HRU_RESUL_ENC, TT_HRU_SITU_INSP, TT_HRU_RESUL_INSP
WHERE
Q022LT00.Q022LT00_PROV=NORA_T17_PROVINCIA.ID (+) and
Q022LT00.Q022LT00_MUNI=NORA_T17_MUNICIPIO.ID(+) and
Q022LT00.Q022LT00_PROV=NORA_T17_MUNICIPIO.PROVINCIA_ID (+) and
Q022LT00.Q022HT00_ID_OFI=Q022HT00.Q022HT00_ID_OFI (+) AND
Q022LT00.Q022YT00_NI_FORMA =TT_HRU_FORMA.Q022YT00_NI (+) AND
Q022LT00.Q022YT00_NI_RESUL_ENC = TT_HRU_RESUL_ENC.Q022YT00_NI (+) AND
Q022LT00.Q022YT00_NI_RESUL_INSP = TT_HRU_RESUL_INSP.Q022YT00_NI (+) AND
Q022LT00.Q022YT00_NI_SITU_INSP = TT_HRU_SITU_INSP.Q022YT00_NI (+)
/


CREATE OR REPLACE VIEW Q022WV01
(Q022WT00_NI, Q022NT00_CODIGO, Q022WT00_ID_GRUPO, Q022WT00_ID_CUES, DATOS_CUESTIONARIO, 
 LOCALIZACION, Q022WT00_DIRECCIN, Q022WT00_ESTADO, Q022WT00_FECHA_GRABACION, Q022WT00_OBSERVACIONES, 
 Q022YT00_DESC, Q022YT00_DESC_EUS, Q022NT00_DESC_ES, Q022NT00_DESC_EU)
AS 
SELECT "Q022WT00_NI", tablasolicitudes."Q022NT00_CODIGO",
          "Q022WT00_ID_GRUPO", "Q022WT00_ID_CUES", "DATOS_CUESTIONARIO",
          "LOCALIZACION", "Q022WT00_DIRECCIN", "Q022WT00_ESTADO",
          "Q022WT00_FECHA_GRABACION", "Q022WT00_OBSERVACIONES", q022yt00_desc,
          q022yt00_desc_eus, q022nt00_desc_es, q022nt00_desc_eu
     FROM (SELECT q022wt00_ni, q022nt00_codigo, q022wt00_id_grupo,
                  q022wt00_id_cues,
                  CASE
                     WHEN q022nt00_codigo = 'SM'
                        THEN (SELECT    q022ct00_ano
                                     || ';'
                                     || (CASE
                                            WHEN LENGTH (q22ct00_mes) = 1
                                               THEN '0' || q22ct00_mes
                                            ELSE '' || q22ct00_mes
                                         END
                                        )
                                     || ';'
                                     || mun_prov
                                     || ';'
                                     || mun_muni
                                     || ';'
                                     || desc_prov
                                     || ';'
                                     || desc_muni
                                     || ';'
                                     || q022et00_enti
                                     || ';'
                                     || desc_localidad
                                FROM q022es01v04
                               WHERE q022wt00_id_grupo = q022ct00_id_grupo
                                 AND q022wt00_id_cues = q022et00_id_cues)
                     WHEN q022nt00_codigo = 'VTM'
                        THEN (SELECT    q022bt00_ano
                                     || ';'
                                     || (CASE
                                            WHEN LENGTH (q022bt00_mes) = 1
                                               THEN '0' || q022bt00_mes
                                            ELSE '' || q022bt00_mes
                                         END
                                        )
                                     || ';'
                                     || fca02t00_codprovinc
                                     || ';'
                                     || fca02t00_codmunicip
                                     || ';'
                                     || desc_prov
                                     || ';'
                                     || desc_muni
                                     || ';'
                                     || q022dt00_enti
                                     || ';'
                                     || desc_localidad
                                FROM q022ds01v04
                               WHERE q022wt00_id_grupo = q022bt00_id_grupo
                                 AND q022wt00_id_cues = q022dt00_id_cues)
                  END datos_cuestionario,
                  CASE
                     WHEN q022nt00_codigo = 'VTM'
                        THEN (SELECT q022dt00_nora_t17_localizacion
                               FROM q022ds01v02
                               WHERE q022wt00_id_grupo = q022bt00_id_grupo
                                 AND q022wt00_id_cues = q022dt00_id_cues)
                     WHEN q022nt00_codigo = 'SM'
                        THEN (SELECT q022et00_nora_t17_localizacion
                                FROM q022es01v02
                               WHERE q022wt00_id_grupo = q022ct00_id_grupo
                                 AND q022wt00_id_cues = q022et00_id_cues)
                  END localizacion,
                  q022wt00_direccin, q022wt00_estado,
                  q022wt00_fecha_grabacion, q022wt00_observaciones
             FROM q022wt00) tablasolicitudes,
          tt_hrc_estsol_nora,
          q022nt00
    WHERE tablasolicitudes.q022wt00_estado = tt_hrc_estsol_nora.q022yt00_cod
      AND tablasolicitudes.q022nt00_codigo = q022nt00.q022nt00_codigo
/


