drop table Q021ET00 cascade constraints; 
CREATE TABLE Q021ET00
(
  Q021ET00_NI            NUMBER(10)             NOT NULL,
  Q021ET00_CODIGO        VARCHAR2(15)           NOT NULL,
  Q021ET00_DESC          VARCHAR2(50)           NOT NULL,
  Q021ET00_USU_ALTA      NUMBER(10)             DEFAULT -1                    NOT NULL,
  Q021ET00_TST_ALTA      DATE                   DEFAULT SYSDATE               NOT NULL,
  Q021ET00_USU_MODIF     NUMBER(10)             DEFAULT -1,
  Q021ET00_TST_MODIF     DATE                   DEFAULT SYSDATE               NOT NULL,
  Q021ET00_IND_INACTIVO  NUMBER(1)              DEFAULT 0
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q021ET00 IS 'Mdulos';

COMMENT ON COLUMN Q021ET00.Q021ET00_NI IS 'Nmero interno del mdulo';

COMMENT ON COLUMN Q021ET00.Q021ET00_CODIGO IS 'Cdigo del Mdulo';

COMMENT ON COLUMN Q021ET00.Q021ET00_DESC IS 'Descripcin';

COMMENT ON COLUMN Q021ET00.Q021ET00_USU_ALTA IS 'Usuario de Alta##USR#insert:usr#update:null';

COMMENT ON COLUMN Q021ET00.Q021ET00_TST_ALTA IS 'Fecha de Alta##FEC#insert:sysdate#update:null';

COMMENT ON COLUMN Q021ET00.Q021ET00_USU_MODIF IS 'Usuario Ultima Modificacion##USR#insert:usr#update:usr';

COMMENT ON COLUMN Q021ET00.Q021ET00_TST_MODIF IS 'Fecha de Modificacion##FEC#insert:sysdate#update:sysdate';

COMMENT ON COLUMN Q021ET00.Q021ET00_IND_INACTIVO IS 'Marca de inactivo (0-activo; 1-inactivo)';

drop table Q021FT00 cascade constraints; 
CREATE TABLE Q021FT00
(
  Q021FT00_NI         NUMBER(10)                NOT NULL,
  Q021FT00_COD        VARCHAR2(50)              NOT NULL,
  Q021FT00_RUTAP      VARCHAR2(500),
  Q021ET00_NI         NUMBER(10)                NOT NULL,
  Q021FT00_DESC       VARCHAR2(500)             NOT NULL,
  Q021FT00_DESC_EUS   VARCHAR2(500),
  Q021FT00_USU_ALTA   NUMBER(10)                DEFAULT -1                    NOT NULL,
  Q021FT00_TST_ALTA   DATE                      DEFAULT SYSDATE               NOT NULL,
  Q021FT00_USU_MODIF  NUMBER(10)                DEFAULT -1,
  Q021FT00_TST_MODIF  DATE                      DEFAULT SYSDATE               NOT NULL,
  Q021FT00_DESC_MENU  VARCHAR2(500)
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q021FT00 IS 'Procesos';

COMMENT ON COLUMN Q021FT00.Q021FT00_NI IS 'Nmero Interno del Proceso';

COMMENT ON COLUMN Q021FT00.Q021FT00_COD IS 'Codigo_Proceso';

COMMENT ON COLUMN Q021FT00.Q021FT00_RUTAP IS 'Ruta del Proceso';

COMMENT ON COLUMN Q021FT00.Q021ET00_NI IS 'Nmero interno del mdulo al que pertenece';

COMMENT ON COLUMN Q021FT00.Q021FT00_DESC IS 'Descripcin del Proceso';

COMMENT ON COLUMN Q021FT00.Q021FT00_DESC_EUS IS 'Descripcin del Proceso en Euskera';

COMMENT ON COLUMN Q021FT00.Q021FT00_USU_ALTA IS 'Usuario de Alta##USR#insert:usr#update:null';

COMMENT ON COLUMN Q021FT00.Q021FT00_TST_ALTA IS 'Fecha de Alta##FEC#insert:sysdate#update:null';

COMMENT ON COLUMN Q021FT00.Q021FT00_USU_MODIF IS 'Usuario Ultima Modificacion##USR#insert:usr#update:usr';

COMMENT ON COLUMN Q021FT00.Q021FT00_TST_MODIF IS 'Fecha de Modificacion##FEC#insert:sysdate#update:sysdate';

COMMENT ON COLUMN Q021FT00.Q021FT00_DESC_MENU IS 'Clave de multiidioma para el texto del menu (GEREMUA)';

drop table Q021GT00 cascade constraints;
CREATE TABLE Q021GT00
(
  Q021GT00_NI         NUMBER(10)                NOT NULL,
  Q021GT00_COD        VARCHAR2(15)              NOT NULL,
  Q021GT00_DESC       VARCHAR2(50)              NOT NULL,
  Q021GT00_TST_ALTA   DATE                      DEFAULT SYSDATE               NOT NULL,
  Q021GT00_USU_ALTA   NUMBER(10)                DEFAULT -1                    NOT NULL,
  Q021GT00_USU_MODIF  NUMBER(10)                DEFAULT -1,
  Q021GT00_TST_MODIF  DATE                      DEFAULT SYSDATE               NOT NULL
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q021GT00 IS 'Roles';

COMMENT ON COLUMN Q021GT00.Q021GT00_NI IS 'Nmero Interno de Rol';

COMMENT ON COLUMN Q021GT00.Q021GT00_COD IS 'Codigo del Rol';

COMMENT ON COLUMN Q021GT00.Q021GT00_DESC IS 'Descripcion';

COMMENT ON COLUMN Q021GT00.Q021GT00_TST_ALTA IS 'Fecha de Alta##FEC#insert:sysdate#update:null';

COMMENT ON COLUMN Q021GT00.Q021GT00_USU_ALTA IS 'Usuario de Alta##USR#insert:usr#update:null';

COMMENT ON COLUMN Q021GT00.Q021GT00_USU_MODIF IS 'Usuario Ultima Modificacion##USR#insert:usr#update:usr';

COMMENT ON COLUMN Q021GT00.Q021GT00_TST_MODIF IS 'Fecha de Modificacion##FEC#insert:sysdate#update:sysdate';

drop table Q021HT00 cascade constraints;
CREATE TABLE Q021HT00
(
  Q021HT00_NI         NUMBER(10)                NOT NULL,
  Q021HT00_COD        VARCHAR2(15)              NOT NULL,
  Q021HT00_DESC       VARCHAR2(50)              NOT NULL,
  Q021HT00_USU_ALTA   NUMBER(10)                DEFAULT -1                    NOT NULL,
  Q021HT00_TST_ALTA   DATE                      DEFAULT SYSDATE               NOT NULL,
  Q021HT00_USU_MODIF  NUMBER(10)                DEFAULT -1,
  Q021HT00_TST_MODIF  DATE                      DEFAULT SYSDATE               NOT NULL
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q021HT00 IS 'Grupos';

COMMENT ON COLUMN Q021HT00.Q021HT00_NI IS 'Nmero Interno del Grupo';

COMMENT ON COLUMN Q021HT00.Q021HT00_COD IS 'Codigo del Grupo';

COMMENT ON COLUMN Q021HT00.Q021HT00_DESC IS 'Descripcion';

COMMENT ON COLUMN Q021HT00.Q021HT00_USU_ALTA IS 'Usuario de Alta##USR#insert:usr#update:null';

COMMENT ON COLUMN Q021HT00.Q021HT00_TST_ALTA IS 'Fecha de Alta##FEC#insert:sysdate#update:null';

COMMENT ON COLUMN Q021HT00.Q021HT00_USU_MODIF IS 'Usuario Ultima Modificacion##USR#insert:usr#update:usr';

COMMENT ON COLUMN Q021HT00.Q021HT00_TST_MODIF IS 'Fecha de Modificacion##FEC#insert:sysdate#update:sysdate';

drop table Q021JT00 cascade constraints;
CREATE TABLE Q021JT00
(
  Q022FT00_NI  NUMBER(8)                        NOT NULL,
  Q021HT00_NI  NUMBER(10)                       NOT NULL
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q021JT00 IS 'Grupos de usuarios';

COMMENT ON COLUMN Q021JT00.Q022FT00_NI IS 'Nmero interno del Usuario';

COMMENT ON COLUMN Q021JT00.Q021HT00_NI IS 'Nmero Interno del Grupo';

drop table Q021KT00 cascade constraints;
CREATE TABLE Q021KT00
(
  Q021HT00_NI  NUMBER(10)                       NOT NULL,
  Q021GT00_NI  NUMBER(10)                       NOT NULL
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q021KT00 IS 'Grupos de Roles';

COMMENT ON COLUMN Q021KT00.Q021HT00_NI IS 'Nmero interno del Grupo';

COMMENT ON COLUMN Q021KT00.Q021GT00_NI IS 'Nmero Interno del Rol';

drop table Q021LT00 cascade constraints;
CREATE TABLE Q021LT00
(
  Q021GT00_NI  NUMBER(10)                       NOT NULL,
  Q021FT00_NI  NUMBER(10)                       NOT NULL
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q021LT00 IS 'Roles por Procesos';

COMMENT ON COLUMN Q021LT00.Q021GT00_NI IS 'Nmero interno del Rol';

COMMENT ON COLUMN Q021LT00.Q021FT00_NI IS 'Nmero interno del Proceso';





drop table Q022AT00 cascade constraints;
CREATE TABLE Q022AT00
(
  Q022AT00_NIPLAZO    NUMBER(8)                 NOT NULL,
  Q022AT00_ANO        NUMBER(4)                 NOT NULL,
  MUN_PROV            VARCHAR2(2),
  MUN_MUNI            VARCHAR2(3),
  Q022AT00_PLAZO      NUMBER(8),
  Q022AT00_FEC_ALTA   DATE,
  Q022AT00_FEC_MOD    DATE,
  Q022NT00_CODIGO     VARCHAR2(5),
  Q022AT00_PLAZO_DIA  NUMBER(8)
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q022AT00 IS 'Parametrizacin de calendarios';

drop table Q022BT00 cascade constraints;
CREATE TABLE Q022BT00
(
  Q022BT00_ID_GRUPO         NUMBER(8)           NOT NULL,
  Q022BT00_ANO              NUMBER(4)           NOT NULL,
  Q022BT00_MES              NUMBER(2),
  Q022BT00_CONCEDIDO_LICEN  NUMBER(1)           DEFAULT 1                     NOT NULL,
  Q022BT00_FEC_ALTA         DATE,
  Q022BT00_FEC_MOD          DATE,
  FCA02T00_CODPROVINC       VARCHAR2(2)         NOT NULL,
  FCA02T00_CODMUNICIP       VARCHAR2(3)         NOT NULL,
  Q022BT00_FEC_FIRMA        DATE,
  Q022BT00_XML_FIRMADO      CLOB,
  Q022BT00_USER_FIRMA       VARCHAR2(200),
  Q022BT00_OBSSU            VARCHAR2(250)
)
TABLESPACE Q0201E00
LOB (Q022BT00_XML_FIRMADO) STORE AS 
      ( TABLESPACE  Q0201E00 
        ENABLE      STORAGE IN ROW        
      );

COMMENT ON TABLE Q022BT00 IS 'Cuestionarios Obra Mayor: Cabecera de Grupo de Cuestionarios de Licencias de Obra Mayor ( Ayuntamientos - Mensual )';

COMMENT ON COLUMN Q022BT00.Q022BT00_FEC_FIRMA IS 'Fecha de Firma del Grupo de Cuestionarios';

COMMENT ON COLUMN Q022BT00.Q022BT00_XML_FIRMADO IS 'Xml con un resmen de los datos ms importantes de los cuestionarios que se firman';

COMMENT ON COLUMN Q022BT00.Q022BT00_USER_FIRMA IS 'Usuario que firma los cuestionarios';

COMMENT ON COLUMN Q022BT00.Q022BT00_OBSSU IS 'Observaciones sobre la no existencia de actuaciones de suelo';

COMMENT ON COLUMN Q022BT00.Q022BT00_ID_GRUPO IS 'Codigo del Grupo de Cuestionarios';

COMMENT ON COLUMN Q022BT00.FCA02T00_CODPROVINC IS 'Cdigo de Provincia del Grupo de Cuestionarios';

COMMENT ON COLUMN Q022BT00.FCA02T00_CODMUNICIP IS 'Cdigo de Municipio del Grupo de Cuestionarios';

COMMENT ON COLUMN Q022BT00.Q022BT00_ANO IS 'Ano del Grupo de Cuestionarios';

COMMENT ON COLUMN Q022BT00.Q022BT00_MES IS 'Mes del Grupo de Cuestionarios';

COMMENT ON COLUMN Q022BT00.Q022BT00_CONCEDIDO_LICEN IS 'Indicativo de si se han concedido licencias en el Grupo de Cuestionarios';

COMMENT ON COLUMN Q022BT00.Q022BT00_FEC_ALTA IS 'Fecha de Alta##FEC#insert:sysdate#update:null';

COMMENT ON COLUMN Q022BT00.Q022BT00_FEC_MOD IS 'Fecha de Modificacin##FEC#insert:null#update:sysdate';

drop table Q022CT00 cascade constraints;
CREATE TABLE Q022CT00
(
  Q022CT00_ID_GRUPO           NUMBER(8)         NOT NULL,
  Q022CT00_ANO                NUMBER(4)         NOT NULL,
  Q022CT00_REALIZA_ACTUACION  NUMBER(1)         DEFAULT 1                     NOT NULL,
  Q022CT00_FEC_ALTA           DATE,
  Q022CT00_FEC_MOD            DATE,
  Q22CT00_MES                 NUMBER(2),
  MUN_PROV                    VARCHAR2(2),
  MUN_MUNI                    VARCHAR2(3),
  Q022CT00_OBSSU              VARCHAR2(250),
  Q022CT00_NCUS               NUMBER(2)
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q022CT00 IS 'Cuestionarios SM: Cabecera Grupo de Cuestionarios de Suelo Municipal (recogida especial y mensual)';

COMMENT ON COLUMN Q022CT00.Q022CT00_ID_GRUPO IS 'Codigo del Grupo de Cuestionarios';

COMMENT ON COLUMN Q022CT00.Q022CT00_OBSSU IS 'Observaciones sobre la no existencia de actuaciones de suelo';

COMMENT ON COLUMN Q022CT00.Q022CT00_ANO IS 'Ano del Grupo de Cuestionarios';

COMMENT ON COLUMN Q022CT00.Q022CT00_REALIZA_ACTUACION IS 'Indicativo de si se han realizado actuaciones';

COMMENT ON COLUMN Q022CT00.Q022CT00_FEC_ALTA IS 'Fecha de Alta##FEC#insert:sysdate#update:null';

COMMENT ON COLUMN Q022CT00.Q022CT00_FEC_MOD IS 'Fecha de Modificacin##FEC#insert:null#update:sysdate';

COMMENT ON COLUMN Q022CT00.Q22CT00_MES IS 'Mes del periodo del cuestionario';

COMMENT ON COLUMN Q022CT00.MUN_PROV IS 'Cdigo de Provincia del Grupo de Cuestionarios';

COMMENT ON COLUMN Q022CT00.MUN_MUNI IS 'Cdigo de Municipio del Grupo de Cuestionarios';

COMMENT ON COLUMN Q022CT00.Q022CT00_NCUS IS 'Nmero de cuestionarios existenten para un territorio, municipio y ao';

drop table Q022DT00 cascade constraints;
CREATE TABLE Q022DT00
(
  Q022BT00_ID_GRUPO         NUMBER(8)           NOT NULL,
  Q022DT00_ID_CUES          NUMBER(10)          NOT NULL,
  Q022DT00_IDEN_LICEN       VARCHAR2(13),
  Q022DT00_FEC_ENT          DATE,
  Q022DT00_ESTADO_LICEN     VARCHAR2(1),
  Q022DT00_CAUSA_BAJA       VARCHAR2(1),
  Q022DT00_ENTI             NUMBER(15),
  Q022DT00_TVIA             VARCHAR2(2),
  Q022DT00_CALLE            NUMBER(15),
  Q022DT00_POR_CL_POR       NUMBER(15),
  Q022DT00_BLOQ             VARCHAR2(3),
  Q022DT00_NUME             NUMBER(4),
  Q022DT00_BIS              VARCHAR2(1),
  Q022DT00_CDIR             VARCHAR2(50),
  Q022DT00_RS_PROMO         VARCHAR2(100),
  Q022DT00_CIF_DNI          VARCHAR2(11),
  Q022DT00_MUN_PROV         VARCHAR2(2),
  Q022DT00_MUN_MUNI         VARCHAR2(3),
  Q022DT00_ENTI_PRO         NUMBER(15),
  Q022DT00_TVIA_PRO         VARCHAR2(2),
  Q022DT00_CALLE_PRO        NUMBER(15),
  Q022DT00_POR_CL_POR_PRO   NUMBER(15),
  Q022DT00_BLOQ_PRO         VARCHAR2(3),
  Q022DT00_NUME_PRO         NUMBER(4),
  Q022DT00_BIS_PRO          VARCHAR2(1),
  Q022DT00_CDIR_PRO         VARCHAR2(50),
  Q022DT00_TLF              VARCHAR2(9),
  Q022DT00_MAIL             VARCHAR2(80),
  Q022DT00_FAX              VARCHAR2(9),
  Q022DT00_WEB              VARCHAR2(80),
  Q022DT00_PRESUPUESTO      NUMBER(14,2),
  Q022DT00_F_INI            DATE,
  Q022DT00_F_FIN            DATE,
  Q022DT00_TIPO_OBRA        VARCHAR2(1),
  Q022DT00_USO_RES          VARCHAR2(1),
  Q022DT00_ACTIVIDAD        VARCHAR2(1),
  Q022DT00_NVN              NUMBER(3),
  Q022DT00_NVR              NUMBER(3),
  Q022DT00_NVL              NUMBER(2),
  Q022DT00_NVVPO            NUMBER(2),
  Q022DT00_NVVS             NUMBER(2),
  Q022DT00_NVPOT            NUMBER(2),
  Q022DT00_NVALDOT          NUMBER(2),
  Q022DT00_NVREAL           NUMBER(2),
  Q022DT00_NVVTMG           NUMBER(2),
  Q022DT00_NVVTME           NUMBER(2),
  Q022DT00_NTOT             NUMBER(3),
  Q022DT00_NSP45            NUMBER(3),
  Q022DT00_NSP75            NUMBER(3),
  Q022DT00_NSP90            NUMBER(3),
  Q022DT00_NSP120           NUMBER(3),
  Q022DT00_NSPT             NUMBER(4),
  Q022DT00_PRINC_USO        VARCHAR2(1),
  Q022DT00_PU_ESPECIF       VARCHAR2(50),
  Q022DT00_PRECIO_MED       NUMBER(6,2),
  Q022DT00_OBS              VARCHAR2(250),
  Q022DT00_DX               NUMBER(16,9),
  Q022DT00_DY               NUMBER(16,9),
  Q022DT00_DX_PRO           NUMBER(16,9),
  Q022DT00_DY_PRO           NUMBER(16,9),
  Q022DT00_DIR_PRO_EXTERNO  VARCHAR2(250),
  Q022DT00_DIR_NUEVA        VARCHAR2(250),
  Q022DT00_FEC_ALTA         DATE                DEFAULT SYSDATE               NOT NULL,
  Q022DT00_FEC_MOD          DATE
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q022DT00 IS 'Cuestionarios Obra Mayor: detalle de cuestionarios';

COMMENT ON COLUMN Q022DT00.Q022DT00_DX IS 'Coordenada x Obra';

COMMENT ON COLUMN Q022DT00.Q022DT00_DY IS 'Coordenada  y Obra';

COMMENT ON COLUMN Q022DT00.Q022BT00_ID_GRUPO IS 'Cdigo del grupo';

COMMENT ON COLUMN Q022DT00.Q022DT00_ID_CUES IS 'Cdigo del cuestionario dentro del grupo';

COMMENT ON COLUMN Q022DT00.Q022DT00_IDEN_LICEN IS 'Clave de la licencia';

COMMENT ON COLUMN Q022DT00.Q022DT00_FEC_ENT IS 'Fecha de entrada';

COMMENT ON COLUMN Q022DT00.Q022DT00_ESTADO_LICEN IS 'Estado de la licencia (A-Alta;B-Baja;P-Prrroga )';

COMMENT ON COLUMN Q022DT00.Q022DT00_CAUSA_BAJA IS 'Motivo de la baja(A-Desestimiento o caducidad; B-Finalizacin de la obra)';

COMMENT ON COLUMN Q022DT00.Q022DT00_ENTI IS 'Localizacin: entidad (localidad)';

COMMENT ON COLUMN Q022DT00.Q022DT00_TVIA IS 'Datos de Localizacin: tipo de via';

COMMENT ON COLUMN Q022DT00.Q022DT00_CALLE IS 'Datos de Localizacin: calle';

COMMENT ON COLUMN Q022DT00.Q022DT00_BLOQ IS 'Datos de Localizacin: bloque';

COMMENT ON COLUMN Q022DT00.Q022DT00_NUME IS 'Datos de Localizacin: nmero';

COMMENT ON COLUMN Q022DT00.Q022DT00_BIS IS 'Datos de Localizacin: bis';

COMMENT ON COLUMN Q022DT00.Q022DT00_CDIR IS 'Datos de Localizacin: complemento de la direccin';

COMMENT ON COLUMN Q022DT00.Q022DT00_RS_PROMO IS 'Datos de Promotor: Razn social';

COMMENT ON COLUMN Q022DT00.Q022DT00_CIF_DNI IS 'Datos de promotor: CIF/DNI';

COMMENT ON COLUMN Q022DT00.Q022DT00_MUN_PROV IS 'Datos del promotor: aproximacin postal: provincia';

COMMENT ON COLUMN Q022DT00.Q022DT00_MUN_MUNI IS 'Datos del promotor: aproximacin postal: municipio';

COMMENT ON COLUMN Q022DT00.Q022DT00_ENTI_PRO IS 'Datos del promotor: aproximacin postal: entidad (localidad)';

COMMENT ON COLUMN Q022DT00.Q022DT00_TVIA_PRO IS 'Datos del promotor: aproximacin postal: tipo de va';

COMMENT ON COLUMN Q022DT00.Q022DT00_CALLE_PRO IS 'Datos del promotor: aproximacin postal: calle';

COMMENT ON COLUMN Q022DT00.Q022DT00_POR_CL_POR_PRO IS 'Datos del promotor:';

COMMENT ON COLUMN Q022DT00.Q022DT00_BLOQ_PRO IS 'Datos del promotor: aproximacin postal: bloque';

COMMENT ON COLUMN Q022DT00.Q022DT00_NUME_PRO IS 'Datos del promotor: aproximacin postal: nmero';

COMMENT ON COLUMN Q022DT00.Q022DT00_BIS_PRO IS 'Datos del promotor: aproximacin postal: bis';

COMMENT ON COLUMN Q022DT00.Q022DT00_CDIR_PRO IS 'Datos del promotor: aproximacin postal: complemento de la direccin';

COMMENT ON COLUMN Q022DT00.Q022DT00_TLF IS 'Datos del promotor: aproximacin telemtica y telefnica: telfono';

COMMENT ON COLUMN Q022DT00.Q022DT00_MAIL IS 'Datos del promotor: aproximacin telemtica y telefnica: e-mail';

COMMENT ON COLUMN Q022DT00.Q022DT00_FAX IS 'Datos del promotor: aproximacin telemtica y telefnica: fax';

COMMENT ON COLUMN Q022DT00.Q022DT00_WEB IS 'Datos del promotor: aproximacin telemtica y telefnica: pgina web';

COMMENT ON COLUMN Q022DT00.Q022DT00_PRESUPUESTO IS 'Presupuesto';

COMMENT ON COLUMN Q022DT00.Q022DT00_F_INI IS 'Fecha de inicio de la obra';

COMMENT ON COLUMN Q022DT00.Q022DT00_F_FIN IS 'Fecha de fin (real o prevista)de la obra';

COMMENT ON COLUMN Q022DT00.Q022DT00_TIPO_OBRA IS 'Tipo de obra mayor: Nueva planta - Rehabilitacin - Demolicin total';

COMMENT ON COLUMN Q022DT00.Q022DT00_USO_RES IS 'Indicador de destinado a viviendas de uso residencial';

COMMENT ON COLUMN Q022DT00.Q022DT00_ACTIVIDAD IS 'Actividad para la que se dedicar la edificacin: agricultura, hosteleria...otros';

COMMENT ON COLUMN Q022DT00.Q022DT00_NVN IS 'Nmero de viviendas nuevas de la promocin';

COMMENT ON COLUMN Q022DT00.Q022DT00_NVR IS 'Nmero de viviendas rehabilitadas de la promocin';

COMMENT ON COLUMN Q022DT00.Q022DT00_NVL IS 'Nmero de viviendas por rgimen: libre';

COMMENT ON COLUMN Q022DT00.Q022DT00_NVVPO IS 'Nmero de viviendas por rgimen: VPO';

COMMENT ON COLUMN Q022DT00.Q022DT00_NVVS IS 'Nmero de viviendas por rgimen: VS';

COMMENT ON COLUMN Q022DT00.Q022DT00_NVPOT IS 'Nmero de viviendas por rgimen: VPOT';

COMMENT ON COLUMN Q022DT00.Q022DT00_NVALDOT IS 'Nmero de viviendas por rgimen: Alojamiento Datacional';

COMMENT ON COLUMN Q022DT00.Q022DT00_NVREAL IS 'Nmero de viviendas por rgimen: Vivienda para Realojo';

COMMENT ON COLUMN Q022DT00.Q022DT00_NVVTMG IS 'Nmero de viviendas por rgimen: VTMG';

COMMENT ON COLUMN Q022DT00.Q022DT00_NVVTME IS 'Nmero de viviendas por rgimen: VTME';

COMMENT ON COLUMN Q022DT00.Q022DT00_NTOT IS 'Nmero de viviendas por rgimen: Total';

COMMENT ON COLUMN Q022DT00.Q022DT00_NSP45 IS 'Nmero de viviendas por superficie: < 45m2';

COMMENT ON COLUMN Q022DT00.Q022DT00_NSP75 IS 'Nmero de viviendas por superficie: >45m2 y <75m2';

COMMENT ON COLUMN Q022DT00.Q022DT00_NSP90 IS 'Nmero de viviendas por superficie: >76m2 y <90m2';

COMMENT ON COLUMN Q022DT00.Q022DT00_NSP120 IS 'Nmero de viviendas por superficie: >91m2 y <120m2';

COMMENT ON COLUMN Q022DT00.Q022DT00_NSPT IS 'Nmero de viviendas por superficie: total';

COMMENT ON COLUMN Q022DT00.Q022DT00_PRINC_USO IS 'Principal uso previsto: Venta/Alquiler/Otro';

COMMENT ON COLUMN Q022DT00.Q022DT00_PU_ESPECIF IS 'Principal uso previsto: Especificacin para otro uso';

COMMENT ON COLUMN Q022DT00.Q022DT00_PRECIO_MED IS 'Precio medio de venta por metro cuadrado';

COMMENT ON COLUMN Q022DT00.Q022DT00_OBS IS 'Observaciones generales';

COMMENT ON COLUMN Q022DT00.Q022DT00_DX_PRO IS 'Coordenada x promotor ';

COMMENT ON COLUMN Q022DT00.Q022DT00_DY_PRO IS 'Coordenada y promotor';

COMMENT ON COLUMN Q022DT00.Q022DT00_DIR_PRO_EXTERNO IS 'Datos del promotor: aproximacin postal: direccion (fuera del CAPV)';

COMMENT ON COLUMN Q022DT00.Q022DT00_DIR_NUEVA IS 'Datos de Localizacin: direccin nueva susceptible de ser solicitada al EUSTAT';

COMMENT ON COLUMN Q022DT00.Q022DT00_FEC_ALTA IS 'Fecha de Alta##FEC#insert:sysdate#update:null';

COMMENT ON COLUMN Q022DT00.Q022DT00_FEC_MOD IS 'Fecha de Modificacin##FEC#insert:null#update:sysdate';

drop table Q022ET00 cascade constraints;
CREATE TABLE Q022ET00
(
  Q022CT00_ID_GRUPO    NUMBER(8)                NOT NULL,
  Q022ET00_ID_CUES     NUMBER(10)               NOT NULL,
  Q022ET00_CLASU       VARCHAR2(20),
  Q022ET00_SUPSU       NUMBER(6),
  Q022ET00_SUPTE       NUMBER(6),
  Q022ET00_VALSU       NUMBER(12,2),
  Q022ET00_NVPOG       NUMBER(3),
  Q022ET00_NVPOE       NUMBER(3),
  Q022ET00_NVTMG       NUMBER(3),
  Q022ET00_NVTME       NUMBER(3),
  Q022ET00_NALOD       NUMBER(3),
  Q022ET00_NREAL       NUMBER(3),
  Q022ET00_NVTOT       NUMBER(6),
  Q022ET00_FEC_ALTA    DATE,
  Q022ET00_FEC_MOD     DATE,
  Q022ET00_FEC_BAJA    DATE,
  Q022ET00_FIRMADO     NUMBER(1)                DEFAULT 0,
  Q022ET00_CDEXP       VARCHAR2(20),
  Q022ET00_NVPOT       NUMBER(4),
  Q022ET00_NLIBRE      NUMBER(4),
  Q022ET00_OBSSU       VARCHAR2(250),
  Q022ET00_FADQ        DATE,
  Q022ET00_ENTI        NUMBER(15),
  Q022ET00_TVIA        VARCHAR2(2),
  Q022ET00_CALLE       NUMBER(15),
  Q022ET00_POR_CL_POR  NUMBER(15),
  Q022ET00_BLOQ        VARCHAR2(3),
  Q022ET00_NUME        NUMBER(4),
  Q022ET00_BIS         VARCHAR2(1),
  Q022ET00_CDIR        VARCHAR2(50),
  Q022ET00_TIPADQ      VARCHAR2(1),
  Q022ET00_DX          NUMBER(16,9),
  Q022ET00_DY          NUMBER(16,9),
  Q022ET00_DIR_NUEVA   VARCHAR2(250)
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q022ET00 IS 'Cuestionarios SM: detalle de cuestionario';

COMMENT ON COLUMN Q022ET00.Q022CT00_ID_GRUPO IS 'Codigo nico del Grupo de Cuestionarios';

COMMENT ON COLUMN Q022ET00.Q022ET00_ID_CUES IS 'Codigo del Cuestionario (por grupo)';

COMMENT ON COLUMN Q022ET00.Q022ET00_CLASU IS 'Identificacin de la liciencia en el Ayuntamiento';

COMMENT ON COLUMN Q022ET00.Q022ET00_SUPSU IS 'Superficie Total del Suelo';

COMMENT ON COLUMN Q022ET00.Q022ET00_SUPTE IS 'Superficie Total Construida';

COMMENT ON COLUMN Q022ET00.Q022ET00_VALSU IS 'Coste de Adquisicin del Suelo';

COMMENT ON COLUMN Q022ET00.Q022ET00_NVPOG IS 'N de Viviendas previstas de VPO Rgimen General';

COMMENT ON COLUMN Q022ET00.Q022ET00_NVPOE IS 'N de Viviendas previstas de VPO Rgimen Especial';

COMMENT ON COLUMN Q022ET00.Q022ET00_NVTMG IS 'N de Viviendas previstas de VTM Rgimen General';

COMMENT ON COLUMN Q022ET00.Q022ET00_NVTME IS 'N de Viviendas previstas de VTM Rgimen Especia';

COMMENT ON COLUMN Q022ET00.Q022ET00_NALOD IS 'N de Viviendas previstas de Alojamientos Dotacionales';

COMMENT ON COLUMN Q022ET00.Q022ET00_NREAL IS 'N de Viviendas previstas de Realojos';

COMMENT ON COLUMN Q022ET00.Q022ET00_NVTOT IS 'N Total de Viviendas previstas';

COMMENT ON COLUMN Q022ET00.Q022ET00_FEC_ALTA IS 'Fecha de Alta##FEC#insert:sysdate#update:null';

COMMENT ON COLUMN Q022ET00.Q022ET00_FEC_MOD IS 'Fecha de Modificacin##FEC#insert:null#update:sysdate';

COMMENT ON COLUMN Q022ET00.Q022ET00_FEC_BAJA IS 'Fecha de Baja lgica del Cuestionario';

COMMENT ON COLUMN Q022ET00.Q022ET00_FIRMADO IS 'Indicador de cuestionario firmado (1-> Si, 0 ->No)';

COMMENT ON COLUMN Q022ET00.Q022ET00_CDEXP IS 'Cdigo de expediente';

COMMENT ON COLUMN Q022ET00.Q022ET00_NVPOT IS 'Nm. de VPOT (Viviendas de Proteccin Oficial de Regulacin Autonmica)';

COMMENT ON COLUMN Q022ET00.Q022ET00_NLIBRE IS 'Nm. de Viviendas Libres';

COMMENT ON COLUMN Q022ET00.Q022ET00_DX IS 'Coordenada x';

COMMENT ON COLUMN Q022ET00.Q022ET00_DY IS 'Coordenada y';

COMMENT ON COLUMN Q022ET00.Q022ET00_DIR_NUEVA IS 'Localizacin: direccin nueva susceptible de ser solicitada al EUSTAT';

COMMENT ON COLUMN Q022ET00.Q022ET00_OBSSU IS 'Observaciones al mdulo de suelo';

COMMENT ON COLUMN Q022ET00.Q022ET00_FADQ IS 'Fecha de adquisicin';

COMMENT ON COLUMN Q022ET00.Q022ET00_ENTI IS 'Localizacin: entidad (localidad)';

COMMENT ON COLUMN Q022ET00.Q022ET00_TVIA IS 'Localizacin: tipo de via';

COMMENT ON COLUMN Q022ET00.Q022ET00_CALLE IS 'Localizacin: calle';

COMMENT ON COLUMN Q022ET00.Q022ET00_POR_CL_POR IS 'Localizacin.';

COMMENT ON COLUMN Q022ET00.Q022ET00_BLOQ IS 'Localizacin:bloque';

COMMENT ON COLUMN Q022ET00.Q022ET00_NUME IS 'Localizacin: nmero';

COMMENT ON COLUMN Q022ET00.Q022ET00_BIS IS 'Localizacin: bis';

COMMENT ON COLUMN Q022ET00.Q022ET00_CDIR IS 'Complemento de direccin';

COMMENT ON COLUMN Q022ET00.Q022ET00_TIPADQ IS 'Tipo de adquisicin';

drop table Q022FT00 cascade constraints;
CREATE TABLE Q022FT00
(
  Q022FT00_IDUSUARIO            NUMBER(8)       NOT NULL,
  Q022FT00_NOMBRE               VARCHAR2(50)    NOT NULL,
  Q022FT00_APELLIDO1            VARCHAR2(50)    NOT NULL,
  Q022FT00_APELLIDO2            VARCHAR2(50),
  Q022FT00_NIF                  VARCHAR2(9),
  Q022FT00_PASSWORD             VARCHAR2(40),
  FCA02T00_CODPROVINC           NUMBER(2),
  FCA02T00_CODMUNICIP           NUMBER(4),
  Q022FT00_FECHA_ACTIVACION     DATE,
  Q022FT00_FECHA_DESACTIVACION  DATE,
  Q021AT00_CODPERFIL            VARCHAR2(2)     DEFAULT 1                     NOT NULL,
  MUN_PROV                      VARCHAR2(2),
  MUN_MUNI                      VARCHAR2(3),
  Q022FT00_EMAIL                VARCHAR2(80)
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q022FT00 IS 'Usuarios';

COMMENT ON COLUMN Q022FT00.Q022FT00_EMAIL IS 'Email del usuario';

COMMENT ON COLUMN Q022FT00.Q022FT00_IDUSUARIO IS 'Identificador del Usuario';

COMMENT ON COLUMN Q022FT00.Q022FT00_NOMBRE IS 'Nombre';

COMMENT ON COLUMN Q022FT00.Q022FT00_APELLIDO1 IS 'Primer Apellido';

COMMENT ON COLUMN Q022FT00.Q022FT00_APELLIDO2 IS 'Segundo Apellido';

COMMENT ON COLUMN Q022FT00.Q022FT00_NIF IS 'Nif';

COMMENT ON COLUMN Q022FT00.Q022FT00_PASSWORD IS 'Password de acceso al aplicativo';

COMMENT ON COLUMN Q022FT00.Q021AT00_CODPERFIL IS 'Perfil';

COMMENT ON COLUMN Q022FT00.FCA02T00_CODPROVINC IS 'Cdigo de Provincia';

COMMENT ON COLUMN Q022FT00.FCA02T00_CODMUNICIP IS 'Cdigo de Municipio';

COMMENT ON COLUMN Q022FT00.Q022FT00_FECHA_ACTIVACION IS 'Fecha de Activacin';

COMMENT ON COLUMN Q022FT00.Q022FT00_FECHA_DESACTIVACION IS 'Fecha de Desactivacin';

drop table Q022GT00 cascade constraints;
CREATE TABLE Q022GT00
(
  Q022GT00_ID_CUES          NUMBER(8)           NOT NULL,
  Q022GT00_ANO              NUMBER(4)           NOT NULL,
  Q022GT00_CONCEDIDO_LICEN  NUMBER(1)           DEFAULT 1                     NOT NULL,
  Q022GT00_MUN_PROV         VARCHAR2(2),
  Q022GT00_MUN_MUNI         VARCHAR2(3),
  Q022GT00_PRV1A            VARCHAR2(1),
  Q022GT00_ADQVI1           VARCHAR2(1),
  Q022GT00_NADQ1            NUMBER(4),
  Q022GT00_PROVI1           VARCHAR2(1),
  Q022GT00_NPRO1            NUMBER(4),
  Q022GT00_OTRVI1           VARCHAR2(1),
  Q022GT00_OTRLT1           VARCHAR2(50),
  Q022GT00_NOTR1            NUMBER(4),
  Q022GT00_NTOT1            NUMBER(4),
  Q022GT00_PRV4A            VARCHAR2(1),
  Q022GT00_ADQVI4           VARCHAR2(1),
  Q022GT00_NADQ4            NUMBER(4),
  Q022GT00_PROVI4           VARCHAR2(1),
  Q022GT00_NPRO4            NUMBER(4),
  Q022GT00_OTRVI4           VARCHAR2(1),
  Q022GT00_OTRLT4           VARCHAR2(50),
  Q022GT00_NOTR4            NUMBER(4),
  Q022GT00_NTOT4            NUMBER(4),
  Q022GT00_TALQ             VARCHAR2(1),
  Q022GT00_NALQ             NUMBER(4),
  Q022GT00_NSP45            NUMBER(4),
  Q022GT00_NSP75            NUMBER(4),
  Q022GT00_NSP90            NUMBER(4),
  Q022GT00_NSP90M           NUMBER(4),
  Q022GT00_NSPT             NUMBER(10,4),
  Q022GT00_NRSP45           NUMBER(4),
  Q022GT00_NRSP75           NUMBER(4),
  Q022GT00_NRSP90           NUMBER(4),
  Q022GT00_NRSP90M          NUMBER(4),
  Q022GT00_NRSPT            NUMBER(4),
  Q022GT00_NOCUP            NUMBER(4),
  Q022GT00_NDESA            NUMBER(4),
  Q022GT00_NDESO            NUMBER(4),
  Q022GT00_NDESOT           NUMBER(4),
  Q022GT00_DESOTR           VARCHAR2(50),
  Q022GT00_NOCUT            NUMBER(4),
  Q022GT00_NVPOG            NUMBER(4),
  Q022GT00_NVPOE            NUMBER(4),
  Q022GT00_NVPOT            NUMBER(4),
  Q022GT00_NALOD            NUMBER(4),
  Q022GT00_NREAL            NUMBER(4),
  Q022GT00_NLIBRE           NUMBER(4),
  Q022GT00_NVTMG            NUMBER(4),
  Q022GT00_NVTME            NUMBER(4),
  Q022GT00_NVTOT            NUMBER(4),
  Q022GT00_NANT60M          NUMBER(4),
  Q022GT00_NANT30           NUMBER(4),
  Q022GT00_NANT10           NUMBER(4),
  Q022GT00_NANT10M          NUMBER(4),
  Q022GT00_NANTT            NUMBER(4),
  Q022GT00_OBSAL            VARCHAR2(250),
  Q022GT00_OBSSU            VARCHAR2(250),
  Q022GT00_FEC_ALTA         DATE,
  Q022GT00_FEC_MOD          DATE
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q022GT00 IS 'VAMP:Tabla de Cuestionarios Vivienda en Alquiler de Propiedad Municipal';

COMMENT ON COLUMN Q022GT00.Q022GT00_FEC_ALTA IS 'Fecha de Alta##FEC#insert:sysdate#update:null';

COMMENT ON COLUMN Q022GT00.Q022GT00_ID_CUES IS 'Identificativo del cuestionario';

COMMENT ON COLUMN Q022GT00.Q022GT00_ANO IS 'Ao del cuestionario';

COMMENT ON COLUMN Q022GT00.Q022GT00_CONCEDIDO_LICEN IS 'Ha concedido licencias en el ao';

COMMENT ON COLUMN Q022GT00.Q022GT00_MUN_PROV IS 'Id Provincia';

COMMENT ON COLUMN Q022GT00.Q022GT00_MUN_MUNI IS 'Id Municipio';

COMMENT ON COLUMN Q022GT00.Q022GT00_FEC_MOD IS 'Fecha de Modificacin##FEC#insert:null#update:sysdate';

COMMENT ON COLUMN Q022GT00.Q022GT00_PRV1A IS 'Previsin para el ao prximo de compra/promocin de viv. de alquiler';

COMMENT ON COLUMN Q022GT00.Q022GT00_ADQVI1 IS 'Previsin de adquisicin de viv. de alquiler (1 ao)';

COMMENT ON COLUMN Q022GT00.Q022GT00_NADQ1 IS 'Nmero de viv. previstas por compra (1 ao)';

COMMENT ON COLUMN Q022GT00.Q022GT00_PROVI1 IS 'Previsin promocin de viv. de alquiler (1 ao)';

COMMENT ON COLUMN Q022GT00.Q022GT00_NPRO1 IS 'Nmero de viv. previstas por promocin (1 ao)';

COMMENT ON COLUMN Q022GT00.Q022GT00_OTRVI1 IS 'Previsin de viv. de alquiler por otro procedimiento (1 ao)';

COMMENT ON COLUMN Q022GT00.Q022GT00_OTRLT1 IS 'Previsin de viv. de alquiler por otro procedimiento. Literal (1 ao)';

COMMENT ON COLUMN Q022GT00.Q022GT00_NOTR1 IS 'Nmero de viv. previstas por otro procedimiento (1 ao)';

COMMENT ON COLUMN Q022GT00.Q022GT00_NTOT1 IS 'Nmero total de viv. previstas el ao prximo ';

COMMENT ON COLUMN Q022GT00.Q022GT00_PRV4A IS 'Previsin para los prox. 4 aos de compra/promocin de viv. de alquiler';

COMMENT ON COLUMN Q022GT00.Q022GT00_ADQVI4 IS 'Previsin de adquisicin de viv. de alquiler (4 aos)';

COMMENT ON COLUMN Q022GT00.Q022GT00_NADQ4 IS 'Nmero de viv. previstas por compra (4 aos)';

COMMENT ON COLUMN Q022GT00.Q022GT00_PROVI4 IS 'Previsin promocin de viv. de alquiler (4 aos)';

COMMENT ON COLUMN Q022GT00.Q022GT00_NPRO4 IS 'Nmero de viv. previstas por promocin (4 aos)';

COMMENT ON COLUMN Q022GT00.Q022GT00_OTRVI4 IS 'Previsin de viv. de alquiler por otro procedimiento (4 aos)';

COMMENT ON COLUMN Q022GT00.Q022GT00_OTRLT4 IS 'Previsin de viv. de alquiler por otro procedimiento. Literal (4 aos)';

COMMENT ON COLUMN Q022GT00.Q022GT00_NOTR4 IS 'Nmero de viv. previstas por otro procedimiento (4 aos)';

COMMENT ON COLUMN Q022GT00.Q022GT00_NTOT4 IS 'Nmero total de viv. previstas en 4 aos prximo (4 aos)';

COMMENT ON COLUMN Q022GT00.Q022GT00_TALQ IS 'Tiene o no viviendas de propiedad municipal para alquiler';

COMMENT ON COLUMN Q022GT00.Q022GT00_NALQ IS 'Nmero total de viviendas de alquiler ';

COMMENT ON COLUMN Q022GT00.Q022GT00_NSP45 IS 'Viv. con menos de 45 m2 de superficie til';

COMMENT ON COLUMN Q022GT00.Q022GT00_NSP75 IS 'Viv. de 45  a 75 m2 de superficie til';

COMMENT ON COLUMN Q022GT00.Q022GT00_NSP90 IS 'Viv. de 76  a 90 m2 de superficie til';

COMMENT ON COLUMN Q022GT00.Q022GT00_NSP90M IS 'Viv. de ms de 90 m2 de superficie til';

COMMENT ON COLUMN Q022GT00.Q022GT00_NSPT IS 'Nmero total de viviendas de alquiler (Superficie)';

COMMENT ON COLUMN Q022GT00.Q022GT00_NRSP45 IS 'Renta  de viv. con menos de 45 m2 de superficie til';

COMMENT ON COLUMN Q022GT00.Q022GT00_NRSP75 IS 'Renta de viv. de 45  a 75 m2 de superficie til';

COMMENT ON COLUMN Q022GT00.Q022GT00_NRSP90 IS 'Renta de viv. de 76  a 90 m2 de superficie til';

COMMENT ON COLUMN Q022GT00.Q022GT00_NRSP90M IS 'Renta de viv. de ms de 90 m2 de superficie til';

COMMENT ON COLUMN Q022GT00.Q022GT00_NRSPT IS 'Nmero total de viviendas de alquiler (Renta)';

COMMENT ON COLUMN Q022GT00.Q022GT00_NOCUP IS 'Nmero de viviendas ocupadas';

COMMENT ON COLUMN Q022GT00.Q022GT00_NDESA IS 'Nmero de viviendas desocupadas accesibles';

COMMENT ON COLUMN Q022GT00.Q022GT00_NDESO IS 'Nmero de viviendas desocupadas en obras/rehabilitacin';

COMMENT ON COLUMN Q022GT00.Q022GT00_NDESOT IS 'Nmero de viviendas desocupadas por otras razones';

COMMENT ON COLUMN Q022GT00.Q022GT00_DESOTR IS 'Razn de desocupacin';

COMMENT ON COLUMN Q022GT00.Q022GT00_NOCUT IS 'Nmero total de viviendas por ocupacin ';

COMMENT ON COLUMN Q022GT00.Q022GT00_NVPOG IS 'Nm. de VPO (Viviendas de Proteccin Oficial de Rgimen General)  ';

COMMENT ON COLUMN Q022GT00.Q022GT00_NVPOE IS 'Nm. de VS (Viviendas de Proteccin Oficial de Rgimen Especial-Vivienda Social-) ';

COMMENT ON COLUMN Q022GT00.Q022GT00_NVPOT IS 'Nm. de VPOT (Viviendas de Proteccin Oficial de Regulacin Autonmica)';

COMMENT ON COLUMN Q022GT00.Q022GT00_NALOD IS 'Nm. de Alojamientos Dotacionales';

COMMENT ON COLUMN Q022GT00.Q022GT00_NREAL IS 'Nm. de Viviendas de Realojo';

COMMENT ON COLUMN Q022GT00.Q022GT00_NLIBRE IS 'Nm. de Viviendas Libres';

COMMENT ON COLUMN Q022GT00.Q022GT00_NVTMG IS 'Nm. de VTMG (Viviendas Tasadas Municipales de Rgimen General)';

COMMENT ON COLUMN Q022GT00.Q022GT00_NVTME IS 'Nm. de VTME (Viviendas Tasadas Municipales de Rgimen Especial)';

COMMENT ON COLUMN Q022GT00.Q022GT00_NVTOT IS 'Nmero de viviendas total (por rgimen)';

COMMENT ON COLUMN Q022GT00.Q022GT00_NANT60M IS 'Viv.  de 60 y ms aos de antigedad';

COMMENT ON COLUMN Q022GT00.Q022GT00_NANT30 IS 'Viv.  de 30 a 59  aos de antigedad';

COMMENT ON COLUMN Q022GT00.Q022GT00_NANT10 IS 'Viv.  de 10 a 29  aos de antigedad';

COMMENT ON COLUMN Q022GT00.Q022GT00_NANT10M IS 'Viv.  de 9 o menos aos de antigedad';

COMMENT ON COLUMN Q022GT00.Q022GT00_NANTT IS 'Total de viviendas por antigedad';

COMMENT ON COLUMN Q022GT00.Q022GT00_OBSAL IS 'Observaciones al mdulo de alquiler';

drop table Q022HT00 cascade constraints;
CREATE TABLE Q022HT00
(
  Q022HT00_ID_OFI    NUMBER(8)                  NOT NULL,
  Q022HT00_PROV      VARCHAR2(2)                NOT NULL,
  Q022HT00_MUNI      VARCHAR2(3)                NOT NULL,
  Q022HT00_DESC      VARCHAR2(50),
  Q022HT00_DESC_EUS  VARCHAR2(50),
  Q022HT00_TVIA      VARCHAR2(2),
  Q022HT00_CALLE     NUMBER(15),
  Q022HT00_BLOQ      VARCHAR2(3),
  Q022HT00_NUME      NUMBER(4),
  Q022HT00_BIS       VARCHAR2(1),
  Q022HT00_ESCA      VARCHAR2(2),
  Q022HT00_PISO      VARCHAR2(2),
  Q022HT00_MANO      VARCHAR2(2),
  Q022HT00_PUER      VARCHAR2(3),
  Q022HT00_CODP      VARCHAR2(5),
  Q022HT00_CDIR      VARCHAR2(50),
  Q022HT00_DEPA      VARCHAR2(50),
  Q022HT00_EMAILD    VARCHAR2(80),
  Q022HT00_TELF1D    NUMBER(9),
  Q022HT00_TELF2D    NUMBER(9),
  Q022HT00_FAXD      NUMBER(9),
  Q022HT00_WEB       VARCHAR2(80)
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q022HT00 IS 'Oficina Municipal';

COMMENT ON COLUMN Q022HT00.Q022HT00_ID_OFI IS 'Identificativo de la oficina';

COMMENT ON COLUMN Q022HT00.Q022HT00_PROV IS 'Id Provincia';

COMMENT ON COLUMN Q022HT00.Q022HT00_MUNI IS 'Id Municipio';

COMMENT ON COLUMN Q022HT00.Q022HT00_DESC IS 'Descripcin';

COMMENT ON COLUMN Q022HT00.Q022HT00_DESC_EUS IS 'Descripcin euskera';

COMMENT ON COLUMN Q022HT00.Q022HT00_TVIA IS 'Tipo de Va ';

COMMENT ON COLUMN Q022HT00.Q022HT00_CALLE IS 'Cdigo calle';

COMMENT ON COLUMN Q022HT00.Q022HT00_BLOQ IS 'Bloque';

COMMENT ON COLUMN Q022HT00.Q022HT00_NUME IS 'Nmero';

COMMENT ON COLUMN Q022HT00.Q022HT00_BIS IS 'Bis  ';

COMMENT ON COLUMN Q022HT00.Q022HT00_ESCA IS 'Escalera ';

COMMENT ON COLUMN Q022HT00.Q022HT00_PISO IS 'Piso';

COMMENT ON COLUMN Q022HT00.Q022HT00_MANO IS 'Mano';

COMMENT ON COLUMN Q022HT00.Q022HT00_PUER IS 'Puerta';

COMMENT ON COLUMN Q022HT00.Q022HT00_CODP IS 'Cdigo Postal';

COMMENT ON COLUMN Q022HT00.Q022HT00_CDIR IS 'Complemento de direccin o acepcin';

COMMENT ON COLUMN Q022HT00.Q022HT00_DEPA IS 'Departamento o rea';

COMMENT ON COLUMN Q022HT00.Q022HT00_EMAILD IS 'Email';

COMMENT ON COLUMN Q022HT00.Q022HT00_TELF1D IS 'Telfono 1 de contacto/informacin del Dept';

COMMENT ON COLUMN Q022HT00.Q022HT00_TELF2D IS 'Telfono 2 de contacto/informacin del Dept';

COMMENT ON COLUMN Q022HT00.Q022HT00_FAXD IS 'Fax del Dept.';

COMMENT ON COLUMN Q022HT00.Q022HT00_WEB IS 'Web principal ';

drop table Q022IT00 cascade constraints;
CREATE TABLE Q022IT00
(
  Q022IT00_ID_INF   NUMBER(8)                   NOT NULL,
  Q022IT00_ID_OFI   NUMBER(8)                   NOT NULL,
  Q022IT00_NOMB     VARCHAR2(50)                NOT NULL,
  Q022IT00_APE1     VARCHAR2(30)                NOT NULL,
  Q022IT00_APE2     VARCHAR2(30)                NOT NULL,
  Q022IT00_CARGO    VARCHAR2(50),
  Q022IT00_DEPA     VARCHAR2(50),
  Q022IT00_EMAIL    VARCHAR2(80),
  Q022IT00_TELF1    NUMBER(9),
  Q022IT00_TELF2    NUMBER(9),
  Q022IT00_FAX      NUMBER(9),
  Q022IT00_FELEC    NUMBER(1),
  Q022IT00_PRINCPL  NUMBER(1),
  Q022IT00_DNI      VARCHAR2(9)
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q022IT00 IS 'Informantes Oficina';

COMMENT ON COLUMN Q022IT00.Q022IT00_ID_INF IS 'Identificativo del informante';

COMMENT ON COLUMN Q022IT00.Q022IT00_ID_OFI IS 'Identificativo de la oficina';

COMMENT ON COLUMN Q022IT00.Q022IT00_NOMB IS 'Nombre informante';

COMMENT ON COLUMN Q022IT00.Q022IT00_APE1 IS 'Apellido 1 informante';

COMMENT ON COLUMN Q022IT00.Q022IT00_APE2 IS 'Apellido 2 informante';

COMMENT ON COLUMN Q022IT00.Q022IT00_CARGO IS 'Cargo o puesto del informante';

COMMENT ON COLUMN Q022IT00.Q022IT00_DEPA IS 'Departamento o rea municipal del que depende inform';

COMMENT ON COLUMN Q022IT00.Q022IT00_EMAIL IS 'Correo electrnico del informant';

COMMENT ON COLUMN Q022IT00.Q022IT00_TELF1 IS 'Telfono 1 del informante';

COMMENT ON COLUMN Q022IT00.Q022IT00_TELF2 IS 'Telfono 2 del informante';

COMMENT ON COLUMN Q022IT00.Q022IT00_FAX IS 'FAX del informante';

COMMENT ON COLUMN Q022IT00.Q022IT00_FELEC IS 'Dispone de firma electrnica ';

COMMENT ON COLUMN Q022IT00.Q022IT00_PRINCPL IS 'Indicador de principal';

COMMENT ON COLUMN Q022IT00.Q022IT00_DNI IS 'Dni del informante';

drop table Q022JT00 cascade constraints;
CREATE TABLE Q022JT00
(
  Q022JT00_ID_AGEN  NUMBER(8)                   NOT NULL,
  Q022JT00_NOMB     VARCHAR2(50)                NOT NULL,
  Q022JT00_APE1     VARCHAR2(30)                NOT NULL,
  Q022JT00_APE2     VARCHAR2(30)                NOT NULL,
  Q022JT00_CODAG    VARCHAR2(2)                 NOT NULL,
  Q022JT00_CODJF    VARCHAR2(2),
  Q022JT00_EMAILA   VARCHAR2(80),
  Q022JT00_TELF1A   NUMBER(9),
  Q022JT00_TELF2A   NUMBER(9),
  Q022JT00_DNI      VARCHAR2(9)
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q022JT00 IS 'Agentes Oficina';

COMMENT ON COLUMN Q022JT00.Q022JT00_ID_AGEN IS 'Identificativo del agente';

COMMENT ON COLUMN Q022JT00.Q022JT00_NOMB IS 'Nombre agente de recogida';

COMMENT ON COLUMN Q022JT00.Q022JT00_APE1 IS 'Apellido 1agente de recogida';

COMMENT ON COLUMN Q022JT00.Q022JT00_APE2 IS 'Apellido 2agente de recogida';

COMMENT ON COLUMN Q022JT00.Q022JT00_CODAG IS 'Cdigo de agente';

COMMENT ON COLUMN Q022JT00.Q022JT00_CODJF IS 'Cdigo de jefe de grupo';

COMMENT ON COLUMN Q022JT00.Q022JT00_EMAILA IS 'Correo electrnico del Agente';

COMMENT ON COLUMN Q022JT00.Q022JT00_TELF1A IS 'Telfono 1 del Agente';

COMMENT ON COLUMN Q022JT00.Q022JT00_TELF2A IS 'Telfono 2 del Agente';

COMMENT ON COLUMN Q022JT00.Q022JT00_DNI IS 'Dni';

drop table Q022KT00 cascade constraints;
CREATE TABLE Q022KT00
(
  Q022KT00_ID_CONT      NUMBER(8)               NOT NULL,
  Q022KT00_PROV         VARCHAR2(2)             NOT NULL,
  Q022KT00_MUNI         VARCHAR2(3)             NOT NULL,
  Q022KT00_ID_INF       NUMBER(8)               NOT NULL,
  Q022KT00_ID_AGEN      NUMBER(8),
  Q022KT00_FECC         DATE                    NOT NULL,
  Q022KT00_RCON         VARCHAR2(10),
  Q022KT00_FECR         DATE,
  Q022KT00_OBSHR        VARCHAR2(250),
  Q022HT00_ID_OFI       NUMBER(8),
  Q022YT00_NI_TIPO_CON  NUMBER(10)
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q022KT00 IS 'Contactos';

COMMENT ON COLUMN Q022KT00.Q022KT00_ID_INF IS 'Identificativo del informante';

COMMENT ON COLUMN Q022KT00.Q022KT00_ID_AGEN IS 'Identificativo del agente';

COMMENT ON COLUMN Q022KT00.Q022KT00_FECC IS 'Fecha de contacto ';

COMMENT ON COLUMN Q022KT00.Q022KT00_RCON IS 'Razn de prximo contacto 1-6';

COMMENT ON COLUMN Q022KT00.Q022KT00_FECR IS 'Fecha de prximo contacto ';

COMMENT ON COLUMN Q022KT00.Q022KT00_OBSHR IS 'Observaciones';

COMMENT ON COLUMN Q022KT00.Q022HT00_ID_OFI IS 'Identificativo de la oficina';

COMMENT ON COLUMN Q022KT00.Q022YT00_NI_TIPO_CON IS 'Tipo de contacto  1-6';

COMMENT ON COLUMN Q022KT00.Q022KT00_ID_CONT IS 'Identificativo del contacto';

COMMENT ON COLUMN Q022KT00.Q022KT00_PROV IS 'Id Provincia';

COMMENT ON COLUMN Q022KT00.Q022KT00_MUNI IS 'Id Municipio';


drop table Q022LT00 cascade constraints;
CREATE TABLE Q022LT00
(
  Q022LT00_ID_RESUL       NUMBER(8)             NOT NULL,
  Q022LT00_PROV           VARCHAR2(2)           NOT NULL,
  Q022LT00_MUNI           VARCHAR2(3)           NOT NULL,
  Q022LT00_OTRF           VARCHAR2(50),
  Q022LT00_NRESPH         VARCHAR2(1),
  Q022LT00_NRESPV         VARCHAR2(1),
  Q022LT00_NRESPS         VARCHAR2(1),
  Q022LT00_NRESPA         VARCHAR2(1),
  Q022LT00_NRESPT         VARCHAR2(1),
  Q022LT00_NRESPP         VARCHAR2(1),
  Q022LT00_OBSHR          VARCHAR2(250),
  Q022HT00_ID_OFI         NUMBER(8),
  Q022YT00_NI_FORMA       NUMBER(10),
  Q022YT00_NI_RESUL_ENC   NUMBER(10),
  Q022YT00_NI_SITU_INSP   NUMBER(10),
  Q022YT00_NI_RESUL_INSP  NUMBER(10)
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q022LT00 IS 'Resultado';

COMMENT ON COLUMN Q022LT00.Q022LT00_ID_RESUL IS 'Identificativo del resultado';

COMMENT ON COLUMN Q022LT00.Q022LT00_PROV IS 'Id Provincia';

COMMENT ON COLUMN Q022LT00.Q022LT00_MUNI IS 'Id Municipio';

COMMENT ON COLUMN Q022LT00.Q022LT00_OTRF IS 'Otra forma de recogida';

COMMENT ON COLUMN Q022LT00.Q022HT00_ID_OFI IS 'Identificativo de la oficina';

COMMENT ON COLUMN Q022LT00.Q022YT00_NI_FORMA IS 'Forma principal de captura de informacin 1-8';

COMMENT ON COLUMN Q022LT00.Q022YT00_NI_RESUL_ENC IS 'Resultado de encuestacin 1-5';

COMMENT ON COLUMN Q022LT00.Q022YT00_NI_SITU_INSP IS 'Situacin de inspeccin 1-3';

COMMENT ON COLUMN Q022LT00.Q022YT00_NI_RESUL_INSP IS 'Resultado de inspeccin 1-2';

COMMENT ON COLUMN Q022LT00.Q022LT00_NRESPH IS 'Falta completar Hoja Resumen';

COMMENT ON COLUMN Q022LT00.Q022LT00_NRESPV IS 'Falta completar VTM';

COMMENT ON COLUMN Q022LT00.Q022LT00_NRESPS IS 'Falta completar Suelo Municipal';

COMMENT ON COLUMN Q022LT00.Q022LT00_NRESPA IS 'Falta completar alquiler';

COMMENT ON COLUMN Q022LT00.Q022LT00_NRESPT IS 'No se recoge ningn cuestionario de LOM';

COMMENT ON COLUMN Q022LT00.Q022LT00_NRESPP IS 'Se recoge parte de los cuestionarios de LOM';

COMMENT ON COLUMN Q022LT00.Q022LT00_OBSHR IS 'Observaciones';

drop table Q022MT00 cascade constraints;
CREATE TABLE Q022MT00
(
  Q022MT00_ID_AYUN   NUMBER(8)                  NOT NULL,
  Q022MT00_PROV      VARCHAR2(2)                NOT NULL,
  Q022MT00_MUNI      VARCHAR2(3)                NOT NULL,
  Q022MT00_DESC      VARCHAR2(50),
  Q022MT00_DESC_EUS  VARCHAR2(50),
  Q022MT00_TVIA      VARCHAR2(2),
  Q022MT00_CALLE     NUMBER(15),
  Q022MT00_BLOQ      VARCHAR2(3),
  Q022MT00_NUME      NUMBER(4),
  Q022MT00_BIS       VARCHAR2(1),
  Q022MT00_ESCA      VARCHAR2(2),
  Q022MT00_PISO      VARCHAR2(2),
  Q022MT00_MANO      VARCHAR2(2),
  Q022MT00_PUER      VARCHAR2(3),
  Q022MT00_CODP      VARCHAR2(5),
  Q022MT00_CDIR      VARCHAR2(50),
  Q022MT00_EMAIL     VARCHAR2(80),
  Q022MT00_TELF1     NUMBER(9),
  Q022MT00_TELF2     NUMBER(9),
  Q022MT00_FAX       NUMBER(9),
  Q022MT00_WEB       VARCHAR2(80)
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q022MT00 IS 'Ayuntamiento';

COMMENT ON COLUMN Q022MT00.Q022MT00_ID_AYUN IS 'Identificativo del ayuntamiento';

COMMENT ON COLUMN Q022MT00.Q022MT00_PROV IS 'Id Provincia';

COMMENT ON COLUMN Q022MT00.Q022MT00_MUNI IS 'Id Municipio';

COMMENT ON COLUMN Q022MT00.Q022MT00_DESC IS 'Descripcin';

COMMENT ON COLUMN Q022MT00.Q022MT00_DESC_EUS IS 'Descripcin euskera';

COMMENT ON COLUMN Q022MT00.Q022MT00_TVIA IS 'Tipo de Va ';

COMMENT ON COLUMN Q022MT00.Q022MT00_CALLE IS 'Cdigo calle';

COMMENT ON COLUMN Q022MT00.Q022MT00_BLOQ IS 'Bloque';

COMMENT ON COLUMN Q022MT00.Q022MT00_NUME IS 'Nmero';

COMMENT ON COLUMN Q022MT00.Q022MT00_BIS IS 'Bis  ';

COMMENT ON COLUMN Q022MT00.Q022MT00_ESCA IS 'Escalera ';

COMMENT ON COLUMN Q022MT00.Q022MT00_PISO IS 'Piso';

COMMENT ON COLUMN Q022MT00.Q022MT00_MANO IS 'Mano';

COMMENT ON COLUMN Q022MT00.Q022MT00_PUER IS 'Puerta';

COMMENT ON COLUMN Q022MT00.Q022MT00_CODP IS 'Cdigo Postal';

COMMENT ON COLUMN Q022MT00.Q022MT00_CDIR IS 'Complemento de direccin o acepcin';

COMMENT ON COLUMN Q022MT00.Q022MT00_EMAIL IS 'Email';

COMMENT ON COLUMN Q022MT00.Q022MT00_TELF1 IS 'Telfono 1';

COMMENT ON COLUMN Q022MT00.Q022MT00_TELF2 IS 'Telfono 2 ';

COMMENT ON COLUMN Q022MT00.Q022MT00_FAX IS 'Fax.';

COMMENT ON COLUMN Q022MT00.Q022MT00_WEB IS 'Web principal ';

drop table Q022NT00 cascade constraints;
CREATE TABLE Q022NT00
(
  Q022NT00_CODIGO   VARCHAR2(5)                 NOT NULL,
  Q022NT00_DESC_ES  VARCHAR2(100),
  Q022NT00_DESC_EU  VARCHAR2(100)
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q022NT00 IS 'Tipos de cuestionarios';

COMMENT ON COLUMN Q022NT00.Q022NT00_CODIGO IS 'Cdigo';

COMMENT ON COLUMN Q022NT00.Q022NT00_DESC_ES IS 'Descripcin en castellano';

COMMENT ON COLUMN Q022NT00.Q022NT00_DESC_EU IS 'Descripcin en euskera';

drop table Q022OT00 cascade constraints;
CREATE TABLE Q022OT00
(
  Q022OT00_COD          VARCHAR2(50)            NOT NULL,
  Q022OT00_TABLE        VARCHAR2(50)            NOT NULL,
  Q022OT00_TITULO       VARCHAR2(100),
  Q022OT00_PLANTILLA    VARCHAR2(50),
  Q022OT00_FIXED_WHERE  VARCHAR2(500),
  Q022OT00_ORDER        VARCHAR2(50),
  Q022OT00_DESCRIPCION  VARCHAR2(500)
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q022OT00 IS 'Parametrizacin de Informes';

COMMENT ON COLUMN Q022OT00.Q022OT00_COD IS 'Clave del informe';

COMMENT ON COLUMN Q022OT00.Q022OT00_TABLE IS 'Nombre de la tabla/vista de la que se extr el informe';

COMMENT ON COLUMN Q022OT00.Q022OT00_TITULO IS 'Ttulo en castellano para la cabecera del informe';

COMMENT ON COLUMN Q022OT00.Q022OT00_PLANTILLA IS 'Nombre del archivo xls';

COMMENT ON COLUMN Q022OT00.Q022OT00_FIXED_WHERE IS 'Where fija para el informe';

COMMENT ON COLUMN Q022OT00.Q022OT00_ORDER IS 'Orden';

COMMENT ON COLUMN Q022OT00.Q022OT00_DESCRIPCION IS 'Descripcion';

drop table Q022WT00 cascade constraints;
CREATE TABLE Q022WT00
(
  Q022WT00_NI               NUMBER(8)           NOT NULL,
  Q022NT00_CODIGO           VARCHAR2(5),
  Q022WT00_ID_GRUPO         NUMBER(8)           NOT NULL,
  Q022WT00_ID_CUES          NUMBER(10)          NOT NULL,
  Q022WT00_DIRECCIN        VARCHAR2(250),
  Q022WT00_ESTADO           VARCHAR2(2)         DEFAULT 'P',
  Q022WT00_FECHA_GRABACION  DATE,
  Q022WT00_OBSERVACIONES    VARCHAR2(250)
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q022WT00 IS 'Solicitudes de Alta en NORA';

COMMENT ON COLUMN Q022WT00.Q022WT00_NI IS 'Codigo nico de la solicitud de alta';

COMMENT ON COLUMN Q022WT00.Q022NT00_CODIGO IS 'Codigo del tipo de formulario';

COMMENT ON COLUMN Q022WT00.Q022WT00_ID_GRUPO IS 'Codigo nico del Grupo de Cuestionarios';

COMMENT ON COLUMN Q022WT00.Q022WT00_ID_CUES IS 'Codigo del Cuestionario (por grupo)';

COMMENT ON COLUMN Q022WT00.Q022WT00_DIRECCIN IS 'Nueva direccin';

COMMENT ON COLUMN Q022WT00.Q022WT00_ESTADO IS 'Estado de la solicitud';

COMMENT ON COLUMN Q022WT00.Q022WT00_FECHA_GRABACION IS 'Fecha de la solicitud';

COMMENT ON COLUMN Q022WT00.Q022WT00_OBSERVACIONES IS 'Observaciones';

drop table Q022XT00 cascade constraints;
CREATE TABLE Q022XT00
(
  Q022XT00_NI           NUMBER(10)              NOT NULL,
  Q022XT00_COD          VARCHAR2(15)            NOT NULL,
  Q022XT00_DESCRIPCION  VARCHAR2(500)           NOT NULL,
  Q022XT00_USU_ALTA     NUMBER(10)              DEFAULT -1,
  Q022XT00_USU_MODIF    NUMBER(10)              DEFAULT -1,
  Q022XT00_TST_ALTA     DATE                    DEFAULT SYSDATE,
  Q022XT00_TST_MODIF    DATE                    DEFAULT SYSDATE
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q022XT00 IS 'Cabecera de Tabla de Tablas';

COMMENT ON COLUMN Q022XT00.Q022XT00_NI IS 'Nmero Interno de la Tabla de Tablas';

COMMENT ON COLUMN Q022XT00.Q022XT00_COD IS 'Cdigo de la Tabla de Tablas';

COMMENT ON COLUMN Q022XT00.Q022XT00_DESCRIPCION IS 'Descripcion';

drop table Q022YT00 cascade constraints;
CREATE TABLE Q022YT00
(
  Q022XT00_NI         NUMBER(10)                NOT NULL,
  Q022YT00_NI         NUMBER(10)                NOT NULL,
  Q022YT00_COD        VARCHAR2(15)              NOT NULL,
  Q022YT00_DESC       VARCHAR2(500)             NOT NULL,
  Q022YT00_DESC_EUS   VARCHAR2(500)             NOT NULL,
  Q022YT00_USU_ALTA   NUMBER(10)                DEFAULT -1                    NOT NULL,
  Q022YT00_USU_MODIF  NUMBER(10)                DEFAULT -1,
  Q022YT00_TST_ALTA   DATE                      DEFAULT SYSDATE,
  Q022YT00_TST_MODIF  DATE                      DEFAULT SYSDATE
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q022YT00 IS 'Elementos de Tabla de Tablas';

COMMENT ON COLUMN Q022YT00.Q022XT00_NI IS 'Nmero Interno de la Tabla de Tablas';

COMMENT ON COLUMN Q022YT00.Q022YT00_NI IS 'Nmero Interno del Elemento';

COMMENT ON COLUMN Q022YT00.Q022YT00_COD IS 'Codigo del elemento';

COMMENT ON COLUMN Q022YT00.Q022YT00_DESC IS 'Descripcin del Elemento';

COMMENT ON COLUMN Q022YT00.Q022YT00_DESC_EUS IS 'Descripcin del Elemento en Euskera';

drop table Q022ZT00 cascade constraints;
CREATE TABLE Q022ZT00
(
  Q022JT00_ID_AGEN  NUMBER(8),
  Q022HT00_ID_OFI   NUMBER(8)
)
TABLESPACE Q0201E00;

COMMENT ON TABLE Q022ZT00 IS 'Agentes-Oficinas';

COMMENT ON COLUMN Q022ZT00.Q022JT00_ID_AGEN IS 'Id agente';

COMMENT ON COLUMN Q022ZT00.Q022HT00_ID_OFI IS 'Id Oficina';




drop table Q022PT00 cascade constraints;
CREATE TABLE Q022PT00                                                                                               
(                                                                                                                   
  Q022PT00_ID_CUES         NUMBER(8)            NOT NULL,                                                           
  Q022PT00_ID              NUMBER(8)            NOT NULL,                                                           
  Q022PT00_RS_PROMO        VARCHAR2(100),                                                                           
  Q022PT00_PROV_PRO        VARCHAR2(2),                                                                             
  Q022PT00_MUNI_PRO        VARCHAR2(3),                                                                             
  Q022PT00_ENTI_PRO        NUMBER(15),                                                                              
  Q022PT00_TVIA_PRO        VARCHAR2(2),                                                                             
  Q022PT00_CALLE_PRO       NUMBER(15),                                                                              
  Q022PT00_POR_CL_POR_PRO  NUMBER(15),                                                                              
  Q022PT00_BLOQ_PRO        VARCHAR2(3),                                                                             
  Q022PT00_NUME_PRO        NUMBER(4),                                                                               
  Q022PT00_BIS_PRO         VARCHAR2(1),                                                                             
  Q022PT00_CP_PRO          VARCHAR2(1),                                                                             
  Q022PT00_CDIR_PRO        VARCHAR2(50),                                                                            
  Q022PT00_CLASE_PRO       VARCHAR2(1),                                                                             
  Q022PT00_CLASE_ESP       VARCHAR2(50),                                                                            
  Q022PT00_PROV_OBR        VARCHAR2(2),                                                                             
  Q022PT00_MUNI_OBR        VARCHAR2(3),                                                                             
  Q022PT00_ENTI_OBR        NUMBER(15),                                                                              
  Q022PT00_TVIA_OBR        VARCHAR2(2),                                                                             
  Q022PT00_CALLE_OBR       NUMBER(15),                                                                              
  Q022PT00_POR_CL_POR_OBR  NUMBER(15),                                                                              
  Q022PT00_BLOQ_OBR        VARCHAR2(3),                                                                             
  Q022PT00_NUME_OBR        NUMBER(4),                                                                               
  Q022PT00_BIS_OBR         VARCHAR2(1),                                                                             
  Q022PT00_CDIR_OBR        VARCHAR2(50),                                                                            
  Q022PT00_CLASIF_SUE      VARCHAR2(1),                                                                             
  Q022PT00_VPROT           VARCHAR2(1),                                                                             
  Q022PT00_TIPO_VPROT      VARCHAR2(1),                                                                             
  Q022PT00_NUM_VPROT       NUMBER(3),                                                                               
  Q022PT00_MES_INI         NUMBER(2),                                                                               
  Q022PT00_MES_DURAC       NUMBER(2),                                                                               
  Q022PT00_TIPO_OBR        VARCHAR2(1),                                                                             
  Q022PT00_RES_AIS         NUMBER(3),                                                                               
  Q022PT00_RES_ADO         NUMBER(3),                                                                               
  Q022PT00_RES_PARE        NUMBER(3),                                                                               
  Q022PT00_RES_2V          NUMBER(3),                                                                               
  Q022PT00_RES_PER         NUMBER(3),                                                                               
  Q022PT00_RES_EVEN        NUMBER(3),                                                                               
  Q022PT00_NRES_EXPL       NUMBER(3),                                                                               
  Q022PT00_NRES_TRANS      NUMBER(3),                                                                               
  Q022PT00_NRES_ALM        NUMBER(3),                                                                               
  Q022PT00_NRES_OFI        NUMBER(3),                                                                               
  Q022PT00_NRES_COMER      NUMBER(3),                                                                               
  Q022PT00_NRES_SANI       NUMBER(3),                                                                               
  Q022PT00_NRES_CUL        NUMBER(3),                                                                               
  Q022PT00_NRES_EDU        NUMBER(3),                                                                               
  Q022PT00_NRES_IGLE       NUMBER(3),                                                                               
  Q022PT00_NRES_OTR        NUMBER(3),                                                                               
  Q022PT00_PRESUP_MAT      NUMBER(12,3),                                                                            
  Q022PT00_TIPO_LIC        NUMBER(1),                                                                               
  Q022PT00_OBS             VARCHAR2(100),                                                                           
  Q022PT00_USU_ALTA        NUMBER(10)           DEFAULT -1                    NOT NULL,                             
  Q022PT00_USU_MODIF       NUMBER(10)           DEFAULT -1,                                                         
  Q022PT00_TST_ALTA        DATE                 DEFAULT SYSDATE               NOT NULL,                             
  Q022PT00_TST_MODIF       DATE                 DEFAULT SYSDATE               NOT NULL                              
)                                                                                                                   
TABLESPACE Q0201E00;                                                                                               
                                                                                                                    
COMMENT ON TABLE Q022PT00 IS 'Cuestionario Ministerio Fomento:Datos Generales';                                     
                                                                                                                    
COMMENT ON COLUMN Q022PT00.Q022PT00_USU_ALTA IS 'Usuario de Alta##USR#insert:usr#update:null';                      
                                                                                                                    
COMMENT ON COLUMN Q022PT00.Q022PT00_USU_MODIF IS 'Usuario Ultima Modificacion##USR#insert:usr#update:usr';          
                                                                                                                    
COMMENT ON COLUMN Q022PT00.Q022PT00_TST_ALTA IS 'Fecha de Alta##FEC#insert:sysdate#update:null';                    
                                                                                                                    
COMMENT ON COLUMN Q022PT00.Q022PT00_TST_MODIF IS 'Fecha de Modificacion##FEC#insert:sysdate#update:sysdate';        
                                                                                                                    
drop table Q022QT00 cascade constraints;                                                                                                                    
CREATE TABLE Q022QT00                                                                                               
(                                                                                                                   
  Q022QT00_ID_CUES    NUMBER(8)                 NOT NULL,                                                           
  Q022QT00_ID         NUMBER(8)                 NOT NULL,                                                           
  Q022QT00_SUP_EDIF   NUMBER(5),                                                                                    
  Q022QT00_SUP_TER    NUMBER(5),                                                                                    
  Q022QT00_NEDIF_G    NUMBER(2),                                                                                    
  Q022QT00_NPLSR_G    NUMBER(2),                                                                                    
  Q022QT00_NPLBR_G    NUMBER(2),                                                                                    
  Q022QT00_SUPT_G     NUMBER(5),                                                                                    
  Q022QT00_VOLT_G     NUMBER(5),                                                                                    
  Q022QT00_NTV_G      NUMBER(3),                                                                                    
  Q022QT00_NTP_G      NUMBER(4),                                                                                    
  Q022QT00_NTPG_G     NUMBER(4),                                                                                    
  Q022QT00_NEDIF_H    NUMBER(2),                                                                                    
  Q022QT00_NPLSR_H    NUMBER(2),                                                                                    
  Q022QT00_NPLBR_H    NUMBER(2),                                                                                    
  Q022QT00_SUPT_H     NUMBER(5),                                                                                    
  Q022QT00_VOLT_H     NUMBER(5),                                                                                    
  Q022QT00_NTV_H      NUMBER(3),                                                                                    
  Q022QT00_NTP_H      NUMBER(4),                                                                                    
  Q022QT00_NTPG_H     NUMBER(4),                                                                                    
  Q022QT00_NEDIF_I    NUMBER(2),                                                                                    
  Q022QT00_NPLSR_I    NUMBER(2),                                                                                    
  Q022QT00_NPLBR_I    NUMBER(2),                                                                                    
  Q022QT00_SUPT_I     NUMBER(5),                                                                                    
  Q022QT00_VOLT_I     NUMBER(5),                                                                                    
  Q022QT00_NTV_I      NUMBER(3),                                                                                    
  Q022QT00_NTP_I      NUMBER(4),                                                                                    
  Q022QT00_NTPG_I     NUMBER(4),                                                                                    
  Q022QT00_NEDIF_J    NUMBER(2),                                                                                    
  Q022QT00_NPLSR_J    NUMBER(2),                                                                                    
  Q022QT00_NPLBR_J    NUMBER(2),                                                                                    
  Q022QT00_SUPT_J     NUMBER(5),                                                                                    
  Q022QT00_VOLT_J     NUMBER(5),                                                                                    
  Q022QT00_NTV_J      NUMBER(3),                                                                                    
  Q022QT00_NTP_J      NUMBER(4),                                                                                    
  Q022QT00_NTPG_J     NUMBER(4),                                                                                    
  Q022QT00_NEDIF_K    NUMBER(2),                                                                                    
  Q022QT00_NPLSR_K    NUMBER(2),                                                                                    
  Q022QT00_NPLBR_K    NUMBER(2),                                                                                    
  Q022QT00_SUPT_K     NUMBER(5),                                                                                    
  Q022QT00_VOLT_K     NUMBER(5),                                                                                    
  Q022QT00_NTV_K      NUMBER(3),                                                                                    
  Q022QT00_NTP_K      NUMBER(4),                                                                                    
  Q022QT00_NTPG_K     NUMBER(4),                                                                                    
  Q022QT00_EV_G       VARCHAR2(1),                                                                                  
  Q022QT00_EV_H       VARCHAR2(1),                                                                                  
  Q022QT00_EV_I       VARCHAR2(1),                                                                                  
  Q022QT00_EV_J       VARCHAR2(1),                                                                                  
  Q022QT00_EV_K       VARCHAR2(1),                                                                                  
  Q022QT00_EH_G       VARCHAR2(1),                                                                                  
  Q022QT00_EH_H       VARCHAR2(1),                                                                                  
  Q022QT00_EH_I       VARCHAR2(1),                                                                                  
  Q022QT00_EH_J       VARCHAR2(1),                                                                                  
  Q022QT00_EH_K       VARCHAR2(1),                                                                                  
  Q022QT00_CU_G       VARCHAR2(1),                                                                                  
  Q022QT00_CU_H       VARCHAR2(1),                                                                                  
  Q022QT00_CU_I       VARCHAR2(1),                                                                                  
  Q022QT00_CU_J       VARCHAR2(1),                                                                                  
  Q022QT00_CU_K       VARCHAR2(1),                                                                                  
  Q022QT00_CEE_G      VARCHAR2(1),                                                                                  
  Q022QT00_CEE_H      VARCHAR2(1),                                                                                  
  Q022QT00_CEE_I      VARCHAR2(1),                                                                                  
  Q022QT00_CEE_J      VARCHAR2(1),                                                                                  
  Q022QT00_CEE_K      VARCHAR2(1),                                                                                  
  Q022QT00_CAE_G      VARCHAR2(1),                                                                                  
  Q022QT00_CAE_H      VARCHAR2(1),                                                                                  
  Q022QT00_CAE_I      VARCHAR2(1),                                                                                  
  Q022QT00_CAE_J      VARCHAR2(1),                                                                                  
  Q022QT00_CAE_K      VARCHAR2(1),                                                                                  
  Q022QT00_EAR_G      VARCHAR2(1),                                                                                  
  Q022QT00_SAP_G      VARCHAR2(1),                                                                                  
  Q022QT00_AC_G       VARCHAR2(1),                                                                                  
  Q022QT00_CA_G       VARCHAR2(1),                                                                                  
  Q022QT00_RE_G       VARCHAR2(1),                                                                                  
  Q022QT00_AM_G       VARCHAR2(1),                                                                                  
  Q022QT00_TAR_G      VARCHAR2(1),                                                                                  
  Q022QT00_TOR_G      VARCHAR2(1),                                                                                  
  Q022QT00_EAR_H      VARCHAR2(1),                                                                                  
  Q022QT00_SAP_H      VARCHAR2(1),                                                                                  
  Q022QT00_AC_H       VARCHAR2(1),                                                                                  
  Q022QT00_CA_H       VARCHAR2(1),                                                                                  
  Q022QT00_RE_H       VARCHAR2(1),                                                                                  
  Q022QT00_AM_H       VARCHAR2(1),                                                                                  
  Q022QT00_TAR_H      VARCHAR2(1),                                                                                  
  Q022QT00_TOR_H      VARCHAR2(1),                                                                                  
  Q022QT00_EAR_I      VARCHAR2(1),                                                                                  
  Q022QT00_SAP_I      VARCHAR2(1),                                                                                  
  Q022QT00_AC_I       VARCHAR2(1),                                                                                  
  Q022QT00_CA_I       VARCHAR2(1),                                                                                  
  Q022QT00_RE_I       VARCHAR2(1),                                                                                  
  Q022QT00_AM_I       VARCHAR2(1),                                                                                  
  Q022QT00_TAR_I      VARCHAR2(1),                                                                                  
  Q022QT00_TOR_I      VARCHAR2(1),                                                                                  
  Q022QT00_EAR_J      VARCHAR2(1),                                                                                  
  Q022QT00_SAP_J      VARCHAR2(1),                                                                                  
  Q022QT00_AC_J       VARCHAR2(1),                                                                                  
  Q022QT00_CA_J       VARCHAR2(1),                                                                                  
  Q022QT00_RE_J       VARCHAR2(1),                                                                                  
  Q022QT00_AM_J       VARCHAR2(1),                                                                                  
  Q022QT00_TAR_J      VARCHAR2(1),                                                                                  
  Q022QT00_TOR_J      VARCHAR2(1),                                                                                  
  Q022QT00_EAR_K      VARCHAR2(1),                                                                                  
  Q022QT00_SAP_K      VARCHAR2(1),                                                                                  
  Q022QT00_AC_K       VARCHAR2(1),                                                                                  
  Q022QT00_CA_K       VARCHAR2(1),                                                                                  
  Q022QT00_RE_K       VARCHAR2(1),                                                                                  
  Q022QT00_AM_K       VARCHAR2(1),                                                                                  
  Q022QT00_TAR_K      VARCHAR2(1),                                                                                  
  Q022QT00_TOR_K      VARCHAR2(1),                                                                                  
  Q022QT00_ENER_G     VARCHAR2(1),                                                                                  
  Q022QT00_ENER_H     VARCHAR2(1),                                                                                  
  Q022QT00_ENER_I     VARCHAR2(1),                                                                                  
  Q022QT00_ENER_J     VARCHAR2(1),                                                                                  
  Q022QT00_ENER_K     VARCHAR2(1),                                                                                  
  Q022QT00_TIP_SU     VARCHAR2(1),                                                                                  
  Q022QT00_CAR_IN     VARCHAR2(1),                                                                                  
  Q022QT00_TEFA       VARCHAR2(1),                                                                                  
  Q022QT00_PERS       VARCHAR2(1),                                                                                  
  Q022QT00_OBS        VARCHAR2(100),                                                                                
  Q022QT00_USU_ALTA   NUMBER(10)                DEFAULT -1                    NOT NULL,                             
  Q022QT00_USU_MODIF  NUMBER(10)                DEFAULT -1,                                                         
  Q022QT00_TST_ALTA   DATE                      DEFAULT SYSDATE               NOT NULL,                             
  Q022QT00_TST_MODIF  DATE                      DEFAULT SYSDATE               NOT NULL                              
)                                                                                                                   
TABLESPACE Q0201E00;                                                                                               
                                                                                                                    
COMMENT ON TABLE Q022QT00 IS 'Cuestionario Ministerio Fomento:Edificacin de Nueva Planta';                         
                                                                                                                    
COMMENT ON COLUMN Q022QT00.Q022QT00_USU_ALTA IS 'Usuario de Alta##USR#insert:usr#update:null';                      
                                                                                                                    
COMMENT ON COLUMN Q022QT00.Q022QT00_USU_MODIF IS 'Usuario Ultima Modificacion##USR#insert:usr#update:usr';          
                                                                                                                    
COMMENT ON COLUMN Q022QT00.Q022QT00_TST_ALTA IS 'Fecha de Alta##FEC#insert:sysdate#update:null';                    
                                                                                                                    
COMMENT ON COLUMN Q022QT00.Q022QT00_TST_MODIF IS 'Fecha de Modificacion##FEC#insert:sysdate#update:sysdate';        
                                                                                                                    
drop table Q022RT00 cascade constraints;                                                                                                                    
CREATE TABLE Q022RT00                                                                                               
(                                                                                                                   
  Q022QT00_ID_EDIFNU  NUMBER(8)                 NOT NULL,                                                           
  Q022RT00_ID         NUMBER(8)                 NOT NULL,                                                           
  Q022RT00_TIP        VARCHAR2(1),                                                                                  
  Q022RT00_SUP_UTL    NUMBER(3),                                                                                    
  Q022RT00_NHAB       NUMBER(2),                                                                                    
  Q022RT00_NBA        NUMBER(2),                                                                                    
  Q022RT00_NVIV       NUMBER(3),                                                                                    
  Q022RT00_TIPG       VARCHAR2(1),                                                                                  
  Q022RT00_TIPH       VARCHAR2(1),                                                                                  
  Q022RT00_TIPI       VARCHAR2(1),                                                                                  
  Q022RT00_TIPJ       VARCHAR2(1),                                                                                  
  Q022RT00_TIPK       VARCHAR2(1)                                                                                   
)                                                                                                                   
TABLESPACE Q0201E00;                                                                                               
                                                                                                                    
COMMENT ON TABLE Q022RT00 IS 'Cuestionario Ministerio Fomento:Edificacin de Nueva Planta-Caractersticas vivienda';
                                                                                                                    
drop table Q022ST00 cascade constraints;                                                                                                                    
CREATE TABLE Q022ST00                                                                                               
(                                                                                                                   
  Q022ST00_ID_CUES    NUMBER(8)                 NOT NULL,                                                           
  Q022ST00_ID         NUMBER(8)                 NOT NULL,                                                           
  Q022ST00_AMP_H      VARCHAR2(1),                                                                                  
  Q022ST00_RE_CV      VARCHAR2(1),                                                                                  
  Q022ST00_RE_SV      VARCHAR2(1),                                                                                  
  Q022ST00_ROA_LOC    VARCHAR2(1),                                                                                  
  Q022ST00_CV_SUP     NUMBER(5),                                                                                    
  Q022ST00_CV_NVC     NUMBER(3),                                                                                    
  Q022ST00_CV_NVS     NUMBER(3),                                                                                    
  Q022ST00_SV_NE      NUMBER(2),                                                                                    
  Q022ST00_SV_NVC     NUMBER(3),                                                                                    
  Q022ST00_SV_NVS     NUMBER(3),                                                                                    
  Q022ST00_SV_ELCI    VARCHAR2(1),                                                                                  
  Q022ST00_SV_ELCU    VARCHAR2(1),                                                                                  
  Q022ST00_SV_ELCEV   VARCHAR2(1),                                                                                  
  Q022ST00_SV_ELCIH   VARCHAR2(1),                                                                                  
  Q022ST00_SV_ELCIV   VARCHAR2(1),                                                                                  
  Q022ST00_SV_ELAI    VARCHAR2(1),                                                                                  
  Q022ST00_SV_ELI     VARCHAR2(1),                                                                                  
  Q022ST00_SV_ELOT    VARCHAR2(1),                                                                                  
  Q022ST00_OBS        VARCHAR2(100),                                                                                
  Q022ST00_USU_ALTA   NUMBER(10)                DEFAULT -1                    NOT NULL,                             
  Q022ST00_USU_MODIF  NUMBER(10)                DEFAULT -1,                                                         
  Q022ST00_TST_ALTA   DATE                      DEFAULT SYSDATE               NOT NULL,                             
  Q022ST00_TST_MODIF  DATE                      DEFAULT SYSDATE               NOT NULL                              
)                                                                                                                   
TABLESPACE Q0201E00;                                                                                               
                                                                                                                    
COMMENT ON TABLE Q022ST00 IS 'Cuestionario Ministerio Fomento:Obras de rehabilitacion';                             
                                                                                                                    
COMMENT ON COLUMN Q022ST00.Q022ST00_USU_ALTA IS 'Usuario de Alta##USR#insert:usr#update:null';                      
                                                                                                                    
COMMENT ON COLUMN Q022ST00.Q022ST00_USU_MODIF IS 'Usuario Ultima Modificacion##USR#insert:usr#update:usr';          
                                                                                                                    
COMMENT ON COLUMN Q022ST00.Q022ST00_TST_ALTA IS 'Fecha de Alta##FEC#insert:sysdate#update:null';                    
                                                                                                                    
COMMENT ON COLUMN Q022ST00.Q022ST00_TST_MODIF IS 'Fecha de Modificacion##FEC#insert:sysdate#update:sysdate';        
                                                                                                                    
drop table Q022TT00 cascade constraints;                                                                                                                    
CREATE TABLE Q022TT00                                                                                               
(                                                                                                                   
  Q022ST00_ID_OBRE  NUMBER(8)                   NOT NULL,                                                           
  Q022TT00_ID       NUMBER(8)                   NOT NULL,                                                           
  Q022TT00_TIP      VARCHAR2(1),                                                                                    
  Q022TT00_SUP_UTL  NUMBER(3),                                                                                      
  Q022TT00_NHAB     NUMBER(2),                                                                                      
  Q022TT00_NBA      NUMBER(2),                                                                                      
  Q022TT00_NVIV     NUMBER(3)                                                                                       
)                                                                                                                   
TABLESPACE Q0201E00;                                                                                               
                                                                                                                    
COMMENT ON TABLE Q022TT00 IS 'Cuestionario Ministerio Fomento:Obras de rehabilitacion-Caractersticas de viviendas';


drop table Q022UT00 cascade constraints;
CREATE TABLE Q022UT00                                    
(                                                        
  Q022UT00_ID_CUES    NUMBER(8)                 NOT NULL,
  Q022UT00_ID         NUMBER(8)                 NOT NULL,
  Q022UT00_NEDIFDE    NUMBER(2),                         
  Q022UT00_SUPEDIFDE  NUMBER(5),                         
  Q022UT00_NVIVDE     NUMBER(3),                         
  Q022UT00_SUPVIVDE   NUMBER(5),                         
  Q022UT00_NPLAZDE    NUMBER(4),                         
  Q022UT00_SUPPLAZDE  NUMBER(5),                         
  Q022UT00_SUPMDE     NUMBER(5),                         
  Q022UT00_OBS        VARCHAR2(100)                      
)                                                        
TABLESPACE Q0201E00;                                      
                                                         
COMMENT ON TABLE Q022UT00 IS 'Cuestionario Ministerio Fomento:Demolicin';